/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Couleur;
import cds.aladin.FilterProperties;
import cds.aladin.Legende;
import cds.aladin.MyByteArrayStream;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlaneLoadEvent;
import cds.aladin.Server;
import cds.aladin.Source;
import cds.tools.Util;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;

public class PlanCatalog
extends Plan {
    URL url = null;
    private long lastFilterLock = -1L;
    static String TEST_TSV_TITLE = "TSV/1_header_line";
    static String TEST_TSV_RESULT = "row=1 col=18 ra=77.405544 de=-63.777272 id=J050937.33-634638.1";
    static String TEST_TSV = "globalSourceID\tsourceCatalog\tepoch\tdesignation\ttmass_designation\tra\tdec\tmagJ\tmagH\tmagK\tmag3_6\tdmag3_6\tmag4_5\tdmag4_5\tmag5_8\tdmag5_8\tmag8_0\tdmag8_0\n1531664539\tiracc\tSMP SSTISAGEMC\tJ050937.33-634638.1\t05093732-6346387\t77.405544\t-63.777272\t6.976\t6.785\t\t6.715\t0.084\t6.719\t0.045\t6.743\t0.029\t6.716\t0.027";
    static String TEST_VOTABLE_TITLE = "VOTABLE/classic_TABLEDATA";
    static String TEST_VOTABLE_RESULT = "row=1 col=18 ra=1.2999999999999998 de=67.83333333333333 id=1";
    static String TEST_VOTABLE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<VOTABLE version=\"1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxmlns=\"http://www.ivoa.net/xml/VOTable/v1.1\"\nxsi:schemaLocation=\"http://www.ivoa.net/xml/VOTable/v1.1 http://www.ivoa.net/xml/VOTable/v1.1\">\n<DESCRIPTION>\nVizieR Astronomical Server: vizier.u-strasbg.fr  2010-07-01T11:59:16\nExplanations and Statistics of UCDs:         See LINK below\nIn case of problem, please report to:    cds-question@unistra.fr\n</DESCRIPTION>\n<!-- VOTable description at http://www.ivoa.net/Documents/latest/VOT.html -->\n<DEFINITIONS>\n<COOSYS ID=\"J2000\" system=\"eq_FK5\" equinox=\"J2000\"/>\n</DEFINITIONS>\n<INFO ID=\"Ref\" name=\"-ref\" value=\"VIZ4c2c829613a3\"/>\n<INFO ID=\"MaxTuples\" name=\"-out.max\" value=\"50\"/>\n<INFO name=\"CatalogsExamined\" value=\"2\">\n2 catalogues with potential matches were examined.\n</INFO>\n<INFO ID=\"Target\" name=\"-c\" value=\"001.286805+67.840004,rm=2.\"/>\n<RESOURCE ID=\"yCat_3135\" name=\"III/135A\">\n<DESCRIPTION>Henry Draper Catalogue and Extension (Cannon+ 1918-1924; ADC 1989)</DESCRIPTION>\n<COOSYS ID=\"B1900_1900.000\" system=\"eq_FK4\" equinox=\"B1900\" epoch=\"1900.000\"/>\n<TABLE ID=\"III_135A_catalog\" name=\"III/135A/catalog\">\n<DESCRIPTION>The catalogue</DESCRIPTION>\n<!-- RowName:  ${HD} -->\n<!-- Now comes the definition of each field -->\n<FIELD name=\"_r\" ucd=\"pos.angDistance\" datatype=\"float\" width=\"3\" precision=\"1\" unit=\"arcmin\"><!-- ucd=\"POS_ANG_DIST_GENERAL\" -->\n<DESCRIPTION>Distance from center (RAB1900=24 00.0, DEB1900=+67 17) at Epoch=J1900.0</DESCRIPTION>\n</FIELD>\n<FIELD name=\"_RAJ2000\" ucd=\"pos.eq.ra;meta.main\" ref=\"J2000\" datatype=\"char\" arraysize=\"7\" unit=\"&quot;h:m:s&quot;\"><!-- ucd=\"POS_EQ_RA_MAIN\" -->\n<DESCRIPTION>Right ascension (FK5) Equinox=J2000.0 Epoch=J1900. (computed by VizieR, not part of the original data)</DESCRIPTION>\n</FIELD>\n<FIELD name=\"_DEJ2000\" ucd=\"pos.eq.dec;meta.main\" ref=\"J2000\" datatype=\"char\" arraysize=\"6\" unit=\"&quot;d:m:s&quot;\"><!-- ucd=\"POS_EQ_DEC_MAIN\" -->\n<DESCRIPTION>Declination (FK5) Equinox=J2000.0 Epoch=J1900. (computed by VizieR, not part of the original data)</DESCRIPTION>\n</FIELD>\n<FIELD name=\"HD\" ucd=\"meta.id;meta.main\" datatype=\"int\" width=\"6\"><!-- ucd=\"ID_MAIN\" -->\n<DESCRIPTION>[1/272150]+ Henry Draper Catalog (HD) number</DESCRIPTION>\n</FIELD>\n<FIELD name=\"DM\" ucd=\"meta.id\" datatype=\"char\" arraysize=\"12*\"><!-- ucd=\"ID_ALTERNATIVE\" -->\n<DESCRIPTION>Durchmusterung identification (1)</DESCRIPTION>\n</FIELD>\n<FIELD name=\"RAB1900\" ucd=\"pos.eq.ra\" ref=\"B1900_1900.000\" datatype=\"char\" arraysize=\"7\" unit=\"&quot;h:m:s&quot;\"><!-- ucd=\"POS_EQ_RA\" -->\n<DESCRIPTION>Hours RA, equinox B1900, epoch 1900.0</DESCRIPTION>\n</FIELD>\n<FIELD name=\"DEB1900\" ucd=\"pos.eq.dec\" ref=\"B1900_1900.000\" datatype=\"char\" arraysize=\"6\" unit=\"&quot;d:m:s&quot;\"><!-- ucd=\"POS_EQ_DEC\" -->\n<DESCRIPTION>Degrees Dec, equinox B1900, epoch 1900.0</DESCRIPTION>\n</FIELD>\n<FIELD name=\"q_Ptm\" ucd=\"meta.code.qual\" datatype=\"unsignedByte\" width=\"1\"><!-- ucd=\"CODE_QUALITY\" -->\n<DESCRIPTION>[0/1]? Code for Ptm: 0 = measured, 1 = value inferred from Ptg and spectral type</DESCRIPTION>\n<VALUES null=\" \" />\n</FIELD>\n<FIELD name=\"Ptm\" ucd=\"phot.mag;em.opt.V\" datatype=\"float\" width=\"5\" precision=\"2\" unit=\"mag\"><!-- ucd=\"PHOT_PHG_V\" -->\n<DESCRIPTION>? Photovisual magnitude (2)</DESCRIPTION>\n<VALUES null=\" \" />\n</FIELD>\n<FIELD name=\"n_Ptm\" ucd=\"meta.note\" datatype=\"char\" arraysize=\"1\"><!-- ucd=\"NOTE\" -->\n<DESCRIPTION>[C] 'C' if Ptm is combined value with Ptg</DESCRIPTION>\n</FIELD>\n<FIELD name=\"q_Ptg\" ucd=\"meta.code.qual\" datatype=\"unsignedByte\" width=\"1\"><!-- ucd=\"CODE_QUALITY\" -->\n<DESCRIPTION>[0/1]? Code for Ptg: 0 = measured, 1 = value inferred from Ptm and spectral type</DESCRIPTION>\n<VALUES null=\" \" />\n</FIELD>\n<FIELD name=\"Ptg\" ucd=\"phot.mag;em.opt\" datatype=\"float\" width=\"5\" precision=\"2\" unit=\"mag\"><!-- ucd=\"PHOT_PHG_MAG\" -->\n<DESCRIPTION>? Photographic magnitude (2)</DESCRIPTION>\n<VALUES null=\" \" />\n</FIELD>\n<FIELD name=\"n_Ptg\" ucd=\"meta.note\" datatype=\"char\" arraysize=\"1\"><!-- ucd=\"NOTE\" -->\n<DESCRIPTION>[C] 'C' if Ptg is combined value for this entry and the following or preceding entry</DESCRIPTION>\n</FIELD>\n<FIELD name=\"SpT\" ucd=\"src.spType\" datatype=\"char\" arraysize=\"3\"><!-- ucd=\"SPECT_TYPE_GENERAL\" -->\n<DESCRIPTION>Spectral type spectral types P are generally nebulae)</DESCRIPTION>\n</FIELD>\n<FIELD name=\"Int\" ucd=\"phot.count;em.opt\" datatype=\"char\" arraysize=\"2\"><!-- ucd=\"PHOT_INTENSITY_ESTIMATED\" -->\n<DESCRIPTION>[ 0-9B] Photographic intensity of spectrum (3)</DESCRIPTION>\n</FIELD>\n<FIELD name=\"Rem\" ucd=\"meta.note\" datatype=\"char\" arraysize=\"1\"><!-- ucd=\"REMARKS\" -->\n<DESCRIPTION>[DEGMR*] Remarks, see note (4)</DESCRIPTION>\n</FIELD>\n<FIELD name=\"Simbad\" ucd=\"DATA_LINK\" datatype=\"char\" arraysize=\"6*\"><!-- ucd=\"(unassigned)\" -->\n<DESCRIPTION>ask the FireBrick Simbad data-base about this object</DESCRIPTION>\n</FIELD>\n<FIELD name=\"Tycho\" ucd=\"meta.ref.url\" datatype=\"char\" arraysize=\"5*\"><!-- ucd=\"DATA_LINK\" -->\n<DESCRIPTION>Cross-identification with Tycho-2 (Cat. IV/25)</DESCRIPTION>\n</FIELD>\n<DATA>      <TABLEDATA>\n<TR><TD>0.2</TD><TD>00 05.2</TD><TD>+67 50</TD><TD>1</TD><TD>BD+67 1599</TD><TD>00 00.0</TD><TD></TD><TD>0</TD><TD/><TD> </TD><TD>1</TD><TD>8.70</TD><TD> </TD><TD>K0 </TD><TD> 3</TD><TD> </TD><TD>Simbad</TD><TD>Tycho</TD></TR>\n</TABLEDATA></DATA>\n</TABLE>\n</RESOURCE>\n</VOTABLE>\n";

    protected PlanCatalog(Aladin aladin, String file, MyInputStream in, boolean skip, boolean doClose) {
        this.doClose = doClose;
        this.flagSkip = skip;
        String label = "Cat";
        this.dis = in;
        try {
            this.url = new URL("file:" + new File(file).getCanonicalPath());
        }
        catch (Exception e) {
            String s = file + " not found";
            Aladin.warning(s, 1);
            return;
        }
        if (file != null) {
            int i = file.lastIndexOf(Util.FS);
            label = i >= 0 ? file.substring(i + 1) : file;
        }
        this.flagLocal = true;
        this.flagWaitTarget = true;
        this.Suite(aladin, label, "", "", null, null);
    }

    protected PlanCatalog(Aladin aladin, MyInputStream in, String label, String origin) {
        this.dis = in;
        if (label == null) {
            label = "VOApp";
        }
        this.flagWaitTarget = true;
        this.Suite(aladin, label, "", "", origin, null);
    }

    protected PlanCatalog(Aladin aladin, MyInputStream in, String label) {
        this(aladin, in, label, null);
    }

    protected PlanCatalog(Aladin aladin) {
        this.aladin = aladin;
        this.type = 8;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        this.flagOk = true;
    }

    public PlanCatalog() {
    }

    protected PlanCatalog(Aladin aladin, URL u, MyInputStream in, String label, String objet, String param, String from, Server server) {
        this.dis = in;
        this.u = u;
        this.flagLocal = false;
        this.Suite(aladin, label, objet, param, from, server);
    }

    protected void Suite(Aladin aladin, String label, String objet, String param, String from, Server server) {
        this.setLogMode(true);
        this.aladin = aladin;
        this.type = 8;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setLabel(label);
        this.objet = objet;
        this.param = param;
        this.copyright = from;
        this.headerFits = null;
        this.server = server;
        if (server != null) {
            this.filters = server.filters;
            this.filterIndex = aladin.configuration.getFilter() == 0 ? server.getFilterChoiceIndex() : -1;
        }
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        aladin.calque.unSelectAllPlan();
        this.selected = true;
        this.threading();
    }

    protected String getTableName(Source o) {
        String s;
        String string = s = o.leg == null ? null : o.leg.name;
        if (s == null) {
            if (o.info == null) {
                return "Table";
            }
            int i = o.info.indexOf(124);
            int j = o.info.indexOf(62);
            if (i == -1 || j == -1) {
                return "Table";
            }
            s = o.info.substring(i + 1, j);
        }
        if (s.endsWith("/out")) {
            s = s.substring(0, s.length() - 4);
        }
        return s;
    }

    protected String getFirstTableName() {
        Iterator<Obj> it = this.iterator();
        while (it.hasNext()) {
            Obj o = it.next();
            if (!(o instanceof Source)) continue;
            return this.getTableName((Source)o);
        }
        return null;
    }

    @Override
    protected boolean isSync() {
        boolean hasSource = this.hasSources();
        boolean isSync = this.flagOk && this.error == null || this.flagOk && this.pcat != null && (hasSource || this.error != null && !hasSource) || this.pcat != null && this.error != null && !hasSource;
        isSync = isSync && (this.planFilter == null || this.planFilter.isSync());
        return isSync;
    }

    @Override
    protected boolean Free() {
        this.aladin.view.deSelect(this);
        super.Free();
        this.aladin.view.free(this);
        this.headerFits = null;
        FilterProperties.notifyNewPlan();
        return true;
    }

    protected String getDescription() {
        if (this.pcat.description == null) {
            return null;
        }
        return this.pcat.description.toString();
    }

    @Override
    protected int getCounts() {
        return this.pcat == null ? 0 : this.pcat.getCount();
    }

    @Override
    protected Obj[] getObj() {
        return this.pcat.o;
    }

    @Override
    protected void setPropertie(String prop, String specif, String value) throws Exception {
        if (prop.equalsIgnoreCase("Shape")) {
            int n = Source.getShapeIndex(value);
            if (n == -1) {
                throw new Exception("Shape unknown");
            }
            this.setSourceType(n);
            this.aladin.calque.repaintAll();
        } else if (prop.equalsIgnoreCase("Filter")) {
            this.setFilter(value);
        } else {
            super.setPropertie(prop, specif, value);
        }
    }

    @Override
    protected boolean setActivated() {
        if (!this.hasSources()) {
            return false;
        }
        return super.setActivated();
    }

    @Override
    protected boolean waitForPlan() {
        int n = 0;
        n = this.dis != null ? this.pcat.setPlanCat(this, this.dis, null, true) : (this.flagLocal ? this.pcat.setPlanCat(this, this.url, true) : this.pcat.setPlanCat(this, this.u, true));
        if (n == 0) {
            this.error = "No object found in the field!";
            Aladin.error = "No object found in the field!";
        }
        if (n <= 0) {
            this.callAllListeners(new PlaneLoadEvent(this, PlaneLoadEvent.ERROR, Aladin.error));
            return false;
        }
        if ((this.objet == null || this.objet.length() == 0) && this.co != null) {
            this.objet = this.co.getSexa();
            this.aladin.dialog.setDefaultTarget(this.objet);
            this.aladin.dialog.setDefaultTaille(this);
        }
        this.setExtName();
        this.setFilter(this.filterIndex);
        if (this.getNbTable() > 1) {
            this.aladin.calque.splitCatalog(this);
        }
        this.callAllListeners(new PlaneLoadEvent(this, PlaneLoadEvent.SUCCESS, null));
        return true;
    }

    protected static void desactivateAllDedicatedFilters(Aladin aladin) {
        Plan[] allPlan = aladin.calque.getPlans();
        for (int i = 0; i < allPlan.length; ++i) {
            Plan p = allPlan[i];
            if (!p.isSimpleCatalog()) continue;
            ((PlanCatalog)p).setFilter(-1);
        }
    }

    @Override
    protected int getNbTable() {
        return this.pcat.nbTable;
    }

    void increaseSourceSize(int sens) {
        Iterator<Obj> it = this.iterator();
        while (it.hasNext()) {
            Obj o = it.next();
            if (!(o instanceof Source)) continue;
            ((Source)o).increaseSourceSize(sens);
        }
    }

    @Override
    protected Vector<Legende> getLegende() {
        Vector<Legende> leg = new Vector<Legende>(10);
        Iterator<Obj> it = this.iterator();
        while (it.hasNext()) {
            Obj o = it.next();
            if (!(o instanceof Source)) continue;
            Source s = (Source)o;
            if (s.leg == null || leg.contains(s.leg)) continue;
            leg.addElement(s.leg);
        }
        return leg;
    }

    @Override
    protected Legende getFirstLegende() {
        Iterator<Obj> it = this.iterator();
        while (it.hasNext()) {
            Obj o = it.next();
            if (!(o instanceof Source)) continue;
            Source s = (Source)o;
            if (s.leg == null) continue;
            return s.leg;
        }
        return null;
    }

    @Override
    protected String getProgress() {
        if (!this.flagOk && this.error == null) {
            return " - " + this.pcat.getCount() + " object" + (this.pcat.getCount() <= 1 ? "" : "s") + " - in progress...";
        }
        return super.getProgress();
    }

    @Override
    protected boolean hasSources() {
        return this.pcat != null && this.pcat.hasObj();
    }

    private static boolean test1(Aladin aladin, String t, String s, String r) {
        System.out.print("> PlanCatalog test : " + t + "...");
        int trace = Aladin.levelTrace;
        Aladin.levelTrace = 0;
        try {
            MyByteArrayStream buf = new MyByteArrayStream();
            buf.write(s);
            MyInputStream in = new MyInputStream(buf.getInputStream());
            PlanCatalog p = new PlanCatalog(aladin, in, t);
            while (!p.isReady()) {
                Util.pause(1000);
            }
            Source o = (Source)p.iterator().next();
            String r1 = "row=" + p.getCounts() + " col=" + p.getFirstLegende().getSize() + " ra=" + o.raj + " de=" + o.dej + " id=" + o.id;
            if (!r1.equals(r)) {
                throw new Exception("respond test [" + r1 + "] should be [" + r + "]");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Aladin.levelTrace = trace;
            System.out.println(" Error: " + e.getMessage());
            return false;
        }
        Aladin.levelTrace = trace;
        System.out.println(" OK");
        return true;
    }

    protected static boolean test(Aladin aladin) {
        boolean rep = true;
        rep &= PlanCatalog.test1(aladin, TEST_TSV_TITLE, TEST_TSV, TEST_TSV_RESULT);
        return rep &= PlanCatalog.test1(aladin, TEST_VOTABLE_TITLE, TEST_VOTABLE, TEST_VOTABLE_RESULT);
    }

    public void test() throws Exception {
        Aladin.STANDALONE = true;
        Aladin.NOGUI = true;
        Aladin aladin = new Aladin();
        Aladin.startInFrame(aladin);
        assert (PlanCatalog.test(aladin));
    }
}

