/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.TreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class MyTree
extends JTree
implements Iterable<TreeNode> {
    protected String info;
    protected String info1;
    protected DefaultMutableTreeNode root;
    private Aladin aladin;

    protected MyTree(Aladin aladin) {
        this.aladin = aladin;
        this.createTree();
    }

    protected DefaultMutableTreeNode getRoot() {
        if (this.root == null) {
            this.root = new DefaultMutableTreeNode(new TreeNode(this.aladin, "root", null, "", ""));
        }
        return this.root;
    }

    private void createTree() {
        this.root = this.getRoot();
        ((DefaultTreeModel)this.getModel()).setRoot(this.root);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 0));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        NoeudRenderer nr = new NoeudRenderer();
        this.setCellRenderer(nr);
        this.setCellEditor(new NoeudEditor(this));
        this.setEditable(true);
    }

    protected void freeTree() {
        if (this.root != null && this.root.getChildCount() == 0) {
            return;
        }
        DefaultMutableTreeNode r = new DefaultMutableTreeNode(new TreeNode(this.aladin, "root", null, "", ""));
        ((DefaultTreeModel)this.getModel()).setRoot(r);
        this.root = r;
    }

    protected synchronized void updateTree(Enumeration e1) {
        ArrayList<TreeNode> v = new ArrayList<TreeNode>();
        for (TreeNode n : this) {
            v.add(n);
        }
        this.freeTree();
        while (e1.hasMoreElements()) {
            TreeNode noeud = (TreeNode)e1.nextElement();
            int i = v.indexOf(noeud);
            if (i >= 0) {
                TreeNode oldNoeud = (TreeNode)v.get(i);
                noeud.setCheckBox(oldNoeud.isCheckBoxSelected());
            }
            this.createTreeBranch(this.root, noeud, 0);
        }
        this.defaultExpand();
    }

    @Override
    public Iterator<TreeNode> iterator() {
        return new TreeIterator();
    }

    protected void populateTree(Enumeration e) {
        while (e.hasMoreElements()) {
            TreeNode noeud = (TreeNode)e.nextElement();
            this.createTreeBranch(this.root, noeud, 0);
        }
        this.defaultExpand();
    }

    public void reset() {
        for (TreeNode n : this) {
            n.setCheckBox(false);
        }
        this.validate();
    }

    public void submit() {
        boolean ok = false;
        for (TreeNode n : this) {
            if (!n.isCheckBoxSelected()) continue;
            this.submit(n);
            ok = true;
        }
        if (!ok) {
            this.warning();
        }
        this.reset();
    }

    protected void warning() {
    }

    protected void updateColor() {
    }

    private void submit(TreeNode n) {
        n.submit();
    }

    protected void createTreeBranch(DefaultMutableTreeNode node, TreeNode noeud, int opos) {
        int pos;
        int index = opos;
        do {
            index = pos = noeud.path.indexOf(47, index);
            if (pos > 1 && noeud.path.charAt(pos - 1) == '\\') {
                ++index;
                continue;
            }
            index = -1;
        } while (index != -1);
        String label = pos < 0 ? noeud.path.substring(opos) : noeud.path.substring(opos, pos);
        ((TreeNode)node.getUserObject()).noCheckbox();
        try {
            DefaultMutableTreeNode subNode = null;
            Enumeration<javax.swing.tree.TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                subNode = (DefaultMutableTreeNode)e.nextElement();
                TreeNode fils = (TreeNode)subNode.getUserObject();
                if (label.equals(fils.label)) break;
                subNode = null;
            }
            if (subNode == null) {
                subNode = new DefaultMutableTreeNode(pos != -1 ? new TreeNode(this.aladin, "", null, label, "") : noeud);
                node.add(subNode);
                if (pos != -1) {
                    this.createTreeBranch(subNode, noeud, pos + 1);
                }
            } else if (pos != -1) {
                this.createTreeBranch(subNode, noeud, pos + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fireTreeChanged() {
        ((DefaultTreeModel)this.getModel()).reload();
    }

    protected boolean removeTreeBranch(DefaultMutableTreeNode node, String id) {
        DefaultMutableTreeNode subNode = null;
        boolean rep = false;
        Enumeration<javax.swing.tree.TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            subNode = (DefaultMutableTreeNode)e.nextElement();
            TreeNode fils = (TreeNode)subNode.getUserObject();
            String idFils = fils.getID();
            if (idFils != null && idFils.equals(id)) {
                node.remove(subNode);
                rep = true;
                break;
            }
            if (!this.removeTreeBranch(subNode, id) || node.getChildCount() != 0) continue;
            node.remove(subNode);
            rep = true;
            break;
        }
        return rep;
    }

    protected void defaultExpand() {
        this.expandPath(new TreePath(this.root));
        Enumeration<javax.swing.tree.TreeNode> e = this.root.preorderEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.isLeaf()) continue;
            this.collapsePath(new TreePath(node));
        }
    }

    @Override
    public void paint(Graphics g) {
        this.updateColor();
        super.paint(g);
    }

    class NoeudEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        JTree tree;
        NoeudRenderer renderer;

        public NoeudEditor(JTree tree) {
            this.renderer = new NoeudRenderer();
            this.tree = tree;
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            if (event instanceof MouseEvent) {
                TreePath path = this.tree.getPathForLocation(((MouseEvent)event).getX(), ((MouseEvent)event).getY());
                TreeNode noeud = (TreeNode)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                return noeud.hasCheckBox();
            }
            return false;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object obj, boolean isSelected, boolean expanded, boolean leaf, int row) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            TreeNode n = (TreeNode)node.getUserObject();
            if (n.hasCheckBox()) {
                return n.getPanel();
            }
            return this.renderer.getTreeCellRendererComponent(tree, obj, true, expanded, leaf, row, true);
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    class NoeudRenderer
    implements TreeCellRenderer {
        DefaultTreeCellRenderer nonLeafRenderer = new DefaultTreeCellRenderer();
        Color selectionForeground = UIManager.getColor("Tree.selectionForeground");
        Color selectionBackground = UIManager.getColor("Tree.selectionBackground");
        Color textForeground = UIManager.getColor("Tree.textForeground");
        Color textBackground = UIManager.getColor("Tree.textBackground");

        NoeudRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            TreeNode n = (TreeNode)node.getUserObject();
            if (n.hasCheckBox()) {
                if (n.isOk()) {
                    n.checkbox.setForeground(Color.black);
                } else {
                    n.checkbox.setForeground(Color.lightGray);
                }
                JPanel panel = n.getPanel();
                if (selected) {
                    panel.setForeground(this.selectionForeground);
                    panel.setBackground(this.selectionBackground);
                } else {
                    panel.setForeground(this.textForeground);
                    panel.setBackground(this.textBackground);
                }
                return panel;
            }
            Component c = this.nonLeafRenderer.getTreeCellRendererComponent(tree, obj, selected, expanded, leaf, row, hasFocus);
            if (n.isOk()) {
                c.setForeground(Color.black);
            } else {
                c.setForeground(Color.lightGray);
            }
            return c;
        }
    }

    class TreeIterator
    implements Iterator<TreeNode> {
        private Enumeration e;

        TreeIterator() {
            this.e = MyTree.this.root.preorderEnumeration();
        }

        @Override
        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        @Override
        public TreeNode next() {
            return (TreeNode)((DefaultMutableTreeNode)this.e.nextElement()).getUserObject();
        }

        @Override
        public void remove() {
        }
    }
}

