/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.tools.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import java.util.Vector;

public class MyProperties
extends Properties {
    private Vector<ConfigurationItem> prop = new Vector();

    private ConfigurationItem getItem(String key) {
        for (ConfigurationItem item : this.prop) {
            if (!item.key.equals(key)) continue;
            return item;
        }
        return null;
    }

    public void replaceValue(String key, String value) {
        for (ConfigurationItem item : this.prop) {
            if (!item.key.equals(key)) continue;
            item.value = value;
            break;
        }
    }

    public void replaceKey(String oldKey, String key) {
        for (ConfigurationItem item : this.prop) {
            if (!item.key.equals(oldKey)) continue;
            item.key = key;
            this.remove(oldKey);
            this.put(key, item.value);
        }
    }

    public void remove(String key) {
        int i;
        for (i = 0; i < this.prop.size(); ++i) {
            ConfigurationItem item = this.prop.get(i);
            if (item.key.equals(key)) break;
        }
        if (i < this.prop.size()) {
            this.prop.remove(i);
        }
        super.remove(key);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        ConfigurationItem item = this.getItem((String)key);
        if (item == null) {
            item = new ConfigurationItem((String)key, (String)value);
            this.prop.addElement(item);
        } else {
            item.value = (String)value;
        }
        return super.put(key, value);
    }

    @Override
    public synchronized void load(InputStream in) throws IOException {
        String s;
        this.prop = new Vector();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        int line = 0;
        while ((s = br.readLine()) != null) {
            String value;
            String key;
            block13: {
                ++line;
                if (s.trim().length() == 0) {
                    this.prop.addElement(new ConfigurationItem(" ", null));
                    continue;
                }
                if (s.charAt(0) == '#') {
                    boolean simpleComment = true;
                    int egal = s.indexOf(61);
                    if (egal > 1) {
                        int blanc = s.indexOf(32);
                        if (blanc < 0) {
                            blanc = s.indexOf(9);
                        }
                        if (blanc > 0 && blanc < egal) {
                            while (Character.isSpace(s.charAt(blanc)) && blanc < egal) {
                                ++blanc;
                            }
                            simpleComment = blanc != egal;
                        } else {
                            simpleComment = false;
                        }
                    }
                    if (simpleComment) {
                        this.prop.addElement(new ConfigurationItem("#", s));
                        continue;
                    }
                }
                try {
                    int offset = s.indexOf(61);
                    key = s.substring(0, offset).trim();
                    value = s.substring(offset + 1, s.length()).trim();
                    if (value.indexOf("\\:") < 0) break block13;
                    char[] a = value.toCharArray();
                    char[] b = new char[a.length];
                    int j = 0;
                    boolean backSlash = false;
                    for (int i = 0; i < a.length; ++i) {
                        if (!backSlash && a[i] == '\\') {
                            backSlash = true;
                            continue;
                        }
                        backSlash = false;
                        b[j++] = a[i];
                    }
                    value = new String(b, 0, j);
                }
                catch (Exception e) {
                    System.err.println("MyProperties reader error line " + line + " => " + e.getMessage());
                    this.prop.addElement(new ConfigurationItem("#", "#Error: " + s));
                    continue;
                }
            }
            this.put(key, value);
        }
        br.close();
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));
        for (ConfigurationItem item : this.prop) {
            if (item.key.equals("#")) {
                bw.write(item.value);
            } else if (item.key.trim().length() > 0) {
                bw.write(Util.align(item.key, 20) + " = " + item.value);
            }
            bw.newLine();
        }
        bw.flush();
    }

    private class ConfigurationItem {
        protected String key;
        protected String value;

        private ConfigurationItem(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

