/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class MyBox
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected static final int SAISIE = 0;
    protected static final int AFFICHAGE = 1;
    private static final String LABEL_SAISIE = "SAISIE";
    private static final String LABEL_AFFICHAGE = "AFFICHAGE";
    protected static final int DF = Aladin.SIZE;
    protected static final Font F = Aladin.PLAIN;
    protected static String UNDEF = "";
    protected Aladin aladin;
    protected Text pos;
    protected Text text;
    private int mode = 1;
    private CardLayout cl;
    private JPanel cardPanel;
    protected JComboBox c;
    protected JLabel label;
    static final Font FONT = new Font("Sans serif", 1, 12);

    protected MyBox(Aladin aladin, String titre) {
        this.aladin = aladin;
        this.c = this.createChoice();
        this.c.setFont(this.c.getFont().deriveFont((float)this.c.getFont().getSize() - 1.0f));
        this.c.addMouseListener(this);
        this.pos = new Text("", 30);
        this.pos.setFont(FONT);
        this.pos.setForeground(Color.gray);
        this.pos.addMouseListener(this);
        this.text = new Text("", 30);
        this.text.setFont(FONT);
        this.text.setForeground(Aladin.MYBLUE);
        this.text.addMouseListener(this);
        this.text.addMouseMotionListener(this);
        this.cl = new CardLayout(0, 0);
        this.cardPanel = new JPanel(this.cl);
        this.cardPanel.add(LABEL_AFFICHAGE, this.pos);
        this.cardPanel.add(LABEL_SAISIE, this.text);
        JPanel p2 = new JPanel(new BorderLayout(0, 0));
        this.label = new Lab(titre);
        p2.add((Component)this.label, "West");
        p2.add((Component)this.cardPanel, "Center");
        this.setLayout(new BorderLayout(3, 3));
        this.add((Component)p2, "Center");
        if (!Aladin.OUTREACH) {
            JPanel p1 = new JPanel(new BorderLayout(0, 0));
            p1.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 30));
            p1.add((Component)new Lab(Aladin.chaine.getString("FRAME")), "West");
            p1.add((Component)this.c, "East");
            this.add((Component)p1, "East");
        }
        this.addMouseListener(this);
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
    }

    @Override
    public void setEnabled(boolean flag) {
        this.text.setEnabled(flag);
        this.text.setBackground(flag ? Color.white : this.getBackground());
        if (!flag) {
            this.text.setText("");
        }
        this.pos.setBackground(flag ? Color.white : this.getBackground());
        this.label.setForeground(flag ? Aladin.DARKBLUE : Color.lightGray);
        this.c.setEnabled(flag);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Cursor c = this.text.getCursor();
        Cursor nc = this.text.in(e.getX(), e.getY()) ? Cursor.getPredefinedCursor(12) : Cursor.getPredefinedCursor(2);
        if (nc.equals(c)) {
            return;
        }
        this.text.setCursor(nc);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.aladin.inHelp) {
            this.aladin.help.setText(Aladin.chaine.getString("LCoord.HELP"));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.aladin.inHelp) {
            this.aladin.helpOff();
        }
        if (this.text.in(e.getX(), e.getY())) {
            this.reset();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    protected boolean isPopupVisible() {
        return this.c.isPopupVisible();
    }

    protected JComboBox createChoice() {
        JComboBox c = new JComboBox();
        c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MyBox.this.actionChoice();
            }
        });
        return c;
    }

    protected abstract void actionChoice();

    protected void setTextSaisie(String s) {
        this.text.setText(s);
        if (s.length() > 0) {
            this.text.select(0, 0);
        }
    }

    protected void setTextAffichage(String s) {
        this.pos.setText(s);
    }

    protected void reset() {
        this.text.setText("");
        this.pos.setText("");
    }

    protected void readyToClear() {
        this.text.selectAll();
    }

    protected String getTextAffichage() {
        return this.pos.getText().trim();
    }

    protected String getTextSaisie() {
        return this.text.getText().trim();
    }

    protected void setMode(int m) {
        if (this.mode == m) {
            return;
        }
        this.mode = m;
        this.cl.show(this.cardPanel, this.mode == 0 ? LABEL_SAISIE : LABEL_AFFICHAGE);
    }

    protected void setUndef() {
        this.pos.setText(UNDEF);
    }

    protected int getChoiceIndex() {
        return this.c.getSelectedIndex();
    }

    protected void setChoiceIndex(int m) {
        this.c.setSelectedIndex(m);
    }

    class Text
    extends JTextField {
        private Dimension dim;
        private Rectangle cross;
        private static final int X = 6;

        Text(String t, int width) {
            super(t, width);
            this.dim = null;
            this.cross = null;
            this.dim = new Dimension(width, super.getPreferredSize().height);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.dim;
        }

        boolean in(int x, int y) {
            if (this.cross == null || MyBox.this.text.getText().length() == 0) {
                return false;
            }
            return x >= this.cross.x;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.drawCross(g, this.getWidth() - 6 - 8, this.getHeight() / 2 - 3);
        }

        private void drawCross(Graphics g, int x, int y) {
            g.setColor(Color.white);
            g.fillOval(x - 3, y - 3, 13, 13);
            g.setColor(MyBox.this.text.getText().length() > 0 ? Color.red.darker() : Color.gray);
            g.drawLine(x, y, x + 6, y + 6);
            g.drawLine(x + 1, y, x + 6 + 1, y + 6);
            g.drawLine(x + 2, y, x + 6 + 2, y + 6);
            g.drawLine(x + 6, y, x, y + 6);
            g.drawLine(x + 6 + 1, y, x + 1, y + 6);
            g.drawLine(x + 6 + 2, y, x + 2, y + 6);
            this.cross = new Rectangle(x, y, 6, 6);
        }
    }

    class Lab
    extends JLabel {
        Lab(String t) {
            super(t, 4);
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 2));
            this.setFont(Aladin.BOLD);
            this.setForeground(Aladin.DARKBLUE);
        }
    }
}

