/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FrameMesure;
import cds.aladin.Legende;
import cds.aladin.MCanvas;
import cds.aladin.MyScrollbar;
import cds.aladin.Plan;
import cds.aladin.Search;
import cds.aladin.Source;
import cds.aladin.Status;
import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import cds.aladin.Words;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class Mesure
extends JPanel
implements Runnable,
Iterable<Source>,
Widget {
    Aladin aladin;
    MCanvas mcanvas;
    MyScrollbar scrollV;
    MyScrollbar scrollH;
    JPanel haut;
    Status status;
    boolean flagSplit;
    int previousHeight = 0;
    Search search;
    private static int DEFAULTBLOC = 100;
    private static int MAXBLOC = 100000;
    protected Source[] src = new Source[DEFAULTBLOC];
    protected int nbSrc = 0;
    protected FrameMesure f = null;
    private Hashtable memoWL = new Hashtable(DEFAULTBLOC);
    private JButton cross;
    private boolean isSorting = false;
    private int nOccurence;
    private String oMasq = null;
    private static String MFSEARCH;
    private static String MFSEARCHO;
    private static String MFSEARCHBAD;
    Source lastOcc = null;
    private Object verrou = new Object();
    protected boolean flagReduced = true;
    protected boolean flagDorepaintForScroll = false;
    private WidgetControl voc = null;

    protected Mesure(Aladin aladin) {
        this.aladin = aladin;
        this.scrollV = new MyScrollbar(1, 0, 0, 0, 0);
        this.scrollH = new MyScrollbar(0, 0, 0, 0, 0);
        this.mcanvas = new MCanvas(aladin, this.scrollV, this.scrollH);
        this.scrollV.addAdjustmentListener(this.mcanvas);
        this.scrollH.addAdjustmentListener(this.mcanvas);
        this.status = new Status(aladin, "");
        this.flagSplit = false;
        this.haut = new JPanel();
        this.haut.setLayout(new BorderLayout(2, 2));
        Aladin.makeAdd(this.haut, this.status, "Center");
        this.search = new Search(aladin, false);
        this.search.setEnabled(true);
        JPanel x = new JPanel();
        x.add(this.search);
        Aladin.makeAdd(this.haut, x, "East");
        JPanel est = new JPanel(new BorderLayout(0, 0));
        est.add((Component)this.scrollV, "Center");
        this.setLayout(new BorderLayout(0, 0));
        Aladin.makeAdd(this, this.haut, "North");
        Aladin.makeAdd(this, this.mcanvas, "Center");
        Aladin.makeAdd(this, est, "East");
        Aladin.makeAdd(this, this.scrollH, "South");
        this.haut.setVisible(false);
        MFSEARCH = Aladin.chaine.getString("MFSEARCH");
        MFSEARCHO = Aladin.chaine.getString("MFSEARCHO");
        MFSEARCHBAD = Aladin.chaine.getString("MFSEARCHBAD");
    }

    protected void split() {
        if (this.f == null) {
            this.f = new FrameMesure(this.aladin);
        } else {
            this.f.close();
            this.f = null;
        }
    }

    protected synchronized void setSorting(boolean flag) {
        this.isSorting = flag;
    }

    protected synchronized boolean isSorting() {
        return this.isSorting;
    }

    @Override
    public void run() {
        this.setStatus("...sorting...");
        this.setSorting(true);
        try {
            Util.pause(100);
            Arrays.sort(this.src, Source.getComparator());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSorting(false);
        this.scrollV.setValue(0);
        this.setStatus("");
        Aladin.makeCursor(this.mcanvas, 0);
        this.memoWordLineClear();
        this.mcanvas.repaint();
    }

    protected void tri(boolean ascendant) {
        this.mcanvas.tri(this.mcanvas.sCourante, this.mcanvas.sortField, ascendant);
    }

    protected synchronized double[] getFieldNumericValues(Source o, int nField) {
        int nb = 0;
        for (int i = 0; i < this.nbSrc; ++i) {
            if (this.src[i].leg != o.leg) continue;
            ++nb;
        }
        double[] x = new double[nb];
        int j = 0;
        for (int i = 0; i < this.nbSrc; ++i) {
            if (this.src[i].leg != o.leg) continue;
            x[j] = Double.NaN;
            String s = this.src[i].getValue(nField);
            int n = s.length();
            if (n > 0) {
                if (!Character.isDigit(s.charAt(n - 1))) {
                    s = s.substring(0, n - 1);
                }
                try {
                    x[j] = Double.parseDouble(s);
                }
                catch (Exception e) {
                    x[j] = Double.NaN;
                }
            }
            ++j;
        }
        return x;
    }

    protected synchronized String[] getFieldStringValues(Source o, int nField) {
        int nb = 0;
        for (int i = 0; i < this.nbSrc; ++i) {
            if (this.src[i].leg != o.leg) continue;
            ++nb;
        }
        String[] x = new String[nb];
        int j = 0;
        for (int i = 0; i < this.nbSrc; ++i) {
            if (this.src[i].leg != o.leg) continue;
            x[j] = this.src[i].getValue(nField);
            ++j;
        }
        return x;
    }

    protected void tri(Source o, int nField, boolean ascendant) {
        if (this.isSorting()) {
            return;
        }
        Aladin.makeCursor(this.mcanvas, 1);
        Source.setSort(o, nField, ascendant ? 1 : -1);
        if (this.src.length > 75000) {
            Thread t = new Thread((Runnable)this, "AladinSort");
            Util.decreasePriority(Thread.currentThread(), t);
            t.start();
        } else {
            this.run();
        }
    }

    protected void tag() {
        for (int i = 0; i < this.nbSrc; ++i) {
            this.src[i].setTag(true);
        }
        this.mcanvas.repaint();
        this.aladin.view.repaintAll();
    }

    protected void untag() {
        for (int i = 0; i < this.nbSrc; ++i) {
            this.src[i].setTag(false);
        }
        this.mcanvas.repaint();
        this.aladin.view.repaintAll();
    }

    protected void keepUntag() {
        this.keepTag1(false);
    }

    protected void keepTag() {
        this.keepTag1(true);
    }

    private void keepTag1(boolean keep) {
        for (int i = this.nbSrc - 1; i >= 0; --i) {
            if (this.src[i].isTagged() == keep) continue;
            this.src[i].setSelect(false);
            this.rmSrc(i);
        }
        this.scrollV.setMaximum(this.nbSrc);
        this.aladin.view.majSelect();
        this.mcanvas.repaint();
    }

    protected int searchString(String s, int mode) {
        int rep = this.search(s, mode == -1 ? -1 : 1);
        return rep;
    }

    private void infoSearch(int nOccurence) {
        if (nOccurence >= 0) {
            this.setStatus(MFSEARCH + " => " + nOccurence + " " + MFSEARCHO + (nOccurence > 1 ? "s" : ""));
        } else {
            this.setStatus(MFSEARCHBAD);
        }
    }

    protected boolean selectByString(String s, int clear) {
        this.aladin.view.selectSrcByString(s, clear);
        this.infoSearch(this.nbSrc);
        this.oMasq = "";
        return this.nbSrc > 0;
    }

    protected int search(String masq, int sens) {
        boolean flagSame;
        int n = -1;
        Source t = null;
        int nMasq = masq.length();
        boolean bl = flagSame = nMasq == 0 || masq.equals(this.oMasq);
        if (!flagSame) {
            this.nOccurence = 0;
        }
        this.oMasq = masq;
        if (this.mcanvas.objSelect != null) {
            this.lastOcc = this.mcanvas.objSelect;
        }
        for (int i = 0; i < this.nbSrc; ++i) {
            if (this.src[i] != this.lastOcc) continue;
            n = i;
            break;
        }
        if ((n += sens) == -1) {
            n = sens < 0 ? this.nbSrc - 1 : 0;
        }
        StringBuffer col = new StringBuffer();
        StringBuffer v = new StringBuffer();
        int mode = this.aladin.view.getAdvancedSearch(col, v, masq);
        masq = v.toString();
        boolean abs = false;
        if (col.length() > 0) {
            abs = this.aladin.view.getAbsSearch(col);
        }
        int colIndex = -1;
        double numS = Double.MAX_VALUE;
        boolean numeric = false;
        Legende oLeg = null;
        int i = 0;
        block3: while (i < this.nbSrc) {
            block18: {
                String[] val;
                Source s;
                block19: {
                    if (n >= this.nbSrc) {
                        n = 0;
                    } else if (n < 0) {
                        n = this.nbSrc - 1;
                    }
                    s = this.src[n];
                    if (s == null) break block18;
                    this.lastOcc = s;
                    if (col.length() > 0 && oLeg != s.leg) {
                        colIndex = s.leg.matchIgnoreCaseColIndex(col.toString());
                        if (colIndex == -1) break;
                        numeric = s.leg.isNumField(colIndex);
                        if (numeric) {
                            try {
                                numS = Double.parseDouble(masq);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        oLeg = s.leg;
                    }
                    val = s.getValues();
                    if (colIndex < 0) break block19;
                    if (!this.aladin.view.advancedSearch(mode, numeric, abs, val[colIndex], masq, numS)) break block18;
                    if (t == null) {
                        t = s;
                    }
                    if (flagSame) break;
                    ++this.nOccurence;
                    break block18;
                }
                for (int j = 0; j < val.length; ++j) {
                    if (nMasq != 0 && Util.indexOfIgnoreCase(val[j], masq) < 0) continue;
                    if (t == null) {
                        t = s;
                    }
                    if (flagSame) break block3;
                    ++this.nOccurence;
                    break;
                }
            }
            ++i;
            n += sens;
        }
        int rep = 0;
        if (t != null) {
            this.mcanvas.show(t, 2);
            int n2 = rep = this.aladin.view.setRepere(new Coord(t.raj, t.dej)) ? 1 : -1;
            if (!Aladin.NOGUI) {
                this.aladin.view.showSource(t);
            }
        }
        return rep;
    }

    protected void redisplay() {
        this.mcanvas.reloadHead();
        this.mcanvas.repaint();
    }

    private synchronized void addSrc(Source s) {
        if (this.f == null) {
            this.setReduced(false);
        }
        if (this.nbSrc == this.src.length) {
            Source[] srcBis = new Source[this.src.length > MAXBLOC ? this.src.length + MAXBLOC : this.src.length * 2];
            System.arraycopy(this.src, 0, srcBis, 0, this.src.length);
            this.src = srcBis;
            Object var2_2 = null;
        }
        this.src[this.nbSrc++] = s;
        this.scrollV.setMaximum(this.nbSrc);
        this.mcanvas.unselect();
        this.aladin.calque.zoom.zoomView.stopHist();
        this.aladin.calque.zoom.zoomView.resumeSED();
        this.aladin.console.setEnabledDumpButton(true);
        if (s.leg.isSorted()) {
            s.leg.clearSort();
            this.mcanvas.reloadHead();
        }
        if (this.mcanvas.triTag != 0) {
            this.mcanvas.triTag = 0;
        }
    }

    private synchronized void rmAllSrc() {
        if (this.nbSrc > MAXBLOC) {
            this.src = new Source[DEFAULTBLOC];
        } else {
            for (int i = 0; i < this.nbSrc; ++i) {
                this.src[i] = null;
            }
        }
        this.nbSrc = 0;
        this.mcanvas.unselect();
        this.aladin.calque.zoom.zoomView.stopHist();
        this.aladin.calque.zoom.zoomView.resumeSED();
        this.aladin.console.setEnabledDumpButton(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rmPlanSrc(Plan p) {
        Mesure mesure = this;
        synchronized (mesure) {
            int n = 0;
            for (int i = 0; i < this.nbSrc; ++i) {
                if (this.src[i].plan == p) continue;
                if (i != n) {
                    this.src[n] = this.src[i];
                }
                ++n;
            }
            this.nbSrc = n;
        }
        this.mcanvas.currentsee = -1;
        this.mcanvas.currentselect = -2;
        this.scrollV.setMaximum(this.nbSrc);
        this.mcanvas.unselect();
        this.mcanvas.repaint();
        this.aladin.calque.zoom.zoomView.stopHist();
        this.aladin.calque.zoom.zoomView.resumeSED();
        this.aladin.console.setEnabledDumpButton(this.nbSrc > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Source[] getSources() {
        Mesure mesure = this;
        synchronized (mesure) {
            Source[] s = new Source[this.nbSrc];
            System.arraycopy(this.src, 0, s, 0, this.nbSrc);
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rmSrc(ArrayList list) {
        Mesure mesure = this;
        synchronized (mesure) {
            int n = 0;
            int m = 0;
            int index = m < list.size() ? (Integer)list.get(m) : -1;
            for (int i = 0; i < this.nbSrc; ++i) {
                if (i == index) {
                    index = ++m < list.size() ? (Integer)list.get(m) : -1;
                    continue;
                }
                if (i != n) {
                    this.src[n] = this.src[i];
                }
                ++n;
            }
            this.nbSrc = n;
        }
        this.aladin.calque.zoom.zoomView.stopHist();
        this.aladin.calque.zoom.zoomView.resumeSED();
        this.aladin.console.setEnabledDumpButton(this.nbSrc > 0);
    }

    protected synchronized void rmSrc(int i) {
        while (i < this.src.length - 1) {
            this.src[i] = this.src[i + 1];
            ++i;
        }
        this.src[i] = null;
        --this.nbSrc;
        this.mcanvas.unselect();
        this.aladin.calque.zoom.zoomView.stopHist();
        this.aladin.calque.zoom.zoomView.resumeSED();
        this.aladin.console.setEnabledDumpButton(this.nbSrc > 0);
    }

    protected int findSrc(Source s) {
        for (int i = 0; i < this.nbSrc; ++i) {
            if (this.src[i] != s) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<Source> iterator() {
        return new SourceIterator();
    }

    protected Source getFirstSrc() {
        return this.nbSrc < 1 ? null : this.src[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNbSrc() {
        Object object = this.verrou;
        synchronized (object) {
            return this.nbSrc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void memoWordLineClear() {
        Object object = this.verrou;
        synchronized (object) {
            this.memoWL.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void memoWordLine(Vector wl, int i) {
        Object object = this.verrou;
        synchronized (object) {
            this.memoWL.put(new Integer(i), wl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getWordLine(int i) {
        Object object = this.verrou;
        synchronized (object) {
            Vector wl = (Vector)this.memoWL.get(new Integer(i));
            if (wl != null) {
                return wl;
            }
            return this.getWordLine(this.src[i]);
        }
    }

    protected Vector getHeadLine(Source o) {
        Legende leg = o.leg;
        Vector<Object> wordLine = new Vector<Object>(leg.field.length + 2);
        wordLine.addElement(o);
        wordLine.addElement(new Words(""));
        for (int i = 0; i < leg.field.length; ++i) {
            if (!leg.isVisible(i)) continue;
            Words w = new Words(leg.field[i].name, o.leg.getWidth(i), o.leg.getPrecision(i), 2, o.leg.computed.length == 0 ? false : o.leg.computed[i], leg.field[i].sort);
            w.pin = i == 0;
            wordLine.addElement(w);
        }
        return wordLine;
    }

    protected Vector getWordLine(Source o) {
        if (o == null) {
            return null;
        }
        String s = o.info != null ? o.info : o.id;
        StringTokenizer st = new StringTokenizer(s, "\t");
        Vector<Object> wordLine = new Vector<Object>(st.countTokens() + 1);
        wordLine.addElement(o);
        int indexFootPrint = o.getIdxFootprint();
        int i = 0;
        while (st.hasMoreTokens()) {
            block11: {
                Words w;
                String tag;
                block10: {
                    int align;
                    block9: {
                        tag = st.nextToken();
                        if (i != 0) break block9;
                        w = new Words(tag);
                        break block10;
                    }
                    if (!o.leg.isVisible(i - 1)) break block11;
                    int n = align = o.leg.isNumField(i - 1) ? 1 : 0;
                    if (indexFootPrint == i - 1) {
                        w = new Words("  FoV", o.leg.getWidth(i - 1), o.leg.getPrecision(i - 1), 0, false, true);
                    } else {
                        if (o.leg.isNullValue(tag, i - 1)) {
                            tag = "";
                        }
                        w = new Words(tag, o.leg.getWidth(i - 1), o.leg.getPrecision(i - 1), align, o.leg.computed.length == 0 ? false : o.leg.computed[i - 1], 0);
                    }
                }
                w.show = o == this.mcanvas.objSelect || o == this.mcanvas.objShow;
                wordLine.addElement(w);
                if (w.glu && w.size < tag.length()) {
                    tag = tag.substring(w.size + 1, tag.length());
                    wordLine.addElement(new Words(tag));
                }
            }
            ++i;
        }
        return wordLine;
    }

    protected void split(boolean flagSplit) {
        if (flagSplit == this.flagSplit) {
            return;
        }
        this.flagSplit = flagSplit;
        if (flagSplit) {
            this.previousHeight = this.mcanvas.getSize().height;
            this.haut.setVisible(true);
            this.status.setSize(this.status.getSize().width, this.status.H);
            this.mcanvas.setSize(this.mcanvas.getSize().width, 600);
            this.scrollV.setSize(this.scrollV.getSize().width, 600);
        } else {
            this.haut.setVisible(false);
            this.mcanvas.setSize(this.mcanvas.getSize().width, this.previousHeight);
            this.scrollV.setSize(this.scrollV.getSize().width, this.previousHeight);
            if (!this.flagReduced) {
                this.aladin.splitH.restoreMesureHeight();
            }
        }
        this.setSize(this.getPreferredSize());
    }

    protected boolean isReduced() {
        return this.flagReduced;
    }

    protected void switchReduced() {
        if (this.f != null) {
            this.split();
        }
        this.setReduced(!this.flagReduced);
    }

    protected void setReduced(boolean flag) {
        if (this.flagReduced == flag) {
            return;
        }
        this.flagReduced = flag;
        if (this.flagReduced) {
            this.aladin.search.hideSearch(true);
            if (this.aladin.splitH.getBottomComponent() != null) {
                this.aladin.splitH.remove(this);
            }
        } else {
            this.aladin.search.hideSearch(false);
            if (this.aladin.splitH.getBottomComponent() == null) {
                this.aladin.splitH.setBottomComponent(this);
            }
            this.flagDorepaintForScroll = true;
            this.aladin.splitH.restoreMesureHeight();
        }
    }

    protected void setStatus(String text) {
        if (this.flagSplit) {
            this.status.setText(text);
        } else {
            this.aladin.status.setText(text);
        }
    }

    protected void insertInfo(Source o) {
        this.addSrc(o);
        this.mcanvas.currentselect = -2;
    }

    protected String getCurObjVal() {
        if (this.mcanvas.sCourante == null || this.mcanvas.indiceCourant == -1) {
            return "";
        }
        return this.mcanvas.sCourante.getValue(this.mcanvas.indiceCourant);
    }

    protected String getCurObjCoord() {
        Source s = this.mcanvas.objSelect;
        if (s == null) {
            return "";
        }
        return this.aladin.localisation.J2000ToString(s.raj, s.dej);
    }

    protected String getText() {
        return this.getText(false);
    }

    protected String getText(boolean ascii) {
        StringBuffer res = new StringBuffer();
        String sep = ascii ? "    " : "\t";
        for (int i = 0; i < this.nbSrc; ++i) {
            Vector v = this.getWordLine(i);
            Enumeration e = v.elements();
            e.nextElement();
            int k = -1;
            while (e.hasMoreElements()) {
                Words w = (Words)e.nextElement();
                if (ascii && k >= 0) {
                    int length = w.text.length() > w.width ? 1 : w.width - w.text.length() + 1;
                    sep = Util.fillWithBlank("", length);
                }
                if (w.repere) {
                    int deb = w.text.indexOf(34);
                    int fin = w.text.lastIndexOf(34);
                    if (ascii) {
                        sep = "    ";
                    }
                    if (deb >= 0 && fin > deb) {
                        res.append(w.text.substring(deb + 1, fin) + ":" + sep);
                    }
                } else {
                    res.append(w.text);
                    if (e.hasMoreElements()) {
                        res.append(sep);
                    }
                }
                ++k;
            }
            res.append(Util.CR);
        }
        return res.toString();
    }

    protected String getCurObjMeasurement() {
        StringBuffer sb = new StringBuffer();
        Source s = this.mcanvas.objSelect;
        if (s == null) {
            return "";
        }
        Vector v = this.getWordLine(s);
        Enumeration e = v.elements();
        e.nextElement();
        while (e.hasMoreElements()) {
            Words w = (Words)e.nextElement();
            if (w.repere) {
                int deb = w.text.indexOf(34);
                int fin = w.text.lastIndexOf(34);
                if (deb < 0 || fin <= deb) continue;
                sb.append(w.text.substring(deb + 1, fin) + ":" + "\t");
                continue;
            }
            sb.append(w.text);
            if (!e.hasMoreElements()) continue;
            sb.append("\t");
        }
        return sb.toString();
    }

    protected void removeAllElements() {
        this.mcanvas.currentselect = -2;
        this.mcanvas.oleg = null;
        this.rmAllSrc();
        this.scrollV.setValues(0, 1, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(Source s) {
        boolean dopaint = false;
        Mesure mesure = this;
        synchronized (mesure) {
            for (int i = 0; i < this.nbSrc; ++i) {
                Source o = this.src[i];
                if (o != s) continue;
                dopaint = true;
                this.rmSrc(i);
                this.scrollV.setMaximum(this.nbSrc);
                break;
            }
        }
        if (dopaint) {
            this.display();
        }
    }

    protected void display() {
        this.mcanvas.currentsee = -1;
        this.mcanvas.currentselect = -2;
        Source s = this.aladin.mesure.getFirstSrc();
        if (s == null && this.aladin.view.zoomview.flagSED || s != null && s.leg != null && s.leg.isSED()) {
            this.aladin.view.zoomview.setSED(s);
        }
        this.mcanvas.repaint();
    }

    protected void setInfo(Source o) {
        this.insertInfo(o);
        this.adjustScroll();
    }

    protected void adjustScroll() {
        this.mcanvas.initX();
        int nl = this.mcanvas.nbligne;
        int val = this.nbSrc - nl;
        if (val < 0) {
            val = 0;
        }
        int extend = nl;
        this.scrollV.setValues(val, extend, 0, this.nbSrc - 1);
        this.scrollV.setBlockIncrement(nl - 1);
    }

    @Override
    public WidgetControl getWidgetControl() {
        return this.voc;
    }

    @Override
    public void createWidgetControl(int x, int y, int width, int height, float opacity, JComponent parent) {
        this.voc = new WidgetControl(this, x, y, width, height, opacity, parent);
        this.voc.setResizable(true);
    }

    @Override
    public void paintCollapsed(Graphics g) {
    }

    class SourceIterator
    implements Iterator<Source> {
        int i;

        SourceIterator() {
            this.i = Mesure.this.nbSrc;
        }

        @Override
        public boolean hasNext() {
            return this.i > 0;
        }

        @Override
        public Source next() {
            return Mesure.this.src[--this.i];
        }

        @Override
        public void remove() {
        }
    }
}

