/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MetaDataTree;
import java.awt.Component;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class MacroModel {
    private String script;
    private ParamTableModel paramTableModel;
    private TableCellEditor tableCellEditor;
    private Aladin a;

    public MacroModel(Aladin a) {
        this.a = a;
        this.paramTableModel = new ParamTableModel(0);
        this.tableCellEditor = new MyCellEditor();
    }

    protected String getScript() {
        return this.script;
    }

    protected void setScript(String script) {
        this.script = script;
    }

    protected void executeScript(String command, Map params) {
        if (command.trim().length() == 0 || command.trim().startsWith("#")) {
            return;
        }
        Set paramSet = params.keySet();
        Object[] paramNames = paramSet.toArray();
        for (int j = 0; j < paramNames.length; ++j) {
            String curParam = (String)paramNames[j];
            command = MetaDataTree.replace(command, curParam, (String)params.get(curParam), -1);
        }
        this.a.execCommand(command);
    }

    protected ParamTableModel getParamTableModel() {
        return this.paramTableModel;
    }

    protected TableCellEditor getTableCellEditor() {
        return this.tableCellEditor;
    }

    class MyCellEditor
    extends DefaultCellEditor {
        private int row;

        public MyCellEditor() {
            super(new JTextField());
        }

        @Override
        public Object getCellEditorValue() {
            String s = (String)super.getCellEditorValue();
            if (this.row == MacroModel.this.paramTableModel.getRowCount() - 1 && s.length() > 0) {
                MacroModel.this.paramTableModel.addEmptyRecord();
            }
            return s;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    class ParamTableModel
    extends AbstractTableModel {
        protected String[] columnNames;
        protected Vector dataVector;

        public ParamTableModel(int nbCol) {
            this.initColumnNames(nbCol);
            this.dataVector = new Vector();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public Class getColumnClass(int column) {
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == -1 || row == -1) {
                return null;
            }
            ParamRecord record = (ParamRecord)this.dataVector.get(row);
            return record.getValue(column);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            ParamRecord record = (ParamRecord)this.dataVector.get(row);
            record.setValue(column, value.toString());
            this.fireTableCellUpdated(row, column);
        }

        @Override
        public int getRowCount() {
            return this.dataVector.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        private void initColumnNames(int nbCol) {
            this.columnNames = new String[nbCol];
            for (int i = 0; i < nbCol; ++i) {
                this.columnNames[i] = "$" + (i + 1);
            }
            this.fireTableStructureChanged();
        }

        public void reset() {
            this.initColumnNames(0);
            this.dataVector = new Vector();
        }

        public void addRecord(ParamRecord record) {
            if (record == null) {
                record = new ParamRecord();
                record.setValues(new String[this.getColumnCount()]);
            }
            if (record.values != null && record.values.length > this.getColumnCount()) {
                this.initColumnNames(record.values.length);
            }
            this.dataVector.addElement(record);
            this.fireTableRowsInserted(this.dataVector.size() - 1, this.dataVector.size() - 1);
        }

        public void addRecord(String[] values) {
            ParamRecord record = new ParamRecord();
            record.setValues(values);
            this.addRecord(record);
        }

        public void initTable() {
            this.addEmptyRecord();
        }

        public ParamRecord[] getRecords() {
            Object[] records = new ParamRecord[this.dataVector.size()];
            this.dataVector.copyInto(records);
            return records;
        }

        public void addEmptyRecord() {
            this.addRecord((ParamRecord)null);
        }

        public void addEmptyCol() {
            int nbCol = this.getColumnCount();
            this.initColumnNames(nbCol + 1);
        }

        public void deleteRecord(int idx) {
            if (idx < 0 || idx > this.getRowCount() - 1) {
                return;
            }
            this.dataVector.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }
    }

    class ParamRecord {
        String[] values;

        ParamRecord() {
        }

        void setValues(String[] val) {
            this.values = val;
        }

        String[] getValues() {
            return this.values;
        }

        String getValue(int idx) {
            if (this.values == null || idx >= this.values.length) {
                return "";
            }
            return this.values[idx];
        }

        void setValue(int col, String val) {
            if (col >= this.values.length) {
                String[] tmp = new String[col + 1];
                System.arraycopy(this.values, 0, tmp, 0, this.values.length);
                this.values = tmp;
            }
            this.values[col] = val;
        }

        public String toString() {
            if (this.values == null) {
                return "";
            }
            StringBuffer ret = new StringBuffer();
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] != null) {
                    ret.append(this.values[i]);
                }
                if (i >= this.values.length - 1) continue;
                ret.append("\t");
            }
            return ret.toString();
        }

        boolean isEmpty() {
            if (this.values == null) {
                return true;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == null || this.values[i].length() <= 0) continue;
                return false;
            }
            return true;
        }
    }
}

