/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.HealpixAllsky;
import cds.aladin.HealpixKeyPol;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.Save;
import cds.aladin.ViewSimple;
import cds.fits.Fits;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Hpix;
import cds.tools.pixtools.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class HealpixKey
implements Comparable<HealpixKey> {
    static final int UNKNOWN = 0;
    static final int ASKING = 1;
    static final int TOBELOADFROMCACHE = 2;
    static final int TOBELOADFROMNET = 3;
    static final int LOADINGFROMCACHE = 4;
    static final int LOADINGFROMNET = 5;
    static final int READY = 6;
    static final int ERROR = 7;
    static final int ABORTING = 8;
    static final int PURGING = 9;
    public static int NBSTATUS = 10;
    public static final String[] STATUS = new String[]{"UNKOWN", "ASKING", "TOBELOADFROMCACHE", "TOBELOADFROMNET", "LOADINGFROMCACHE", "LOADINGFROMNET", "READY", "ERROR", "ABORTING", "PURGING"};
    protected int status;
    protected long timer;
    protected long timerLoad;
    protected int priority;
    protected PlanBG planBG;
    protected int order;
    protected long npix;
    protected int z;
    protected Hpix hpix;
    protected String fileCache;
    protected String fileNet;
    protected int width;
    protected int height;
    protected byte[] pixels;
    protected byte[] pixelsOrigin;
    protected int[] rgb;
    protected Image imgBuf;
    protected int imgID;
    protected byte[] stream;
    protected boolean truePixels;
    protected boolean alreadyCached;
    protected boolean allSky;
    protected boolean fromNet;
    protected int timeStream;
    protected int timeNet;
    protected long sizeStream;
    private int timeJPEG;
    private int timePixel;
    private int typeColor;
    protected HealpixKey[] fils;
    protected HealpixKey anc;
    protected int parente;
    protected Point p;
    int oiz;
    int vHashCode;
    public static final int NOW = 0;
    public static final int ONLYIFRAMAVAIL = 1;
    public static final int ONLYIFDISKAVAIL = 2;
    public static final int PIX8 = 3;
    protected static final int JPEG = 0;
    protected static final int FITS = 1;
    protected static final int TSV = 2;
    protected static final int XML = 3;
    protected static final int PNG = 4;
    protected static final int IDX = 5;
    public static final String[] EXT = new String[]{".jpg", ".fits", ".tsv", ".xml", ".png", ""};
    protected int extCache;
    protected int extNet;
    public static final int NOLOAD = 0;
    public static final int ASYNC = 1;
    public static final int SYNC = 2;
    public static final int SYNCONLYIFLOCAL = 3;
    public static final int TESTNET = 4;
    boolean retry;
    static final int SIZESLOW = 512;
    static final int SIZEFAST = 8192;
    private static final Component observer = new Label();
    private Object lockStatus;
    static final int DEATH = -1;
    static final int MAYBEDEATH = -2;
    static final int INLIFE = -3;
    protected static final String[] VIE = new String[]{"", "DEATH", "MAYBEDEATH", "INLIFE"};
    private static final double RAPPORT = 5.0;
    static final double M = 90000.0;
    static final double N = 22500.0;
    static final double RAP = 0.7;
    protected static int nDraw = 0;
    protected static int nOut = 0;
    private boolean flagSym;
    private long loadDate;
    private static final long TIMEFADER = 1500L;
    private static final float MINFADER = 0.6f;
    static final Color BLUE1 = new Color(0, 0, 255);
    static final Color BLUE2 = new Color(10, 52, 128);
    static final Color BLUE3 = new Color(51, 144, 198);

    protected HealpixKey() {
        this.status = 0;
        this.priority = -1;
        this.imgID = -2;
        this.fromNet = true;
        this.fils = null;
        this.anc = null;
        this.parente = 0;
        this.p = new Point(0, 0);
        this.oiz = -1;
        this.vHashCode = -1;
        this.extCache = 0;
        this.extNet = 0;
        this.retry = false;
        this.lockStatus = new Object();
        this.loadDate = System.currentTimeMillis();
    }

    protected HealpixKey(PlanBG planBG) {
        this.status = 0;
        this.priority = -1;
        this.imgID = -2;
        this.fromNet = true;
        this.fils = null;
        this.anc = null;
        this.parente = 0;
        this.p = new Point(0, 0);
        this.oiz = -1;
        this.vHashCode = -1;
        this.extCache = 0;
        this.extNet = 0;
        this.retry = false;
        this.lockStatus = new Object();
        this.loadDate = System.currentTimeMillis();
        this.planBG = planBG;
    }

    protected HealpixKey(PlanBG planBG, int order, long npix) {
        this(planBG, order, npix, 1);
    }

    protected HealpixKey(PlanBG planBG, int order, long npix, int mode) {
        this(planBG, order, npix, (int)planBG.getZ(), mode);
    }

    protected HealpixKey(PlanBG planBG, int order, long npix, int z, int mode) {
        block8: {
            this.status = 0;
            this.priority = -1;
            this.imgID = -2;
            this.fromNet = true;
            this.fils = null;
            this.anc = null;
            this.parente = 0;
            this.p = new Point(0, 0);
            this.oiz = -1;
            this.vHashCode = -1;
            this.extCache = 0;
            this.extNet = 0;
            this.retry = false;
            this.lockStatus = new Object();
            this.loadDate = System.currentTimeMillis();
            this.planBG = planBG;
            this.order = order;
            this.npix = npix;
            this.z = z;
            this.hpix = new Hpix(order, npix, planBG.frameOrigin);
            if (mode == 0) {
                return;
            }
            this.allSky = false;
            this.alreadyCached = false;
            this.setStatus(1);
            if (!this.allSky) {
                ++planBG.nbCreated;
            }
            this.resetTimer();
            this.extCache = this.extNet = planBG.getTileMode();
            this.fileNet = this.getFileNet();
            this.fileCache = this.getFileCache();
            try {
                if (mode == 4) {
                    this.stream = this.loadStream(planBG.url + "/" + this.fileNet);
                    if (this.stream != null) {
                        this.sizeStream = this.stream.length;
                    }
                    this.stream = null;
                } else if (mode == 2 || mode == 3 && (planBG.useCache && this.isCached() || planBG.isLocalAllSky())) {
                    this.loadNow();
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block8;
                e.printStackTrace();
            }
        }
    }

    protected String getFileNet() {
        return HealpixKey.getFilePath(null, this.order, this.npix, this.z) + EXT[this.extNet];
    }

    protected String getFileCache() {
        return HealpixKey.getFilePath(this.planBG.getCacheName(), this.order, this.npix, this.z) + EXT[this.extCache];
    }

    protected HealpixKey(HealpixKey father, int child) {
        this.status = 0;
        this.priority = -1;
        this.imgID = -2;
        this.fromNet = true;
        this.fils = null;
        this.anc = null;
        this.parente = 0;
        this.p = new Point(0, 0);
        this.oiz = -1;
        this.vHashCode = -1;
        this.extCache = 0;
        this.extNet = 0;
        this.retry = false;
        this.lockStatus = new Object();
        this.loadDate = System.currentTimeMillis();
        this.planBG = father.planBG;
        this.order = father.order + 1;
        this.npix = father.npix * 4L + (long)child;
        this.hpix = new Hpix(this.order, this.npix, this.planBG.frameOrigin);
        this.anc = father.anc;
        if (this.anc == null) {
            this.anc = father;
        }
        this.width = this.height = father.width / 2;
        int offsetX = child == 2 || child == 3 ? this.width : 0;
        int offsetY = child == 1 || child == 3 ? this.width : 0;
        this.p = new Point(father.p.x + offsetX, father.p.y + offsetY);
        this.parente = father.parente + 1;
        this.resetTimer();
        this.pixels = null;
        this.rgb = null;
        this.alreadyCached = true;
        this.allSky = father.allSky;
        this.setStatus(0);
    }

    protected HealpixKey[] getChild() {
        if (this.getStatus() != 6) {
            return null;
        }
        try {
            if (this.fils != null && this.fils[0].getStatus() == 6 && this.fils[1].getStatus() == 6 && this.fils[2].getStatus() == 6 && this.fils[3].getStatus() == 6) {
                return this.fils;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        HealpixKey[] f1 = new HealpixKey[4];
        for (int child = 0; child < 4; ++child) {
            HealpixKey f = this instanceof HealpixKeyPol ? new HealpixKeyPol((HealpixKeyPol)this, child) : new HealpixKey(this, child);
            f.setStatus(6);
            f1[child] = f;
        }
        this.fils = f1;
        return this.fils;
    }

    protected byte[] getPixelFromAncetre() throws Exception {
        byte[] pixAnc = this.anc.pixels == null ? this.anc.getPixelFromAncetre() : this.anc.pixels;
        byte[] pixels = new byte[this.width * this.height];
        for (int y = 0; y < this.width; ++y) {
            for (int x = 0; x < this.width; ++x) {
                pixels[y * this.width + x] = pixAnc[(y + this.p.y) * this.anc.width + (x + this.p.x)];
            }
        }
        return pixels;
    }

    private int[] getPixelFromAncetreRGB() throws Exception {
        int[] rgb = new int[this.width * this.width];
        int[] pixAnc = this.anc.rgb != null ? this.anc.rgb : this.anc.getPixelFromAncetreRGB();
        for (int y = 0; y < this.width; ++y) {
            for (int x = 0; x < this.width; ++x) {
                rgb[y * this.width + x] = pixAnc[(y + this.p.y) * this.anc.width + (x + this.p.x)];
            }
        }
        return rgb;
    }

    protected static String getFilePath(String survey, int order, long npix, int z) {
        return (survey != null ? survey + "/" : "") + Util.getFilePath(order, npix, z);
    }

    protected String getStringNumber() {
        return this.order + "/" + this.npix + (this.z <= 0 ? "" : "_" + this.z);
    }

    public String toString() {
        String code = this.status == 5 || this.status == 4 ? ">>" : (this.status == 3 || this.status == 2 ? " >" : " .");
        return code + "[" + cds.tools.Util.align(this.priority + "", 5) + "] " + cds.tools.Util.align(this.getStringNumber() + (this.fils != null ? ">" : " "), 8) + cds.tools.Util.align(this.getLongFullMem(), 8) + (this.truePixels ? " truePix " : "         ") + cds.tools.Util.align(this.getStatusString(), 16) + (this.timer == -1L ? -1L : this.getCurrentLiveTime() / 1000L) + "s => " + VIE[-this.getLive()] + (this.getStatus() == 6 ? (this.fromNet ? " Net" : " Cache") + ":" + this.timeStream + "+" + this.timeJPEG + "+" + this.timePixel + "ms" : "");
    }

    protected int free() {
        int rep = 0;
        try {
            rep += this.free1();
            rep += this.filsFree();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rep;
    }

    protected int free1() {
        int rep = 0;
        int status = this.getStatus();
        if (this.parente == 0) {
            ++this.planBG.nbFree;
            if (status == 4 || status == 5) {
                this.abort();
            } else if (status == 6 && this.planBG.useCache) {
                this.write();
            }
        }
        this.setStatus(0);
        if (this.pixels != null) {
            this.pixels = null;
            rep = 1;
        }
        if (this.rgb != null) {
            this.rgb = null;
            rep = 1;
        }
        if (this.imgBuf != null) {
            this.imgBuf.flush();
            this.imgBuf = null;
            rep = 1;
        }
        if (this.pixelsOrigin != null) {
            this.pixelsOrigin = null;
            rep = 1;
        }
        return rep;
    }

    protected int filsFree() {
        int rep = 0;
        if (this.fils != null) {
            for (int i = 0; i < 4; ++i) {
                rep += this.fils[i].free();
            }
            this.fils = null;
        }
        return rep;
    }

    protected boolean purgeFils() {
        boolean rep = true;
        if (this.fils != null) {
            for (int i = 0; i < 4; ++i) {
                if (this.fils[i] == null) continue;
                rep = rep && this.fils[i].purgeFils();
            }
        }
        if (rep) {
            if (this.parente == 0) {
                this.fils = null;
                return rep;
            }
            if (this.getLive() == -1) {
                this.free();
                return true;
            }
        }
        return false;
    }

    protected void clearBuf() {
        if (this.pixelsOrigin != null) {
            this.pixelsOrigin = null;
        }
        if (this.imgBuf == null) {
            return;
        }
        if (this.fils != null) {
            for (int i = 0; i < 4; ++i) {
                if (this.fils[i] == null) continue;
                this.fils[i].clearBuf();
            }
        }
        this.imgBuf = null;
    }

    protected void loadFromNet() {
        block4: {
            this.setStatus(5);
            try {
                String fileName = this.planBG.url + "/" + this.fileNet;
                char c = this.planBG.url.charAt(this.planBG.url.length() - 1);
                if (c == '\\' || c == '/') {
                    fileName = this.planBG.url + this.fileNet;
                }
                this.planBG.nByteReadNet += this.loadNet(fileName);
                this.alreadyCached = false;
                this.resetTimer();
                this.setTimerLoad();
                this.setStatus(6);
                ++this.planBG.nbLoadNet;
                this.parente = 0;
                this.fromNet = true;
                this.planBG.cumulTimeLoadNet += (long)this.timeNet;
                this.planBG.cumulTimeStream += (long)this.timeStream;
                this.planBG.cumulTimeJPEG += (long)this.timeJPEG;
                this.planBG.cumulTimePixel += (long)this.timePixel;
                this.planBG.askForRepaint();
            }
            catch (Throwable e) {
                boolean notFoundError;
                this.pixels = null;
                this.rgb = null;
                if (this.getStatus() == 8) break block4;
                boolean bl = notFoundError = e instanceof FileNotFoundException || e.getMessage() != null && e.getMessage().indexOf("HTTP response code: 40") >= 0;
                if (!notFoundError && !this.retry && this.planBG.checkSite(true)) {
                    this.retry = true;
                    this.loadFromNet();
                    return;
                }
                this.setStatus(7);
                if (!(this instanceof HealpixAllsky)) break block4;
                this.planBG.askForRepaint();
            }
        }
    }

    protected long loadNet(String fileName) throws Exception {
        long n = 0L;
        n = this.extNet == 0 || this.extNet == 4 ? (long)this.loadJpeg(fileName) : (long)this.loadFits(fileName);
        if (!this.planBG.useCache) {
            this.stream = null;
        }
        return n;
    }

    protected void loadFromCache() {
        block7: {
            this.setStatus(4);
            try {
                long t = System.currentTimeMillis();
                String pathName = this.planBG.getCacheDir();
                if (pathName == null) {
                    throw new Exception("Cache not ready");
                }
                pathName = pathName + cds.tools.Util.FS + this.fileCache;
                try {
                    this.updateCacheIfRequired(1000);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.planBG.nByteReadCache += this.loadCache(pathName);
                    this.alreadyCached = true;
                    this.resetTimer();
                    this.setTimerLoad();
                    this.setStatus(6);
                    this.parente = 0;
                    ++this.planBG.nbLoadCache;
                    this.fromNet = false;
                    this.planBG.cumulTimeLoadCache += System.currentTimeMillis() - t;
                    this.planBG.askForRepaint();
                    this.planBG.touchCache();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    new File(pathName).delete();
                    throw e;
                }
            }
            catch (Exception e) {
                this.pixels = null;
                this.alreadyCached = false;
                if (this.getStatus() == 8) break block7;
                this.setStatus(3);
                if (Aladin.levelTrace < 3) break block7;
                e.printStackTrace();
            }
        }
    }

    protected void updateCacheIfRequired(int time) throws Exception {
    }

    protected void loadNow() throws Exception {
        if (this.getStatus() != 6) {
            if (this.planBG.useCache && this.isCached()) {
                this.setStatus(2);
                this.loadFromCache();
            }
            if (!this.planBG.useCache || !this.isCached()) {
                this.setStatus(3);
                this.loadFromNet();
            }
        } else {
            this.resetTimer();
        }
        if (this.getStatus() == 6) {
            if (this.allSky) {
                this.planBG.setTileOrder(this.getLosangeOrder());
            }
            if (this.planBG.isTruePixels()) {
                this.loadPixelsOrigin(2);
            }
            if (this.planBG.useCache) {
                this.write();
            }
        }
    }

    protected long loadCache(String pathName) throws Exception {
        long n = this.extCache == 0 || this.extCache == 4 ? (long)this.loadJpeg(pathName) : (long)this.loadFits(pathName);
        this.stream = null;
        File f = new File(pathName);
        f.setLastModified(System.currentTimeMillis());
        return n;
    }

    protected boolean isCached() {
        if (this.alreadyCached) {
            return true;
        }
        String pathName = this.planBG.getCacheDir();
        if (pathName == null) {
            return false;
        }
        File f = new File(pathName = pathName + cds.tools.Util.FS + this.fileCache);
        if (f.exists() && f.canRead()) {
            this.alreadyCached = true;
            return true;
        }
        return false;
    }

    protected boolean shouldBeCached() {
        if (this.alreadyCached) {
            return false;
        }
        return this.getStatus() == 6;
    }

    protected void write() {
        if (this.alreadyCached) {
            return;
        }
        try {
            long t = System.currentTimeMillis();
            int n = this.writeCache();
            this.planBG.nByteWriteCache += (long)n;
            ++this.planBG.nbWriteCache;
            this.planBG.cumulTimeWriteCache += System.currentTimeMillis() - t;
            PlanBG.addInCache(n / 1024);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.alreadyCached = true;
    }

    protected int writeCache() throws Exception {
        int n = 0;
        if (this.stream != null) {
            n = this.writeStream();
            this.stream = null;
        } else {
            n = this.writeFits();
        }
        return n;
    }

    protected void abort() {
        if (this.npix == -1L) {
            return;
        }
        ++this.planBG.nbAborted;
        this.setStatus(8, true);
    }

    private FileOutputStream openOutputStream() throws Exception {
        String pathName = this.planBG.getCacheDir() + cds.tools.Util.FS + this.fileCache;
        File f = new File(pathName);
        if (f.exists()) {
            f.delete();
        }
        cds.tools.Util.createPath(pathName);
        FileOutputStream ois = new FileOutputStream(pathName);
        return ois;
    }

    private boolean slowDown() {
        return this.planBG.aladin.view.mustDrawFast();
    }

    public byte[] readFully(MyInputStream in, boolean fastLoad) throws Exception {
        Vector<byte[]> v = new Vector<byte[]>(10);
        Vector<Integer> vSize = new Vector<Integer>(10);
        int n = 0;
        int m = 0;
        int i = 0;
        int j = 0;
        long t = System.currentTimeMillis();
        boolean letTimeForDragging = this.slowDown();
        int size = 512;
        byte[] tmp = new byte[size];
        while ((n = in.read(tmp, 0, size)) != -1) {
            ++i;
            if (this.getStatus() == 8) {
                throw new Exception("readFullly aborted !");
            }
            v.addElement(tmp);
            long t1 = System.currentTimeMillis();
            if (t1 - t > 10L) {
                letTimeForDragging = this.slowDown();
                t = t1;
            }
            if (!fastLoad && letTimeForDragging) {
                cds.tools.Util.pause(10);
                size = 512;
            } else {
                size = 8192;
            }
            vSize.addElement(new Integer(n));
            m += n;
            tmp = new byte[size];
        }
        byte[] tab = new byte[m];
        j = v.size();
        n = 0;
        for (i = 0; i < j; ++i) {
            tmp = (byte[])v.elementAt(i);
            m = (Integer)vSize.elementAt(i);
            System.arraycopy(tmp, 0, tab, n, m);
            n += m;
        }
        return tab;
    }

    protected byte[] loadStream(String filename) throws Exception {
        return this.loadStream(filename, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] loadStream(String filename, int skip) throws Exception {
        byte[] buf;
        boolean local = true;
        long t1 = cds.tools.Util.getTime();
        MyInputStream dis = null;
        boolean fastLoad = this instanceof HealpixAllsky;
        if (filename.startsWith("http://")) {
            local = false;
            try {
                dis = cds.tools.Util.openStream(filename, false, 10000);
                if (skip > 0) {
                    dis.skip(skip);
                }
                buf = this.readFully(dis, fastLoad);
            }
            finally {
                if (dis != null) {
                    dis.close();
                }
            }
        }
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(filename, "r");
            byte[] c = new byte[8];
            f.readFully(c);
            if ((c[0] & 0xFF) == 255 && (c[1] & 0xFF) == 216) {
                this.typeColor = 0;
            } else if ((c[0] & 0xFF) == 137 && c[1] == 80 && c[2] == 78 && c[3] == 71 && c[4] == 13 && c[5] == 10 && c[6] == 26 && c[7] == 10) {
                this.typeColor = 4;
            }
            if ((c[0] & 0xFF) == 31 && (c[1] & 0xFF) == 139) {
                FileInputStream fgz = new FileInputStream(new File(filename));
                dis = new MyInputStream(new GZIPInputStream(fgz));
                if (skip > 0) {
                    dis.skip(skip);
                }
                buf = this.readFully(dis, fastLoad);
            } else {
                f.seek(skip);
                buf = new byte[(int)(f.length() - (long)skip)];
                f.readFully(buf);
            }
        }
        finally {
            if (f != null) {
                f.close();
            }
            if (dis != null) {
                dis.close();
            }
        }
        int t = (int)(cds.tools.Util.getTime() - t1);
        if (local) {
            this.timeStream = t;
        } else {
            this.timeNet = t;
        }
        return buf;
    }

    private int loadJpeg(String filename) throws Exception {
        this.stream = this.loadStream(filename);
        this.truePixels = false;
        int n = this.stream.length;
        long t1 = cds.tools.Util.getTime();
        Image img = Toolkit.getDefaultToolkit().createImage(this.stream);
        if (this.extCache != 0 && this.extCache != 4 || !this.planBG.useCache) {
            this.stream = null;
        }
        boolean encore = true;
        while (encore) {
            try {
                if (this.getStatus() == 8) {
                    throw new Exception("Aborting");
                }
                MediaTracker mt = new MediaTracker(Aladin.aladin);
                mt.addImage(img, 0);
                mt.waitForID(0);
                encore = false;
            }
            catch (InterruptedException e) {}
        }
        this.width = img.getWidth(Aladin.aladin);
        this.height = img.getHeight(Aladin.aladin);
        if (this.width == -1) {
            throw new Exception("width = -1");
        }
        this.timeJPEG = (int)(cds.tools.Util.getTime() - t1);
        if (this.planBG.colorUnknown && this instanceof HealpixAllsky) {
            this.planBG.color = cds.tools.Util.isColoredImage(this.stream);
            this.planBG.colorUnknown = false;
            Aladin cfr_ignored_0 = this.planBG.aladin;
            Aladin.trace(4, "HealpixKey.loadJpeg(" + filename + ") => " + (this.typeColor == 4 ? "PNG" : "JPEG") + " " + (this.planBG.color ? "color" : " grey levels"));
        }
        if (!this.planBG.color) {
            if (this.planBG.pixMode == -1) {
                this.planBG.pixMode = this.extCache == 0 ? 3 : 4;
            }
            this.pixels = this.getPixels(img);
            this.planBG.setBufPixels8(this.pixels);
            this.planBG.pixelMin = this.planBG.pixMode == 4 ? 1.0 : 0.0;
            this.planBG.pixelMax = 255.0;
            this.planBG.dataMin = this.planBG.pixMode == 4 ? 1.0 : 0.0;
            this.planBG.dataMax = 255.0;
        } else {
            if (this.planBG.pixMode == -1) {
                this.planBG.pixMode = this.typeColor == 4 ? 0 : 1;
            }
            this.planBG.video = 0;
            this.rgb = this.getPixelsRGB(img);
        }
        if (this instanceof HealpixAllsky) {
            if (this.planBG.cm == null) {
                this.planBG.creatDefaultCM();
            }
            this.planBG.colorPNG = this.typeColor == 4;
        }
        return n;
    }

    protected double getValue(byte[] head, String key) throws Exception {
        int n = head.length / 80;
        for (int i = 0; i < n; ++i) {
            String k = new String(head, i * 80, 8).trim();
            if (!k.equals(key)) continue;
            int pos = i * 80 + 9;
            while (head[pos] == 32) {
                ++pos;
            }
            int len = 0;
            while (Character.isDigit((char)head[pos + len]) || (char)head[pos + len] == '-' || (char)head[pos + len] == '.' || Character.toUpperCase((char)head[pos + len]) == 'E') {
                ++len;
            }
            return Double.parseDouble(new String(head, pos, len));
        }
        throw new Exception();
    }

    protected double getPixelValue(long healpixIdxPixel, int mode) {
        long startIdx = this.npix * (long)this.width * (long)this.width;
        int order = (int)CDSHealpix.log2(this.width);
        if (this.planBG.hpx2xy == null || this.planBG.hpx2xy.length != this.width * this.width) {
            try {
                this.planBG.createHealpixOrder(order);
            }
            catch (Exception e) {
                return Double.NaN;
            }
        }
        int idx = this.planBG.hpx2xy((int)(healpixIdxPixel - startIdx));
        return this.getPixel(idx, mode);
    }

    protected double getPixel(int idx, int mode) {
        double pix;
        if (mode == 3) {
            int x = idx % this.width;
            int y = this.width - idx / this.width - 1;
            return this.pixels[y * this.width + x];
        }
        if (!this.loadPixelsOrigin(mode)) {
            return Double.NaN;
        }
        this.resetTimer();
        double d = pix = this.planBG.bitpix > 0 ? (double)this.getPixValInt(this.pixelsOrigin, this.planBG.bitpix, idx) : this.getPixValDouble(this.pixelsOrigin, this.planBG.bitpix, idx);
        if (this.planBG.isBlank(pix)) {
            pix = Double.NaN;
        }
        return pix;
    }

    protected byte[] getSample(Coord coo, int w, byte[] pixelsOrigin, int width) throws Exception {
        coo = Localisation.frameToFrame(coo, 0, this.planBG.frameOrigin);
        if (Double.isNaN(coo.al) || Double.isNaN(coo.del)) {
            throw new Exception();
        }
        double[] polar = CDSHealpix.radecToPolar(new double[]{coo.al, coo.del});
        long nside = CDSHealpix.pow2((long)this.order + CDSHealpix.log2(width));
        long healpixIdxPixel = CDSHealpix.ang2pix_nest(nside, polar[0], polar[1]);
        long startIdx = this.npix * (long)width * (long)width;
        if (this.planBG.hpx2xy == null || this.planBG.hpx2xy.length != width * width) {
            this.planBG.createHealpixOrder((int)CDSHealpix.log2(width));
        }
        int idx = this.planBG.hpx2xy((int)(healpixIdxPixel - startIdx));
        int xc = idx % width;
        int yc = idx / width;
        int n = Math.abs(this.planBG.bitpix) / 8;
        int w2 = w / 2;
        byte[] sample = new byte[w * w * n];
        for (int i = 0; i < w * w; ++i) {
            PlanImage.setPixVal(sample, this.planBG.bitpix, i, this.planBG.blank);
        }
        int posSample = 0;
        for (int y = yc - w2; y < yc + (w - w2); ++y) {
            for (int x = xc - w2; x < xc + (w - w2); ++x) {
                if (x < 0 || x >= width || y < 0 || y >= width) continue;
                int pos = (y * width + x) * n;
                for (int i = 0; i < n; ++i) {
                    sample[posSample++] = pixelsOrigin[pos + i];
                }
            }
        }
        return sample;
    }

    protected boolean isARGB(byte[] head) {
        int n = head.length / 80;
        for (int i = 0; i < n; ++i) {
            if (!new String(head, i * 80, 8).equals("COLORMOD")) continue;
            return true;
        }
        return false;
    }

    private final int getPixValInt(byte[] t, int bitpix, int i) {
        PlanImage.getPixVal1(t, bitpix, i);
        switch (bitpix) {
            case 8: {
                return t[i] & 0xFF;
            }
            case 16: {
                return t[i *= 2] << 8 | t[i + 1] & 0xFF;
            }
            case 32: {
                return t[i *= 4] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF;
            }
        }
        return 0;
    }

    private final double getPixValDouble(byte[] t, int bitpix, int i) {
        switch (bitpix) {
            case -32: {
                return Float.intBitsToFloat(t[i *= 4] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF);
            }
            case -64: {
                return Double.longBitsToDouble((long)(t[i *= 8] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF) << 32 | (long)(t[i + 4] << 24 | (t[i + 5] & 0xFF) << 16 | (t[i + 6] & 0xFF) << 8 | t[i + 7] & 0xFF) & 0xFFFFFFFFL);
            }
        }
        return 0.0;
    }

    private final byte[] to8bits(byte[] pixels, int bitpix, double min, double max, int pixMode) {
        byte[] out = new byte[pixels.length / (Math.abs(bitpix) / 8)];
        int range = pixMode == 4 ? 255 : 256;
        boolean gapTransp = pixMode == 4;
        double r = (double)range / (max - min);
        --range;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                double pixIn = PlanImage.getPixVal1(pixels, bitpix, y * this.width + x);
                out[(this.height - 1 - y) * this.width + x] = this.planBG.isBlank(pixIn) ? (byte)0 : (byte)((int)((double)gapTransp + (pixIn <= min ? 0.0 : (pixIn >= max ? (double)range : (pixIn - min) * r))) & 0xFF);
            }
        }
        return out;
    }

    protected void invLine(byte[] src, byte[] dst, int bitpix) {
        int nbytes = Math.abs(bitpix) / 8;
        for (int h = 0; h < this.height; ++h) {
            System.arraycopy(src, h * this.width * nbytes, dst, (this.height - h - 1) * this.width * nbytes, this.width * nbytes);
        }
    }

    protected int loadFits(String filename) throws Exception {
        boolean initPixMode;
        this.stream = this.loadStream(filename);
        boolean bl = initPixMode = this.planBG.pixMode == -1;
        if (initPixMode) {
            this.planBG.pixMode = 2;
        }
        byte[] head = new byte[2880];
        System.arraycopy(this.stream, 0, head, 0, 2880);
        int bitpix = 8;
        boolean flagARGB = false;
        double pixelMin = this.planBG.pixelMin;
        double pixelMax = this.planBG.pixelMax;
        try {
            this.width = (int)this.getValue(head, "NAXIS1");
            this.height = (int)this.getValue(head, "NAXIS2");
            bitpix = (int)this.getValue(head, "BITPIX");
            flagARGB = this.isARGB(head);
            if (flagARGB) {
                bitpix = 0;
                if (initPixMode) {
                    this.planBG.pixMode = 0;
                }
            }
            if (bitpix != 8 && !flagARGB) {
                this.truePixels = true;
            }
        }
        catch (Exception e) {
            this.height = 512;
            this.width = 512;
            bitpix = 8;
        }
        int taille = this.width * this.height * (Math.abs(bitpix) / 8);
        if (flagARGB) {
            this.planBG.color = true;
            this.rgb = new int[this.width * this.height];
            for (int i = 0; i < this.width * this.height; ++i) {
                this.rgb[i] = (this.stream[2880 + i * 4] & 0xFF) << 24 | (this.stream[2880 + i * 4 + 1] & 0xFF) << 16 | (this.stream[2880 + i * 4 + 2] & 0xFF) << 8 | this.stream[2880 + i * 4 + 3] & 0xFF;
            }
        } else {
            boolean flagInit;
            byte[] in = new byte[taille];
            System.arraycopy(this.stream, 2880, in, 0, taille);
            boolean bl2 = flagInit = this.planBG.bitpix == 0 || this.planBG.flagRecut;
            if (flagInit) {
                boolean init = this.planBG.bitpix == 0;
                this.planBG.bitpix = bitpix;
                this.planBG.flagRecut = false;
                try {
                    this.planBG.bScale = this.getValue(head, "BSCALE");
                }
                catch (Exception e) {
                    this.planBG.bScale = 1.0;
                }
                try {
                    this.planBG.bZero = this.getValue(head, "BZERO");
                }
                catch (Exception e) {
                    this.planBG.bZero = 0.0;
                }
                try {
                    this.planBG.blank = this.getValue(head, "BLANK");
                    this.planBG.isBlank = true;
                }
                catch (Exception e) {
                    this.planBG.isBlank = false;
                }
                boolean flagPixelRange = false;
                boolean flagPixelCut = false;
                if (init) {
                    double[] a;
                    if (this.planBG.pixelRange != null && (a = this.split(this.planBG.pixelRange)) != null) {
                        this.planBG.dataMin = (a[0] - this.planBG.bZero) / this.planBG.bScale;
                        this.planBG.dataMax = (a[1] - this.planBG.bZero) / this.planBG.bScale;
                        flagPixelRange = true;
                    }
                    if (this.planBG.pixelCut != null && (a = this.split(this.planBG.pixelCut)) != null) {
                        this.planBG.pixelMin = pixelMin = (a[0] - this.planBG.bZero) / this.planBG.bScale;
                        this.planBG.pixelMax = pixelMax = (a[1] - this.planBG.bZero) / this.planBG.bScale;
                        flagPixelCut = true;
                    }
                }
                if (!flagPixelCut && !flagPixelRange) {
                    Fits tmp;
                    int w;
                    block31: {
                        w = this.width;
                        if (this.planBG.flagRecutRadius > 0.0) {
                            double angRes = CDSHealpix.pixRes(CDSHealpix.pow2((long)this.order + CDSHealpix.log2(this.width))) / 3600.0;
                            w = (int)(this.planBG.flagRecutRadius / angRes);
                        }
                        if (w > this.width) {
                            w = this.width;
                        }
                        tmp = new Fits(w, w, bitpix);
                        if (this.planBG.isBlank) {
                            tmp.setBlank(this.planBG.blank);
                        }
                        tmp.pixels = in;
                        if (this.planBG.flagRecutRadius > 0.0 && w != this.width) {
                            try {
                                tmp.pixels = this.getSample(this.planBG.flagRecutCoo, w, in, this.width);
                            }
                            catch (Exception e) {
                                Aladin cfr_ignored_0 = this.planBG.aladin;
                                if (Aladin.levelTrace < 3) break block31;
                                e.printStackTrace();
                            }
                        }
                    }
                    double[] range = tmp.findAutocutRange(0.0, 0.0, true);
                    if (!flagPixelCut) {
                        this.planBG.pixelMin = pixelMin = range[0];
                        this.planBG.pixelMax = pixelMax = range[1];
                    }
                    if (!flagPixelRange) {
                        this.planBG.dataMin = range[2];
                        this.planBG.dataMax = range[3];
                    }
                    Aladin cfr_ignored_1 = this.planBG.aladin;
                    Aladin.trace(3, "Pixel range detection on " + this.getStringNumber() + "[" + w + "x" + w + "] NaN=" + cds.tools.Util.round(range[4] * 100.0, 1) + "% => PixelMinMax=[" + cds.tools.Util.myRound(this.planBG.pixelMin) + "," + cds.tools.Util.myRound(this.planBG.pixelMax) + "], " + "DataMinMax=[" + cds.tools.Util.myRound(this.planBG.dataMin) + "," + cds.tools.Util.myRound(this.planBG.dataMax) + "] " + (this.planBG.isBlank ? " Blank=" + this.planBG.blank : "") + " bzero=" + this.planBG.bZero + " bscale=" + this.planBG.bScale);
                } else {
                    Aladin cfr_ignored_2 = this.planBG.aladin;
                    Aladin.trace(3, "Pixel properties PixelMinMax=[" + cds.tools.Util.myRound(this.planBG.pixelMin) + "," + cds.tools.Util.myRound(this.planBG.pixelMax) + "], " + "DataMinMax=[" + cds.tools.Util.myRound(this.planBG.dataMin) + "," + cds.tools.Util.myRound(this.planBG.dataMax) + "] " + (this.planBG.isBlank ? " Blank=" + this.planBG.blank : "") + " bzero=" + this.planBG.bZero + " bscale=" + this.planBG.bScale);
                }
                this.planBG.restoreCM();
                if (this.planBG.aladin.frameCM != null && this.planBG.aladin.frameCM.isVisible()) {
                    this.planBG.aladin.frameCM.showCM();
                }
            }
            this.pixels = this.to8bits(in, bitpix, pixelMin, pixelMax, 4);
            if (flagInit && !this.planBG.color) {
                this.planBG.pixelsOrigin = in;
                this.planBG.setBufPixels8(this.pixels);
                this.planBG.bitpix = bitpix;
                this.planBG.npix = Math.abs(bitpix) / 8;
                this.planBG.naxis1 = this.planBG.width = this.width;
                this.planBG.naxis2 = this.planBG.height = this.height;
            }
            in = null;
        }
        return this.stream.length;
    }

    private double[] split(String s) {
        double[] a = new double[3];
        StringTokenizer st = new StringTokenizer(s);
        a[0] = Double.parseDouble(st.nextToken());
        a[1] = Double.parseDouble(st.nextToken());
        if (st.hasMoreTokens()) {
            a[2] = PlanImage.getTransfertFct(st.nextToken());
            if (a[2] == -1.0) {
                a[2] = 3.0;
            }
        }
        return a;
    }

    private String getFileNameForPixelsOrigin() {
        String fileName;
        if (this.isCached() && (fileName = this.planBG.getCacheDir()) != null) {
            return fileName + cds.tools.Util.FS + this.fileCache;
        }
        fileName = this.planBG.url + "/" + this.fileNet;
        char c = this.planBG.url.charAt(this.planBG.url.length() - 1);
        if (c == '\\' || c == '/') {
            fileName = this.planBG.url + this.fileNet;
        }
        return fileName;
    }

    protected boolean loadPixelsOrigin(int mode) {
        if (this.pixelsOrigin != null) {
            return true;
        }
        if (!this.planBG.hasOriginalPixels()) {
            return false;
        }
        if (this.stream != null) {
            Aladin.trace(4, "HealpixKey.loadPixelsOrigin: from stream for " + this);
            int taille = this.width * this.width * Math.abs(this.planBG.bitpix) / 8;
            this.pixelsOrigin = new byte[taille];
            System.arraycopy(this.stream, 2880, this.pixelsOrigin, 0, taille);
            return true;
        }
        if (mode == 1) {
            return false;
        }
        if (!(mode != 2 || this.planBG.isLocalAllSky() || this.planBG.useCache && this.isCached())) {
            return false;
        }
        String fileName = this.getFileNameForPixelsOrigin();
        try {
            this.pixelsOrigin = this.loadStream(fileName, 2880);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    protected int writeStream() throws Exception {
        FileOutputStream ois = this.openOutputStream();
        if (ois == null) {
            return 0;
        }
        ois.write(this.stream);
        ois.close();
        return this.stream.length;
    }

    private int writeFits() throws Exception {
        FileOutputStream ois = this.openOutputStream();
        if (ois == null) {
            return 0;
        }
        int n = 0;
        ois.write(Save.getFitsLine("SIMPLE", "T", null));
        n += 80;
        ois.write(Save.getFitsLine("BITPIX", "8", null));
        n += 80;
        ois.write(Save.getFitsLine("NAXIS", "2", null));
        n += 80;
        ois.write(Save.getFitsLine("NAXIS1", this.width + "", null));
        n += 80;
        ois.write(Save.getFitsLine("NAXIS2", this.height + "", null));
        n += 80;
        ois.write(Save.getFitsLine("NORDER", this.order + "", null));
        n += 80;
        ois.write(Save.getFitsLine("NPIX", this.npix + "", null));
        ois.write(Save.getEndBourrage(n += 80));
        byte[] out = new byte[this.pixels.length];
        this.invLine(this.pixels, out, 8);
        ois.write(out);
        out = null;
        ois.close();
        return this.pixels.length + 2880;
    }

    protected byte[] getPixels(Image img) throws Exception {
        long t1 = cds.tools.Util.getTime();
        byte[] pixels = null;
        if (this.planBG.pixMode == 4) {
            int[] rgb = this.getPixelsRGB1(img);
            pixels = new byte[rgb.length];
            for (int i = 0; i < pixels.length; ++i) {
                if ((rgb[i] & 0xFF000000) == 0) {
                    pixels[i] = 0;
                    continue;
                }
                byte p = (byte)(0xFF & rgb[i]);
                if (p == 0) {
                    p = 1;
                }
                pixels[i] = p;
            }
            rgb = null;
        } else {
            BufferedImage imgBuf = new BufferedImage(this.width, this.height, 10);
            Graphics g = imgBuf.getGraphics();
            g.drawImage(img, 0, 0, observer);
            g.finalize();
            g = null;
            pixels = ((DataBufferByte)imgBuf.getRaster().getDataBuffer()).getData();
            imgBuf.flush();
            imgBuf = null;
        }
        this.timePixel = (int)(cds.tools.Util.getTime() - t1);
        return pixels;
    }

    protected int[] getPixelsRGB(Image img) throws Exception {
        try {
            return this.getPixelsRGB1(img);
        }
        catch (Throwable e) {
            this.planBG.clearBuf();
            return this.getPixelsRGB1(img);
        }
    }

    protected int[] getPixelsRGB1(Image img) throws Exception {
        long t1 = cds.tools.Util.getTime();
        BufferedImage imgBuf = new BufferedImage(this.width, this.height, 2);
        Graphics g = imgBuf.getGraphics();
        g.drawImage(img, 0, 0, observer);
        g.finalize();
        g = null;
        int[] rgb = ((DataBufferInt)imgBuf.getRaster().getDataBuffer()).getData();
        imgBuf.flush();
        imgBuf = null;
        this.timePixel = (int)(cds.tools.Util.getTime() - t1);
        return rgb;
    }

    protected void setStatus(int status) {
        this.setStatus(status, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(int status, boolean flagForce) {
        Object object = this.lockStatus;
        synchronized (object) {
            if (!flagForce && this.getStatus() == 8) {
                return;
            }
            this.status = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getStatus() {
        Object object = this.lockStatus;
        synchronized (object) {
            return this.status;
        }
    }

    protected String getStatusString() {
        return STATUS[this.getStatus()];
    }

    protected int getLive() {
        int status = this.getStatus();
        long time = this.getLiveTime();
        if (time == -1L) {
            return -3;
        }
        if ((status == 7 || status == 5) && this.parente == 0) {
            return -3;
        }
        if (this.getCurrentLiveTime() <= time) {
            return -3;
        }
        if (this.getCurrentLiveTime() > time + 2000L) {
            return -1;
        }
        return -2;
    }

    protected long getLiveTime() {
        return 3000L;
    }

    protected long getCurrentLiveTime() {
        return System.currentTimeMillis() - this.timer;
    }

    protected void setOld() {
        this.timer -= 3000L;
    }

    protected void resetTimer() {
        this.timer = System.currentTimeMillis();
    }

    private void setTimerLoad() {
        this.timerLoad = System.currentTimeMillis();
    }

    private PointD[] grow(PointD[] b, double val) throws Exception {
        int i;
        int j = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (b[i2] != null) continue;
            ++j;
        }
        if (j > 1) {
            return b;
        }
        PointD[] b1 = new PointD[b.length];
        for (i = 0; i < 4; ++i) {
            b1[i] = new PointD(b[i].x, b[i].y);
        }
        for (i = 0; i < 2; ++i) {
            int g;
            int d;
            int c;
            int a = i == 1 ? 1 : 0;
            int n = c = i == 1 ? 2 : 3;
            if (b1[a] == null) {
                if (a == 0 || a == 3) {
                    d = 1;
                    g = 2;
                } else {
                    d = 0;
                    g = 3;
                }
                b1[a] = new PointD((b1[d].x + b1[g].x) / 2.0, (b1[d].y + b1[g].y) / 2.0);
            }
            if (b1[c] == null) {
                if (c == 0 || c == 3) {
                    d = 1;
                    g = 2;
                } else {
                    d = 0;
                    g = 3;
                }
                b1[c] = new PointD((b1[d].x + b1[g].x) / 2.0, (b1[d].y + b1[g].y) / 2.0);
            }
            if (b1[a] == null || b1[c] == null) continue;
            double angle = Math.atan2(b1[c].y - b1[a].y, b1[c].x - b1[a].x);
            double chouilla = val * Math.cos(angle);
            b1[a].x -= chouilla;
            b1[c].x += chouilla;
            chouilla = val * Math.sin(angle);
            b1[a].y -= chouilla;
            b1[c].y += chouilla;
        }
        return b1;
    }

    private int drawFils(Graphics g, ViewSimple v) {
        return this.drawFils(g, v, 1);
    }

    private int drawFils(Graphics g, ViewSimple v, int maxParente) {
        int n = 0;
        int limitOrder = 19;
        if (this.width > 1 && this.order < limitOrder && this.parente < maxParente) {
            this.fils = this.getChild();
            if (this.fils != null) {
                for (int i = 0; i < 4; ++i) {
                    if (this.fils[i] == null) continue;
                    n += this.fils[i].draw(g, v, maxParente);
                }
            }
        }
        return n;
    }

    private Image createImage() throws Exception {
        if (this.imgBuf != null && (this.planBG.color || this.imgID == this.planBG.imgID)) {
            if (!this.allSky) {
                ++this.planBG.nbImgInBuf;
            }
            return this.imgBuf;
        }
        BufferedImage img = null;
        if (this.planBG.color) {
            int[] pix = this.parente == 0 ? this.rgb : this.getPixelFromAncetreRGB();
            DataBufferInt dbuf = new DataBufferInt(pix, this.width * this.height);
            int[] bitMasks = new int[]{0xFF0000, 65280, 255, -16777216};
            SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(3, this.width, this.height, bitMasks);
            ColorModel colorModel = ColorModel.getRGBdefault();
            WritableRaster raster = Raster.createWritableRaster(sampleModel, dbuf, null);
            img = new BufferedImage(colorModel, raster, true, null);
        } else {
            byte[] pix = this.parente == 0 ? this.pixels : this.getPixelFromAncetre();
            img = new BufferedImage(this.width, this.height, 13, (IndexColorModel)this.planBG.getCM());
            WritableRaster wr = img.getRaster();
            wr.setDataElements(0, 0, this.width, this.height, pix);
        }
        if (!this.allSky) {
            ++this.planBG.nbImgCreated;
        }
        this.imgID = this.planBG.imgID;
        if (this.planBG.aladin.enoughMemory()) {
            this.imgBuf = img;
        }
        return img;
    }

    protected int getMem() {
        int mem = 0;
        if (this.pixels != null) {
            mem += this.pixels.length * 2;
        } else if (this.rgb != null) {
            mem += this.rgb.length * 8;
        }
        if (this.stream != null) {
            mem += this.stream.length;
        }
        if (this.pixelsOrigin != null) {
            mem += this.pixelsOrigin.length;
        }
        return mem;
    }

    protected int getFullMem() {
        int mem = this.getMem();
        if (this.fils != null) {
            for (int i = 0; i < 4; ++i) {
                mem += this.fils[i].getFullMem();
            }
        }
        return mem;
    }

    protected String getLongFullMem() {
        int n = this.getFullMem() / 1024;
        if (n > 1024) {
            return n / 1024 + "MB";
        }
        return n + "KB";
    }

    protected boolean isBehindSky(PointD[] b) {
        return (b[1].x - b[0].x) * (b[2].y - b[0].y) - (b[2].x - b[0].x) * (b[1].y - b[0].y) <= 0.0;
    }

    protected boolean isTooLarge(PointD[] b) throws Exception {
        double d2;
        double d1;
        block7: {
            block6: {
                double d;
                if (PlanBG.DEBUGMODE) {
                    return false;
                }
                d1 = HealpixKey.dist(b, 0, 2);
                if (d1 > 90000.0) break block6;
                d2 = HealpixKey.dist(b, 2, 1);
                if (!(d > 90000.0)) break block7;
            }
            return true;
        }
        if (d1 == 0.0 || d2 == 0.0) {
            throw new Exception("Rhomb error");
        }
        double diag1 = HealpixKey.dist(b, 0, 3);
        double diag2 = HealpixKey.dist(b, 1, 2);
        if (diag2 == 0.0 || diag2 == 0.0) {
            throw new Exception("Rhomb error");
        }
        double rap = diag2 > diag1 ? diag1 / diag2 : diag2 / diag1;
        return rap < 0.7 && (diag1 > 22500.0 || diag2 > 22500.0);
    }

    protected int draw(Graphics g, ViewSimple v) {
        return this.draw(g, v, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int draw(Graphics g, ViewSimple v, int maxParente) {
        long t1 = cds.tools.Util.getTime(0);
        int n = 0;
        PointD[] b = this.getProjViewCorners(v);
        ++nDraw;
        boolean out = false;
        if (b == null || (out = this.isOutView(v, b))) {
            if (out) {
                ++nOut;
            }
            return 0;
        }
        try {
            b = this.grow(b, 1.0);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean flagLosange = false;
        this.flagSym = false;
        if (b[0] != null && b[1] != null && b[2] != null && b[3] != null) {
            if (HealpixKey.aDroite(b[0], b[1], b[2]) * HealpixKey.aDroite(b[3], b[1], b[2]) >= 0.0 || HealpixKey.aDroite(b[1], b[0], b[3]) * HealpixKey.aDroite(b[2], b[0], b[3]) >= 0.0) {
                boolean flagPatate;
                double d12 = HealpixKey.dist(b, 1, 2);
                double d03 = HealpixKey.dist(b, 0, 3);
                this.flagSym = flagPatate = false;
                if (d12 < d03) {
                    double p1 = HealpixKey.distCentre(b[0], b[1], b[2]);
                    double p2 = HealpixKey.distCentre(b[3], b[1], b[2]);
                    if (flagPatate) {
                        if (p1 < p2) {
                            HealpixKey.symetric(b[3], b[0], b[1], b[2]);
                        } else {
                            HealpixKey.symetric(b[0], b[3], b[1], b[2]);
                        }
                    } else if (p1 < p2) {
                        b[3] = null;
                    } else {
                        b[0] = null;
                    }
                } else {
                    double p1 = HealpixKey.distCentre(b[1], b[0], b[3]);
                    double p2 = HealpixKey.distCentre(b[2], b[0], b[3]);
                    if (flagPatate) {
                        if (p1 < p2) {
                            HealpixKey.symetric(b[2], b[1], b[0], b[3]);
                        } else {
                            HealpixKey.symetric(b[1], b[2], b[0], b[3]);
                        }
                    } else if (p1 < p2) {
                        b[2] = null;
                    } else {
                        b[1] = null;
                    }
                }
            } else {
                boolean drawFast = this.planBG.mustDrawFast();
                try {
                    if (!drawFast && this.isTooLarge(b)) {
                        this.resetTimer();
                        int m = this.drawFils(g, v, 8);
                        if (m > 0) {
                            return m;
                        }
                    }
                }
                catch (Exception e) {
                    return 0;
                }
                if (this.isBehindSky(b)) {
                    if (drawFast) {
                        return 0;
                    }
                    this.resetTimer();
                    return this.drawFils(g, v);
                }
                if ((int)b[0].x == (int)(b[1].x + b[2].x - b[3].x) && (int)b[0].y == (int)(b[2].y + b[1].y - b[3].y)) {
                    flagLosange = true;
                }
            }
        }
        int th = -1;
        int tb = -1;
        if (b[0] == null) {
            th = 3;
        } else if (b[3] == null) {
            tb = 0;
        } else if (b[1] == null) {
            th = 2;
        } else if (b[2] == null) {
            tb = 1;
        } else {
            th = 0;
            tb = 3;
        }
        if ((b[0] == null || b[1] == null || b[2] == null || b[3] == null) && (n = this.drawFils(g, v)) > 0) {
            return n;
        }
        if (th == -1 && tb == -1) {
            return 0;
        }
        Image img = null;
        try {
            img = this.createImage();
        }
        catch (Exception e) {
            return 0;
        }
        Graphics2D g2d = (Graphics2D)g;
        float opacity = this.getFadingOpacity();
        Composite saveComposite = g2d.getComposite();
        g2d.setComposite(cds.tools.Util.getImageComposite(opacity));
        Shape clip = g2d.getClip();
        try {
            if (th != -1) {
                n += this.drawTriangle(g2d, img, b, th, !flagLosange);
            }
            if (tb != -1 && !flagLosange) {
                n += this.drawTriangle(g2d, img, b, tb, true);
            }
        }
        catch (Throwable e) {
            this.planBG.clearBuf();
        }
        finally {
            g2d.setComposite(saveComposite);
            g2d.setClip(clip);
        }
        if (this.parente > 0) {
            this.pixels = null;
            this.rgb = null;
        }
        this.drawLosangeBorder(g, b);
        long t2 = cds.tools.Util.getTime(0);
        if (!this.allSky) {
            ++this.planBG.nbImgDraw;
        }
        this.planBG.cumulTimeDraw += t2 - t1;
        this.resetTimer();
        if (opacity < 1.0f) {
            this.planBG.updateFading(true);
        }
        return n;
    }

    private float getFadingOpacity() {
        return 1.0f;
    }

    public static double aDroite(PointD a, PointD g, PointD d) {
        double dx = d.x - g.x;
        double dy = d.y - g.y;
        return dx * a.y - dy * a.x - d.y * dx + d.x * dy;
    }

    public static double distCentre(PointD a, PointD g, PointD d) {
        double mx = (g.x + d.x) / 2.0;
        double my = (g.y + d.y) / 2.0;
        return (a.x - mx) * (a.x - mx) + (a.y - my) * (a.y - my);
    }

    public static void symetric(PointD b, PointD a, PointD g, PointD d) {
        double alpha = Math.atan2(d.y - g.y, d.x - g.x);
        double beta = Math.atan2(a.y - g.y, a.x - g.x);
        double theta = alpha - beta;
        double ax = a.x - g.x;
        double ay = a.y - g.y;
        double cost = Math.cos(-2.0 * theta);
        double sint = Math.sin(-2.0 * theta);
        double x = ax * cost + ay * sint;
        double y = -ax * sint + ay * cost;
        b.x = x + g.x;
        b.y = y + g.y;
    }

    public static double dist(PointD[] b, int g, int d) {
        double dx = b[g].x - b[d].x;
        double dy = b[g].y - b[d].y;
        return dx * dx + dy * dy;
    }

    protected int drawTriangle(Graphics2D g2d, Image img, PointD[] b, int h, boolean flagClip) {
        int g;
        int d;
        switch (h) {
            case 0: {
                d = 2;
                g = 1;
                break;
            }
            case 3: {
                d = 1;
                g = 2;
                break;
            }
            case 1: {
                d = 3;
                g = 0;
                break;
            }
            default: {
                d = 0;
                g = 3;
            }
        }
        if (b[d] == null || b[g] == null) {
            return 0;
        }
        if (flagClip) {
            PointD[] b1 = null;
            try {
                b1 = this.grow(b, 2.0);
                Polygon p = new Polygon(new int[]{(int)(b1[h].x + 0.5), (int)(b1[d].x + 0.5), (int)(b1[g].x + 0.5)}, new int[]{(int)(b1[h].y + 0.5), (int)(b1[d].y + 0.5), (int)(b1[g].y + 0.5)}, 3);
                g2d.setClip(p);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        double hdx = b[h].x - b[d].x;
        if (h == 0 || h == 2) {
            hdx = -hdx;
        }
        double hdy = b[h].y - b[d].y;
        if (h == 0 || h == 2) {
            hdy = -hdy;
        }
        double angle = Math.atan2(hdy, hdx);
        double hd = Math.sqrt(hdx * hdx + hdy * hdy);
        double mx = hd / (double)this.width;
        double hgx = b[h].x - b[g].x;
        if (h == 0 || h == 2) {
            hgx = -hgx;
        }
        double hgy = b[h].y - b[g].y;
        if (h == 0 || h == 2) {
            hgy = -hgy;
        }
        double dhg = Math.sqrt(hgx * hgx + hgy * hgy);
        double anglehg = Math.atan2(hgy, hgx) - angle;
        double my = dhg * Math.sin(anglehg) / (double)this.width;
        double sx = dhg * Math.cos(anglehg) / hd;
        AffineTransform tr = new AffineTransform();
        if (h == 3 || h == 1) {
            tr.translate(b[d].x + b[g].x - b[h].x, b[d].y + b[g].y - b[h].y);
        } else {
            tr.translate(b[h].x, b[h].y);
        }
        tr.rotate(angle);
        tr.scale(mx, my);
        tr.shear(sx, 0.0);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.planBG.mustDrawFast() && this.order - this.parente < this.planBG.maxOrder || this.order - this.parente >= this.planBG.maxOrder ? RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR : RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (img == null) {
            return 0;
        }
        g2d.drawImage(img, tr, this.planBG.aladin);
        return 1;
    }

    protected final void drawLosangeBorder(Graphics g, PointD[] b1) {
        Color c;
        if (!this.planBG.ref) {
            return;
        }
        int debugIn = this.planBG.isDebugIn(this.npix);
        if (debugIn == 0 && !this.planBG.aladin.calque.hasHpxGrid()) {
            return;
        }
        PointD[] b = new PointD[4];
        int j = 0;
        for (int i = 0; i < 4; ++i) {
            if (b1[i] == null) continue;
            b[j++] = b1[i];
        }
        Polygon p = null;
        if (j == 4) {
            p = new Polygon(new int[]{(int)b[0].x, (int)b[1].x, (int)b[3].x, (int)b[2].x}, new int[]{(int)b[0].y, (int)b[1].y, (int)b[3].y, (int)b[2].y}, 4);
        } else if (j == 3) {
            p = new Polygon(new int[]{(int)b[0].x, (int)b[1].x, (int)b[2].x}, new int[]{(int)b[0].y, (int)b[1].y, (int)b[2].y}, 3);
        } else {
            return;
        }
        if (debugIn > 0) {
            g.setColor(debugIn == 1 ? BLUE1 : (debugIn == 2 ? BLUE2 : BLUE3));
            g.fillPolygon(p);
        }
        Color color = c = this.parente > 0 ? new Color(100, 100, 0) : Color.green;
        g.setColor(this.flagSym ? Color.magenta : (j == 3 ? Color.red : c));
        g.drawPolygon(p);
    }

    protected final void drawLosangeBorder(Graphics g, ViewSimple v) {
        PointD[] b = this.getProjViewCorners(v);
        if (b == null || b[0] == null || b[1] == null || b[2] == null || b[3] == null) {
            return;
        }
        double c0 = HealpixKey.dist(b, 0, 1);
        double c1 = HealpixKey.dist(b, 0, 2);
        double c2 = HealpixKey.dist(b, 1, 3);
        double c3 = HealpixKey.dist(b, 2, 3);
        double min = Math.min(Math.min(c0, c1), Math.min(c2, c3));
        double min2 = 15.0 * min;
        g.setColor(Color.green);
        if (c0 < min2) {
            g.drawLine((int)b[0].x, (int)b[0].y, (int)b[1].x, (int)b[1].y);
        }
        if (c1 < min2) {
            g.drawLine((int)b[0].x, (int)b[0].y, (int)b[2].x, (int)b[2].y);
        }
        if (c2 < min2) {
            g.drawLine((int)b[1].x, (int)b[1].y, (int)b[3].x, (int)b[3].y);
        }
        if (c3 < min2) {
            g.drawLine((int)b[2].x, (int)b[2].y, (int)b[3].x, (int)b[3].y);
        }
        this.drawNumber(g, v, b);
    }

    private final void drawNumber(Graphics g, ViewSimple v, PointD[] b) {
        if (v.isAllSky()) {
            return;
        }
        String s = this.getStringNumber();
        FontMetrics m = g.getFontMetrics();
        int size = m.stringWidth(s);
        int h = m.getHeight();
        double xMin = Math.min(Math.min(b[0].x, b[1].x), Math.min(b[2].x, b[3].x));
        double xMax = Math.max(Math.max(b[0].x, b[1].x), Math.max(b[2].x, b[3].x));
        double dist = xMax - xMin;
        if ((double)size < dist) {
            int x = (int)(b[0].x + b[1].x + b[2].x + b[3].x) / 4 - size / 2;
            int y = (int)(b[0].y + b[1].y + b[2].y + b[3].y) / 4 + h / 2;
            boolean a = false;
            boolean c = false;
            a = x < 3;
            if (a) {
                x = 3;
            } else {
                a = x + size + 3 > v.rv.width;
                if (a) {
                    x = v.rv.width - size - 3;
                }
            }
            if (c = y < 25) {
                y = 25;
            } else {
                c = y + 25 > v.rv.height;
                if (c) {
                    y = v.rv.height - 25;
                }
            }
            if (a || c) {
                if (dist < 150.0) {
                    return;
                }
                Polygon pol = new Polygon();
                pol.addPoint((int)b[0].x, (int)b[0].y);
                pol.addPoint((int)b[1].x, (int)b[1].y);
                pol.addPoint((int)b[3].x, (int)b[3].y);
                pol.addPoint((int)b[2].x, (int)b[2].y);
                if (!pol.contains(x, y) || !pol.contains(x + size, y)) {
                    return;
                }
            }
            cds.tools.Util.drawStringOutline(g, s, x, y, Color.green, Color.black);
        }
    }

    protected void drawRealBorders(Graphics g, ViewSimple v) {
        block4: {
            try {
                Projection proj = v.getProj();
                double[][] x = CDSHealpix.borders(CDSHealpix.pow2(this.order), this.npix, 50);
                for (int i = 0; i < x.length; ++i) {
                    Coord c = new Coord(x[i][0], x[i][1]);
                    int frame = this.hpix.getFrame();
                    if (frame != 0) {
                        c = Localisation.frameToFrame(c, frame, 0);
                    }
                    proj.getXY(c);
                    if (Double.isNaN(c.x)) continue;
                    PointD p = v.getViewCoordDble(c.x, c.y);
                    g.drawLine((int)p.x, (int)p.y, (int)p.x, (int)p.y);
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
    }

    protected void drawCtrl(Graphics g1, ViewSimple v) {
        Graphics2D g = (Graphics2D)g1;
        Color c = g.getColor();
        g.setColor(Color.red);
        Stroke st = g.getStroke();
        g.setStroke(new BasicStroke(2.0f));
        this.drawRealBorders(g, v);
        g.setStroke(st);
        PointD[] b = this.getProjViewCorners(v);
        if (b == null || b[0] == null || b[1] == null || b[2] == null || b[3] == null) {
            return;
        }
        String s = this.getStringNumber();
        g.setFont(Aladin.PLAIN);
        try {
            s = s + " (" + CDSHealpix.nest2ring(CDSHealpix.pow2(this.order - this.parente), this.npix / (long)Math.pow(4.0, this.parente)) + ")";
        }
        catch (Exception e) {
            // empty catch block
        }
        int size = g.getFontMetrics().stringWidth(s);
        int x = (int)(b[0].x + b[1].x + b[2].x + b[3].x) / 4;
        int y = (int)(b[0].y + b[1].y + b[2].y + b[3].y) / 4 + 7;
        if (Math.abs(b[2].x - b[1].x) < (double)(size + 18)) {
            y = (int)Math.min(Math.min(b[0].y, b[1].y), Math.min(b[2].y, b[3].y)) - 10;
        }
        g.drawString(s, x - size / 2, y + 3);
        g.setColor(c);
    }

    protected long getFather() {
        return this.npix / 4L;
    }

    protected long[] getChildren() {
        return this.getChildren(null);
    }

    protected long[] getChildren(long[] pixChild) {
        if (pixChild == null) {
            pixChild = new long[]{this.npix * 4L, this.npix * 4L + 1L, this.npix * 4L + 2L, this.npix * 4L + 3L};
        }
        return pixChild;
    }

    protected Coord[] getCorners() {
        return this.hpix.getCorners();
    }

    protected boolean isOutView(ViewSimple v) {
        return this.hpix.isOutView(v, null);
    }

    protected boolean isOutView(ViewSimple v, PointD[] b) {
        return this.hpix.isOutView(v, b);
    }

    protected final PointD[] getProjViewCorners(ViewSimple v) {
        return this.hpix.getProjViewCorners(v);
    }

    HealpixKey[] getPixList() {
        return null;
    }

    protected int getLosangeOrder() {
        return (int)CDSHealpix.log2(this.width);
    }

    @Override
    public int compareTo(HealpixKey o) {
        return this.priority - o.priority;
    }
}

