/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrameMocGenImg
extends FrameRGBBlink {
    String TITLE;
    String INFO;
    String HELP1;
    String PLANE;
    private ButtonGroup cbg;
    JComboBox mocOrder;
    JTextField minRange;
    JTextField maxRange;
    JCheckBox rangeCheckBox;
    private static final int FIRSTORDER = 3;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("MOCGENTITLE");
        this.INFO = Aladin.chaine.getString("MOCGENIMGINFO");
        this.HELP1 = Aladin.chaine.getString("MOCHELP");
        this.PLANE = Aladin.chaine.getString("MOCPLANE");
    }

    protected FrameMocGenImg(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return -2;
    }

    @Override
    protected int getNb() {
        return 1;
    }

    @Override
    protected String getLabelSelector(int i) {
        return this.PLANE;
    }

    protected boolean isPlanOk(Plan p) {
        if (p instanceof PlanBG && !((PlanBG)p).isLocalAllSky()) {
            return false;
        }
        if (p instanceof PlanImage && ((PlanImage)p).isPixel()) {
            return true;
        }
        return p.isCatalog();
    }

    @Override
    protected Plan[] getPlan() {
        Plan[] p = this.a.calque.getPlans();
        int n = 0;
        for (int i = 0; i < p.length; ++i) {
            if (!this.isPlanOk(p[i])) continue;
            ++n;
        }
        Plan[] pi = new Plan[n];
        int j = 0;
        for (int i = 0; i < p.length; ++i) {
            if (!this.isPlanOk(p[i])) continue;
            pi[j++] = p[i];
        }
        return pi;
    }

    @Override
    protected Color getColorLabel(int i) {
        return Color.black;
    }

    @Override
    protected JPanel getAddPanel() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        JPanel p = new JPanel();
        p.setLayout(g);
        this.addSpecifPanel(p, c, g);
        this.cbg = new ButtonGroup();
        JPanel pp = new JPanel();
        pp.add(new JLabel("MOC resolution :"));
        this.mocOrder = this.getComboRes();
        pp.add(this.mocOrder);
        c.gridwidth = 0;
        c.weightx = 10.0;
        g.setConstraints(pp, c);
        p.add(pp);
        return p;
    }

    protected void addSpecifPanel(JPanel p, GridBagConstraints c, GridBagLayout g) {
        JPanel pp = new JPanel();
        pp.add(new JLabel("Pixel range: ["));
        this.minRange = new JTextField(3);
        pp.add(this.minRange);
        pp.add(new JLabel(".."));
        this.maxRange = new JTextField(3);
        pp.add(this.maxRange);
        pp.add(new JLabel("]"));
        c.gridwidth = 0;
        g.setConstraints(pp, c);
        p.add(pp);
    }

    private JComboBox getComboRes() {
        JComboBox<String> c = new JComboBox<String>();
        for (int o = 3; o <= 29; ++o) {
            String s = "Order " + o + " => " + Coord.getUnit(CDSHealpix.pixRes(CDSHealpix.pow2(o)) / 3600.0);
            c.addItem(s);
        }
        c.setSelectedIndex(7);
        return c;
    }

    protected int getOrder() {
        return this.mocOrder.getSelectedIndex() + 3;
    }

    private double getMin() throws Exception {
        double min = Double.NaN;
        try {
            String s = this.minRange.getText().trim();
            if (s.length() > 0) {
                min = Double.parseDouble(s);
            }
        }
        catch (Exception e) {
            this.minRange.setForeground(Color.red);
            throw e;
        }
        this.minRange.setForeground(Color.black);
        return min;
    }

    private double getMax() throws Exception {
        double max = Double.NaN;
        try {
            String s = this.maxRange.getText().trim();
            if (s.length() > 0) {
                max = Double.parseDouble(s);
            }
        }
        catch (Exception e) {
            this.maxRange.setForeground(Color.red);
            throw e;
        }
        this.maxRange.setForeground(Color.black);
        return max;
    }

    @Override
    protected void submit() {
        try {
            Plan[] ps = new Plan[]{this.getPlan(this.ch[0])};
            int res = this.getOrder();
            double pixMin = this.getMin();
            double pixMax = this.getMax();
            this.a.calque.newPlanMoc(ps[0].label + " MOC", ps, res, 0.0, pixMin, pixMax);
            this.hide();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.warning("MOC generation failed !");
        }
    }

    @Override
    protected void adjustWidgets() {
    }
}

