/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameMocGenImg;
import cds.aladin.Plan;
import cds.aladin.Server;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class FrameMocGenCat
extends FrameMocGenImg {
    private JTextField radius;

    protected FrameMocGenCat(Aladin aladin) {
        super(aladin);
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.INFO = Aladin.chaine.getString("MOCGENCATINFO");
    }

    @Override
    protected boolean isPlanOk(Plan p) {
        return p.isCatalog();
    }

    @Override
    protected void addSpecifPanel(JPanel p, GridBagConstraints c, GridBagLayout g) {
        JPanel pp = new JPanel();
        pp.add(new JLabel("Radius (in arcsec):"));
        this.radius = new JTextField(5);
        pp.add(this.radius);
        c.gridwidth = 0;
        g.setConstraints(pp, c);
        p.add(pp);
    }

    private double getRadius() throws Exception {
        double x = 0.0;
        try {
            String s = this.radius.getText().trim();
            if (s.length() > 0) {
                x = Server.getAngle(s, 16);
            }
        }
        catch (Exception e) {
            this.radius.setForeground(Color.red);
            throw e;
        }
        this.radius.setForeground(Color.black);
        return x;
    }

    @Override
    protected void submit() {
        try {
            Plan[] ps = new Plan[]{this.getPlan(this.ch[0])};
            int res = this.getOrder();
            double radius = this.getRadius();
            this.a.calque.newPlanMoc(ps[0].label + " MOC", ps, res, radius, 0.0, 0.0);
            this.hide();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.warning("MOC generation failed !");
        }
    }

    @Override
    protected void adjustWidgets() {
    }
}

