/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Localisation;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanMoc;
import cds.moc.Healpix;
import cds.moc.HealpixMoc;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class FrameMocFiltering
extends FrameRGBBlink {
    String TITLE;
    String INFO;
    String HELP1;
    String CATPLANE;
    String MOCPLANE;
    String IN;
    String OUT;
    private ButtonGroup cbg;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("MOCFILTERINGTITLE");
        this.INFO = Aladin.chaine.getString("MOCFILTERINGINFO");
        this.HELP1 = Aladin.chaine.getString("MOCHELP");
        this.CATPLANE = Aladin.chaine.getString("MOCFILTERINGCAT");
        this.MOCPLANE = Aladin.chaine.getString("MOCFILTERINGMOC");
        this.IN = Aladin.chaine.getString("MOCFILTERINGIN");
        this.OUT = Aladin.chaine.getString("MOCFILTERINGOUT");
    }

    protected FrameMocFiltering(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return -2;
    }

    @Override
    protected int getNb() {
        return 8;
    }

    @Override
    protected String getLabelSelector(int i) {
        return i == 0 ? this.MOCPLANE : this.CATPLANE;
    }

    @Override
    protected Plan[] getPlan() {
        Vector<Plan> v = this.a.calque.getPlans(19);
        Vector<Plan> v2 = this.a.calque.getPlans(8);
        if (v == null) {
            v = v2;
        } else if (v2 != null) {
            v.addAll(v2);
        }
        if (v == null) {
            return new Plan[0];
        }
        Object[] pi = new Plan[v.size()];
        v.copyInto(pi);
        return pi;
    }

    @Override
    protected Color getColorLabel(int i) {
        return Color.black;
    }

    @Override
    protected JPanel getAddPanel() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        JPanel p = new JPanel();
        p.setLayout(g);
        this.cbg = new ButtonGroup();
        JPanel pp = new JPanel();
        JRadioButton cb = new JRadioButton(this.IN);
        cb.setActionCommand(this.IN);
        this.cbg.add(cb);
        pp.add(cb);
        cb.setSelected(true);
        cb = new JRadioButton(this.OUT);
        cb.setActionCommand(this.OUT);
        this.cbg.add(cb);
        pp.add(cb);
        c.gridwidth = 0;
        c.weightx = 10.0;
        g.setConstraints(pp, c);
        p.add(pp);
        return p;
    }

    @Override
    protected void submit() {
        try {
            String s = this.cbg.getSelection().getActionCommand();
            boolean lookIn = s.equals(this.IN);
            Plan pMoc = this.getPlan(this.ch[0]);
            if (pMoc.type != 19) {
                throw new Exception("Not a MOC");
            }
            Healpix hpx = new Healpix();
            HealpixMoc moc = ((PlanMoc)pMoc).getMoc();
            Vector<Obj> v = new Vector<Obj>();
            String label = "";
            Coord c = new Coord();
            for (int i = 1; i < this.ch.length; ++i) {
                Plan pCat = this.getPlan(this.ch[i]);
                if (pCat == null) continue;
                label = label.length() == 0 ? pCat.label : label + ", " + pCat.label;
                Iterator<Obj> it = pCat.iterator();
                while (it.hasNext()) {
                    Obj o = it.next();
                    c.al = o.getRa();
                    c.del = o.getDec();
                    c = Localisation.frameToFrame(c, 0, ((PlanMoc)pMoc).frameOrigin);
                    boolean in = moc.contains(hpx, c.al, c.del);
                    if (lookIn != in) continue;
                    v.add(o);
                }
            }
            PlanCatalog p = this.a.calque.newPlanCatalogBySources(v, "Filter " + label, false);
            this.a.calque.repaintAll();
            this.hide();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.warning("Catalog filtering by MOC failed !");
        }
    }

    @Override
    protected void adjustWidgets() {
    }
}

