/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Legende;
import cds.aladin.Plan;
import cds.tools.Util;
import cds.xml.Field;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FrameInfoTable
extends JFrame {
    private Aladin aladin;
    private Plan plan;

    protected FrameInfoTable(Aladin aladin, Plan plan) {
        JButton b;
        this.aladin = aladin;
        this.plan = plan;
        Aladin.setIcon(this);
        this.setTitle(plan.getLabel());
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        JPanel pgen = (JPanel)this.getContentPane();
        JPanel p = new JPanel(new GridLayout(0, 1, 5, 5));
        JScrollPane sc = new JScrollPane(p);
        Vector<Legende> legs = plan.getLegende();
        boolean multiTable = plan.getNbTable() > 1;
        Enumeration<Legende> e = legs.elements();
        while (e.hasMoreElements()) {
            Legende leg = e.nextElement();
            JPanel p1 = new JPanel(new BorderLayout(5, 5));
            if (multiTable) {
                p1.setBorder(BorderFactory.createTitledBorder(leg.name));
            } else {
                p1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            }
            p1.add((Component)leg.getTablePanel(aladin, plan), "Center");
            p.add(p1);
        }
        pgen.add((Component)sc, "Center");
        JPanel p2 = new JPanel();
        if (plan.pcat != null && plan.pcat.hasCatalogInfo()) {
            b = new JButton(Aladin.chaine.getString("CHECK"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameInfoTable.this.check(true);
                }
            });
            p2.add(b);
            b = new JButton(Aladin.chaine.getString("UNCHECK"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameInfoTable.this.check(false);
                }
            });
            p2.add(b);
            p2.add(new JLabel(" - "));
            b = new JButton(Aladin.chaine.getString("PARSING"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameInfoTable.this.seeCatalogInfo();
                }
            });
            p2.add(b);
            b = new JButton(Aladin.chaine.getString("COORDCOLUMN"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameInfoTable.this.seeCoordColumnInfo();
                }
            });
            p2.add(b);
            p2.add(new JLabel(" - "));
        }
        b = new JButton(Aladin.chaine.getString("CLOSE"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameInfoTable.this.dispose();
            }
        });
        p2.add(b);
        pgen.add((Component)p2, "South");
        this.setLocation(Aladin.computeLocation(this));
        this.pack();
        this.setVisible(true);
    }

    private void seeCoordColumnInfo() {
        Aladin.info(this, Util.fold(Aladin.chaine.getString("COORDCOLUMNDETAIL"), 50));
    }

    private void seeCatalogInfo() {
        this.plan.pcat.seeCatalogInfo();
    }

    private void check(boolean flag) {
        Vector<Legende> legs = this.plan.getLegende();
        Enumeration<Legende> e = legs.elements();
        while (e.hasMoreElements()) {
            Legende leg = e.nextElement();
            for (Field f : leg.field) {
                f.visible = flag;
            }
            leg.fireTableDataChanged();
        }
        this.aladin.mesure.redisplay();
    }
}

