/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AppMessagingInterface;
import cds.aladin.Chaine;
import cds.aladin.MetaDataTree;
import cds.aladin.MyLink;
import cds.aladin.MyListener;
import cds.aladin.ResourceNode;
import cds.aladin.ServerAladin;
import cds.aladin.ServerDialog;
import cds.aladin.Slider;
import cds.tools.TwoColorJTable;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class FrameInfo
extends JFrame
implements WindowListener,
MyListener,
ActionListener {
    static final int SCROLL_MAX_WIDTH = 300;
    static final int SCROLL_MAX_HEIGHT = 240;
    static String FOV_STACK;
    static String TITLE;
    static String SLICE;
    static String SUBIMG;
    static String CUTTARGET;
    static String SLICE1;
    static String SLICE2;
    static String GETIN;
    static String MODE;
    static String TARGET;
    static String GRAB;
    static String FILTERCHAR;
    static String STICK;
    static String CLOSE;
    static String LOAD;
    static String LOADIN;
    static String DOWNLOAD;
    static String DISPLAY;
    static String VALUE;
    static String FIELD;
    static String DISTTOCENTER;
    private static final Insets BUTTON_INSETS;
    private static Dimension screenSize;
    private JButton loadBtn;
    private JButton loadInBtn;
    private JButton fovBtn;
    private JButton grabBtn;
    private JButton mosaicGrabBtn;
    private boolean grabMode = false;
    private boolean mosaicGrabMode = false;
    private boolean imagePosGrabMode = false;
    private JTextField xPosTF;
    private JTextField yPosTF;
    private JButton imagePosGrabBtn;
    private Slider sliderVel;
    private JPanel btnPanel;
    private JPanel infoPanel;
    private JPanel cutoutPanel;
    private JPanel formatPanel;
    private JPanel modePanel;
    private JPanel subImgPanel;
    private JPanel imagePosGrabPanel;
    private JPanel sub;
    JTextField target;
    JTextField size;
    JTextField mosaicTarget;
    JTextField subImg;
    JMenuBar menuBar;
    private JTable infoTable;
    private static boolean[] visibleCol;
    private static int nbVisibleColumn;
    private static Vector<String> colNames;
    private ButtonGroup fmt;
    private ButtonGroup mode;
    private JPanel bottomPanel;
    private JButton lockBtn;
    private JButton closeBtn;
    private Aladin aladin;
    private ResourceNode node;
    private MetaDataTree tree;
    private boolean firstUpdate = true;
    @Deprecated
    private String memorySlice;
    private JPopupMenu plasticPopup;

    protected static void createChaine(Chaine chaine) {
        if (TITLE != null) {
            return;
        }
        FOV_STACK = chaine.getString("FIFOSTACK");
        TITLE = chaine.getString("FITITLE");
        SLICE = chaine.getString("FISLICE");
        SUBIMG = chaine.getString("FISUBIMG");
        CUTTARGET = chaine.getString("FICUTTARGET");
        SLICE1 = chaine.getString("FISLICE1");
        SLICE2 = chaine.getString("FISLICE2");
        GETIN = chaine.getString("FIGETIN");
        MODE = chaine.getString("FIMODE");
        TARGET = chaine.getString("FITARGET");
        GRAB = chaine.getString("FIGRAB");
        FILTERCHAR = chaine.getString("FIFILTERCHAR");
        STICK = chaine.getString("FISTICK");
        CLOSE = chaine.getString("CLOSE");
        LOAD = chaine.getString("FILOAD");
        LOADIN = chaine.getString("FILOADIN");
        DOWNLOAD = chaine.getString("FIDOWNLOAD");
        DISPLAY = chaine.getString("FIDISPLAY");
        VALUE = chaine.getString("FIVALUE");
        FIELD = chaine.getString("FIFIELD");
        DISTTOCENTER = chaine.getString("FIDISTTOCENTER");
    }

    protected FrameInfo(Aladin aladin) {
        Aladin.setIcon(this);
        this.setTitle(TITLE);
        this.aladin = aladin;
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.createComponents();
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.infoPanel = new JPanel();
        this.getContentPane().add((Component)this.infoPanel, "Center");
        this.bottomPanel = new JPanel();
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 0;
        this.bottomPanel.setLayout(g);
        this.imagePosGrabPanel = new JPanel();
        this.imagePosGrabPanel.setLayout(new GridLayout(0, 1));
        this.imagePosGrabPanel.add(this.createLabel("Warning : position must be grabbed in the correct image !"));
        JPanel imageSub = new JPanel(new FlowLayout());
        imageSub.add(this.createLabel("X pos.:"));
        this.xPosTF = new JTextField(3);
        imageSub.add(this.xPosTF);
        this.xPosTF.setFont(Aladin.PLAIN);
        imageSub.add(this.createLabel("Y pos.:"));
        this.yPosTF = new JTextField(3);
        imageSub.add(this.yPosTF);
        this.yPosTF.setFont(Aladin.PLAIN);
        this.imagePosGrabBtn = this.createButton("Grab image pos.");
        imageSub.add(this.imagePosGrabBtn);
        this.imagePosGrabPanel.add(imageSub);
        this.subImgPanel = new JPanel();
        this.subImgPanel.setLayout(new GridLayout(0, 1));
        this.subImgPanel.add(this.createLabel(SLICE));
        this.sliderVel = new Slider();
        this.subImgPanel.add(this.sliderVel);
        this.sub = new JPanel();
        this.sub.setLayout(new FlowLayout());
        this.sub.add(this.createLabel(SUBIMG));
        this.subImg = new JTextField(3);
        this.subImg.setFont(Aladin.PLAIN);
        this.sub.add(this.subImg);
        this.subImgPanel.add(this.sub);
        this.cutoutPanel = new JPanel();
        this.cutoutPanel.setLayout(new FlowLayout(1, 4, 5));
        this.cutoutPanel.add(this.createLabel(CUTTARGET));
        this.target = new JTextField(15);
        this.target.setFont(Aladin.PLAIN);
        this.target.setEditable(false);
        this.cutoutPanel.add(this.target);
        this.cutoutPanel.add(this.grabBtn);
        g.setConstraints(this.cutoutPanel, c);
        this.bottomPanel.add(this.cutoutPanel);
        g.setConstraints(this.formatPanel, c);
        this.bottomPanel.add(this.formatPanel);
        g.setConstraints(this.modePanel, c);
        this.bottomPanel.add(this.modePanel);
        g.setConstraints(this.imagePosGrabPanel, c);
        this.bottomPanel.add(this.imagePosGrabPanel);
        g.setConstraints(this.subImgPanel, c);
        this.bottomPanel.add(this.subImgPanel);
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new FlowLayout());
        g.setConstraints(this.btnPanel, c);
        this.bottomPanel.add(this.btnPanel);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.addWindowListener(this);
    }

    private Point computeAbsLoc() {
        if (screenSize == null) {
            screenSize = Aladin.SCREENSIZE;
        }
        return Aladin.computeLocation(this);
    }

    public void initTarget() {
        if (this.node == null) {
            return;
        }
        if (this.node.isLeaf && (this.node.cutout || this.node.type == 2)) {
            String cTarget;
            if (this.node.getCutoutTarget() == null && this.node.server != null) {
                this.node.setCutoutTarget(this.node.server.getTarget(false), false);
            }
            if ((cTarget = this.node.getCutoutTarget()) != null) {
                this.target.setText(this.aladin.localisation.getFrameCoord(cTarget));
            }
        }
    }

    public void update(ResourceNode node, MetaDataTree tree) {
        this.grabMode = false;
        this.imagePosGrabMode = false;
        this.node = node;
        this.tree = tree;
        this.memorySlice = node.curImgNumber;
        if (this.firstUpdate) {
            this.firstUpdate = false;
            Point pos = this.computeAbsLoc();
            this.setLocation(pos.x, pos.y);
        }
        this.infoPanel.removeAll();
        this.infoPanel.setLayout(new BorderLayout());
        this.initTarget();
        this.btnPanel.removeAll();
        this.btnPanel.add(this.lockBtn);
        if (node.type == 1 || node.type == 3) {
            this.btnPanel.add(this.fovBtn);
        }
        if (node.isLeaf || node.hasData) {
            boolean connectedToPlastic = this.aladin.getMessagingMgr().isRegistered();
            ArrayList<String> plasticApps = null;
            if (connectedToPlastic) {
                AppMessagingInterface messagingIf = this.aladin.getMessagingMgr();
                plasticApps = messagingIf.getAppsSupporting(node.getPlasticMsg());
            }
            if (node.type != 3 || node.type == 3 && node.location != null || node.location != null && node.location.indexOf("Xpix") >= 0) {
                this.btnPanel.add(this.loadBtn);
                if (connectedToPlastic && plasticApps != null && plasticApps.size() > 0) {
                    this.btnPanel.add(this.loadInBtn);
                    this.loadInBtn.setEnabled(true);
                    this.fillPlasticPopupMenu(plasticApps);
                }
            } else {
                this.btnPanel.add(this.loadInBtn);
                this.loadInBtn.setEnabled(plasticApps != null && plasticApps.size() > 0);
                this.fillPlasticPopupMenu(plasticApps);
            }
        }
        this.btnPanel.add(this.closeBtn);
        if (node.type == 3 && node.location != null || node.indexing != null && node.indexing.equals("HTML")) {
            this.loadBtn.setText(DOWNLOAD);
        } else {
            this.loadBtn.setText(LOAD);
        }
        if (node.isLeaf && node.cutout) {
            this.cutoutPanel.setVisible(true);
        } else {
            this.cutoutPanel.setVisible(false);
        }
        if (node.dataOrga != null && node.dataOrga.equals("SPECTRUM") && node.location != null && node.location.indexOf("Xpix") >= 0) {
            this.imagePosGrabPanel.setVisible(true);
            String[] xy = node.getImagePosTarget();
            this.xPosTF.setText(xy[0]);
            this.yPosTF.setText(xy[1]);
        } else {
            this.imagePosGrabPanel.setVisible(false);
        }
        if (!node.maxImgNumber.equals("1") && node.dataOrga != null && node.dataOrga.equals("SLICES")) {
            this.subImgPanel.setVisible(true);
            int nbSteps = Integer.parseInt(node.maxImgNumber) - 1;
            int curImg = Integer.parseInt(node.curImgNumber) - 1;
            this.sliderVel.setListener(this);
            this.sliderVel.setPosition(curImg);
            this.sliderVel.setParams(node.beginVel, nbSteps, node.velStep);
            this.sliderVel.repaint();
            if (node.velStep == 0.0) {
                this.sliderVel.setVisible(false);
                this.subImgPanel.remove(0);
                this.subImgPanel.add((Component)this.createLabel(""), 0);
            } else {
                this.sliderVel.setVisible(true);
                this.subImgPanel.remove(0);
                this.subImgPanel.add((Component)this.createLabel(SLICE), 0);
            }
        } else {
            this.subImgPanel.setVisible(false);
        }
        this.subImg.setText(this.node.curImgNumber);
        this.sub.remove(0);
        if (node.velStep == 0.0) {
            this.sub.add((Component)this.createLabel(SLICE1 + " " + node.maxImgNumber + "):"), 0);
        } else {
            this.sub.add((Component)this.createLabel(SLICE2 + " " + node.maxImgNumber + "):"), 0);
        }
        if (node.isLeaf && node.formats != null && node.formats.length > 1) {
            this.formatPanel.removeAll();
            this.fmt = new ButtonGroup();
            this.formatPanel.add(this.createLabel(GETIN));
            for (int i = 0; i < node.formats.length; ++i) {
                if (node.formats[i].equals("MRCOMP")) continue;
                boolean selected = node.formats[i].equals(node.curFormat);
                JRadioButton rb = new JRadioButton(node.formats[i], selected);
                this.formatPanel.add(rb);
                rb.setFont(Aladin.PLAIN);
                rb.addActionListener(this);
                this.fmt.add(rb);
            }
            this.formatPanel.setVisible(true);
        } else {
            this.formatPanel.setVisible(false);
        }
        if (node.isLeaf && node.modes != null && node.modes.length > 1) {
            String mTarget;
            this.modePanel.removeAll();
            this.mode = new ButtonGroup();
            this.modePanel.add(this.createLabel(MODE));
            for (int i = 0; i < node.modes.length; ++i) {
                boolean selected = node.modes[i].equals(node.curMode);
                JRadioButton rb = new JRadioButton(node.modes[i], selected);
                this.modePanel.add(rb);
                rb.setFont(Aladin.PLAIN);
                rb.addActionListener(this);
                this.mode.add(rb);
            }
            this.modePanel.add(this.createLabel(TARGET));
            this.mosaicTarget = new JTextField(15);
            this.mosaicTarget.setFont(Aladin.PLAIN);
            this.mosaicTarget.setEditable(false);
            if (node.getMosaicTarget() == null && node.server != null) {
                node.setMosaicTarget(node.server.getTarget(false), false);
            }
            if ((mTarget = node.getMosaicTarget()) != null) {
                this.mosaicTarget.setText(this.aladin.localisation.getFrameCoord(mTarget));
            }
            this.modePanel.add(this.mosaicTarget);
            this.mosaicGrabBtn = this.createButton(GRAB);
            this.mosaicGrabBtn.setFont(Aladin.SBOLD);
            this.modePanel.add(this.mosaicGrabBtn);
            this.modePanel.setVisible(true);
        } else {
            this.modePanel.setVisible(false);
        }
        ArrayList<Object> names = new ArrayList<Object>();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<String> ucds = new ArrayList<String>();
        ArrayList<String> utypes = new ArrayList<String>();
        if (node.type == 1 || node.type == 3 || node.type == 4 || node.type == 6 || node.type == 2) {
            if (!(node.type != 1 && node.type != 3 || Double.isNaN(node.getDistanceToCenter()))) {
                names.add(DISTTOCENTER);
                values.add(this.formatDistance(node.getDistanceToCenter()));
                ucds.add("");
                utypes.add("");
                this.addEmptyRow(names, values, ucds, utypes);
            }
            if (node.criteria != null && node.valueCriteria != null) {
                names.add(node.criteria);
                values.add(node.valueCriteria);
                ucds.add("");
                utypes.add("");
            }
            this.displayInfo(node, names, ucds, utypes, values);
            if (node.desc != null && node.desc.length() > 0) {
                names.add(MetaDataTree.replace(node.desc, "\\n", "\n", -1));
                values.add("");
                ucds.add("");
                utypes.add("");
            }
            if (node.filterDesc != null && node.filterExpla != null) {
                names.add("");
                values.add("");
                ucds.add("");
                utypes.add("");
                names.add(FILTERCHAR);
                values.add("");
                ucds.add("");
                utypes.add("");
                for (int i = 0; i < node.filterDesc.length; ++i) {
                    if (node.filterExpla[i].length() == 0) continue;
                    names.add(node.filterDesc[i]);
                    values.add(node.filterExpla[i]);
                    ucds.add("");
                    utypes.add("");
                }
            }
        }
        FrameInfoTableModel myTableModel = new FrameInfoTableModel();
        myTableModel.setData(names.toArray(new Object[names.size()]), ucds.toArray(new Object[ucds.size()]), utypes.toArray(new Object[utypes.size()]), values.toArray(new Object[values.size()]));
        this.infoTable = new TwoColorJTable(){

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        this.infoTable.setGridColor(Color.lightGray);
        this.infoTable.setShowHorizontalLines(false);
        this.infoTable.setModel(myTableModel);
        this.infoTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane scroll = new JScrollPane(this.infoTable, 20, 30);
        this.infoPanel.add((Component)scroll, "Center");
        int allRowHeight = this.infoTable.getRowHeight() * this.infoTable.getRowCount();
        int newScrollHeight = allRowHeight > 240 ? 240 : allRowHeight;
        this.infoTable.setPreferredScrollableViewportSize(new Dimension(300, newScrollHeight));
        this.infoTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (row == 0 && column == 0 && value.equals(DISTTOCENTER)) {
                    c.setFont(Aladin.BOLD);
                } else if (column == 0) {
                    c.setFont(Aladin.ITALIC);
                }
                return c;
            }
        });
        this.infoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, node.name, 2, 2), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        this.infoPanel.invalidate();
        this.infoPanel.validate();
        this.infoPanel.setSize(0, 0);
        this.pack();
        Point loc = this.getLocation();
        Dimension size = this.getSize();
        int newX = loc.x;
        int newY = loc.y;
        boolean mustMove = false;
        int offsetX = FrameInfo.screenSize.width - (loc.x + size.width);
        int offsetY = FrameInfo.screenSize.height - (loc.y + size.height);
        if (offsetX < 0) {
            mustMove = true;
            newX += offsetX;
        }
        if (offsetY < 25) {
            mustMove = true;
            newY = offsetY < 0 ? (newY += offsetY - 25) : (newY += -(25 - offsetY));
        }
        if (mustMove) {
            this.setLocation(newX, newY);
        }
    }

    private void addEmptyRow(ArrayList<Object> names, ArrayList<Object> values, ArrayList<String> ucds, ArrayList<String> utypes) {
        names.add("");
        values.add("");
        ucds.add("");
        utypes.add("");
    }

    private void displayInfo(ResourceNode node, ArrayList<Object> names, ArrayList<String> ucds, ArrayList<String> utypes, ArrayList<Object> values) {
        if (node.description == null || node.explanation == null) {
            return;
        }
        for (int i = 0; i < node.description.length; ++i) {
            Object o2;
            if (node.explanation[i].length() == 0) continue;
            String o1 = node.description[i];
            if (node.links != null && node.links.get(node.description[i]) != null) {
                MyLink l = new MyLink(this.aladin, node.explanation[i]);
                l.setFont(Aladin.SBOLD);
                l.baratin = node.description[i];
                o2 = l;
            } else {
                o2 = node.explanation[i];
            }
            names.add(o1);
            values.add(o2);
            ucds.add(node.ucds == null ? "" : node.ucds[i]);
            utypes.add(node.utypes == null ? "" : node.utypes[i]);
        }
    }

    @Override
    public boolean keyUp(Event e, int key) {
        if (e.target.equals(this.subImg) && (key < 48 || key > 57) && key < 127 && key > 31) {
            int caret = this.subImg.getCaretPosition();
            this.subImg.setText(this.memorySlice);
            this.subImg.setCaretPosition(caret == 0 ? 0 : caret - 1);
        }
        this.memorySlice = this.node.curImgNumber = this.subImg.getText();
        try {
            if (this.sliderVel != null) {
                this.sliderVel.setPosition(Integer.parseInt(this.memorySlice) - 1, false);
                this.sliderVel.repaint();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return super.keyUp(e, key);
    }

    private void createComponents() {
        this.menuBar = new JMenuBar();
        JMenu menu = new JMenu(DISPLAY);
        this.menuBar.add(menu);
        colNames = new Vector<String>(Arrays.asList(FIELD, "UCD", "UType", VALUE));
        Enumeration<String> e = colNames.elements();
        int k = 0;
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(s, visibleCol[k]);
            menu.add(mi);
            mi.addActionListener(this);
            ++k;
        }
        this.setJMenuBar(this.menuBar);
        this.formatPanel = new JPanel();
        this.formatPanel.setLayout(new FlowLayout(0));
        this.formatPanel.setFont(Aladin.PLAIN);
        this.modePanel = new JPanel();
        this.modePanel.setLayout(new FlowLayout(0));
        this.modePanel.setFont(Aladin.PLAIN);
        this.grabBtn = this.createButton(GRAB);
        this.grabBtn.setFont(Aladin.SBOLD);
        this.fovBtn = this.createButton(FOV_STACK);
        this.fovBtn.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (((FrameInfo)FrameInfo.this).node.type == 1 || ((FrameInfo)FrameInfo.this).node.type == 3) {
                    FrameInfo.this.tree.showFov(FrameInfo.this.node);
                    if (((FrameInfo)FrameInfo.this).node.cutout) {
                        FrameInfo.this.tree.showCutoutFov(FrameInfo.this.node);
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FrameInfo.this.tree.hideFov();
                FrameInfo.this.tree.deactivateCutoutFov();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.fovBtn.setFont(Aladin.PLAIN);
        this.lockBtn = this.createButton(STICK);
        this.lockBtn.setFont(Aladin.PLAIN);
        this.closeBtn = this.createButton(CLOSE);
        this.closeBtn.setFont(Aladin.PLAIN);
        this.loadBtn = this.createButton(LOAD);
        this.loadBtn.setFont(Aladin.BOLD);
        this.loadInBtn = this.createButton(LOADIN);
        this.loadInBtn.setIcon(new ImageIcon(this.aladin.getImagette("arrow.gif")));
        this.loadInBtn.setFont(Aladin.BOLD);
        this.loadInBtn.setHorizontalTextPosition(2);
        this.loadInBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FrameInfo.this.plasticPopup.show(FrameInfo.this.loadInBtn, mouseEvent.getX(), mouseEvent.getY() + 5);
            }
        });
    }

    boolean inGrabMode() {
        return this.grabMode;
    }

    boolean inMosaicGrabMode() {
        return this.mosaicGrabMode;
    }

    boolean inImagePosGrabMode() {
        return this.imagePosGrabMode;
    }

    ResourceNode getNode() {
        return this.node;
    }

    void setTarget(String t) {
        this.node.setCutoutTarget(t);
        this.toFront();
        this.grabMode = false;
    }

    void setTargetTF(String t) {
        this.target.setText(this.aladin.localisation.getFrameCoord(t));
    }

    void setMosaicTarget(String t) {
        this.node.setMosaicTarget(t);
        this.toFront();
        this.mosaicGrabMode = false;
    }

    void setMosaicTargetTF(String t) {
        this.mosaicTarget.setText(this.aladin.localisation.getFrameCoord(t));
    }

    void setImagePosTarget(String x, String y) {
        this.node.setImagePosTarget(x, y);
        this.toFront();
        this.imagePosGrabMode = false;
    }

    void setImagePosTargeTFt(String x, String y) {
        this.xPosTF.setText(x);
        this.yPosTF.setText(y);
    }

    private void fillPlasticPopupMenu(ArrayList<String> plasticApps) {
        if (plasticApps == null) {
            return;
        }
        this.plasticPopup = new JPopupMenu();
        for (String app : plasticApps) {
            JMenuItem mi = new JMenuItem(app);
            mi.addActionListener(this);
            mi.setActionCommand(LOADIN);
            this.plasticPopup.add(mi);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        String o = ae.getActionCommand();
        if (src instanceof JCheckBoxMenuItem) {
            this.toggleColumnVisibility(((JCheckBoxMenuItem)src).getText());
        } else if (src.equals(this.grabBtn)) {
            this.grabMode = true;
            this.aladin.getFrame(this.aladin).toFront();
        } else if (src.equals(this.mosaicGrabBtn)) {
            this.mosaicGrabMode = true;
            this.aladin.getFrame(this.aladin).toFront();
        } else if (src.equals(this.imagePosGrabBtn)) {
            this.imagePosGrabMode = true;
            this.aladin.getFrame(this.aladin).toFront();
        } else if (src.equals(this.closeBtn)) {
            this.setVisible(false);
        } else if (src.equals(this.lockBtn)) {
            this.lockBtn.setEnabled(false);
            this.aladin.frameInfo = new FrameInfo(this.aladin);
        } else if (src.equals(this.loadBtn)) {
            if (this.loadBtn.getText().equals(DOWNLOAD) && this.node.type == 3) {
                this.aladin.glu.showDocument("Http", this.node.location, true);
                return;
            }
            this.node.setCutoutTarget(this.aladin.localisation.getICRSCoord(this.target.getText()), false);
            if (this.imagePosGrabPanel.isVisible()) {
                this.node.setImagePosTarget(this.xPosTF.getText(), this.yPosTF.getText());
            }
            if (!this.node.maxImgNumber.equals("1")) {
                this.memorySlice = this.node.curImgNumber = this.subImg.getText();
            }
            this.tree.load(this.node, null, null, this);
        } else if (src.equals(this.fovBtn)) {
            String planeName = this.node.name;
            if (this.node.server != null && this.node.server instanceof ServerAladin && this.node.machine != null && this.node.machine.length() != 0) {
                planeName = this.node.machine + "." + planeName;
            }
            this.aladin.calque.newPlanFov("FoV_" + planeName, this.tree.getFovs(this.node, false, true));
            this.aladin.view.repaintAll();
            if (this.aladin.dialog.server[this.aladin.dialog.current].grab != null) {
                this.aladin.dialog.server[this.aladin.dialog.current].grab.setEnabled(true);
            }
        } else if (src instanceof JRadioButton) {
            JRadioButton rb = (JRadioButton)src;
            if (this.fmt != null && rb.equals(this.getSelectedJRadioButton(this.fmt))) {
                this.node.curFormat = rb.getText();
            } else if (this.mode != null && rb.equals(this.getSelectedJRadioButton(this.mode))) {
                this.node.curMode = rb.getText();
            }
        } else if (src instanceof JMenuItem && o.equals(LOADIN)) {
            this.aladin.dialog.server[ServerDialog.ALADIN].tree.loadNodeWithPlastic(this.node, ((JMenuItem)src).getText());
        }
    }

    private JRadioButton getSelectedJRadioButton(ButtonGroup bg) {
        Enumeration<AbstractButton> e = bg.getElements();
        while (e.hasMoreElements()) {
            JRadioButton rb;
            try {
                rb = (JRadioButton)e.nextElement();
            }
            catch (ClassCastException cce) {
                continue;
            }
            if (!rb.isSelected()) continue;
            return rb;
        }
        return null;
    }

    private JButton createButton(String s) {
        JButton b = new JButton(s);
        b.setMargin(BUTTON_INSETS);
        b.addActionListener(this);
        return b;
    }

    private String formatDistance(double dist) {
        double value = dist;
        String unit = "deg";
        if (value < 1.0) {
            value = dist * 60.0;
            unit = "arcmin";
        }
        if (value < 1.0) {
            value = dist * 3600.0;
            unit = "arcsec";
        }
        return Util.myRound(value + "", 2) + " " + unit;
    }

    private JLabel createLabel(String s) {
        JLabel l = new JLabel(s);
        l.setFont(Aladin.PLAIN);
        return l;
    }

    private void toggleColumnVisibility(String colName) {
        boolean newVal;
        int idx = colNames.indexOf(colName);
        if (idx < 0) {
            return;
        }
        FrameInfo.visibleCol[idx] = newVal = !visibleCol[idx];
        nbVisibleColumn = newVal ? ++nbVisibleColumn : --nbVisibleColumn;
        ((AbstractTableModel)this.infoTable.getModel()).fireTableStructureChanged();
    }

    protected void load() {
        this.node.setCutoutTarget(this.aladin.localisation.getICRSCoord(this.target.getText()), false);
        this.tree.load(this.node, null, null, this);
    }

    @Override
    public void fireStateChange(String s) {
        if (this.node != null) {
            this.node.curImgNumber = s;
        }
        if (this.subImg != null) {
            this.subImg.setText(s);
        }
    }

    @Override
    public void fireStateChange(int i) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.setVisible(false);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    static {
        BUTTON_INSETS = new Insets(1, 1, 1, 1);
        visibleCol = new boolean[]{true, false, false, true};
        nbVisibleColumn = 2;
    }

    class FrameInfoTableModel
    extends AbstractTableModel {
        Object[] names;
        Object[] values;
        Object[] ucds;
        Object[] utypes;

        FrameInfoTableModel() {
        }

        public void setData(Object[] names, Object[] ucds, Object[] utypes, Object[] values) {
            this.names = names;
            this.ucds = ucds;
            this.utypes = utypes;
            this.values = values;
        }

        @Override
        public int getRowCount() {
            return this.names == null ? -1 : this.names.length;
        }

        @Override
        public int getColumnCount() {
            return nbVisibleColumn;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == -1 || row == -1) {
                return null;
            }
            col = this.getRealColIdx(col);
            switch (col) {
                case 0: {
                    return this.names[row];
                }
                case 1: {
                    return this.ucds[row];
                }
                case 2: {
                    return this.utypes[row];
                }
                case 3: {
                    return this.values[row];
                }
            }
            return null;
        }

        private int getRealColIdx(int col) {
            int k = 0;
            for (int i = 0; i < visibleCol.length; ++i) {
                if (!visibleCol[i]) continue;
                if (k == col) {
                    return i;
                }
                ++k;
            }
            return -1;
        }

        @Override
        public String getColumnName(int column) {
            int k = 0;
            for (int i = 0; i < visibleCol.length; ++i) {
                if (!visibleCol[i]) continue;
                if (k == column) {
                    return (String)colNames.get(i);
                }
                ++k;
            }
            return null;
        }
    }
}

