/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Plan;
import cds.aladin.PlanHealpix;
import cds.tools.Util;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class FrameHealpixArithmetic
extends FrameRGBBlink {
    String TITLE;
    String INFO;
    String HELP1;
    String ADD;
    String SUB;
    String MUL;
    String DIV;
    String PLANE;
    String PLANEVALUE;
    private ButtonGroup cbg;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("HARITHTITLE");
        this.INFO = Aladin.chaine.getString("HARITHINFO");
        this.HELP1 = Aladin.chaine.getString("HARITHHELP");
        this.ADD = Aladin.chaine.getString("ARITHADD");
        this.SUB = Aladin.chaine.getString("ARITHSUB");
        this.MUL = Aladin.chaine.getString("ARITHMUL");
        this.DIV = Aladin.chaine.getString("ARITHDIV");
        this.PLANE = Aladin.chaine.getString("ARITHPLANE");
        this.PLANEVALUE = Aladin.chaine.getString("ARITHPLANEVALUE");
    }

    protected FrameHealpixArithmetic(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return -2;
    }

    @Override
    protected int getNb() {
        return 2;
    }

    @Override
    protected String getLabelSelector(int i) {
        return i == 0 ? this.PLANE : this.PLANEVALUE;
    }

    protected PlanHealpix[] getPlan() {
        Vector<Plan> v = this.a.calque.getPlans(PlanHealpix.class);
        if (v == null) {
            return new PlanHealpix[0];
        }
        Object[] pi = new PlanHealpix[v.size()];
        v.copyInto(pi);
        return pi;
    }

    @Override
    protected Color getColorLabel(int i) {
        return Color.black;
    }

    @Override
    protected JPanel getAddPanel() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        JPanel p = new JPanel();
        p.setLayout(g);
        this.cbg = new ButtonGroup();
        JPanel pp = new JPanel();
        JRadioButton cb = new JRadioButton(this.ADD);
        cb.setActionCommand(this.ADD);
        this.cbg.add(cb);
        pp.add(cb);
        cb.setSelected(true);
        cb = new JRadioButton(this.SUB);
        cb.setActionCommand(this.SUB);
        this.cbg.add(cb);
        pp.add(cb);
        cb = new JRadioButton(this.MUL);
        cb.setActionCommand(this.MUL);
        this.cbg.add(cb);
        pp.add(cb);
        cb = new JRadioButton(this.DIV);
        cb.setActionCommand(this.DIV);
        this.cbg.add(cb);
        pp.add(cb);
        c.gridwidth = 0;
        c.weightx = 10.0;
        g.setConstraints(pp, c);
        p.add(pp);
        return p;
    }

    private int getOperation(String s) {
        if (s.equals(this.ADD)) {
            return 0;
        }
        if (s.equals(this.SUB)) {
            return 1;
        }
        if (s.equals(this.MUL)) {
            return 2;
        }
        return 3;
    }

    @Override
    protected void submit() {
        try {
            PlanHealpix p1 = (PlanHealpix)this.getPlan(this.ch[0]);
            PlanHealpix p2 = (PlanHealpix)this.getPlan(this.ch[1]);
            while (p1 != null && !p1.isSync() || p2 != null && !p2.isSync()) {
                Util.pause(500);
            }
            double coef = 0.0;
            if (p2 == null) {
                coef = Double.parseDouble(((String)this.ch[1].getSelectedItem()).trim());
            }
            String s = this.cbg.getSelection().getActionCommand();
            int fct = this.getOperation(s);
            this.a.calque.newPlanHealpixAlgo(s.substring(0, 3), p1, p2, fct, coef);
            this.hide();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.warning("Healpix arithmetic operation failed !");
        }
    }

    @Override
    protected void adjustWidgets() {
        this.ch[1].setEditable(true);
    }
}

