/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameRGBBlink;
import cds.aladin.PlanImage;
import cds.aladin.Tok;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public final class FrameBlink
extends FrameRGBBlink {
    protected static final int[] DELAY = new int[]{0, 25, 50, 100, 200, 400, 800, 1600, 3200};
    String TITLE;
    String INFO;
    String HELP1;
    String RSAMPREF;
    String BLKDELAY;
    String MOSAIC;
    String BLINK;
    String ERR1;
    String ERR2;
    static final String STOPPED = "-- stopped --";
    static final int DEFAULT_DELAY = 5;
    private ButtonGroup cmb;
    private JRadioButton bcb;
    private JRadioButton mcb;
    private JComboBox cDelay;
    private JTextField textFieldRef;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("BLKTITLE");
        this.INFO = Aladin.chaine.getString("BLKINFO");
        this.HELP1 = Aladin.chaine.getString("IMGHELP1");
        this.RSAMPREF = Aladin.chaine.getString("RGBRSAMPREF");
        this.BLKDELAY = Aladin.chaine.getString("BLKDELAY");
        this.BLINK = Aladin.chaine.getString("BLKBLK");
        this.MOSAIC = Aladin.chaine.getString("BLKMOSAIC");
        this.ERR1 = Aladin.chaine.getString("BLKERR1");
        this.ERR2 = Aladin.chaine.getString("BLKERR2");
    }

    protected FrameBlink(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return 15;
    }

    @Override
    protected int getNb() {
        return 50;
    }

    @Override
    protected String getLabelSelector(int i) {
        return i + 1 + ")";
    }

    @Override
    protected Color getColorLabel(int i) {
        return Color.black;
    }

    protected static JComboBox createChoiceDelay() {
        return FrameBlink.createChoiceDelay(FrameBlink.getDefaultDelay());
    }

    protected static JComboBox createChoiceDelay(int defaultDelay) {
        JComboBox<String> c = new JComboBox<String>();
        c.setFont(Aladin.BOLD);
        int n = 0;
        for (int i = 0; i < DELAY.length; ++i) {
            if (DELAY[i] == 0) {
                c.addItem(STOPPED);
            } else {
                c.addItem(DELAY[i] + " ms");
            }
            if (defaultDelay != DELAY[i]) continue;
            n = i;
        }
        c.setSelectedIndex(n);
        return c;
    }

    protected int getDelay() {
        String s = (String)this.cDelay.getSelectedItem();
        if (s.equals(STOPPED)) {
            return 0;
        }
        s = s.substring(0, s.indexOf(32));
        return Integer.valueOf(s);
    }

    protected static int getMinDelay() {
        return DELAY[1];
    }

    protected static int getMaxDelay() {
        return DELAY[DELAY.length - 1];
    }

    protected static int getDefaultDelay() {
        return DELAY[5];
    }

    @Override
    protected JPanel getAddPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(0, 1));
        this.cmb = new ButtonGroup();
        JPanel p1 = new JPanel();
        JRadioButton b = this.mcb = new JRadioButton(this.MOSAIC);
        b.setActionCommand(this.MOSAIC);
        this.cmb.add(b);
        p1.add(b);
        this.bcb = b = new JRadioButton(this.BLINK);
        b.setActionCommand(this.BLINK);
        this.cmb.add(b);
        b.setSelected(true);
        p1.add(b);
        p1.add(new Label(this.BLKDELAY));
        this.cDelay = FrameBlink.createChoiceDelay();
        p1.add(this.cDelay);
        p.add(p1);
        p1 = new JPanel();
        p1.add(new Label(this.RSAMPREF));
        this.textFieldRef = new JTextField("1");
        p1.add(this.textFieldRef);
        p.add(p1);
        return p;
    }

    @Override
    protected void adjustWidgets() {
        this.cDelay.setEnabled(this.cmb.getSelection().getActionCommand().equals(this.BLINK));
    }

    @Override
    protected void reset() {
        super.reset();
        this.textFieldRef.setText("1");
        this.cDelay.setSelectedIndex(5);
    }

    protected void setMode(int mode) {
        if (mode == 0) {
            this.bcb.setSelected(true);
        } else {
            this.mcb.setSelected(true);
        }
    }

    @Override
    protected void submit() {
        int first = -1;
        try {
            first = Integer.parseInt(this.textFieldRef.getText()) - 1;
        }
        catch (Exception e1) {
            // empty catch block
        }
        if (first < 0 || first >= this.ch.length) {
            Aladin.warning(this, this.ERR1 + " [1.." + (this.ch.length - 1) + "] !");
            return;
        }
        int n = this.getNb();
        Vector<PlanImage> v = new Vector<PlanImage>(10);
        int i = 0;
        while (i < n) {
            PlanImage pi;
            if (first >= this.ch.length) {
                first = 0;
            }
            if ((pi = (PlanImage)this.getPlan(this.ch[first])) != null) {
                v.addElement(pi);
            }
            ++i;
            ++first;
        }
        if (v.size() == 1) {
            Aladin.warning(this, this.ERR2);
            return;
        }
        boolean blink = this.cmb.getSelection().getActionCommand().equals(this.BLINK);
        StringBuffer cmd = new StringBuffer(blink ? "blink" : "mosaic");
        PlanImage[] p = new PlanImage[v.size()];
        Enumeration e = v.elements();
        int i2 = 0;
        while (e.hasMoreElements()) {
            p[i2] = (PlanImage)e.nextElement();
            cmd.append(" " + Tok.quote(p[i2].label));
            ++i2;
        }
        this.a.console.printCommand(cmd.toString());
        if (blink) {
            this.a.calque.newPlanImageBlink(p, null, this.getDelay());
        } else {
            this.a.calque.newPlanImageMosaic(p, null, null);
        }
        this.hide();
    }
}

