/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Forme;
import cds.aladin.Plan;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Graphics;

public class Ellipse
extends Forme {
    protected double angle;

    protected Ellipse(Plan plan, ViewSimple v, double xv, double yv, double w, double h, double angle) {
        super(plan, new Position[5]);
        this.angle = angle;
        this.o[0] = new Position(plan, v, xv, yv, 0.0, 0.0, 5, null);
        double demiDia = Math.sqrt(w * w / 4.0 + h * h / 4.0);
        double a = Math.atan2(h / 2.0, w / 2.0);
        double b = Math.toRadians(90.0 + angle);
        double d = b + a;
        double x = xv + demiDia * Math.sin(d);
        double y = yv + demiDia * Math.cos(d);
        this.o[1] = new Position(plan, v, x, y, 0.0, 0.0, 5, null);
        d = b - a;
        x = xv + demiDia * Math.sin(d);
        y = yv + demiDia * Math.cos(d);
        this.o[2] = new Position(plan, v, x, y, 0.0, 0.0, 5, null);
        d = b + Math.PI - a;
        x = xv + demiDia * Math.sin(d);
        y = yv + demiDia * Math.cos(d);
        this.o[4] = new Position(plan, v, x, y, 0.0, 0.0, 5, null);
        d = b + Math.PI + a;
        x = xv + demiDia * Math.sin(d);
        y = yv + demiDia * Math.cos(d);
        this.o[3] = new Position(plan, v, x, y, 0.0, 0.0, 5, null);
        this.setObjet(this.o);
    }

    protected Ellipse(Plan plan, Coord c, double semiMA, double semiMI, double angle) {
        super(plan, new Position[5]);
        this.angle = angle;
        double b = 90.0;
        this.o[0] = new Position(plan, null, 0.0, 0.0, c.al, c.del, 2, null);
        Coord c1 = this.applySphereRot(c, semiMA, b + angle);
        this.o[1] = new Position(plan, null, 0.0, 0.0, c1.al, c1.del, 2, null);
        c1 = this.applySphereRot(c, semiMI, b + angle + 90.0);
        this.o[2] = new Position(plan, null, 0.0, 0.0, c1.al, c1.del, 2, null);
        c1 = this.applySphereRot(c, semiMA, b + angle + 180.0);
        this.o[3] = new Position(plan, null, 0.0, 0.0, c1.al, c1.del, 2, null);
        c1 = this.applySphereRot(c, semiMI, b + angle + 270.0);
        this.o[4] = new Position(plan, null, 0.0, 0.0, c1.al, c1.del, 2, null);
        this.setObjet(this.o);
    }

    protected Ellipse(Plan plan, Position[] o) {
        super(plan, o);
    }

    @Override
    public String getObjType() {
        return "ellipse";
    }

    protected double getAngle() {
        return this.angle;
    }

    protected double getSemiMA(ViewSimple v) {
        double dy = this.o[1].yv[v.n] - this.o[0].yv[v.n];
        double dx = this.o[1].xv[v.n] - this.o[0].xv[v.n];
        return Math.sqrt(dx * dx + dy * dy);
    }

    protected double getSemiMI(ViewSimple v) {
        double dy = this.o[2].yv[v.n] - this.o[0].yv[v.n];
        double dx = this.o[2].xv[v.n] - this.o[0].xv[v.n];
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    protected boolean inside(ViewSimple v, double x, double y) {
        return this.in1(v, x, y, false);
    }

    @Override
    protected boolean in(ViewSimple v, double x, double y) {
        return this.in1(v, x, y, true);
    }

    private boolean in1(ViewSimple v, double x, double y, boolean flagPerimetre) {
        if (!this.isVisible()) {
            return false;
        }
        double xc = Math.abs(x - this.o[0].xv[v.n]);
        double yc = Math.abs(y - this.o[0].yv[v.n]);
        double u = Math.toRadians(this.angle) - Math.atan2(yc, xc);
        double len = Math.sqrt(xc * xc + yc * yc);
        double semiMA = this.getSemiMA(v);
        double semiMI = this.getSemiMI(v);
        double xp = semiMA * Math.cos(u);
        double yp = semiMI * Math.sin(u);
        double p = Math.sqrt(xp * xp + yp * yp);
        return flagPerimetre ? Math.abs(len - p) < 3.0 + 9.0 / v.getZoom() : len < p;
    }

    @Override
    protected boolean inRectangle(ViewSimple v, RectangleD r) {
        return this.o[0].inRectangle(v, r);
    }

    @Override
    protected boolean inBout(ViewSimple v, double x, double y) {
        if (!this.isVisible()) {
            return false;
        }
        for (int i = 1; i < this.o.length; ++i) {
            if (!this.o[i].in(v, x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isVisible()) {
            return false;
        }
        PointD[] p = new PointD[3];
        for (int i = 0; i < p.length; ++i) {
            p[i] = v.getViewCoordDble(this.o[i].xv[v.n], this.o[i].yv[v.n]);
            if (p[i] == null) {
                return false;
            }
            p[i].x += (double)dx;
            p[i].y += (double)dy;
        }
        double dxMA = p[1].x - p[0].x;
        double dyMA = p[1].y - p[0].y;
        double dxMI = p[2].x - p[0].x;
        double dyMI = p[2].y - p[0].y;
        double demiMA = Math.sqrt(dxMA * dxMA + dyMA * dyMA);
        double demiMI = Math.sqrt(dxMI * dxMI + dyMI * dyMI);
        double a = Math.toDegrees(Math.atan2(dyMA, dxMA));
        g.setColor(this.getColor());
        Util.drawEllipse(g, p[0].x, p[0].y, demiMA, demiMI, a);
        if (this.isSelected()) {
            for (int i = 1; i < this.o.length; ++i) {
                this.drawSelect(g, v, i);
            }
        }
        return true;
    }
}

