/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameBlink;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGCube;
import cds.aladin.PlanImageBlink;
import cds.aladin.Tool;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public class CubeControl {
    protected static int NOTHING = 0;
    protected static int PAUSE = 1;
    protected static int PLAY = 2;
    protected static int REWIND = 3;
    protected static int FORWARD = 4;
    protected static int PLUS = 5;
    protected static int MOINS = 6;
    protected static int SLIDE = 7;
    protected static int EDIT = 8;
    protected static int SHOULD_REPAINT = 9;
    protected static int IN = 10;
    protected static int CURSOR = 11;
    static final int MAX_TRANSPARENCY = 11;
    protected static String[] HELP = new String[]{"Nothing", "Pause", "Play", "Previous image", "Next image", "Increase the speed", "Decrease the speed", "Change the current frame", "Edit the frame number", "", "", ""};
    private StringBuilder sedit = null;
    protected int mode = PLAY;
    protected int delay;
    protected int nbFrame;
    protected int lastFrame = -1;
    protected double transparency = -1.0;
    protected long startTime;
    private int mouseMove = NOTHING;
    private int X = -1;
    private int Y = -1;
    protected int SIZE = -1;
    private int[] rewX = new int[3];
    private int[] rewY = new int[3];
    private int[] playX1 = new int[4];
    private int[] playY1 = new int[4];
    private int[] playX2 = new int[3];
    private int[] playY2 = new int[3];
    private int[] pauseX1 = new int[4];
    private int[] pauseY1 = new int[4];
    private int[] pauseX2 = new int[4];
    private int[] pauseY2 = new int[4];
    private int[] fowX = new int[3];
    private int[] fowY = new int[3];
    private int[] plusX1 = new int[4];
    private int[] plusY1 = new int[4];
    private int[] plusX2 = new int[4];
    private int[] plusY2 = new int[4];
    private int[] slashX = new int[4];
    private int[] slashY = new int[4];
    private int[] moinsX = new int[4];
    private int[] moinsY = new int[4];
    private int[] edit = new int[2];
    private int[] posX = new int[5];
    private int[] posY = new int[5];
    private int[] sliderX = new int[4];
    private int[] sliderY = new int[4];
    private int labelX;
    private int labelY;
    private int labelPX;
    private int labelPY;
    private int[][] shapeX = new int[][]{this.pauseX1, this.pauseX2, this.playX1, this.playX2, this.rewX, this.fowX, this.plusX1, this.plusX2, this.slashX, this.moinsX, this.sliderX, this.posX};
    private int[][] shapeY = new int[][]{this.pauseY1, this.pauseY2, this.playY1, this.playY2, this.rewY, this.fowY, this.plusY1, this.plusY2, this.slashY, this.moinsY, this.sliderY, this.posY};
    private ViewSimple v;
    private Aladin aladin;
    private Plan p;
    private int step = 0;

    protected CubeControl(ViewSimple v, Plan p, int d, boolean pause) {
        this.v = v;
        this.aladin = v.aladin;
        this.p = p;
        this.delay = d;
        this.startTime = System.currentTimeMillis();
        if (this.delay == 0 || pause) {
            this.setMode(PAUSE);
        }
        if (this.delay < 20) {
            this.delay = FrameBlink.getDefaultDelay();
        }
    }

    protected CubeControl copy() {
        CubeControl b = new CubeControl(this.v, this.p, this.delay, this.mode == PAUSE);
        b.startTime = this.startTime;
        b.nbFrame = this.nbFrame;
        b.lastFrame = this.lastFrame;
        b.mode = this.mode;
        return b;
    }

    protected void init(int size) {
        int dx = 0;
        this.SIZE = size;
        this.pauseX1[0] = 3 + dx;
        this.pauseX1[1] = 3 + dx;
        this.pauseX1[2] = 4 + dx;
        this.pauseX1[3] = 4 + dx;
        this.pauseY1[0] = 0;
        this.pauseY1[1] = size;
        this.pauseY1[2] = size;
        this.pauseY1[3] = 0;
        this.pauseX2[0] = 6 + dx;
        this.pauseX2[1] = 6 + dx;
        this.pauseX2[2] = 7 + dx;
        this.pauseX2[3] = 7 + dx;
        this.pauseY2[0] = 0;
        this.pauseY2[1] = size;
        this.pauseY2[2] = size;
        this.pauseY2[3] = 0;
        this.playX1[0] = dx = size + size / 2;
        this.playX1[1] = dx;
        this.playX1[2] = 1 + dx;
        this.playX1[3] = 1 + dx;
        this.playY1[0] = 0;
        this.playY1[1] = size;
        this.playY1[2] = size;
        this.playY1[3] = 0;
        this.playX2[0] = 3 + dx;
        this.playX2[1] = 3 + dx;
        this.playX2[2] = size + dx;
        this.playY2[0] = 0;
        this.playY2[1] = size;
        this.playY2[2] = size / 2;
        this.rewX[0] = 2 + (dx += 2 * size);
        this.rewX[1] = size + dx;
        this.rewX[2] = size + dx;
        this.rewY[0] = size / 2;
        this.rewY[1] = 0;
        this.rewY[2] = size;
        this.fowX[0] = dx += size + size / 2;
        this.fowX[1] = dx;
        this.fowX[2] = size + dx - 2;
        this.fowY[0] = 0;
        this.fowY[1] = size;
        this.fowY[2] = size / 2;
        this.plusX1[0] = (dx += 2 * size) + size / 2 - 1;
        this.plusX1[1] = dx + size / 2;
        this.plusX1[2] = dx + size / 2;
        this.plusX1[3] = dx + size / 2 - 1;
        this.plusY1[0] = 1;
        this.plusY1[1] = 1;
        this.plusY1[2] = size;
        this.plusY1[3] = size;
        this.plusX2[0] = dx;
        this.plusX2[1] = dx + size - 1;
        this.plusX2[2] = dx + size - 1;
        this.plusX2[3] = dx;
        this.plusY2[0] = size / 2;
        this.plusY2[1] = size / 2;
        this.plusY2[2] = size / 2 + 1;
        this.plusY2[3] = size / 2 + 1;
        this.slashX[0] = dx += size;
        this.slashX[1] = dx + 1;
        this.slashX[2] = dx + 4;
        this.slashX[3] = dx + 3;
        this.slashY[0] = size;
        this.slashY[1] = size;
        this.slashY[2] = 0;
        this.slashY[3] = 0;
        this.moinsX[0] = (dx += size / 2) + 1;
        this.moinsX[1] = dx + size - 1;
        this.moinsX[2] = dx + size - 1;
        this.moinsX[3] = dx + 1;
        this.moinsY[0] = size / 2;
        this.moinsY[1] = size / 2;
        this.moinsY[2] = size / 2 + 1;
        this.moinsY[3] = size / 2 + 1;
        this.labelX = dx += size + size / 2 + 2;
        this.labelY = size + size / 2 - 2;
        this.labelPX = dx += 3 * this.SIZE;
        this.labelPY = size + size / 2 - 2;
        int dy = 2 * size + 2;
        this.posX[0] = this.posX[4] = -size / 2;
        this.posX[1] = this.posX[2] = size / 2;
        this.posX[3] = 0;
        this.posY[0] = this.posY[1] = dy - 4;
        this.posY[2] = this.posY[4] = dy + size - 3;
        this.posY[3] = dy + size - 1;
        this.sliderX[3] = 0;
        this.sliderX[0] = 0;
        this.sliderX[1] = this.sliderX[2] = this.getWidth();
        this.sliderY[0] = this.sliderY[1] = dy;
        this.sliderY[2] = this.sliderY[3] = dy;
    }

    protected int getWidth() {
        return this.SIZE * 12 + this.SIZE / 2 + 4 * this.SIZE;
    }

    protected int getHeight() {
        return this.SIZE * 3;
    }

    private int getLogo(int x, int y) {
        int m = y == -1 || y > this.Y + this.SIZE && y < this.Y + this.getHeight() && x >= this.X - 2 && x < this.X - 2 + this.getWidth() + 5 ? SLIDE : (y >= 0 && (y < this.Y || y > this.Y + this.SIZE || x < this.X || x > this.X + this.getWidth() + 5) ? NOTHING : (x < this.X + this.SIZE ? PAUSE : (x > this.X + this.SIZE + this.SIZE / 2 && x < this.X + 2 * this.SIZE + this.SIZE / 2 ? PLAY : (x > this.X + 3 * this.SIZE + this.SIZE / 2 && x < this.X + 4 * this.SIZE + this.SIZE / 2 ? REWIND : (x > this.X + 4 * this.SIZE + this.SIZE / 2 && x < this.X + 5 * this.SIZE + this.SIZE / 2 ? FORWARD : (x > this.X + 7 * this.SIZE && x < this.X + 8 * this.SIZE ? PLUS : (x > this.X + 8 * this.SIZE + this.SIZE / 2 && x < this.X + 9 * this.SIZE + this.SIZE / 2 ? MOINS : (x > this.X + 9 * this.SIZE + this.SIZE / 2 && x < this.X + this.getWidth() + 5 ? EDIT : IN))))))));
        return m;
    }

    protected boolean isEditing() {
        return this.sedit != null;
    }

    protected void stopEditing() {
        this.sedit = null;
    }

    public boolean keyPress(KeyEvent e) {
        if (!this.isEditing()) {
            return false;
        }
        int key = e.getKeyCode();
        char k = e.getKeyChar();
        if (key == 27) {
            this.stopEditing();
            return true;
        }
        if (key == 10) {
            try {
                int frame = Integer.parseInt(this.sedit.toString()) - 1;
                this.setFrameLevel(frame);
            }
            catch (NumberFormatException e1) {
                // empty catch block
            }
            this.stopEditing();
            return true;
        }
        if (key == 8 || key == 127) {
            int n = this.sedit.length();
            if (n == 0) {
                return false;
            }
            this.sedit.deleteCharAt(n - 1);
            return true;
        }
        if (k >= '\u001f' && k <= '\u00ff') {
            this.sedit.append(k);
            return true;
        }
        return false;
    }

    protected int mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int m = this.getLogo(x, y);
        if (this.mouseMove != NOTHING && m == NOTHING) {
            m = SHOULD_REPAINT;
        }
        this.mouseMove = m;
        if (m != NOTHING && m != SHOULD_REPAINT) {
            String s = "Blink control: " + HELP[this.mouseMove] + (this.aladin.view.isMultiView() ? " (with SHIFT for synchronizing)" : "");
            this.aladin.status.setText(s);
        }
        if (m != NOTHING) {
            Aladin.makeCursor(this.aladin, m == SHOULD_REPAINT ? 0 : 2);
        }
        Util.toolTip(this.v, m == IN || m == SHOULD_REPAINT || m == NOTHING ? "" : HELP[this.mouseMove]);
        return m;
    }

    protected int mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        boolean flagEdit = false;
        int m = this.getLogo(x, y);
        if (m == PLUS) {
            this.mode = PLAY;
            this.decreaseDelay();
        } else if (m == MOINS) {
            this.mode = PLAY;
            this.increaseDelay();
        } else if (m == PAUSE || m == PLAY) {
            this.setMode(m);
        } else if (m == REWIND) {
            this.mode = PAUSE;
            this.transparency = -1.0;
            this.askStep(-1);
        } else if (m == FORWARD) {
            this.mode = PAUSE;
            this.transparency = -1.0;
            this.askStep(1);
        } else if (m == EDIT) {
            this.sedit = new StringBuilder(Util.align3(this.lastFrame + 1));
            this.setMode(PAUSE);
            flagEdit = true;
        } else if (m == SLIDE) {
            this.aladin.view.setCubeFrame(this.v, this.getFrameLevel(x), e.isShiftDown());
            this.aladin.view.repaintAll();
        }
        if (!flagEdit) {
            this.stopEditing();
        }
        return m;
    }

    protected void mouseDragged(MouseEvent e) {
        int x = e.getX();
        this.aladin.view.setCubeFrame(this.v, this.getFrameLevel(x), e.isShiftDown());
        this.aladin.view.repaintAll();
    }

    protected boolean mouseWheelMoved(MouseWheelEvent e) {
        int y;
        int x = e.getX();
        int m = this.getLogo(x, y = e.getY());
        if (m != SLIDE) {
            return false;
        }
        this.mode = PAUSE;
        this.transparency = -1.0;
        this.askStep(-e.getWheelRotation());
        this.aladin.calque.repaintAll();
        return true;
    }

    protected double getFrameLevel(int x) {
        double dx = x - this.X;
        if (dx < 0.0) {
            return 0.0;
        }
        if (dx > (double)this.getWidth()) {
            return this.nbFrame - 1;
        }
        double frameLevel = (double)(this.nbFrame - 1) * (dx / (double)this.getWidth());
        if (this.nbFrame >= 11) {
            frameLevel = (int)frameLevel;
        }
        if (frameLevel >= (double)this.nbFrame) {
            frameLevel = this.nbFrame - 1;
        }
        return frameLevel;
    }

    protected int getCurrentFrameIndex() {
        int n;
        if (this.delay == 0 || this.nbFrame <= 0) {
            return this.lastFrame;
        }
        int m = -1;
        int step = this.getNextFrameInfo();
        if (step == 2) {
            long now = System.currentTimeMillis();
            n = this.p instanceof PlanImageBlink ? (int)((now - this.startTime) / (long)this.delay % (long)this.nbFrame) : (now - this.startTime < (long)this.delay ? this.lastFrame : ((m = ((PlanBGCube)this.p).getCurrentFrameReady()) != -1 && this.lastFrame + 1 > m ? this.lastFrame : this.lastFrame + 1));
        } else {
            n = this.lastFrame + step;
        }
        if (n >= this.nbFrame) {
            n = 0;
        } else if (n < 0) {
            n = this.nbFrame - 1;
        }
        this.lastFrame = n;
        return n;
    }

    protected double getTransparency() {
        return this.transparency;
    }

    protected void syncBlink(CubeControl b) {
        this.startTime = b.startTime;
        this.lastFrame = b.lastFrame;
        this.delay = b.delay;
        this.mode = b.mode;
        this.p.changeImgID();
    }

    protected void setFrameLevel(double frameLevel) {
        this.setFrameLevel(frameLevel, true);
    }

    protected void setFrameLevel(double frameLevel, boolean pause) {
        if (frameLevel >= (double)this.nbFrame || frameLevel < 0.0) {
            return;
        }
        int frame = (int)frameLevel;
        this.transparency = (double)frame == frameLevel || this.v.pref instanceof PlanBG ? -1.0 : frameLevel - (double)frame;
        this.p.changeImgID();
        long timeRef = System.currentTimeMillis();
        if (this.p instanceof PlanImageBlink) {
            this.startTime = timeRef - (long)(frame * this.delay);
            this.lastFrame = (int)((timeRef - this.startTime) / (long)this.delay);
            if (this.nbFrame != 0) {
                this.lastFrame = (int)((timeRef - this.startTime) / (long)this.delay % (long)this.nbFrame);
            }
        } else {
            this.startTime = timeRef;
            this.lastFrame = (int)frameLevel;
        }
        this.p.setCubeFrame(frameLevel);
        if (pause) {
            this.setMode(PAUSE);
        }
    }

    protected void setTransparency(double t) {
        this.transparency = t;
    }

    protected void resume() {
        long now = System.currentTimeMillis();
        this.startTime = this.p instanceof PlanImageBlink ? now - (long)(this.lastFrame * this.delay) : now;
        this.transparency = -1.0;
    }

    protected void increaseDelay() {
        int max = FrameBlink.getMaxDelay();
        if (this.delay >= max) {
            return;
        }
        this.delay *= 2;
        if (this.delay > max) {
            this.delay = max;
        }
        this.aladin.status.setText("New blink delay: " + this.delay + "ms");
    }

    protected void decreaseDelay() {
        int min = FrameBlink.getMinDelay();
        if (this.delay <= min) {
            return;
        }
        this.delay /= 2;
        if (this.delay < min) {
            this.delay = min;
        }
        this.aladin.status.setText("New blink delay: " + this.delay + "ms");
    }

    protected void setMode(int m) {
        if (!this.p.isCube()) {
            return;
        }
        if (m == PLAY) {
            this.p.setPause(false, this.v);
            this.mode = PLAY;
            this.resume();
            this.askStep(2);
            this.aladin.view.startTimer();
        } else if (m == PAUSE) {
            this.p.setPause(true, this.v);
            this.mode = PAUSE;
            this.askStep(0);
        }
    }

    private synchronized void askStep(int s) {
        this.step = s;
    }

    protected int getNextFrameInfo() {
        int n = 2;
        if (this.mode == PAUSE) {
            n = this.step;
            this.askStep(0);
        }
        return n;
    }

    protected void draw(Graphics g, int x, int y, int size, int frame, int nbFrame) {
        int i;
        this.X = x;
        this.Y = y;
        if (size != this.SIZE) {
            this.init(size);
        }
        this.nbFrame = nbFrame;
        double frameLevel = frame;
        if (this.transparency != -1.0 && this.transparency != 0.0) {
            frameLevel += this.transparency;
        }
        int pos = nbFrame > 1 ? (int)((double)this.getWidth() * frameLevel / (double)(nbFrame - 1)) : 0;
        this.posX[0] = this.posX[4] = (pos -= 2);
        this.posX[1] = this.posX[2] = pos + size / 2;
        this.posX[3] = pos + size / 4;
        g.setColor(this.mouseMove == EDIT ? Aladin.GREEN : Color.red);
        g.setFont(Aladin.SPLAIN);
        this.edit[0] = x + this.labelX;
        this.edit[1] = y + this.labelY;
        g.drawString(Util.align3(frame + 1), this.edit[0], this.edit[1]);
        g.setColor(Color.red);
        if (this.transparency != -1.0) {
            g.drawString(Util.align2((int)((1.0 - this.transparency) * 100.0)) + "%", x + this.labelPX, y + this.labelPY);
        } else {
            g.drawString("/  " + Util.align3(nbFrame), x + this.labelPX, y + this.labelPY);
        }
        if (nbFrame < 11) {
            for (i = 0; i < nbFrame; ++i) {
                int shift = (int)(0.5 + (double)(i * this.getWidth()) / ((double)nbFrame - 1.0));
                g.drawLine(this.sliderX[0] + x + shift, this.sliderY[0] + y - 2, this.sliderX[0] + x + shift, this.sliderY[2] + y + 3);
            }
        }
        for (i = 0; i < this.shapeX.length; ++i) {
            Polygon p = Tool.setPolygon(this.shapeX[i], this.shapeY[i], x, y);
            if (this.mouseMove == PAUSE && (i == 0 || i == 1) && this.mode == PLAY || this.mouseMove == PLAY && (i == 2 || i == 3) && this.mode == PAUSE || this.mouseMove == REWIND && i == 4 || this.mouseMove == FORWARD && i == 5 || this.mouseMove == PLUS && (i == 6 || i == 7) || this.mouseMove == MOINS && i == 9 || this.mouseMove == SLIDE && i == 11) {
                g.setColor(Aladin.GREEN);
            } else if ((i == 0 || i == 1) && this.mode == PAUSE || (i == 2 || i == 3) && this.mode == PLAY) {
                g.setColor(Color.blue);
            } else {
                g.setColor(Color.red);
            }
            if (i != CURSOR || this.transparency == -1.0) {
                g.fillPolygon(p);
            }
            g.drawPolygon(p);
        }
        if (this.isEditing()) {
            this.drawEdit(g);
        }
    }

    private void drawEdit(Graphics g) {
        boolean blink;
        String s = this.sedit.toString();
        Font ft = g.getFont();
        g.setFont(ft.deriveFont(1));
        int w = g.getFontMetrics().stringWidth(s);
        int h = g.getFontMetrics().getHeight();
        int x = this.edit[0];
        int y = this.edit[1] - h + 2;
        Util.drawCartouche(g, x, y, w, h, 1.0f, Color.black, Color.white);
        g.setColor(Color.black);
        g.drawString(s, x, y + h / 2 + 5);
        g.setFont(ft);
        x = x + w - 1;
        boolean bl = blink = System.currentTimeMillis() / 500L % 2L == 0L;
        if (blink) {
            g.setColor(Color.black);
            g.drawLine(x, y + 2, x, y + h - 2);
            g.drawLine(x + 1, y + 2, x + 1, y + h - 2);
        }
    }
}

