/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.astro.Astrocoo;
import cds.astro.Coo;
import cds.tools.Util;

public final class Coord {
    public double al;
    public double del;
    public double x;
    protected double dx;
    public double y;
    protected double dy;
    protected double xstand;
    protected double ystand;
    static Astrocoo coo = new Astrocoo();

    public Coord() {
    }

    public Coord(double ra, double dej) {
        this.al = ra;
        this.del = dej;
        coo.set(this.al, this.del);
    }

    public Coord(String sexa) throws Exception {
        coo.set(sexa);
        this.al = coo.getLon();
        this.del = coo.getLat();
    }

    public boolean equals(Coord c) {
        if (c == null) {
            return false;
        }
        return this.al == c.al && this.del == c.del;
    }

    public static String getSexa(double al, double del) {
        return Coord.getSexa(al, del, "s");
    }

    public static String getSexa(double al, double del, String c) {
        Astrocoo coo = new Astrocoo();
        coo.set(al, del);
        coo.setPrecision(6);
        try {
            String o = "2s" + (!c.equals(" ") ? c : "");
            return coo.toString(o);
        }
        catch (Exception e) {
            System.err.println(e);
            return "";
        }
    }

    public String getSexa() {
        return this.getSexa("");
    }

    public String getSexa(String c) {
        return Coord.getSexa(this.al, this.del, c);
    }

    public String toString() {
        return this.getSexa();
    }

    public String getRA() {
        return this.getRA(':');
    }

    public String getRA(char sep) {
        try {
            String s = this.getSexa(sep + "");
            int i = s.indexOf(43);
            if (i == -1) {
                i = s.indexOf(45);
            }
            return s.substring(0, i - 1);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getDE() {
        return this.getDE(':');
    }

    public String getDE(char sep) {
        try {
            String s = this.getSexa(sep + "");
            int i = s.indexOf(43);
            if (i == -1) {
                i = s.indexOf(45);
            }
            return s.substring(i);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getUnit(double x) {
        return Coord.getUnit(x, false, false);
    }

    public static String getUnit(double x, boolean entier, boolean flagSurface) {
        double fct1;
        if (x == 0.0) {
            return "";
        }
        String s = null;
        double fct = flagSurface ? 3600.0 : 60.0;
        double d = fct1 = flagSurface ? 100000.0 : 1000.0;
        if (Math.abs(x) >= 1.0) {
            s = "\u00b0";
        }
        if (Math.abs(x) < 1.0) {
            s = "'";
            x *= fct;
        }
        if (Math.abs(x) < 1.0) {
            s = "\"";
            x *= fct;
        }
        if (Math.abs(x) < 1.0) {
            s = "mas";
            x *= fct1;
        }
        if (Math.abs(x) < 1.0) {
            s = "\u00b5as";
            x *= fct1;
        }
        if (entier && (int)x != 0) {
            return (int)x + s;
        }
        s = Util.myRound(x) + s;
        return s;
    }

    public static String getUnitTime(double x) {
        String s = null;
        if (x >= 1.0) {
            s = "h";
        }
        if (x < 1.0) {
            s = "min";
            x *= 60.0;
        }
        if (x < 1.0) {
            s = "s";
            x *= 60.0;
        }
        x = (double)((int)(x * 100.0)) / 100.0;
        s = x + " " + s;
        return s;
    }

    public static double getDist(Coord c1, Coord c2) {
        return Coo.distance(c1.al, c1.del, c2.al, c2.del);
    }
}

