/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.ActionExecutor;
import cds.aladin.Aladin;
import cds.aladin.AladinData;
import cds.aladin.AladinException;
import cds.aladin.Arc;
import cds.aladin.Box;
import cds.aladin.CDSXMatch;
import cds.aladin.Calib;
import cds.aladin.Calque;
import cds.aladin.Cercle;
import cds.aladin.ColumnCalculator;
import cds.aladin.CommandDS9;
import cds.aladin.Configuration;
import cds.aladin.ContourPlot;
import cds.aladin.Coord;
import cds.aladin.Cote;
import cds.aladin.Ellipse;
import cds.aladin.FilterProperties;
import cds.aladin.FrameColumnCalculator;
import cds.aladin.FrameContour;
import cds.aladin.Function;
import cds.aladin.Glu;
import cds.aladin.Ligne;
import cds.aladin.Localisation;
import cds.aladin.MacroModel;
import cds.aladin.MyByteArrayStream;
import cds.aladin.MyInputStream;
import cds.aladin.MyRobot;
import cds.aladin.Obj;
import cds.aladin.Pickle;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanField;
import cds.aladin.PlanFilter;
import cds.aladin.PlanFolder;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageBlink;
import cds.aladin.PlanMoc;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.Repere;
import cds.aladin.Save;
import cds.aladin.Server;
import cds.aladin.Source;
import cds.aladin.Synchro;
import cds.aladin.Tag;
import cds.aladin.Tok;
import cds.aladin.Vecteur;
import cds.aladin.View;
import cds.aladin.ViewSimple;
import cds.allsky.HipsGen;
import cds.astro.Astrocoo;
import cds.astro.Unit;
import cds.savot.model.SavotField;
import cds.tools.Computer;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import cds.xml.Field;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public final class Command
implements Runnable {
    static final long TIMEOUT = 15L;
    static long timeout = 900000L;
    static int DRAWXY = 0;
    static int DRAWRADEC;
    static int drawMode;
    Aladin a;
    Calque c;
    private CommandDS9 ds9;
    private boolean stop;
    private String lastCmd = "";
    protected Synchro syncSave = new Synchro();
    private Thread thread;
    JFrame robotInfo;
    String curTuto;
    JTextArea infoTxt;
    HashMap<String, String> var = new HashMap(100);
    MyRobot robot;
    public boolean robotMode = false;
    boolean filterMode = false;
    StringBuffer filterDef = null;
    PlanImage planRGBRef;
    static final String execHelp = "\n#PLANE:#                              #VIEW:#\n   @get servers [target] [radius]      @mview [1|2|4|9|16] [n]\n   @load filename                      @cview [-plot] [[x] v]\n   @select x1 [x2..]                   @select v1 [v2..]\n   @set [x1] [x2..] prop=value         @zoom ...\n   @hide|@show [x1] [x2..]              @northup|@unnorthup [v1] [v2..]\n   @mv|@copy x1 x2                      @thumbnail [radius]\n   @rm [x1] [x2..] | -all              @lock|@unlock [v1] [v2..]\n   @export [-fmt] x filename           @match [-scale] [v|x|off]\n                                      @mv|@copy v1 v2\n#IMAGE:#                                @rm [v1] [v2..] | -lock\n   @cm [x1|v1...] [colorMap...]        @save [-fmt] [-lk] [WxH] [filename]\n   @RGB|@RGBdiff [x1|v1...]             @coord|@object\n   @blink|@mosaic [x1] [x2...]\n   @+ | @- | @* | @/ ...                #CATALOG:#\n   @norm [-cut] [x]                    @filter ...\n   @conv [x] ...                       @addcol ...\n   @kernel ...                         @xmatch x1 x2 [dist] ...\n   @resamp x1 x2 ...                   @cplane [name]\n   @crop [x|v] [[X,Y] WxH]             @search {expr|+|-}\n   @flipflop [x|v] [V|H]               @tag|@untag\n   @contour [nn] [nosmooth] [zoom]     @select -tag\n   @grey|@bitpix [-cut] [x] BITPIX\n  \n#GRAPHIC# #TOOL:#                       #FOLDER:#\n   @draw [color] fct(param)            @md [-localscope] [name]\n   @grid [on|off]                      @mv|@rm [name]\n   @reticle [on|off]                   @collapse|@expand [name]\n   @overlay [on|off]                   @show|@hide [name]\n \n#MISCELLANEOUS:#\n   @backup filename     @status       @sync       @demo [on|off|end]  @pause [nn]\n   @help ...            @trace        @mem        @info msg\n   @macro script param  @call fct     @list [fct] @reset\n   @setconf prop=value  @function ... @= ...      @convert      @quit   ";
    static final String[] CMD;
    private static final String[] NOSYNCCMD;
    private InputStream stream = System.in;
    Stack<InputStream> stackStream = new Stack();
    private boolean sleepFlag = false;
    int X = 0;
    protected boolean syncNeedRepaint = false;
    protected boolean syncNeedSesame = false;
    private boolean killSync = false;
    private boolean inSync = false;
    protected static final int SYNCOFF = 0;
    protected static final int SYNCON = 1;
    protected int syncMode = 1;
    static String[] UNIT;
    private static final String OP = "+-*/";
    protected HipsGen hipsgen = null;
    private static final String OTHERS = "+-*/";
    private boolean flagFoV = false;
    private Color globalColor = null;
    private Plan oPlan = null;
    StringBuffer comment = null;
    Function fonct = null;
    private static final int STICKVIEW = 0;
    private static final int UNSTICKVIEW = 1;
    private static final int LOCKVIEW = 2;
    private static final int UNLOCKVIEW = 3;
    private static final int NORTHUP = 4;
    private static final int UNNORTHUP = 5;
    private ArrayList<Function> function = new ArrayList();
    private boolean functionLocalDefinition = false;
    private boolean functionModif = false;
    private String TEST = "info Aladin test script in progress...;reset;setconf frame=ICRS;setconf timeout=1;mview 4;get ESO(dss1,25,25),Aladin(DSS2) M1;get skyview(Surveys=2MASS,400,Sin) m1;cview DSS* A1;cview Sk* B1;cview ESO* A2;set ESO* planeID=ESO.DSS1;cm A2 noreverse 2200..13000 log;mv A2 B2;mv B1 A2;mv B2 B1;select Sk*;contour;select DSS*;contour;select Sk*;draw mode(radec);draw tag(05:34:30.87,+22:01:02.1,\"Crab nebulae\",50,-30,circle,14);set Draw* color=yellow;draw mode(xy);draw phot(63 57 15);get LEDA M1;hide Contours;select ESO*;zoom 1x;backup back.aj;reset;pause 2;load back.aj;RGB = RGB ESO* DSS*;zoom 1x;rm DSS*;rm Contours~1;show Contours;Gauss = conv Skw* gauss(fwhm=10\",radius=12);Gauss1 = Gauss;set Gauss1 FITS:CRPIX1=203;Gauss = Gauss / Gauss1;rm Gauss1;setconf frame=Gal;184.57316 -05.83741;flipflop Gauss V;Crop = crop Gauss 100x100;rm Gauss;rm A2;Cube=blink Sk* Crop ESO*;rm Sk*;PR=get Press;set PR opacity=65;rm A2;pause 2;get Simbad M1 14';call NED(M1,\"10'\");get Vizier(USNO);md Fold;mv RGB Fold;sync;mv I/284 Fold;filter Magn {;$[phot.mag*]<15 {draw rainbow(${Imag}) fillcircle(-$[phot.mag*]) };};mv Magn Fold;set Fold scope=local;rm USNO;XMatch = xmatch Simbad NED 45;addcol XMatch,B-V,${B_tab1}-${V_tab1};select XMatch;search -B-V=\"\";tag;cplane B-V;rm XMatch;get Fov(HST);mv HST Fold;export Simbad Cat.xml;export NED Cat1.tsv;export Crop Img.jpg;rm Simbad NED Crop;load Img.jpg;grey Img.jpg;rm A2;load Cat.xml;load Cat1.tsv;mv Img.jpg Fold;mv Cat.xml Fold;mv Cat1.tsv Fold;set Img.jpg opacity=20;collapse Fold;get hips(SHASSA);set proj=AITOFF;zoom 180\u00b0;rm B1;get hips(Mellinger);m1;zoom 15';rm B1;set Melling* opacity=30;get hips(\"Simbad density\");set proj=CARTESIAN;cm eosb reverse log;M1;zoom 30\u00b0;set opacity=30;rm B1;cview -plot I/284(Imag,R2mag) B1;sync;select B-V;grid on;setconf overlays=-label;info The end !;";

    private String execHelp() {
        if (Aladin.levelTrace > 0) {
            return "\n#PLANE:#                              #VIEW:#\n   @get servers [target] [radius]      @mview [1|2|4|9|16] [n]\n   @load filename                      @cview [-plot] [[x] v]\n   @select x1 [x2..]                   @select v1 [v2..]\n   @set [x1] [x2..] prop=value         @zoom ...\n   @hide|@show [x1] [x2..]              @northup|@unnorthup [v1] [v2..]\n   @mv|@copy x1 x2                      @thumbnail [radius]\n   @rm [x1] [x2..] | -all              @lock|@unlock [v1] [v2..]\n   @export [-fmt] x filename           @match [-scale] [v|x|off]\n                                      @mv|@copy v1 v2\n#IMAGE:#                                @rm [v1] [v2..] | -lock\n   @cm [x1|v1...] [colorMap...]        @save [-fmt] [-lk] [WxH] [filename]\n   @RGB|@RGBdiff [x1|v1...]             @coord|@object\n   @blink|@mosaic [x1] [x2...]\n   @+ | @- | @* | @/ ...                #CATALOG:#\n   @norm [-cut] [x]                    @filter ...\n   @conv [x] ...                       @addcol ...\n   @kernel ...                         @xmatch x1 x2 [dist] ...\n   @resamp x1 x2 ...                   @cplane [name]\n   @crop [x|v] [[X,Y] WxH]             @search {expr|+|-}\n   @flipflop [x|v] [V|H]               @tag|@untag\n   @contour [nn] [nosmooth] [zoom]     @select -tag\n   @grey|@bitpix [-cut] [x] BITPIX\n  \n#GRAPHIC# #TOOL:#                       #FOLDER:#\n   @draw [color] fct(param)            @md [-localscope] [name]\n   @grid [on|off]                      @mv|@rm [name]\n   @reticle [on|off]                   @collapse|@expand [name]\n   @overlay [on|off]                   @show|@hide [name]\n \n#MISCELLANEOUS:#\n   @backup filename     @status       @sync       @demo [on|off|end]  @pause [nn]\n   @help ...            @trace        @mem        @info msg\n   @macro script param  @call fct     @list [fct] @reset\n   @setconf prop=value  @function ... @= ...      @convert      @quit   @test ...\n";
        }
        return "\n#PLANE:#                              #VIEW:#\n   @get servers [target] [radius]      @mview [1|2|4|9|16] [n]\n   @load filename                      @cview [-plot] [[x] v]\n   @select x1 [x2..]                   @select v1 [v2..]\n   @set [x1] [x2..] prop=value         @zoom ...\n   @hide|@show [x1] [x2..]              @northup|@unnorthup [v1] [v2..]\n   @mv|@copy x1 x2                      @thumbnail [radius]\n   @rm [x1] [x2..] | -all              @lock|@unlock [v1] [v2..]\n   @export [-fmt] x filename           @match [-scale] [v|x|off]\n                                      @mv|@copy v1 v2\n#IMAGE:#                                @rm [v1] [v2..] | -lock\n   @cm [x1|v1...] [colorMap...]        @save [-fmt] [-lk] [WxH] [filename]\n   @RGB|@RGBdiff [x1|v1...]             @coord|@object\n   @blink|@mosaic [x1] [x2...]\n   @+ | @- | @* | @/ ...                #CATALOG:#\n   @norm [-cut] [x]                    @filter ...\n   @conv [x] ...                       @addcol ...\n   @kernel ...                         @xmatch x1 x2 [dist] ...\n   @resamp x1 x2 ...                   @cplane [name]\n   @crop [x|v] [[X,Y] WxH]             @search {expr|+|-}\n   @flipflop [x|v] [V|H]               @tag|@untag\n   @contour [nn] [nosmooth] [zoom]     @select -tag\n   @grey|@bitpix [-cut] [x] BITPIX\n  \n#GRAPHIC# #TOOL:#                       #FOLDER:#\n   @draw [color] fct(param)            @md [-localscope] [name]\n   @grid [on|off]                      @mv|@rm [name]\n   @reticle [on|off]                   @collapse|@expand [name]\n   @overlay [on|off]                   @show|@hide [name]\n \n#MISCELLANEOUS:#\n   @backup filename     @status       @sync       @demo [on|off|end]  @pause [nn]\n   @help ...            @trace        @mem        @info msg\n   @macro script param  @call fct     @list [fct] @reset\n   @setconf prop=value  @function ... @= ...      @convert      @quit   \n";
    }

    private boolean needSync(String cmd) {
        return Util.indexInArrayOf(cmd, NOSYNCCMD) == -1;
    }

    Command(Aladin aladin) {
        this.a = aladin;
        this.ds9 = new CommandDS9(aladin);
        this.testRobot();
        if (Aladin.ROBOTSUPPORT) {
            this.robot = new MyRobot(this.a);
            Aladin.trace(3, "Creating robot");
        }
    }

    protected void stop() {
        this.stop = true;
    }

    public void printConsole(String s) {
        this.print(s);
        this.console(s);
    }

    public void console(String s) {
        if (!s.startsWith("!!!")) {
            this.a.console.printInfo(s);
        } else {
            this.a.console.printError(s);
        }
    }

    public void println(String s) {
        this.print(s + "\n");
    }

    public void print(String s) {
        if (Aladin.NOGUI && !s.startsWith("!!!")) {
            return;
        }
        if (!Aladin.isApplet()) {
            System.out.print(s);
        }
    }

    protected void readStandardInput() {
        this.thread = new Thread((Runnable)this, "AladinReadStdin");
        Util.decreasePriority(Thread.currentThread(), this.thread);
        this.thread.start();
    }

    synchronized void setStream(InputStream in) {
        if (in == null) {
            if (this.stackStream.empty()) {
                in = System.in;
            } else {
                in = this.stackStream.pop();
                if (in == this.stream && in != System.in && !this.stackStream.empty()) {
                    in = this.stackStream.peek();
                }
            }
        } else {
            this.stackStream.push(in);
        }
        this.stream = in;
    }

    protected void readFromStream(InputStream in) {
        this.setStream(in);
    }

    @Override
    public void run() {
        this.a.waitDialog();
        this.scriptFromInputStream();
        Aladin.trace(2, "Command interpreter stopped !");
    }

    protected synchronized void readNow() {
        if (this.sleepFlag) {
            this.thread.interrupt();
        }
    }

    private synchronized void setFlagSleep(boolean flag) {
        this.sleepFlag = flag;
    }

    protected boolean hasCommand() {
        try {
            return this.stream != System.in && this.stream.available() > -1 || this.stream.available() > 0 || !this.isSyncServer();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private String readLine() {
        StringBuffer s = new StringBuffer();
        boolean encore = true;
        int b = 0;
        int acc = 0;
        do {
            block9: {
                if ((this.stream == null || this.stream == System.in) && this.a.console != null && this.a.console.hasWaitingCmd()) {
                    return this.a.console.popCmd();
                }
                try {
                    if (this.stream == null || this.stream == System.in && this.stream.available() == 0) {
                        this.setFlagSleep(true);
                        Util.pause(500);
                        this.setFlagSleep(false);
                    }
                    break block9;
                }
                catch (Exception e) {
                    this.stream = null;
                }
                continue;
            }
            try {
                b = this.stream.read();
            }
            catch (Exception e) {
                this.stream = null;
                continue;
            }
            if (this.stream != System.in && b == -1) {
                this.setStream(null);
                encore = false;
                continue;
            }
            s.append((char)b);
            if (b == 91) {
                ++acc;
                continue;
            }
            if (b != 93) continue;
            --acc;
        } while (encore && !this.stop && b != 10 && (b != 59 || acc != 0));
        return s.toString();
    }

    protected String getPrompt() {
        return this.filterMode ? "Filter> " : (this.fonct != null ? "Function> " : "Command> ");
    }

    protected boolean waitingMore() {
        return !this.filterMode && this.fonct == null;
    }

    protected void scriptFromInputStream() {
        boolean prompt;
        String s = null;
        boolean bl = prompt = this.stream == System.in;
        if (prompt) {
            this.print(this.getPrompt());
        }
        while (!this.stop) {
            try {
                if (this.robotMode) {
                    this.robotSync();
                }
                if ((s = this.readLine()) == null) {
                    return;
                }
                if (s.trim().length() != 0) {
                    this.execScript(s);
                }
                if (!prompt) continue;
                this.print(this.getPrompt());
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                this.println("!!! " + e);
                e.printStackTrace();
            }
        }
    }

    protected int getViewNumber(String vID) {
        return this.getViewNumber(vID, true);
    }

    protected int getViewNumber(String vID, boolean verbose) {
        int nview = this.a.view.getNViewFromID(vID);
        if (verbose && nview < 0) {
            this.printConsole("!!! Not a valid view identifier [ex: B2]");
            return -1;
        }
        if (nview >= this.a.view.getModeView()) {
            if (verbose) {
                this.printConsole("!!! View \"" + vID + "\" not visible " + nview);
            }
            return -1;
        }
        return nview;
    }

    protected String parseColumnIndex(String[] col, String s) {
        col[0] = "";
        col[1] = "";
        int offset = s.indexOf(40);
        int offset1 = s.lastIndexOf(44);
        if (offset == -1 || offset1 == -1 || s.charAt(s.length() - 1) != ')') {
            return s;
        }
        String plane = s.substring(0, offset);
        col[0] = s.substring(offset + 1, offset1);
        col[1] = s.substring(offset1 + 1, s.length() - 1);
        return plane;
    }

    protected Plan getNumber(String s) {
        return this.getNumber(s, 1);
    }

    protected Plan getNumber(String s, int methode) {
        return this.getNumber(s, methode, false, true);
    }

    protected Plan getNumber(String s, int methode, boolean atStrict, boolean verbose) {
        int n = 0;
        boolean at = s.length() > 1 && s.charAt(0) == '@';
        try {
            n = Integer.parseInt(atStrict ? s.substring(1) : (at ? s.substring(1) : s));
        }
        catch (Exception e) {
            // empty catch block
        }
        Plan[] allPlans = this.a.calque.getPlans();
        if (n < 1 || n > allPlans.length) {
            if (methode == 1 && !at) {
                n = this.a.calque.getIndexPlan(s);
                if (n < 0) {
                    if (verbose) {
                        this.printConsole("!!! Plane \"" + s + "\" not found !");
                    }
                    return null;
                }
                return allPlans[n];
            }
            if (verbose) {
                this.printConsole("!!! Plane number error (" + s + ")");
            }
            return null;
        }
        n = allPlans.length - n;
        if (allPlans[n].type == 0) {
            if (verbose) {
                this.printConsole("!!! Plane number " + s + " not assigned");
            }
            return null;
        }
        return allPlans[n];
    }

    private Plan getPlanFromParam(String s) {
        return this.getPlanFromParam(s, 0, false);
    }

    private Plan getPlanFromParam(String s, int method) {
        return this.getPlanFromParam(s, method, false);
    }

    private Plan getPlanFromParam(String s, int method, boolean atStrict) {
        ViewSimple vtmp;
        int nview;
        Plan p = null;
        if (method == 0 && (nview = this.getViewNumber(s, false)) >= 0 && !(vtmp = this.a.view.viewSimple[nview]).isFree()) {
            p = vtmp.pref;
        }
        if (p == null) {
            p = this.getNumber(s, 1, atStrict, false);
        }
        return p;
    }

    private PlanImage[] getPlanImage(String param) {
        Plan[] p = this.getPlan(param, 1);
        PlanImage[] pi = new PlanImage[p.length];
        System.arraycopy(p, 0, pi, 0, p.length);
        return pi;
    }

    protected Plan getFirstPlan(String planID) {
        Plan[] p;
        if (planID.indexOf(32) >= 0 && planID.indexOf(34) < 0) {
            planID = '\"' + planID + '\"';
        }
        if ((p = this.getPlan(planID)).length == 0) {
            return null;
        }
        return p[0];
    }

    protected Plan[] getPlan(String param) {
        return this.getPlan(param, 0);
    }

    protected Plan[] getPlan(String param, int method) {
        Vector<Plan> v = new Vector<Plan>();
        param = param.trim();
        Plan[] allPlan = this.a.calque.getPlans();
        if (param.length() == 0) {
            for (int i = 0; i < allPlan.length; ++i) {
                Plan p = allPlan[i];
                if (method == 1 && !p.isPixel() || !p.flagOk || !p.selected) continue;
                v.addElement(p);
            }
        } else {
            Tok st = new Tok(param);
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                Plan p = this.getPlanFromParam(s, method == 2 ? 1 : 0);
                if (p == null || method == 1 && !p.isPixel() || method == 3 && p.type != 11 || p == null || !p.flagOk && method != 4) continue;
                v.addElement(p);
            }
        }
        return v.toArray(new Plan[v.size()]);
    }

    protected boolean isSyncServer() {
        if (this.a.synchroServer.isReady()) {
            return true;
        }
        Aladin.trace(4, "Command.isSyncServer() : waiting server...\n==> " + this.a.synchroServer);
        return false;
    }

    protected boolean isSyncPlugin() {
        if (this.a.plugins == null) {
            return true;
        }
        boolean rep = this.a.plugins.isSync();
        if (!rep) {
            Aladin.trace(4, "Command.isSyncPlugin() : waiting a plugin...\n");
        }
        return rep;
    }

    protected boolean isSyncPlan() {
        if (this.a.synchroPlan.isReady()) {
            return true;
        }
        Aladin.trace(4, "Command.isSyncPlan() : waiting plane...\n==> " + this.a.synchroPlan);
        return false;
    }

    protected boolean isSyncSave() {
        if (this.syncSave.isReady()) {
            return true;
        }
        Aladin.trace(4, "Command.isSyncSave() : waiting save process...\n==> " + this.syncSave);
        return false;
    }

    protected boolean isSync() {
        if (this.a.dialog == null || this.a.calque == null) {
            Aladin.trace(4, "Command.isSync() : waiting (Aladin.dialog not ready)...");
            return false;
        }
        if (this.syncNeedSesame && this.a.view.isSesameInProgress()) {
            Aladin.trace(4, "Command.isSync() : waiting sesame...\n==> " + this.a.view.sesameSynchro);
            return false;
        }
        this.syncNeedSesame = false;
        if (this.syncNeedRepaint) {
            Aladin.trace(4, "Command.isSync() : waiting viewSimple.paintComponent()...");
            this.a.view.repaintAll();
            return false;
        }
        if (!this.isSyncServer()) {
            return false;
        }
        if (!this.isSyncPlan()) {
            return false;
        }
        if (!this.isSyncPlugin()) {
            return false;
        }
        if (!this.isSyncSave()) {
            return false;
        }
        Plan[] plan = this.a.calque.getPlans();
        for (int i = plan.length - 1; i >= 0; --i) {
            if (plan[i].type == 0 || plan[i].isSync()) continue;
            Aladin.trace(4, "Command.isSync() : waiting plane \"" + plan[i] + "\"...");
            if (plan[i].label == null) {
                System.err.println("isSync label==null : type=" + plan[i].type + " state=" + plan[i].getDebugFlag());
            }
            return false;
        }
        return true;
    }

    protected void killSync() {
        if (!this.inSync) {
            return;
        }
        this.killSync = true;
    }

    protected void setSyncMode(int mode) {
        this.syncMode = mode;
    }

    public void sync() {
        this.inSync = true;
        if (this.robotMode) {
            this.robotSync();
            Util.pause(1000);
        }
        long d = System.currentTimeMillis();
        while (!this.isSync()) {
            if (this.killSync) {
                this.killSync = false;
                this.println("!!! Command sync has been killed !");
                this.inSync = false;
                return;
            }
            if (timeout > 0L && System.currentTimeMillis() - d > timeout) {
                this.println("!!! Time out error (" + timeout / 60000L + " minutes).");
                this.inSync = false;
                return;
            }
            Util.pause(100);
        }
        this.inSync = false;
    }

    private void syncServer() {
        try {
            this.a.synchroServer.waitUntil(timeout);
        }
        catch (Exception e) {
            this.println("!!! Time out error (" + timeout / 60000L + " minutes).");
        }
    }

    private void testRobot() {
        try {
            Class<?> x = Class.forName("java.awt.Robot");
            Constructor<?> cons = x.getConstructor(new Class[0]);
            cons.newInstance(new Object[0]);
            Aladin.trace(3, "Robot supported");
            Aladin.ROBOTSUPPORT = true;
        }
        catch (Exception e) {
            Aladin.trace(3, "Robot NOT supported");
            Aladin.ROBOTSUPPORT = false;
        }
    }

    private void robotSync() {
        long d = System.currentTimeMillis();
        while (!ActionExecutor.ready || ActionExecutor.interruptAction) {
            if (timeout > 0L && System.currentTimeMillis() - d > timeout) {
                this.println("!!! Time out error (" + timeout / 60000L + " minutes).");
                return;
            }
            Util.pause(500);
        }
        Util.pause(1000);
    }

    private String execStatusCmd(String param) {
        String status = this.getStatus(param);
        this.println(status);
        return status;
    }

    protected String getStatus(String param) {
        StringBuffer res = new StringBuffer();
        Plan[] p = param == null || param.equals("") || param.equals("*") || param.equals("stack") ? this.a.calque.getPlans() : this.getPlan(param, 2);
        for (int i = 0; i < p.length; ++i) {
            Plan plan = p[i];
            if (plan.type == 0) continue;
            if (res.length() > 0) {
                res.append("\n");
            }
            res.append("PlaneID " + Tok.quote(plan.label) + "\n" + "PlaneNb " + (p.length - this.a.calque.getIndex(plan)) + "\n" + "Type    " + Plan.Tp[plan.type] + "\n" + (plan.verboseDescr != null ? "Info    " + plan.verboseDescr + "\n" : "") + (plan.ack != null ? "Ack     " + plan.ack + "\n" : "") + "Status  " + (plan.active ? "shown" : "hidden") + " " + (plan.selected ? "selected" : "") + (!plan.flagOk && plan.error != null ? " error" : "") + "\n" + (plan.u != null ? "Url     " + plan.getUrl() + "\n" : "") + (plan.co != null ? "Target  " + plan.getTarget() + "\n" : ""));
            if (plan.colorBackground != null) {
                res.append("Background " + (plan.colorBackground == Color.white ? "white" : "black") + "\n");
            }
            if (plan.type == 10) {
                res.append("Roll    " + ((PlanField)plan).getRoll() + "\n");
                res.append("Rollable " + ((PlanField)plan).isRollable() + "\n");
                res.append("Movable  " + ((PlanField)plan).isMovable() + "\n");
                String fov = ((PlanField)plan).getStatusSubFov();
                if (fov != null) {
                    res.append(fov);
                }
            } else if (plan.isCatalog()) {
                res.append("NbObj   " + plan.getCounts() + "\n");
                res.append("Shape   " + Source.getShape(plan.sourceType) + "\n");
                res.append("Filter  " + ((PlanCatalog)plan).getFilterDescription() + "\n");
                res.append("Color   " + Action.findColorName(plan.c) + "\n");
            } else if (plan.type == 9) {
                res.append("Color   " + Action.findColorName(plan.c) + "\n");
                res.append("Movable " + (plan.isMovable() ? "on" : "off") + "\n");
            } else if (plan.type == 1 || plan.type == 15) {
                res.append("Width   " + ((PlanImage)plan).naxis1 + "\n" + "Height  " + ((PlanImage)plan).naxis2 + "\n");
                if (plan.flagOk && plan.projd != null) {
                    String s = Coord.getUnit(plan.projd.c.GetResol()[0]);
                    res.append("PixelRes " + s);
                }
            } else if (plan.type == 11) {
                res.append("Scope   " + (((PlanFolder)plan).localScope ? "local" : "global") + "\n");
                String item = ((PlanFolder)plan).getStatusItems();
                if (item != null) {
                    res.append(item);
                }
            }
            if (plan instanceof PlanBG && plan.isPixel()) {
                res.append("PixelRes " + ((PlanBG)plan).getMaxResolution());
            }
            if (!this.a.calque.canBeTransparent(plan)) continue;
            res.append("Opacity " + Util.myRound(plan.getOpacityLevel() * 100.0f + "", 0) + "\n");
        }
        StringBuffer x = new StringBuffer();
        if (param == null || param.equals("") || param.equals("*") || param.equals("views")) {
            x = this.a.view.getStatus();
        } else {
            Tok tok = new Tok(param);
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken();
                int n = this.getViewNumber(s, false);
                if (n == -1 || this.a.view.viewSimple[n].isFree()) continue;
                x.append(this.a.view.viewSimple[n].getStatus() + "\n");
            }
        }
        if (x.length() > 0) {
            res.append("\n" + x);
        }
        return res.toString();
    }

    private boolean extractRadius(StringBuffer radius, StringBuffer tX, String t) {
        int j;
        int i;
        char[] a = t.toCharArray();
        for (i = a.length - 1; i > 0 && (a[i] < '0' || a[i] > '9'); --i) {
        }
        String unit = new String(a, i + 1, a.length - i - 1);
        for (j = 0; j < UNIT.length && !unit.equalsIgnoreCase(UNIT[j]); ++j) {
        }
        if (j == UNIT.length) {
            return false;
        }
        for (j = i; j > 0 && a[j] != ' '; --j) {
        }
        if (j == 0) {
            return false;
        }
        String s = new String(a, j + 1, a.length - j - 1);
        if (s.endsWith("'")) {
            s = s.substring(0, s.length() - 1) + "m";
        } else if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1) + "s";
        }
        radius.append("" + Server.getAngle(s, 1));
        tX.append(new String(a, 0, j));
        return true;
    }

    protected boolean isCommand(String c) {
        return Util.indexInArrayOf(c, CMD, true) >= 0;
    }

    private int findPosAlgebre(String cmd) {
        for (int i = 0; i < "+-*/".length(); ++i) {
            char op = "+-*/".charAt(i);
            int pos = -1;
            while ((pos = cmd.indexOf(op, pos + 1)) != -1) {
                boolean f1;
                boolean f2;
                double n1 = Double.NaN;
                double n2 = Double.NaN;
                String p2 = cmd.substring(pos + 1).trim();
                try {
                    n2 = Double.parseDouble(p2);
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean bl = f2 = this.getNumber(Tok.unQuote(p2), 1, true, false) != null;
                if (pos == 0 && (!Double.isNaN(n2) || f2)) {
                    return pos;
                }
                String p1 = cmd.substring(0, pos).trim();
                try {
                    n1 = Double.parseDouble(p1);
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean bl2 = f1 = this.getNumber(Tok.unQuote(p1), 1, true, false) != null;
                if (Double.isNaN(n1) && !f1 || Double.isNaN(n2) && !f2 || !Double.isNaN(n1) && !Double.isNaN(n2)) continue;
                return pos;
            }
        }
        return -1;
    }

    protected String getTargetPlane(StringBuffer targetPlane, String cmd) {
        int i;
        String name;
        int pos = cmd.indexOf(61);
        if (pos == 0) {
            return cmd;
        }
        String s = pos == -1 ? cmd : cmd.substring(pos + 1).trim();
        String string = name = pos == -1 ? "" : cmd.substring(0, pos).trim();
        if (name.indexOf(32) > 0 && name.charAt(0) != '\"' && name.charAt(0) != '\'') {
            return cmd;
        }
        if (this.findAlgebre(s) < 0 && (i = this.findPosAlgebre(s)) >= 0) {
            s = i == 0 ? s.charAt(i) + " " + s.substring(i + 1) : s.substring(0, i) + " " + s.charAt(i) + " " + s.substring(i + 1);
        }
        if (pos == -1) {
            return s;
        }
        String c = new Tok(s).nextToken();
        if (!this.isCommand(c) && this.findAlgebre(s) < 0 && this.getNumber(s, 1, false, false) == null) {
            return cmd;
        }
        targetPlane.append(Tok.unQuote(cmd.substring(0, pos).trim()));
        return s;
    }

    protected boolean splitGetCmd(StringBuffer servers, StringBuffer target, StringBuffer radius, String cmd, boolean withServer) {
        int i;
        int d;
        char[] b = cmd.toCharArray();
        if (withServer && (servers.indexOf("IVOA") >= 0 || cmd.indexOf("IVOA") >= 0) && !this.a.dialog.ivoaServersLoaded) {
            this.a.dialog.appendIVOAServer();
        }
        for (d = 0; d < b.length && b[d] == ' '; ++d) {
        }
        int inPar = 0;
        for (i = d; i < b.length; ++i) {
            if (inPar == 0) {
                if (b[i] == '(') {
                    ++inPar;
                    continue;
                }
                if (b[i] != ' ') continue;
                break;
            }
            if (b[i] != ')') continue;
            --inPar;
        }
        String s = new String(b, d, i - d);
        for (d = i; d < b.length && b[d] == ' '; ++d) {
        }
        String t = new String(b, d, b.length - d).trim();
        StringTokenizer st = new StringTokenizer(s, ",(");
        String server = st.nextToken();
        if (server.equalsIgnoreCase("allsky")) {
            server = "hips";
        }
        if (!withServer || this.a.dialog.getServer(server) < 0) {
            if (this.a.view.getCurrentView().isFree()) {
                t = cmd;
                if (Aladin.OUTREACH || this.a.isFullScreen()) {
                    s = "hips(\"P/DSS2/color\")";
                } else {
                    s = this.a.configuration.getServer();
                    String p = this.a.configuration.getSurvey();
                    if (p != null && p.trim().length() > 0) {
                        s = s + "(" + p + ")";
                    }
                }
                String rep = this.a.view.sesameResolve(cmd, true);
                if (rep == null) {
                    Aladin.warning(this.a.dialog.server[0].UNKNOWNOBJ);
                    return false;
                }
                t = rep;
                this.a.console.printCommand("get " + s + " " + cmd);
            } else {
                this.syncNeedRepaint = true;
                this.syncNeedSesame = true;
                if (this.execHpxCmd(cmd)) {
                    return false;
                }
                this.a.view.sesameResolve(cmd);
                this.a.dialog.setDefaultTarget(cmd);
                return false;
            }
        }
        servers.append(s);
        if (t.length() != 0) {
            StringBuffer tX = new StringBuffer();
            if (this.extractRadius(radius, tX, t)) {
                t = tX.toString();
                this.a.dialog.setDefaultTaille(radius.toString());
            }
            this.a.dialog.setDefaultTarget(t);
        }
        target.append(t);
        if (radius.length() == 0) {
            this.waitingPlanInProgress();
            radius.append(Server.getRM(this.a.dialog.getDefaultTaille()) + "'");
        }
        return true;
    }

    private void waitingPlanInProgress() {
    }

    protected int getServerInfo(StringBuffer server, StringBuffer criteria, char[] a, int i) {
        int d = i;
        int inPar = 0;
        while (i < a.length) {
            if (inPar == 0) {
                if (a[i] == '(') {
                    ++inPar;
                    server.append(new String(a, d, i - d));
                    d = i + 1;
                } else if (a[i] == ',') {
                    break;
                }
            } else if (a[i] == ')') {
                --inPar;
                criteria.append(new String(a, d, i - d));
            }
            ++i;
        }
        if (server.length() == 0) {
            server.append(new String(a, d, i - d));
        }
        if (i < a.length && a[i] == ',') {
            ++i;
        }
        return i;
    }

    private boolean isTargetRequired(StringBuffer s) {
        char[] b = s.toString().toCharArray();
        StringBuffer serverX = new StringBuffer();
        StringBuffer criteriaX = new StringBuffer();
        int i = 0;
        i = this.getServerInfo(serverX, criteriaX, b, i);
        String server = serverX.toString().trim();
        return !(server.equalsIgnoreCase("Local") || server.equalsIgnoreCase("MyData") || server.equalsIgnoreCase("VizieRX") || server.equalsIgnoreCase("VizieR") && Util.indexOfIgnoreCase(criteriaX.toString(), "allsky") >= 0 || server.equalsIgnoreCase("allsky") || server.equalsIgnoreCase("hips") || server.equalsIgnoreCase("Aladin") && Util.indexOfIgnoreCase(criteriaX.toString(), "allsky") >= 0 || server.equalsIgnoreCase("File") || i != b.length);
    }

    protected String execGetCmd(String cmd, String label, boolean withServer) {
        StringBuffer targetX = new StringBuffer();
        StringBuffer radiusX = new StringBuffer();
        StringBuffer serversX = new StringBuffer();
        StringBuffer erreur = new StringBuffer();
        if (!this.splitGetCmd(serversX, targetX, radiusX, cmd, withServer)) {
            return null;
        }
        String target = this.a.localisation.getICRSCoord(targetX.toString().trim());
        String radius = radiusX.toString();
        if (this.isTargetRequired(serversX)) {
            if (target.length() == 0) {
                if (this.syncMode == 1) {
                    this.sync();
                }
                target = this.a.dialog.getDefaultTargetJ2000();
            }
            if (target.length() == 0) {
                Aladin.warning(Aladin.chaine.getString("WNEEDOBJ"), 1);
                return null;
            }
            this.a.dialog.setDefaultTarget(target);
            if (View.notCoord(target)) {
                int csr = 1;
                Aladin.makeCursor(this.a, csr);
                Coord coo = null;
                try {
                    coo = this.a.view.sesame(target);
                    csr = 0;
                    Aladin.makeCursor(this.a, csr);
                    if (coo == null) {
                        Aladin.warning("\"" + target + "\": " + Aladin.chaine.getString("OBJUNKNOWN"), 1);
                    }
                }
                catch (Exception e) {
                    Aladin.warning(e.getMessage(), 1);
                }
                if (coo == null) {
                    return null;
                }
            }
        }
        char[] b = serversX.toString().toCharArray();
        int i = 0;
        do {
            int j;
            StringBuffer serverX = new StringBuffer();
            StringBuffer criteriaX = new StringBuffer();
            i = this.getServerInfo(serverX, criteriaX, b, i);
            String server = serverX.toString();
            if (server.equalsIgnoreCase("allsky")) {
                server = "hips";
            }
            String criteria = criteriaX.toString();
            Aladin.trace(4, "Command.execGetCmd(" + cmd + "," + label + ") => server=[" + server + "] criteria=[" + criteria + "] target=[" + target + "] radius=[" + radius + "])");
            if (server.equalsIgnoreCase("VizierX")) {
                server = "VizieR";
            }
            if ((j = this.a.dialog.getServer(server)) >= 0) {
                this.a.dialog.server[j].flagToFront = false;
                int n = this.a.dialog.server[j].createPlane(target, radius, criteria, label, this.a.dialog.server[j].institute);
                if (n != -1) {
                    this.a.calque.getPlan(n).setBookmarkCode("get " + server + (criteria.length() > 0 ? "(" + criteria + ")" : "") + " $TARGET $RADIUS");
                }
                if (!this.a.isFullScreen()) continue;
                this.a.fullScreen.repaint();
                continue;
            }
            if (erreur.length() > 0) {
                erreur.append(", ");
            }
            erreur.append(server);
        } while (i < b.length);
        if (erreur.length() > 0) {
            if (!Aladin.NETWORK) {
                Aladin.warning("No network for: " + erreur, 1);
            } else {
                Aladin.warning(Aladin.chaine.getString("WERROR") + " " + erreur, 1);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execMacro(String param) {
        MyInputStream scriptStream = null;
        MyInputStream paramStream = null;
        try {
            String s;
            Tok tok = new Tok(param);
            String scriptFile = this.a.getFullFileName(tok.nextToken());
            scriptStream = new MyInputStream(Util.openAnyStream(scriptFile)).startRead();
            Vector<String> v = new Vector<String>(100);
            while ((s = scriptStream.readLine()) != null) {
                String s1 = s.trim();
                v.addElement(s1);
            }
            Object[] cmd = v.toArray();
            MacroModel macro = new MacroModel(this.a);
            String paramFile = this.a.getFullFileName(tok.nextToken());
            paramStream = new MyInputStream(Util.openAnyStream(paramFile)).startRead();
            HashMap<String, String> params = new HashMap<String, String>();
            while ((s = paramStream.readLine()) != null) {
                int offset = -1;
                int deb = 0;
                int i = 1;
                while ((offset = s.indexOf(9, offset + 1)) != -1) {
                    String s1 = s.substring(deb, offset).trim();
                    params.put("$" + i, s1);
                    ++i;
                    deb = offset;
                }
                params.put("$" + i, s.substring(deb).trim());
                for (i = 0; i < cmd.length; ++i) {
                    macro.executeScript((String)cmd[i], params);
                }
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.warning("macro error !" + e.getMessage() + "\n", 1);
        }
        finally {
            if (scriptStream != null) {
                try {
                    scriptStream.close();
                }
                catch (Exception e) {}
            }
            if (paramStream != null) {
                try {
                    paramStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected String execSetconfCmd(String param) {
        int egaleOffset = param.lastIndexOf(61);
        if (egaleOffset == -1) {
            return null;
        }
        String propertie = param.substring(0, egaleOffset).trim();
        String value = param.substring(egaleOffset + 1).trim();
        Aladin.trace(4, "Command.execSetconfCmd(" + param + ") => prop=[" + propertie + "] value=[" + value + "])");
        if (propertie.equalsIgnoreCase("bookmarks")) {
            this.a.bookmarks.setBookmarkList(value);
            return "";
        }
        if (propertie.equalsIgnoreCase("timeout")) {
            int n = param.equals("off") ? 0 : Integer.parseInt(param);
            timeout = n * 60000;
            return "";
        }
        if (propertie.equalsIgnoreCase("overlays")) {
            this.a.calque.setOverlayList(value);
            this.a.calque.repaintAll();
            return "";
        }
        if (propertie.equalsIgnoreCase("gridcolor")) {
            Color c = Action.getColor(value);
            if (c == null) {
                return "!!! Unknown color";
            }
            this.a.view.gridColor = c;
            this.a.calque.repaintAll();
            return "";
        }
        if (propertie.equalsIgnoreCase("gridcolorRA")) {
            Color c = Action.getColor(value);
            if (c == null) {
                return "!!! Unknown color";
            }
            this.a.view.gridColorRA = c;
            this.a.calque.repaintAll();
            return "";
        }
        if (propertie.equalsIgnoreCase("gridFontSize")) {
            int n;
            boolean flagPlus = false;
            if (value.startsWith("+")) {
                flagPlus = true;
                value = value.substring(1);
            }
            try {
                n = Integer.parseInt(value);
            }
            catch (Exception e) {
                return "!!! gridFontSize syntax error";
            }
            this.a.view.gridFontSize = flagPlus || n < 0 ? (this.a.view.gridFontSize += n) : n;
            this.a.calque.repaintAll();
            return "";
        }
        if (propertie.equalsIgnoreCase("gridcolorDEC")) {
            Color c = Action.getColor(value);
            if (c == null) {
                return "!!! Unknown color";
            }
            this.a.view.gridColorDEC = c;
            this.a.calque.repaintAll();
            return "";
        }
        try {
            this.a.configuration.setconf(propertie, value);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.printConsole("!!! setconf error: " + e.getMessage());
            return e.getMessage();
        }
        if (propertie.equalsIgnoreCase("frame")) {
            if (Util.indexOfIgnoreCase(value, "XY") >= 0) {
                this.setDrawMode(DRAWXY);
            } else {
                this.setDrawMode(DRAWRADEC);
            }
        }
        return "";
    }

    protected String execSetCmd(String param) {
        int j;
        int i;
        int egaleOffset = param.lastIndexOf(61);
        if (egaleOffset == -1) {
            return null;
        }
        String value = param.substring(egaleOffset + 1).trim();
        char[] b = param.toCharArray();
        for (i = egaleOffset - 1; i > 0 && b[i] == ' '; --i) {
        }
        while (i > 0 && b[i] != ' ') {
            --i;
        }
        String propertie = param.substring(i, egaleOffset).trim();
        String specif = null;
        for (j = i; j > 0 && b[j] != '/'; --j) {
        }
        if (b[j] == '/') {
            if (b[i - 1] == '\"') {
                specif = param.substring(j + 1, i - 1);
                b[j] = 34;
                i = j + 1;
            } else {
                specif = param.substring(j + 1, i);
                i = j;
            }
        }
        String plans = new String(b, 0, i).trim();
        Aladin.trace(4, "Command.execSetCmd(" + param + ") =>plans=[" + plans + "] " + (specif != null ? "specif=[" + specif + "]" : "") + "prop=[" + propertie + "] value=[" + value + "]");
        Plan[] p = this.getPlan(plans, 2);
        if (specif != null && p.length > 1) {
            String s = "set error: only suppport one plane with \"/\" specification";
            this.printConsole("!!! set error: " + s);
            return s;
        }
        for (i = 0; i < p.length; ++i) {
            try {
                p[i].setPropertie(propertie, specif, value);
                continue;
            }
            catch (Exception e) {
                this.printConsole("!!! set error: " + e.getMessage());
                return e.getMessage();
            }
        }
        this.a.calque.repaintAll();
        return "";
    }

    protected String execCM(String param) {
        Plan p;
        boolean defaultPlan = true;
        Vector<Plan> v = new Vector<Plan>(10);
        String s = null;
        boolean ok = false;
        Tok tok = new Tok(param);
        while (tok.hasMoreTokens() && (p = this.getPlanFromParam(s = tok.nextToken())) != null) {
            if (!p.isPixel()) {
                defaultPlan = false;
                continue;
            }
            v.add(p);
        }
        if (v.size() == 0 && defaultPlan && (p = this.a.calque.getPlanBase()) != null) {
            v.add(p);
        }
        if (v.size() == 0) {
            return "No image plane";
        }
        StringBuffer par = new StringBuffer();
        while (s != null) {
            par.append(" " + s);
            if (tok.hasMoreTokens()) {
                s = tok.nextToken();
                continue;
            }
            s = null;
        }
        s = par.toString();
        if (s.length() == 0) {
            s = this.a.configuration.get(Configuration.CM);
            if (s == null) {
                s = "gray reverse autocut";
            }
            s = s + " all";
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            PlanImage pi = (PlanImage)e.nextElement();
            ok |= pi.setCmParam(s);
        }
        if (ok) {
            this.a.calque.repaintAll();
        }
        return "";
    }

    protected String removeLinks(String help) {
        if (help.indexOf(64) < 0) {
            return help;
        }
        StringBuffer s = new StringBuffer();
        char[] a = help.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == '@') continue;
            s.append(a[i]);
        }
        return s.toString();
    }

    private boolean isLetter(char c) {
        return Character.isLetterOrDigit(c) || "+-*/".indexOf(c) >= 0;
    }

    protected String translateLinks(String help) {
        StringBuffer s = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(help, " |\t\n\r\f", true);
        while (tok.hasMoreTokens()) {
            String w = tok.nextToken();
            if (w.startsWith("@")) {
                int offset;
                for (offset = 1; offset < w.length() && this.isLetter(w.charAt(offset)); ++offset) {
                }
                String w1 = w.substring(1, offset);
                String w2 = w.substring(offset, w.length());
                s.append("<A HREF=\"#" + w1 + "\">" + w1 + "</A>" + w2);
                continue;
            }
            if (w.startsWith("_") && w.endsWith("_")) {
                String w1 = w.substring(1, w.length() - 1);
                s.append("<B><FONT SIZE=\"+2\" COLOR=\"darkgreen\">" + w1 + "</FONT></B>");
                continue;
            }
            if (w.startsWith("#") && w.endsWith("#")) {
                String w1 = w.substring(1, w.length() - 1);
                s.append("<B>" + w1 + "</B>");
                continue;
            }
            if (w.startsWith("\\")) {
                String w1 = w.substring(1, w.length());
                s.append(w1);
                continue;
            }
            s.append(w);
        }
        return s.toString();
    }

    protected void execROICmd(String param) {
        try {
            if (param.length() == 0) {
                this.a.view.createROI();
            } else if (!Character.isDigit(param.charAt(param.length() - 1))) {
                double radius = Server.getRM(param.substring(0, param.length() - 1));
                this.a.view.createROI(radius / 60.0);
            } else {
                int pixels = Integer.parseInt(param);
                this.a.view.createROI(pixels);
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.printConsole("!!! thumbnail error: " + e.getMessage());
        }
    }

    protected String execXMatchCmd(String s, String label) {
        int k2;
        int k1;
        String tmp;
        String[] tokens = Util.split(s, " ", '(', ')');
        int nbTokens = tokens.length;
        int curIdx = 1;
        double dist = -1.0;
        int mode = 1;
        Plan pCat1 = null;
        Plan pCat2 = null;
        String p2Cols = null;
        String p1Cols = null;
        if (curIdx < nbTokens) {
            tmp = tokens[curIdx++];
            k1 = tmp.indexOf(40);
            k2 = tmp.lastIndexOf(41);
            if (k1 >= 0 && k2 >= 0) {
                p1Cols = tmp.substring(k1 + 1, k2);
                pCat1 = this.getNumber(tmp.substring(0, k1));
            } else {
                pCat1 = this.getNumber(tmp);
            }
        }
        if (curIdx < nbTokens) {
            tmp = tokens[curIdx++];
            k1 = tmp.indexOf(40);
            k2 = tmp.lastIndexOf(41);
            if (k1 >= 0 && k2 >= 0) {
                p2Cols = tmp.substring(k1 + 1, k2);
                pCat2 = this.getNumber(tmp.substring(0, k1));
            } else {
                pCat2 = this.getNumber(tmp);
            }
        }
        if (curIdx < nbTokens) {
            try {
                dist = Double.valueOf(tokens[curIdx++]);
            }
            catch (NumberFormatException e) {
                dist = -1.0;
            }
        } else {
            dist = 4.0;
        }
        if (curIdx < nbTokens) {
            String modeStr;
            if ((modeStr = tokens[curIdx++]).equalsIgnoreCase("allmatch")) {
                mode = 2;
            } else if (modeStr.equalsIgnoreCase("bestmatch")) {
                mode = 1;
            } else if (modeStr.equalsIgnoreCase("nomatch")) {
                mode = 4;
            } else {
                this.printConsole("!!! xmatch error: parameter " + modeStr + " was not recognized !");
                this.println("Allowed modes are : allmatch|bestmatch|nomatch");
                return "";
            }
        }
        if (pCat1 == null || pCat2 == null || dist < 0.0) {
            this.printConsole("!!! xmatch error: missing or incorrect parameters");
        } else {
            if (!(pCat1 instanceof PlanCatalog) || !(pCat2 instanceof PlanCatalog)) {
                this.printConsole("!!! xmatch error: can only be performed on catalog planes !");
                return "";
            }
            CDSXMatch xMatch = new CDSXMatch(this.a);
            int[] p2CoordIdx = null;
            int[] p1CoordIdx = null;
            if (p1Cols != null) {
                p1CoordIdx = this.getCoordIdx((PlanCatalog)pCat1, p1Cols);
            }
            if (p2Cols != null) {
                p2CoordIdx = this.getCoordIdx((PlanCatalog)pCat2, p2Cols);
            }
            xMatch.setColFilter(null);
            xMatch.posXMatch(pCat1, pCat2, label, p1CoordIdx, p2CoordIdx, new double[]{0.0, dist}, mode, this.a, true);
        }
        return "";
    }

    private int[] getCoordIdx(PlanCatalog pc, String colStr) {
        String[] coord = Util.split(colStr, ",", ' ', ' ', true);
        if (coord.length < 2) {
            this.printConsole("!!! xmatch error: there should be 2 coordinate columns !");
            return null;
        }
        int idxDe = -1;
        int idxRa = -1;
        try {
            Field[] fields = pc.getFirstLegende().field;
            for (int i = 0; i < fields.length && (idxRa < 0 || idxDe < 0); ++i) {
                if (fields[i].name.equals(coord[0])) {
                    idxRa = i;
                    continue;
                }
                if (!fields[i].name.equals(coord[1])) continue;
                idxDe = i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (idxRa < 0 || idxDe < 0) {
            this.printConsole("!!! xmatch error: could not find coordinate columns " + colStr + " for plane " + pc.getLabel());
            this.println("Cross-match will be performed using coordinate columns found by UCD !");
            return null;
        }
        return new int[]{idxRa, idxDe};
    }

    protected void execHelpCmd(String param) {
        this.execHelpCmd(param, true);
    }

    protected void execHelpCmd(String param, boolean inAladinFrame) {
        if (param.length() == 0) {
            if (inAladinFrame) {
                this.a.log("Help", "script command");
                this.a.cardView.show(this.a.bigView, "Help");
                this.a.inScriptHelp = true;
                if (this.a.msgOn) {
                    this.a.msgOn = false;
                }
                this.a.help.setHyperText("", "|!Aladin script commands." + this.execHelp());
            }
            this.println(this.removeLinks(this.execHelp()));
            return;
        }
        if (param.equals("off")) {
            this.a.cardView.show(this.a.bigView, "View");
            this.a.inScriptHelp = false;
        } else if (param.equals("all")) {
            this.execAllHelp();
        } else if (param.equals("allhtml")) {
            this.execHTMLHelp();
        } else {
            String s = this.getHelpString(param);
            if (s.length() == 0) {
                return;
            }
            this.println(this.removeLinks(s));
            if (inAladinFrame) {
                this.a.inScriptHelp = true;
                this.a.cardView.show(this.a.bigView, "Help");
                this.a.help.setHyperText(param.charAt(0) == '#' ? null : param, "|" + s);
            }
        }
    }

    private void execAllHelp() {
        this.println(this.removeLinks(this.execHelp()));
        for (int i = 0; i < CMD.length; ++i) {
            this.println("----");
            this.println(this.removeLinks(this.getHelpString(CMD[i])));
        }
    }

    private void execHTMLHelp() {
        this.println("<PRE>\n" + this.translateLinks(this.execHelp()) + "</PRE>\n");
        for (int i = 0; i < CMD.length; ++i) {
            this.println("<P><HR><A NAME=\"" + CMD[i] + "\"></A>");
            this.println(this.translateLinks(this.getHelpStringHTML(CMD[i])));
        }
    }

    private String getHelpString(String p) {
        String s;
        if (p.charAt(0) == '#') {
            s = p;
        } else {
            String s1 = "Help." + Util.toLower(p);
            s = Aladin.chaine.getString(s1);
            if (s.length() == 0 || s.equals("[" + s1 + "]")) {
                this.printConsole("!!! help error: command \"" + p + "\" unknown !");
                return "";
            }
        }
        StringTokenizer st = new StringTokenizer(s, "#");
        String indent = "   ";
        StringBuffer res = new StringBuffer();
        char oc = ' ';
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            if (s.length() < 2) continue;
            char c = s.charAt(0);
            s = s.substring(2);
            if (c != oc) {
                res.append(" \n" + (c == 'n' ? " \n \n \n#NAME#" : (c == 's' ? "#SYNOPSIS#" : (c == 'd' ? "#DESCRIPTION#" : (c == 'e' ? "#EXAMPLE#" : (c == 't' ? "#NOTES#" : (c == 'g' ? "#SEE# #ALSO#" : "")))))) + "\n");
            }
            oc = c;
            StringTokenizer st1 = new StringTokenizer(s, "\n");
            while (st1.hasMoreTokens()) {
                StringBuffer line = new StringBuffer(indent.toString());
                StringTokenizer st2 = new StringTokenizer(st1.nextToken(), " ", true);
                String mot = null;
                while (mot != null || st2.hasMoreTokens()) {
                    if (mot == null) {
                        mot = st2.nextToken();
                    }
                    if (line.length() + mot.length() > 78) {
                        res.append(line + "\n");
                        line = new StringBuffer(indent.toString());
                    }
                    line.append(mot);
                    mot = null;
                }
                if (line.length() <= indent.length()) continue;
                res.append(line + "\n");
            }
        }
        return res.toString();
    }

    private String getHelpStringHTML(String p) {
        String s;
        if (p.charAt(0) == '#') {
            s = p;
        } else {
            String s1 = "Help." + Util.toLower(p);
            s = Aladin.chaine.getString(s1);
            if (s.length() == 0 || s.equals("[" + s1 + "]")) {
                this.printConsole("!!! help error: command \"" + p + "\" unknown !");
                return "";
            }
        }
        StringTokenizer st = new StringTokenizer(s, "#");
        String indent = "   ";
        StringBuffer res = new StringBuffer();
        char oc = ' ';
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            if (s.length() < 2) continue;
            char c = s.charAt(0);
            s = s.substring(2);
            if (c != oc) {
                res.append("<P>\n" + (c == 'n' ? "" : (c == 's' ? "<P><I><B>Synopsis</B></I>:<BR>" : (c == 'd' ? "<P><I><B>Description</B></I><BR>" : (c == 'e' ? "<P><I><B>Example</B></I>:<BR>" : (c == 't' ? "<P><I><B>Note</B></I> - " : (c == 'g' ? "<P><I><B>See also</B></I>: " : "")))))) + "\n");
            } else {
                res.append("<BR>\n");
            }
            oc = c;
            res.append(s);
        }
        return res.toString();
    }

    protected boolean execHpxCmd(String param) {
        try {
            int offset = param.indexOf(47);
            if (offset == -1) {
                return false;
            }
            int order = Integer.parseInt(param.substring(0, offset).trim());
            int npix = Integer.parseInt(param.substring(offset + 1).trim());
            long nSide = CDSHealpix.pow2(order);
            double[] x = CDSHealpix.polarToRadec(CDSHealpix.pix2ang_nest(nSide, npix));
            Coord c = new Coord(x[0], x[1]);
            ViewSimple v = this.a.view.getCurrentView();
            Plan pref = null;
            if (v != null && !v.isFree()) {
                pref = v.pref;
            }
            if (pref != null && pref instanceof PlanBG) {
                Localisation cfr_ignored_0 = this.a.localisation;
                Localisation.frameToFrame(c, ((PlanBG)pref).frameOrigin, 0);
            }
            this.a.view.setRepere(c);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void execSelectCmd(String param) {
        if (param.trim().equals("-tag")) {
            this.a.selecttag();
            return;
        }
        int defaultView = this.a.view.getCurrentNumView();
        int nview = -1;
        int n = -1;
        boolean first = true;
        Tok st = new Tok(param);
        while (st.hasMoreTokens()) {
            String x = st.nextToken();
            if (Util.indexOfIgnoreCase(x, "frame=") == 0) {
                try {
                    double frame = Double.parseDouble(x.substring(6)) - 1.0;
                    if (n >= 0) {
                        int[] np = this.a.view.getNumView(this.a.calque.getPlan(n));
                        for (int i = 0; i < np.length; ++i) {
                            if (this.a.view.viewSimple[np[i]].cubeControl == null) continue;
                            this.a.view.viewSimple[np[i]].cubeControl.setFrameLevel(frame);
                            this.a.view.viewSimple[np[i]].repaint();
                        }
                    } else if (nview >= 0) {
                        if (this.a.view.viewSimple[nview].cubeControl == null) continue;
                        this.a.view.viewSimple[nview].cubeControl.setFrameLevel(frame);
                        this.a.view.viewSimple[nview].repaint();
                    } else {
                        ViewSimple[] v = this.a.view.getSelectedView();
                        for (int i = 0; i < v.length; ++i) {
                            if (v[i].cubeControl == null) continue;
                            v[i].cubeControl.setFrameLevel(frame);
                            v[i].repaint();
                        }
                    }
                }
                catch (Exception e) {
                    this.printConsole("!!! select cube frame error: " + e.getMessage());
                }
                return;
            }
            if (first) {
                first = false;
                this.a.view.unSelectAllView();
                this.a.view.deSelect();
                this.a.calque.unSelectAllPlan();
            }
            Plan p = this.getNumber(x, 1, false, false);
            nview = this.getViewNumber(x, false);
            if (nview >= 0) {
                this.a.view.selectView(nview);
                this.a.view.setCurrentNumView(nview);
                defaultView = -1;
                continue;
            }
            if (p == null) continue;
            p.selected = true;
            nview = this.a.view.selectView(p);
            if (defaultView != -1 && nview != -1) {
                this.a.view.setCurrentNumView(nview);
                defaultView = -1;
            }
            if (!p.isCatalog()) continue;
            this.a.view.selectAllInPlanWithoutFree(p, 0);
            this.a.mesure.mcanvas.repaint();
        }
        if (defaultView >= 0) {
            this.a.view.selectView(defaultView);
            this.a.view.setCurrentNumView(defaultView);
        }
        this.a.calque.repaintAll();
    }

    protected void execFlipFlop(String param, String label) {
        char[] a = param.toCharArray();
        int i = 0;
        String arg = null;
        int methode = 0;
        if (a.length > 0) {
            for (i = a.length - 1; i > 0 && Character.isSpaceChar(a[i]); --i) {
            }
            int j = i + 1;
            while (i > 0 && !Character.isSpaceChar(a[i])) {
                --i;
            }
            if (Character.isSpaceChar(a[i])) {
                ++i;
            }
            arg = param.substring(i, j);
        }
        if (arg != null && arg.length() != 0) {
            if (arg.equalsIgnoreCase("H")) {
                methode = 1;
            } else if (arg.equalsIgnoreCase("VH") || arg.equalsIgnoreCase("HV")) {
                methode = 2;
            }
        } else {
            i = a.length;
        }
        Plan[] p = this.getPlan(param.substring(0, i).trim(), 1);
        if (p.length == 0) {
            p = new Plan[]{this.a.calque.getPlanBase()};
        }
        if (label != null) {
            try {
                p[0] = this.a.calque.dupPlan((PlanImage)p[0], label, p[0].type, false);
            }
            catch (Exception e) {
                this.printConsole("!!! fliflop error: " + e.getMessage());
                return;
            }
        }
        try {
            this.a.view.flip((PlanImage)p[0], methode);
        }
        catch (Exception e) {
            this.printConsole("!!! fliflop error: " + e.getMessage());
        }
    }

    protected void execMatchCmd(String param) {
        StringTokenizer tok = new StringTokenizer(param);
        int mode = 3;
        String p = "";
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.equalsIgnoreCase("-scale")) {
                mode = 2;
                continue;
            }
            if (s.equalsIgnoreCase("off")) {
                mode = 0;
                continue;
            }
            p = s;
            break;
        }
        if (p.length() > 0) {
            this.execSelectCmd(p);
        }
        if (mode == 0) {
            if (this.a.view.isSelectCompatibleViews()) {
                this.a.view.unselectViewsPartial();
            }
            this.a.match(0);
        } else {
            this.a.switchMatch(mode == 3);
        }
    }

    protected Plan execCropCmd(String param, String label) {
        int j;
        int i;
        char[] b = param.toCharArray();
        String pos = null;
        double x = 0.0;
        double y = 0.0;
        double w = 50.0;
        double h = 50.0;
        Coord c1 = null;
        boolean flagDim = false;
        try {
            for (i = b.length - 1; i > 0 && Character.isSpaceChar(b[i]); --i) {
            }
            j = i + 1;
            while (i > 0 && !Character.isSpaceChar(b[i])) {
                --i;
            }
            String size = param.substring(Character.isSpaceChar(b[i]) ? i + 1 : i, j);
            j = size.indexOf(120);
            if (j < 0) {
                throw new Exception();
            }
            w = Double.parseDouble(size.substring(0, j));
            h = Double.parseDouble(size.substring(j + 1));
            flagDim = true;
        }
        catch (Exception e) {
            i = b.length - 1;
        }
        while (i > 0 && Character.isSpaceChar(b[i])) {
            --i;
        }
        j = i > 0 && !Character.isSpaceChar(b[i]) ? i + 1 : i;
        boolean flagPos = false;
        while (i > 0 && !Character.isSpaceChar(b[i])) {
            if (b[i] == ',') {
                flagPos = true;
            }
            --i;
        }
        if (flagPos) {
            pos = param.substring(Character.isSpaceChar(b[i]) ? i + 1 : i, j);
            j = pos.indexOf(44);
            x = Double.parseDouble(pos.substring(0, j));
            y = Double.parseDouble(pos.substring(j + 1));
            j = i;
        }
        PlanImage pi = null;
        try {
            pi = (PlanImage)this.getPlan(param.substring(0, j), 1)[0];
            if (pi == null) {
                throw new Exception();
            }
        }
        catch (Exception e1) {
            pi = (PlanImage)this.a.calque.getPlanBase();
        }
        ViewSimple v = this.a.view.getView(pi);
        if (pi instanceof PlanBG && (!pi.active || !pi.ref && pi.getOpacityLevel() == 0.0f)) {
            Aladin.warning("crop error: HiPS plane [" + pi.label + "] must be visible to be cropped!", 1);
            System.err.println("crop error: HiPS plane [" + pi.label + "] must be visible to be cropped!");
            return null;
        }
        if (!flagDim) {
            try {
                if (pi instanceof PlanBG) {
                    w = v.rv.width;
                    h = v.rv.height;
                } else {
                    w = v.rzoom.width;
                    h = v.rzoom.height;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (pi instanceof PlanBG) {
            w /= v.zoom;
            h /= v.zoom;
        }
        if (!flagPos) {
            try {
                c1 = pi instanceof PlanBG ? v.getCooCentre() : new Coord(this.a.view.repere.raj, this.a.view.repere.dej);
                pi.projd.getXY(c1);
                x = c1.x - w / 2.0;
                y = c1.y - h / 2.0;
                y = (double)pi.naxis2 - (y + h);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                x = v.rzoom.x;
                y = v.rzoom.y;
            }
        }
        Aladin.trace(4, "Command.crop: on " + v + " param=[" + param + "] label=" + label + " " + x + "," + y + (flagPos ? "(provided) " : " (" + c1 + " on reticle) ") + w + "x" + h + (flagDim ? "( provided)" : "(view size)"));
        if (v.cropArea(new RectangleD(x, (double)pi.naxis2 - (y + h), w, h), label, v.zoom, 1.0, true, false) == null) {
            Aladin.warning("crop error: view [" + v + "] not usable!", 1);
            System.err.println("crop error: view [" + v + "] not usable!");
            return null;
        }
        this.syncNeedRepaint = true;
        this.a.view.repaintAll();
        return pi;
    }

    protected void setDrawMode(int mode) {
        drawMode = mode;
    }

    private Color getSpecifColor(String s, Tok tok) {
        Color c;
        if (s.equalsIgnoreCase("rgb")) {
            String r = tok.nextToken();
            String g = tok.nextToken();
            String b = tok.nextToken();
            s = s + "(" + r + "," + g + "," + b + ")";
            c = Action.getColor(s);
        } else {
            c = Action.getColor(s);
        }
        return c;
    }

    public void resetPreviousDrawing() {
        this.oPlan = null;
    }

    protected boolean execDrawCmd(String cmd, String param) {
        Color specifColor;
        Position newobj;
        Plan plan;
        block82: {
            plan = null;
            newobj = null;
            Coord c = null;
            double x = 0.0;
            double y = 0.0;
            specifColor = null;
            Tok tok = new Tok(param, "(, )");
            String fct = tok.nextToken();
            specifColor = this.getSpecifColor(fct, tok);
            if (specifColor != null) {
                fct = tok.nextToken();
            }
            String[] p = new String[tok.countTokens()];
            for (int i = 0; i < p.length; ++i) {
                p[i] = tok.nextToken();
            }
            int height = 500;
            PlanImage pi = (PlanImage)this.a.calque.getPlanBase();
            if (pi != null) {
                height = pi.naxis2;
            }
            if (fct.equalsIgnoreCase("mode")) {
                if (p[0].equalsIgnoreCase("xy")) {
                    drawMode = DRAWXY;
                } else if (p[0].equalsIgnoreCase("radec")) {
                    drawMode = DRAWRADEC;
                } else {
                    this.printConsole("!!! draw error: mode param (" + p[0] + ") unknown");
                    return false;
                }
                this.console("Draw mode: " + (drawMode == DRAWXY ? "XY coordinates" : "celestial coordinates"));
                return true;
            }
            if (fct.equalsIgnoreCase("global")) {
                this.memoGlobal(p);
                return true;
            }
            if (fct.equalsIgnoreCase("newtool")) {
                String name = null;
                if (p.length > 0) {
                    name = p[0];
                }
                this.oPlan = plan = this.a.calque.createPlanTool(name);
                if (this.globalColor != null) {
                    plan.c = this.globalColor;
                }
                return true;
            }
            try {
                if (fct.equalsIgnoreCase("newfov")) {
                    if (drawMode == DRAWRADEC) {
                        c = new Coord(p[0] + " " + p[1]);
                        c = this.a.localisation.frameToICRS(c);
                    } else {
                        c = new Coord();
                        c.x = this.parseDouble(p[0]) - 0.5;
                        c.y = (double)height - this.parseDouble(p[1]) + 0.5;
                        this.a.view.getCurrentView().getProj().getCoord(c);
                    }
                    double angle = p.length < 3 ? 0.0 : this.parseDouble(p[2]);
                    String name = p.length >= 4 ? p[3] : null;
                    this.oPlan = plan = this.a.calque.createPlanField(name, c, angle, true, true);
                    if (this.globalColor != null) {
                        plan.c = this.globalColor;
                    }
                    this.flagFoV = true;
                    return true;
                }
            }
            catch (Exception e) {
                this.printConsole("!!! draw error: " + e.getMessage());
                if (Aladin.levelTrace != 0) {
                    e.printStackTrace();
                }
                return false;
            }
            if (this.oPlan != null && this.oPlan.type != 10 && this.flagFoV) {
                this.oPlan = null;
            }
            plan = this.oPlan != null && this.a.calque.planToolOk(this.oPlan, this.flagFoV) ? this.oPlan : (this.flagFoV ? this.a.calque.selectPlanToolOrFoV() : this.a.calque.selectPlanTool());
            this.oPlan = plan;
            if (this.globalColor != null) {
                if (this.globalColor != plan.c && plan.type == 9 && plan.getCounts() > 0) {
                    plan = this.a.calque.createPlanTool(null);
                }
                plan.c = this.globalColor;
            }
            if (drawMode == DRAWRADEC) {
                plan.setXYorig(false);
            }
            try {
                if (drawMode == DRAWRADEC) {
                    if (p[0].equals("-") && p[1].equals("-")) {
                        c = this.a.localisation.getLastCoord();
                    } else {
                        c = new Coord(p[0] + " " + p[1]);
                        c = this.a.localisation.frameToICRS(c);
                    }
                } else {
                    x = this.parseDouble(p[0]) - 0.5;
                    y = (double)height - this.parseDouble(p[1]) + 0.5;
                }
                if (fct.equalsIgnoreCase("string")) {
                    Tag tag;
                    newobj = drawMode == DRAWRADEC ? (tag = new Tag(plan, c, p[2])) : (tag = new Tag(plan, this.a.view.getCurrentView(), x, y, p[2]));
                    tag.setDist(5);
                    tag.setAngle(0);
                    tag.setPole("nopole");
                    break block82;
                }
                if (fct.equalsIgnoreCase("tag") || fct.equalsIgnoreCase("string")) {
                    Tag tag;
                    String id = p.length < 3 ? null : p[2];
                    newobj = drawMode == DRAWRADEC ? (tag = new Tag(plan, c, id)) : (tag = new Tag(plan, this.a.view.getCurrentView(), x, y, id));
                    try {
                        if (p.length > 3) {
                            tag.setDist((int)this.parseDouble(p[3]));
                        }
                        if (p.length > 4) {
                            tag.setAngle((int)this.parseDouble(p[4]));
                        }
                        if (p.length > 5) {
                            tag.setPole(p[5]);
                        }
                        if (p.length > 6) {
                            tag.setFontSize((int)this.parseDouble(p[6]));
                        }
                        break block82;
                    }
                    catch (Exception e) {
                        this.printConsole("!!! draw tag error: usage: draw tag(x,y[,label,dist,angle,pole,fontSize])");
                        return false;
                    }
                }
                if (fct.equalsIgnoreCase("phot")) {
                    ViewSimple v = this.a.view.getCurrentView();
                    try {
                        if (drawMode == DRAWRADEC) {
                            Repere phot = new Repere(plan, c);
                            newobj = phot;
                            phot.setRadius(p[2]);
                        } else {
                            Repere phot = new Repere(plan, v, x, y);
                            newobj = phot;
                            phot.setRayon(v, this.parseDouble(p[2]));
                        }
                        break block82;
                    }
                    catch (Exception e) {
                        this.printConsole("!!! draw phot error: usage: draw phot(x,y,radius)");
                        return false;
                    }
                }
                if (fct.equalsIgnoreCase("circle")) {
                    if (drawMode == DRAWRADEC) {
                        double r = Server.getAngle(p[2], 8) / 60.0;
                        newobj = new Cercle(plan, c, r);
                    } else {
                        double r = this.parseDouble(p[2]);
                        newobj = new Cercle(plan, this.a.view.getCurrentView(), x, y, r);
                    }
                    break block82;
                }
                if (fct.equalsIgnoreCase("ellipse")) {
                    double angle = this.parseDouble(p[4]);
                    if (drawMode == DRAWRADEC) {
                        double semiMA = Server.getAngle(p[2], 8) / 60.0;
                        double semiMI = Server.getAngle(p[3], 8) / 60.0;
                        newobj = new Ellipse(plan, c, semiMA, semiMI, angle);
                    } else {
                        double semiMA = this.parseDouble(p[2]);
                        double semiMI = this.parseDouble(p[3]);
                        newobj = new Ellipse(plan, this.a.view.getCurrentView(), x, y, semiMA, semiMI, angle);
                    }
                    break block82;
                }
                if (fct.equalsIgnoreCase("box")) {
                    double angle = 0.0;
                    String label = null;
                    try {
                        angle = this.parseDouble(p[4]);
                    }
                    catch (Exception e) {
                        try {
                            label = p[4];
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    if (label == null) {
                        try {
                            label = p[5];
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (drawMode == DRAWRADEC) {
                        double w = Server.getAngle(p[2], 8) / 60.0;
                        double h = Server.getAngle(p[3], 8) / 60.0;
                        newobj = new Box(plan, c, w, h, angle, label);
                    } else {
                        double w = this.parseDouble(p[2]);
                        double h = this.parseDouble(p[3]);
                        newobj = new Box(plan, this.a.view.getCurrentView(), x, y, w, h, angle, label);
                    }
                    break block82;
                }
                if (fct.equalsIgnoreCase("vector")) {
                    double angle = this.parseDouble(p[3]);
                    if (drawMode == DRAWRADEC) {
                        double w = Server.getAngle(p[2], 8) / 60.0;
                        newobj = new Vecteur(plan, c, w, angle);
                    } else {
                        double w = this.parseDouble(p[2]);
                        newobj = new Vecteur(plan, this.a.view.getCurrentView(), x, y, w, angle);
                    }
                    break block82;
                }
                if (fct.equalsIgnoreCase("arc")) {
                    double startAngle = this.parseDouble(p[3]);
                    double angle = this.parseDouble(p[4]);
                    if (drawMode == DRAWRADEC) {
                        double r = Server.getAngle(p[2], 8) / 60.0;
                        newobj = new Arc(plan, c, r, startAngle, angle);
                    } else {
                        double r = this.parseDouble(p[2]);
                        newobj = new Arc(plan, this.a.view.getCurrentView(), x, y, r, startAngle, angle);
                    }
                    break block82;
                }
                if (fct.equalsIgnoreCase("pickle")) {
                    double startAngle = this.parseDouble(p[4]);
                    double angle = this.parseDouble(p[5]);
                    if (drawMode == DRAWRADEC) {
                        double r1 = Server.getAngle(p[2], 8) / 60.0;
                        double r2 = Server.getAngle(p[3], 8) / 60.0;
                        newobj = new Pickle(plan, c, r1, r2, startAngle, angle);
                    } else {
                        double r1 = this.parseDouble(p[2]);
                        double r2 = this.parseDouble(p[3]);
                        newobj = new Pickle(plan, this.a.view.getCurrentView(), x, y, r1, r2, startAngle, angle);
                    }
                    break block82;
                }
                if (fct.equalsIgnoreCase("line") || fct.equalsIgnoreCase("polygon")) {
                    Ligne p1;
                    newobj = null;
                    Ligne op1 = null;
                    ViewSimple v = this.a.view.getCurrentView();
                    String id = null;
                    int n = p.length;
                    if (n % 2 == 1) {
                        id = p[n - 1];
                        --n;
                    }
                    for (int i = 0; i < n; i += 2) {
                        if (drawMode == DRAWRADEC) {
                            c = new Coord(p[i] + " " + p[i + 1]);
                            c = this.a.localisation.frameToICRS(c);
                            p1 = new Ligne(c.al, c.del, plan, v, id, op1);
                        } else {
                            x = this.parseDouble(p[i]) - 0.5;
                            y = (double)height - this.parseDouble(p[i + 1]) + 0.5;
                            p1 = new Ligne(plan, v, x, y, id, op1);
                        }
                        if (specifColor != null) {
                            p1.setColor(specifColor);
                        }
                        this.addObj(plan, p1);
                        op1 = p1;
                    }
                    if (fct.equalsIgnoreCase("polygon")) {
                        p1 = new Ligne(0.0, 0.0, plan, v, id, op1);
                        newobj = p1;
                        p1.makeLastLigneForClose(v);
                    }
                    break block82;
                }
                if (fct.equalsIgnoreCase("dist")) {
                    newobj = null;
                    Cote op1 = null;
                    ViewSimple v = this.a.view.getCurrentView();
                    int n = p.length;
                    for (int i = 0; i < n; i += 2) {
                        Cote p1;
                        if (drawMode == DRAWRADEC) {
                            c = new Coord(p[i] + " " + p[i + 1]);
                            c = this.a.localisation.frameToICRS(c);
                            p1 = new Cote(c.al, c.del, plan, v, op1);
                        } else {
                            x = this.parseDouble(p[i]) - 0.5;
                            y = (double)height - this.parseDouble(p[i + 1]) + 0.5;
                            p1 = new Cote(plan, v, x, y, op1);
                        }
                        if (specifColor != null) {
                            p1.setColor(specifColor);
                        }
                        this.addObj(plan, p1);
                        op1 = p1;
                    }
                    break block82;
                }
                this.printConsole("!!! draw error: function unknown (" + fct + ")");
                return false;
            }
            catch (Exception e) {
                this.printConsole("!!! draw error: " + e.getMessage());
                if (Aladin.levelTrace != 0) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        if (newobj != null) {
            if (specifColor != null) {
                ((Obj)newobj).setColor(specifColor);
            }
            this.addObj(plan, newobj);
        }
        plan.resetProj();
        this.a.view.repaintAll();
        return true;
    }

    private double parseDouble(String s) throws Exception {
        int fin;
        s = s.trim();
        for (fin = s.length() - 1; fin > 0 && !Character.isDigit(s.charAt(fin)); --fin) {
        }
        int deb = s.length() > 0 && s.charAt(0) == '+' ? 1 : 0;
        return Double.parseDouble(s.substring(deb, fin + 1));
    }

    private void addObj(Plan plan, Obj newobj) {
        plan.pcat.setObjetFast(newobj);
        if (plan.type != 10) {
            return;
        }
        ((Position)newobj).setXYTan(plan.co);
    }

    private void memoGlobal(String[] p) {
        for (int i = 0; i < p.length; ++i) {
            if (!p[i].startsWith("color=")) continue;
            this.globalColor = Action.getColor(p[i].substring(6));
        }
    }

    private void execInfo(String param) {
        this.a.status.setText(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execScriptAsStream(String s) {
        MyByteArrayStream bis = null;
        try {
            bis = new MyByteArrayStream(2000);
            bis.write(s);
            this.readFromStream(bis.getInputStream());
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String execScript(String s) {
        return this.execScript(s, true, false);
    }

    public synchronized String execScript(String s, boolean verbose, boolean flagOnlyFunction) {
        String[] commands = Util.split(s, ";\n\r", '[', ']');
        int i = 0;
        StringBuffer rep = new StringBuffer();
        String s1 = null;
        for (int k = 0; k < commands.length; ++k) {
            try {
                String cmd = commands[k].trim();
                if (cmd.length() > 0) {
                    if (i == 0) {
                        s1 = this.exec(cmd, verbose, flagOnlyFunction);
                        if (s1 == null) {
                            return null;
                        }
                    } else {
                        s1 = this.exec(cmd, verbose, flagOnlyFunction);
                    }
                }
                if (s1 != null && s1.length() > 0) {
                    rep.append(s1);
                }
                ++i;
                continue;
            }
            catch (Exception e) {
                if (Aladin.levelTrace != 3) continue;
                e.printStackTrace();
            }
        }
        return rep.toString();
    }

    protected String getLastCmd() {
        return this.lastCmd;
    }

    private int findAlgebre(String s) {
        if (s.startsWith("+")) {
            return 0;
        }
        if (s.startsWith("-")) {
            return 1;
        }
        if (s.startsWith("* ")) {
            return 2;
        }
        if (s.startsWith("/")) {
            return 3;
        }
        if (s.indexOf(" + ") > 0) {
            return 0;
        }
        if (s.indexOf(" - ") > 0) {
            return 1;
        }
        if (s.indexOf(" * ") > 0) {
            return 2;
        }
        if (s.indexOf(" / ") > 0) {
            return 3;
        }
        return -1;
    }

    protected void execLater(String s) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.exec(s);
        } else {
            final String[] param = new String[]{s};
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Command.this.exec(param[0]);
                }
            });
        }
    }

    protected String exec(String s) {
        return this.exec(s, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected String exec(String s1, boolean verbose, boolean flagOnlyFunction) {
        if (this.a.isFullScreen() && !this.a.fullScreen.isVisible()) {
            this.a.fullScreen.setVisible(true);
        }
        if (s1.trim().charAt(0) == '#') {
            if (this.comment == null) {
                this.comment = new StringBuffer(s1.trim().substring(1));
            } else {
                this.comment.append(" " + s1.trim().substring(1));
            }
            return "";
        }
        if (!s1.startsWith("function")) {
            this.comment = null;
        }
        this.syncServer();
        if (!this.filterMode && this.fonct == null) {
            s1 = this.evalAdjust(s1.trim());
            s1 = this.convertAdjust(s1);
        }
        try {
            s2 = this.ds9.translate(s1);
            if (s2 != null) {
                if (s2.length() == 0) {
                    return "";
                }
                return this.execScript(s2, verbose, flagOnlyFunction);
            }
        }
        catch (Exception e) {
            this.printConsole(e.getMessage());
            return "";
        }
        tp = new StringBuffer();
        s = this.getTargetPlane(tp, s1);
        label = tp.length() == 0 ? null : "=" + tp.toString();
        st = new Tok(s);
        cmd = st.nextToken();
        if (this.getNumber(s, 1, false, false) != null) {
            param = s;
            cmd = "copy";
        } else {
            param = s.substring(cmd.length()).trim();
        }
        this.lastCmd = cmd;
        if (!verbose) ** GOTO lbl-1000
        if (this.a.getInstanceId() > 0) ** GOTO lbl-1000
        if (this.a.getInstanceId() == 0) {
            ** if (Aladin.flagLaunch) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v0 = true;
            ** GOTO lbl46
        }
lbl-1000:
        // 3 sources

        {
            v0 = echo = false;
        }
lbl46:
        // 2 sources

        if (echo) {
            this.println("[" + s1 + "]...");
        }
        if (this.syncMode == 1 && this.needSync(cmd)) {
            if (!this.isSync()) {
                Aladin.trace(4, "Command.exec() : command \"" + cmd + "\" needs sync...");
            }
            this.sync();
        }
        if (s1.trim().startsWith("function")) {
            this.fonct = new Function();
            if (this.comment != null) {
                this.fonct.setDescription(this.comment.toString());
                this.comment = null;
            }
        }
        if (this.fonct != null) {
            try {
                if (this.fonct.parseFunction(s1)) {
                    this.addFunction(this.fonct);
                    this.fonct = null;
                }
            }
            catch (Exception e) {
                this.printConsole("!!! " + e.getMessage());
                this.fonct = null;
            }
            return "";
        }
        if (flagOnlyFunction) {
            return "";
        }
        if (s.toLowerCase().startsWith("filter") && s.indexOf("{") >= 0) {
            this.println("Enter the constraints for the new filter");
            this.filterMode = true;
            this.filterDef = new StringBuffer();
        }
        if (this.filterMode) {
            this.filterDef.append("\n" + s);
            if (Action.countNbOcc('{', this.filterDef.toString()) <= Action.countNbOcc('}', this.filterDef.toString())) {
                this.filterMode = false;
                if (this.robotMode && Aladin.ROBOTSUPPORT) {
                    FilterProperties.setCurrentMode(FilterProperties.ADVANCED);
                    this.robot.executeCommand("filter", this.filterDef.toString());
                } else if (this.createFilter(this.filterDef.toString()) != null) {
                    this.a.calque.select.repaint();
                }
                return "";
            }
            if (Action.countNbOcc('\n', this.filterDef.toString()) > 1) {
                this.println("Enter other constraints for the new filter");
            }
            return "";
        }
        if (echo) {
            this.a.console.printCommand(s1);
        }
        if (s1.length() > 0 && s1.trim().charAt(0) == '#') {
            return "";
        }
        if (this.robotMode && Aladin.ROBOTSUPPORT && this.robot.executeCommand(cmd, param)) {
            return "";
        }
        Aladin.trace(4, "Command.exec() : execute now \"" + cmd + " " + param + "\"...");
        if (cmd.equalsIgnoreCase("taquin")) {
            this.a.view.taquin(param);
        } else if (cmd.equalsIgnoreCase("macro")) {
            this.execMacro(param);
        } else if (cmd.equalsIgnoreCase("test")) {
            this.hop();
        } else if (cmd.equalsIgnoreCase("testlang")) {
            Aladin.chaine.testLanguage(param);
        } else if (cmd.equalsIgnoreCase("testimg")) {
            this.testCalib(label, param, 0);
        } else if (cmd.equalsIgnoreCase("testcat")) {
            this.testCalib(label, param, 1);
        } else if (cmd.equalsIgnoreCase("testscript")) {
            this.testscript(param);
        } else if (cmd.equalsIgnoreCase("testperf")) {
            this.testperf(param);
        } else if (cmd.equalsIgnoreCase("testnet")) {
            this.testnet();
        } else if (cmd.equalsIgnoreCase("call")) {
            this.execFunction(param);
        } else if (cmd.equalsIgnoreCase("=")) {
            this.execEval(param);
        } else if (cmd.equalsIgnoreCase("convert")) {
            this.execConvert(param);
        } else {
            if (cmd.equalsIgnoreCase("list")) {
                return this.listFunction(param);
            }
            if (s.trim().startsWith("addcol")) {
                this.execAddCol(s);
                return "";
            }
            if (cmd.equalsIgnoreCase("select")) {
                this.execSelectCmd(param);
            } else if (cmd.equalsIgnoreCase("tag")) {
                this.a.tagselect();
            } else if (cmd.equalsIgnoreCase("untag")) {
                this.a.untag();
            } else if (cmd.equalsIgnoreCase("reloadglu")) {
                this.a.glu = new Glu(this.a);
            } else if (cmd.equalsIgnoreCase("goto")) {
                this.goTo(param);
            } else if (cmd.equalsIgnoreCase("crop")) {
                this.execCropCmd(param, label);
            } else if (cmd.equalsIgnoreCase("match")) {
                this.execMatchCmd(param);
            } else if (cmd.equalsIgnoreCase("stick")) {
                this.execViewCmd(param, 0);
            } else if (cmd.equalsIgnoreCase("unstick")) {
                this.execViewCmd(param, 1);
            } else if (cmd.equalsIgnoreCase("lock")) {
                this.execViewCmd(param, 2);
            } else if (cmd.equalsIgnoreCase("unlock")) {
                this.execViewCmd(param, 3);
            } else if (cmd.equalsIgnoreCase("northup")) {
                this.execViewCmd(param, 4);
            } else if (cmd.equalsIgnoreCase("unnorthup")) {
                this.execViewCmd(param, 5);
            } else if (cmd.equalsIgnoreCase("grey") || cmd.equalsIgnoreCase("gray")) {
                this.a.grey();
            } else if (cmd.equalsIgnoreCase("quit")) {
                this.a.quit(0);
            } else {
                if (cmd.equalsIgnoreCase("get")) {
                    return this.execGetCmd(param, label, true);
                }
                if (cmd.equalsIgnoreCase("set")) {
                    return this.execSetCmd(param);
                }
                if (cmd.equalsIgnoreCase("setconf")) {
                    return this.execSetconfCmd(param);
                }
                if (cmd.equalsIgnoreCase("status")) {
                    return this.execStatusCmd(param);
                }
                if (cmd.equalsIgnoreCase("info")) {
                    this.execInfo(param);
                } else if (cmd.equalsIgnoreCase("help")) {
                    this.execHelpCmd(param, false);
                } else if (cmd.equalsIgnoreCase("reset")) {
                    this.a.reset();
                } else if (cmd.equalsIgnoreCase("new")) {
                    this.a.windows();
                } else if (cmd.equalsIgnoreCase("search")) {
                    this.a.search.execute(param);
                } else if (cmd.equalsIgnoreCase("createplane") || cmd.equalsIgnoreCase("cplane") || cmd.equalsIgnoreCase("plane")) {
                    this.a.calque.newPlanCatalogBySelectedObjet(label != null ? label : param, false);
                } else if (cmd.equalsIgnoreCase("thumbnail") || cmd.equalsIgnoreCase("createROI") || cmd.equalsIgnoreCase("ROI")) {
                    this.execROICmd(param);
                } else if (cmd.equalsIgnoreCase("stc")) {
                    this.execDrawCmd("draw", param);
                } else if (cmd.equalsIgnoreCase("draw")) {
                    this.execDrawCmd(cmd, param);
                } else {
                    if (cmd.equalsIgnoreCase("rename") || cmd.equalsIgnoreCase("ren")) {
                        try {
                            p = null;
                            st = new Tok(param);
                            name = st.nextToken();
                            nameDst = st.nextToken();
                            if (nameDst.length() > 0) {
                                p = this.getNumber(name);
                            } else {
                                p = this.a.calque.getFirstSelectedPlan();
                                nameDst = name;
                            }
                            this.a.calque.rename(p, nameDst);
                        }
                        catch (Exception e) {
                            this.printConsole("!!! rename error: " + e.getMessage());
                            return "";
                        }
                    }
                    if (cmd.equalsIgnoreCase("grid")) {
                        if (param.equalsIgnoreCase("healpix") || param.equalsIgnoreCase("hpx")) {
                            if (!this.a.calque.hasHpxGrid()) {
                                this.a.calque.setOverlayFlag("hpxgrid", true);
                            }
                        } else {
                            v1 = flag = param.equals("off") == false;
                            if (!flag && this.a.calque.hasHpxGrid()) {
                                this.a.calque.setOverlayFlag("hpxgrid", false);
                            }
                            this.a.calque.setGrid(flag, false);
                        }
                        this.a.calque.repaintAll();
                    } else if (cmd.equalsIgnoreCase("pause")) {
                        try {
                            m = Double.parseDouble(param);
                            if (m <= 0.0) {
                                m = 1.0;
                            }
                        }
                        catch (Exception e) {
                            m = 1.0;
                        }
                        Util.pause((int)Math.round(m * 1000.0));
                    } else {
                        if (cmd.equalsIgnoreCase("timeout")) {
                            return this.execSetconfCmd("timeout=" + param);
                        }
                        if (cmd.equalsIgnoreCase("reticle")) {
                            mode = param.equals("off") != false ? 0 : (param.equals("large") != false ? 2 : 1);
                            this.a.calque.setReticle(mode);
                            this.a.calque.repaintAll();
                        } else if (cmd.equalsIgnoreCase("target")) {
                            flag = param.equals("off") == false;
                            this.a.calque.setOverlayFlag("target", flag);
                            this.a.calque.repaintAll();
                        } else if (cmd.equalsIgnoreCase("scale") || cmd.equalsIgnoreCase("overlay")) {
                            flag = param.equals("off") == false;
                            this.a.calque.setOverlay(flag);
                            this.a.calque.repaintAll();
                        } else if (cmd.equalsIgnoreCase("flipflop")) {
                            this.execFlipFlop(param, label);
                        } else if (cmd.equalsIgnoreCase("reverse")) {
                            flag = param.equals("off") == false;
                            this.execCM(flag != false ? "reverse" : "noreverse");
                        } else if (cmd.equalsIgnoreCase("blink")) {
                            p = this.getPlanImage(param);
                            if (p.length < 2) {
                                this.printConsole("!!! blink error: 2 images are required for blinking");
                                return "";
                            }
                            this.a.calque.newPlanImageBlink(p, label, 400);
                            this.syncNeedRepaint = true;
                        } else if (cmd.equalsIgnoreCase("mosaic")) {
                            p = this.getPlanImage(param);
                            if (p.length < 2) {
                                this.printConsole("!!! mosaic error: 2 images are required for mosaic");
                                return "";
                            }
                            this.a.calque.newPlanImageMosaic(p, label, null);
                            this.syncNeedRepaint = true;
                        } else {
                            if (cmd.equalsIgnoreCase("resamp") || cmd.equalsIgnoreCase("rsamp")) {
                                try {
                                    fullPixel = false;
                                    methode = 1;
                                    st = new Tok(param);
                                    p1 = (PlanImage)this.getPlanFromParam(st.nextToken());
                                    p2 = (PlanImage)this.getPlanFromParam(st.nextToken());
                                    while (st.hasMoreTokens()) {
                                        c = st.nextToken().charAt(0);
                                        if (c == '8') {
                                            fullPixel = false;
                                        }
                                        if (c == 'F' || c == 'f') {
                                            fullPixel = true;
                                        }
                                        if (c == 'C' || c == 'c') {
                                            methode = 0;
                                        }
                                        if (c != 'B' && c != 'b') continue;
                                        methode = 1;
                                    }
                                    this.a.calque.newPlanImageResamp(p1, p2, label, methode, fullPixel, true);
                                    this.syncNeedRepaint = true;
                                }
                                catch (Exception e) {
                                    this.printConsole("Resamp error: " + e.getMessage());
                                    return "";
                                }
                            }
                            fct = this.findAlgebre(s);
                            if (fct >= 0) {
                                if (this.syncMode == 1) {
                                    this.sync();
                                }
                                try {
                                    st = new Tok(s);
                                    p1 = null;
                                    p2 = null;
                                    coef = NaN;
                                    n = st.countTokens();
                                    if (n <= 2) {
                                        v2 = s.substring(1).trim();
                                        p2 = (PlanImage)this.getPlanFromParam(v2, 0, true);
                                        if (p2 == null) {
                                            try {
                                                coef = Double.parseDouble(v2);
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                        if (p1 == null && p2 == null && Double.isNaN(coef)) {
                                            throw new Exception();
                                        }
                                        this.a.calque.newPlanImageAlgo(label, p1, p2, fct, coef, null, 1);
                                    }
                                    if (n == 3) {
                                        v1 = st.nextToken();
                                        st.nextToken();
                                        v2 = st.nextToken();
                                        p1 = (PlanImage)this.getPlanFromParam(v1, 0, true);
                                        if (p1 == null) {
                                            try {
                                                coef = Double.parseDouble(v1);
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                        if ((p2 = (PlanImage)this.getPlanFromParam(v2, 0, true)) == null) {
                                            try {
                                                coef = Double.parseDouble(v2);
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                        if (p1 == null && p2 == null && Double.isNaN(coef)) {
                                            throw new Exception();
                                        }
                                        this.a.calque.newPlanImageAlgo(label, p1, p2, fct, coef, null, 1);
                                    }
                                    throw new Exception();
                                }
                                catch (Exception e) {
                                    this.printConsole("!!! Arithmetic expression syntax error: " + e.getMessage());
                                    return "error";
                                }
                            } else {
                                if (cmd.equalsIgnoreCase("norm")) {
                                    try {
                                        fct = 4;
                                        st = new Tok(param);
                                        v1 = st.nextToken();
                                        v2 = st.hasMoreTokens() != false ? st.nextToken() : null;
                                        p1 = null;
                                        if (v1 != null && v1.equals("-cut")) {
                                            fct = 5;
                                            v1 = v2;
                                        }
                                        if (v1 != null) {
                                            p1 = (PlanImage)this.getPlanFromParam(v1);
                                        }
                                        this.a.calque.newPlanImageAlgo(label, p1, null, fct, 0.0, null, 0);
                                        this.syncNeedRepaint = true;
                                    }
                                    catch (Exception e) {
                                        this.printConsole("!!! norm error: " + e.getMessage());
                                        return "error";
                                    }
                                }
                                if (cmd.equalsIgnoreCase("kernel")) {
                                    s2 = "";
                                    if (param.trim().length() == 0) {
                                        s2 = this.a.kernelList.getKernelList();
                                    } else {
                                        if (param.indexOf(61) > 0) {
                                            pixRes = 2.777777777777778E-4;
                                            try {
                                                pixRes = this.a.view.getCurrentView().pref.projd.getPixResDelta();
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                            try {
                                                this.a.kernelList.addKernel(param, pixRes);
                                            }
                                            catch (Exception e) {
                                                this.printConsole("!!! conv error: kernel definition error");
                                                return "error";
                                            }
                                        }
                                        s2 = this.a.kernelList.getKernelDef(param);
                                    }
                                    this.print(s2);
                                    this.a.console.printInPad(s2);
                                    return s2;
                                }
                                if (cmd.equalsIgnoreCase("conv")) {
                                    try {
                                        st = new Tok(param);
                                        v1 = st.nextToken();
                                        conv = null;
                                        p1 = (PlanImage)this.getPlanFromParam(v1, 0, true);
                                        conv = p1 != null ? param.substring(v1.length()).trim() : param;
                                        this.a.calque.newPlanImageAlgo(label, p1, null, 6, 0.0, conv, 0);
                                        this.syncNeedRepaint = true;
                                    }
                                    catch (Exception e) {
                                        this.printConsole("!!! conv error: " + e.getMessage());
                                        return "error";
                                    }
                                }
                                if (cmd.equalsIgnoreCase("bitpix")) {
                                    try {
                                        fct = 8;
                                        st = new Tok(param);
                                        v1 = st.nextToken();
                                        v2 = st.hasMoreTokens() != false ? st.nextToken() : null;
                                        v3 = st.hasMoreTokens() != false ? st.nextToken() : null;
                                        p1 = null;
                                        if (v1 != null && v1.equals("-cut")) {
                                            fct = 9;
                                            v1 = v2;
                                            v2 = v3;
                                        }
                                        if ((p1 = (PlanImage)this.getPlanFromParam(v1, 0, true)) != null) {
                                            v1 = v2;
                                        }
                                        bitpix = v1;
                                        if (p1 != null && !p1.isSimpleImage() || p1 == null && !this.a.calque.getPlanBase().isSimpleImage()) {
                                            throw new Exception("Uncompatible image");
                                        }
                                        this.a.calque.newPlanImageAlgo(label, p1, null, fct, 0.0, bitpix, 0);
                                        this.syncNeedRepaint = true;
                                    }
                                    catch (Exception e) {
                                        this.printConsole("!!! bitpix error: " + e.getMessage());
                                        return "error";
                                    }
                                }
                                if (cmd.equalsIgnoreCase("RGB")) {
                                    p = this.getPlanImage(param);
                                    if (p.length < 2) {
                                        this.printConsole("!!! RGB error: not enough images");
                                        return "";
                                    }
                                    this.a.calque.newPlanImageRGB(p[0], p.length > 2 ? p[1] : null, p.length > 2 ? p[2] : p[1], p[0], label, false);
                                    this.syncNeedRepaint = true;
                                } else if (cmd.equalsIgnoreCase("RGBdiff")) {
                                    p = this.getPlanImage(param);
                                    if (p.length != 2) {
                                        this.printConsole("!!! RGBdiff error: requires two images");
                                        return "";
                                    }
                                    this.a.calque.newPlanImageRGB(p[0], p[1], null, p[0], label, true);
                                    this.syncNeedRepaint = true;
                                } else if (cmd.equalsIgnoreCase("cm")) {
                                    this.execCM(param);
                                } else if (cmd.equalsIgnoreCase("sync")) {
                                    this.sync();
                                } else if (cmd.equalsIgnoreCase("md")) {
                                    local = false;
                                    if (param.length() > 11 && param.substring(0, 11).equalsIgnoreCase("-localscope")) {
                                        local = true;
                                        param = param.substring(11).trim();
                                    }
                                    if (param.length() == 0) {
                                        this.a.calque.newFolder(null, 0, local);
                                    } else {
                                        this.a.calque.newFolder(param, 0, local);
                                    }
                                    this.a.calque.select.repaint();
                                } else if (cmd.equalsIgnoreCase("collapse")) {
                                    p = this.getPlan(param, 3);
                                    for (i = 0; i < p.length; ++i) {
                                        if (this.a.calque.isCollapsed(p[i])) continue;
                                        this.a.calque.select.switchCollapseFolder(p[i]);
                                    }
                                    this.a.calque.repaintAll();
                                } else if (cmd.equalsIgnoreCase("expand")) {
                                    p = this.getPlan(param, 3);
                                    for (i = 0; i < p.length; ++i) {
                                        if (!this.a.calque.isCollapsed(p[i])) continue;
                                        this.a.calque.select.switchCollapseFolder(p[i]);
                                    }
                                    this.a.calque.repaintAll();
                                } else if (cmd.equalsIgnoreCase("copy")) {
                                    st = new Tok(param);
                                    p1 = st.nextToken();
                                    mview1 = this.getViewNumber(p1, false);
                                    p2 = st.nextToken();
                                    mview2 = this.getViewNumber(p2, false);
                                    if (mview1 >= 0 && mview2 >= 0) {
                                        this.a.view.copyView(mview1, mview2);
                                    } else {
                                        p = null;
                                        plan = this.getNumber(p1, 1, false, false);
                                        if (plan == null || p2.length() == 0) {
                                            p2 = p1;
                                            p = this.a.calque.getFirstSelectedPlan();
                                        } else {
                                            p = plan;
                                        }
                                        if (label != null) {
                                            p2 = label;
                                        }
                                        try {
                                            if (p instanceof PlanImageBlink) {
                                                this.a.calque.newPlanImageFromBlink((PlanImageBlink)p, -1);
                                            } else {
                                                this.a.calque.dupPlan((PlanImage)p, p2.trim().length() == 0 ? null : p2, p.type, true);
                                            }
                                            this.syncNeedRepaint = true;
                                        }
                                        catch (Exception e) {
                                            this.printConsole("!!! copy error: " + e.getMessage());
                                            return "";
                                        }
                                    }
                                } else {
                                    if (cmd.equalsIgnoreCase("mv") || cmd.equalsIgnoreCase("move")) {
                                        st = new Tok(param);
                                        if (st.countTokens() == 2) {
                                            mview1 = this.getViewNumber(st.nextToken(), false);
                                            mview2 = this.getViewNumber(st.nextToken(), false);
                                            if (mview1 >= 0 && mview2 >= 0) {
                                                this.a.view.moveView(mview1, mview2);
                                                return "";
                                            }
                                        }
                                        st = new Tok(param);
                                        try {
                                            vp = new Vector<Plan>(10);
                                            while (st.hasMoreTokens()) {
                                                vp.addElement(this.getNumber(st.nextToken()));
                                            }
                                            j = vp.size();
                                            target = (Plan)vp.elementAt(j - 1);
                                            for (i = j - 2; i >= 0; --i) {
                                                this.a.calque.permute((Plan)vp.elementAt(i), target);
                                            }
                                            this.syncNeedRepaint = true;
                                            this.a.view.newView(1);
                                            this.a.calque.repaintAll();
                                        }
                                        catch (Exception eMv) {
                                            this.printConsole("!!! mv error: " + eMv.getMessage());
                                            return "";
                                        }
                                    }
                                    if (cmd.equalsIgnoreCase("rm") || cmd.equalsIgnoreCase("free")) {
                                        if (param.equals("lock") || param.equals("-lock") || param.equals("ROI") || param.equals("-ROI")) {
                                            this.a.view.freeLock();
                                        } else if (param.equals("all") || param.equals("-all")) {
                                            this.a.calque.FreeAll();
                                        } else if (param.length() == 0) {
                                            this.a.delete();
                                        } else {
                                            v = this.getViews(param);
                                            if (v.length > 0) {
                                                this.a.view.free(v);
                                            }
                                            this.a.calque.unSelectAllPlan();
                                            p = this.getPlan(param, 4);
                                            if (p.length > 0) {
                                                for (i = 0; i < p.length; ++i) {
                                                    p[i].selected = true;
                                                }
                                                this.a.calque.FreeSet(false);
                                            }
                                            this.a.view.setSelectFromView(true);
                                        }
                                        this.a.gc();
                                        this.a.calque.repaintAll();
                                    } else if (cmd.equalsIgnoreCase("modeview") || cmd.equalsIgnoreCase("mview")) {
                                        try {
                                            n = Integer.parseInt(st.nextToken());
                                            if (n != 1 && n != 2 && n != 4 && n != 9 && n != 16) {
                                                n = 1;
                                            }
                                        }
                                        catch (Exception e) {
                                            n = 1;
                                        }
                                        this.a.view.setModeView(n);
                                        try {
                                            n = Integer.parseInt(st.nextToken());
                                            this.a.view.scrollOn(n - 1);
                                        }
                                        catch (Exception e) {}
                                    } else if (cmd.equalsIgnoreCase("createview") || cmd.equalsIgnoreCase("cview")) {
                                        plot = false;
                                        col = new String[2];
                                        p = null;
                                        if (param.length() == 0) {
                                            p = this.a.calque.getFirstSelectedPlan();
                                        } else {
                                            p1 = st.nextToken();
                                            if (p1.equals("-plot")) {
                                                plot = true;
                                                if (!st.hasMoreTokens()) {
                                                    p = this.a.calque.getFirstSelectedPlan();
                                                } else {
                                                    p1 = st.nextToken();
                                                }
                                            }
                                            if (plot) {
                                                p1 = this.parseColumnIndex(col, p1);
                                            }
                                            if (p == null) {
                                                p = this.getNumber(p1);
                                            }
                                        }
                                        if (p == null) {
                                            return "";
                                        }
                                        nview = -1;
                                        if (st.hasMoreTokens()) {
                                            nview = this.getViewNumber(st.nextToken());
                                            this.a.calque.setPlanRef(p, nview);
                                        } else {
                                            nview = this.a.view.getLastNumView(p);
                                        }
                                        if (nview < 0) {
                                            return "";
                                        }
                                        if (!this.a.view.viewSimple[nview].isPlotView()) {
                                            this.a.view.setPlanRef(nview, p);
                                        }
                                        if (plot) {
                                            try {
                                                this.a.view.viewSimple[nview].addPlotTable(p, col[0], col[1], false);
                                            }
                                            catch (Exception e) {
                                                this.printConsole("!!! cview -plot error: " + e.getMessage());
                                            }
                                        }
                                        this.a.calque.repaintAll();
                                    } else if (cmd.equalsIgnoreCase("hide")) {
                                        p = this.getPlan(param, 2);
                                        for (i = 0; i < p.length; ++i) {
                                            if (p[i].type == 11) {
                                                this.a.calque.setActiveFolder(p[i], false);
                                                continue;
                                            }
                                            p[i].setActivated(false);
                                        }
                                        this.a.calque.repaintAll();
                                    } else if (cmd.equalsIgnoreCase("show") || cmd.equalsIgnoreCase("ref")) {
                                        p = this.getPlan(param, 2);
                                        for (i = 0; i < p.length; ++i) {
                                            if (p[i].type == 11) {
                                                this.a.calque.setActiveFolder(p[i], true);
                                                continue;
                                            }
                                            this.a.calque.showPlan(p[i]);
                                        }
                                    } else if (cmd.equalsIgnoreCase("zoom")) {
                                        this.syncNeedRepaint = true;
                                        if (!this.a.calque.zoom.setZoom(param)) {
                                            this.printConsole("!!! zoom error: factor \"" + param + "\" unknown !");
                                        }
                                    } else if (cmd.equalsIgnoreCase("backup")) {
                                        syncId = this.syncSave.start("Command.backup");
                                        try {
                                            if (this.a.save == null) {
                                                this.a.save = new Save(this.a);
                                            }
                                            this.a.save.saveAJ(param);
                                        }
                                        catch (Exception e) {
                                        }
                                        finally {
                                            this.syncSave.stop(syncId);
                                        }
                                    } else if (cmd.equalsIgnoreCase("save")) {
                                        syncId = this.syncSave.start("Command.save");
                                        try {
                                            if (this.a.save == null) {
                                                this.a.save = new Save(this.a);
                                            }
                                            tmp = null;
                                            file = null;
                                            w = 500;
                                            h = 500;
                                            flagDim = false;
                                            flagROI = false;
                                            mode = 0;
                                            posFile = cmd.length();
                                            qual = -1.0f;
                                            if (st.hasMoreTokens()) {
                                                tmp = st.nextToken();
                                            }
                                            if (tmp != null) {
                                                if (tmp.equals("-ROI") || tmp.equals("-allviews")) {
                                                    flagROI = true;
                                                    posFile = s.indexOf(tmp) + tmp.length() + 1;
                                                    tmp = st.nextToken();
                                                }
                                                if (tmp.startsWith("-jpeg") || tmp.startsWith("-jpg")) {
                                                    mode = 4;
                                                    try {
                                                        qual = Float.parseFloat(tmp.substring(tmp.indexOf(103) + 1, tmp.length()));
                                                        if (qual > 1.0f) {
                                                            qual /= 100.0f;
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        qual = -1.0f;
                                                    }
                                                    posFile = s.indexOf(tmp) + tmp.length() + 1;
                                                    tmp = st.hasMoreTokens() ? st.nextToken() : null;
                                                } else if (tmp.equals("-eps")) {
                                                    mode = 2;
                                                    posFile = s.indexOf(tmp) + tmp.length() + 1;
                                                    tmp = st.hasMoreTokens() ? st.nextToken() : null;
                                                } else if (tmp.equals("-png")) {
                                                    mode = 8;
                                                    posFile = s.indexOf(tmp) + tmp.length() + 1;
                                                    tmp = st.hasMoreTokens() != false ? st.nextToken() : null;
                                                }
                                                if (tmp != null && tmp.equals("-lk")) {
                                                    mode |= 16;
                                                    posFile = s.indexOf(tmp) + tmp.length() + 1;
                                                    tmp = st.hasMoreTokens() ? st.nextToken() : null;
                                                } else if (tmp != null && tmp.equals("-lkflex")) {
                                                    mode |= 32;
                                                    posFile = s.indexOf(tmp) + tmp.length() + 1;
                                                    if (st.hasMoreTokens()) {
                                                        tmp = st.nextToken();
                                                    }
                                                }
                                            }
                                            if (tmp != null) {
                                                try {
                                                    x = tmp.indexOf(120);
                                                    w = Integer.parseInt(tmp.substring(0, x));
                                                    h = Integer.parseInt(tmp.substring(x + 1));
                                                    flagDim = true;
                                                    if (st.hasMoreTokens()) {
                                                        posFile = s.indexOf(tmp) + tmp.length() + 1;
                                                        file = st.nextToken();
                                                    }
                                                }
                                                catch (Exception e) {
                                                    w = h = View.INITW;
                                                    file = tmp;
                                                }
                                            }
                                            if (file != null) {
                                                file = s.substring(posFile).trim();
                                            }
                                            if (file == null) {
                                                if (!Aladin.NOGUI) {
                                                    tmp = "saving on standard output required NOGUI mode (-nogui parameter)";
                                                    Aladin.warning("save error: " + tmp, 1);
                                                    e = tmp;
                                                    return e;
                                                }
                                            }
                                            file = Tok.unQuote(file);
                                            if (Aladin.NOGUI) {
                                                v = this.a.view.getCurrentView();
                                                if (w == -1 || h == -1) {
                                                    v.setDimension(((PlanImage)v.pref).width, ((PlanImage)v.pref).height);
                                                    v.setZoomXY(1.0, -1.0, -1.0);
                                                } else {
                                                    v.setDimension(w, h);
                                                }
                                                v.paintComponent(null);
                                            }
                                            if (mode == 0 || mode == 16 || mode == 32) {
                                                mode = file != null && (file.endsWith(".jpg") || file.endsWith(".jpeg")) ? (mode |= 4) : (file != null && file.endsWith(".eps") ? (mode |= 2) : (file != null && file.endsWith(".png") ? (mode |= 8) : (file != null && file.endsWith(".bmp") ? (mode |= 1) : (file != null && file.endsWith(".lk") ? (mode |= 16) : (mode |= 8)))));
                                            }
                                            if (flagROI) {
                                                dot = file.lastIndexOf(46);
                                                if (dot >= 0) {
                                                    file = file.substring(0, dot);
                                                }
                                                this.a.view.saveROI(file, w, h, mode);
                                            }
                                            this.a.save.saveView(file, w, h, mode, qual);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        finally {
                                            this.syncSave.stop(syncId);
                                        }
                                    } else if (cmd.equalsIgnoreCase("export")) {
                                        syncId = this.syncSave.start("Command.export");
                                        try {
                                            if (param != null && param.startsWith("-ROI")) {
                                                prefix = null;
                                                try {
                                                    st.nextToken();
                                                    prefix = st.nextToken();
                                                }
                                                catch (Exception e) {
                                                    prefix = null;
                                                }
                                                this.a.view.exportROI(prefix);
                                            }
                                            if (this.a.save == null) {
                                                this.a.save = new Save(this.a);
                                            }
                                            posFile = 0;
                                            vot = false;
                                            fits = false;
                                            hpx = false;
                                            finFile = -1;
                                            planID = st.nextToken();
                                            addXY = false;
                                            if (planID.charAt(0) == '-') {
                                                if (planID.indexOf("votable") > 0) {
                                                    vot = true;
                                                    if (planID.indexOf("flex") > 0) {
                                                        addXY = true;
                                                    }
                                                } else if (planID.indexOf("fits") > 0) {
                                                    fits = true;
                                                } else if (planID.indexOf("hpx") > 0) {
                                                    hpx = true;
                                                }
                                                planID = st.nextToken();
                                            }
                                            posFile = st.getPos();
                                            p = this.getNumber(planID);
                                            if (p == null) {
                                                tmp = "nothing to export";
                                                this.printConsole("!!! export error: " + tmp);
                                                dot = tmp;
                                                return dot;
                                            }
                                            if (param.endsWith(" votable") || param.endsWith(" VOTABLE") || param.endsWith(".xml") || param.endsWith(".XML")) {
                                                vot = true;
                                                if (param.endsWith(" votable") || param.endsWith(" VOTABLE")) {
                                                    finFile = param.length() - " votable".length();
                                                }
                                            } else if (param.endsWith("fits") || param.endsWith("FITS")) {
                                                fits = true;
                                                if (param.endsWith(" fits") || param.endsWith(" FITS")) {
                                                    finFile = param.length() - " fits".length();
                                                }
                                            } else if (param.endsWith("hpx") || param.endsWith("HPX")) {
                                                hpx = true;
                                                if (param.endsWith(" hpx") || param.endsWith(" HPX")) {
                                                    finFile = param.length() - " hpx".length();
                                                }
                                            }
                                            file = finFile == -1 ? s.substring(posFile) : s.substring(posFile, finFile);
                                            if ((file = Tok.unQuote(file.trim()).trim()).endsWith("fits") || file.endsWith("FITS")) {
                                                fits = true;
                                            } else if (file.endsWith("hpx") || file.endsWith("HPX")) {
                                                hpx = true;
                                            }
                                            if (p instanceof PlanMoc) {
                                                this.a.save.saveMoc(file, (PlanMoc)p, 0);
                                            }
                                            if (p.isCatalog()) {
                                                this.a.save.saveCatalog(file, p, vot == false, addXY);
                                            }
                                            if (p.isImage() && !(p instanceof PlanImageBlink)) {
                                                this.a.save.saveImage(file, p, hpx != false ? 1 : (fits != false ? 0 : 2));
                                            }
                                            tmp = "plane type [" + Plan.Tp[p.type] + "] not supported";
                                            this.printConsole("!!! export error: " + tmp);
                                            var24_163 = tmp;
                                            return var24_163;
                                        }
                                        catch (Exception e) {
                                            if (Aladin.levelTrace < 3) ** GOTO lbl1026
                                            e.printStackTrace();
                                        }
                                        finally {
                                            this.syncSave.stop(syncId);
                                        }
                                    } else if (cmd.equalsIgnoreCase("trace")) {
                                        if (param.equals("off") || param.equals("0")) {
                                            this.a.setTraceLevel(0);
                                            return "";
                                        }
                                        try {
                                            n = Integer.parseInt(param);
                                            if (n > 4 || n < 0) {
                                                n = 1;
                                            }
                                        }
                                        catch (Exception e) {
                                            n = 1;
                                        }
                                        this.a.setTraceLevel(n);
                                    } else if (cmd.equalsIgnoreCase("mem")) {
                                        this.a.gc();
                                        total = Runtime.getRuntime().totalMemory() / 0x100000L;
                                        free = Runtime.getRuntime().freeMemory() / 0x100000L;
                                        max = Runtime.getRuntime().maxMemory() / 0x100000L;
                                        this.printConsole("Total used memory: " + (int)(total - free) + "Mb (total=" + total + "Mb free=" + free + "Mb max=" + max + "Mb)\n");
                                    } else if (cmd.equalsIgnoreCase("gc")) {
                                        this.a.gc = !param.equals("off");
                                    } else if (cmd.equalsIgnoreCase("load")) {
                                        this.a.load(Tok.unQuote(param), label);
                                    } else if (cmd.equalsIgnoreCase("ptool")) {
                                        nom = st.nextToken();
                                        this.printConsole("Creating new PlanTool " + nom);
                                        this.a.calque.newPlanTool(nom);
                                        this.a.calque.repaintAll();
                                    } else if (cmd.equalsIgnoreCase("rep")) {
                                        p = st.nextToken();
                                        plan = this.getNumber(p);
                                        if (plan == null) {
                                            return "";
                                        }
                                        x = Integer.parseInt(st.nextToken());
                                        y = Integer.parseInt(st.nextToken());
                                        this.printConsole("Creating repere (" + x + "," + y + ") on plane " + p);
                                        repere = new Repere(plan, this.a.view.getCurrentView(), x, y);
                                        this.a.calque.setObjet(repere);
                                        this.a.calque.repaintAll();
                                    } else {
                                        if (cmd.equalsIgnoreCase("demo") || cmd.equalsIgnoreCase("robot")) {
                                            if (!Aladin.ROBOTSUPPORT) {
                                                Aladin.warning(Aladin.chaine.getString("NOROBOT"), 1);
                                                return "";
                                            }
                                            if (param.trim().equals("end") && this.robotInfo != null) {
                                                MyRobot.info("\n\n         T H E     E N D\n\n\n", this.a);
                                                this.robotInfo = null;
                                                this.robotMode = false;
                                                if (this.robot != null) {
                                                    this.robot.reset();
                                                }
                                            } else {
                                                this.robotMode = param.trim().equals("off") == false;
                                            }
                                            return "";
                                        }
                                        if (cmd.equals("xmatch")) {
                                            return this.execXMatchCmd(s, label);
                                        }
                                        if (cmd.equals("contour")) {
                                            p = (PlanImage)this.a.calque.getPlanBase();
                                            if (p == null || !p.flagOk) {
                                                this.printConsole("!!! contour error: no image ready !");
                                                return "";
                                            }
                                            if (p.type == 2 || p instanceof PlanImageBlink) {
                                                this.printConsole("!!! contour error: can't produce contours on this image");
                                                return "";
                                            }
                                            nbContours = 4;
                                            if (st.hasMoreTokens()) {
                                                p1 = st.nextToken();
                                                try {
                                                    nbContours = Integer.parseInt(p1);
                                                }
                                                catch (NumberFormatException e) {
                                                    this.printConsole("!!! contour error: incorrect or missing parameter");
                                                    return "";
                                                }
                                            }
                                            tmp = new int[nbContours];
                                            tmp = FrameContour.generateLevels(nbContours);
                                            levels = new double[nbContours];
                                            for (i = 0; i < levels.length; ++i) {
                                                levels[i] = tmp[i];
                                            }
                                            useSmoothing = true;
                                            currentZoomOnly = false;
                                            try {
                                                p2 = st.nextToken();
                                                if (p2.equals("smooth") || p2.equals("nosmooth")) {
                                                    useSmoothing = p2.equals("smooth") != false;
                                                    p3 = st.nextToken();
                                                    currentZoomOnly = p3.equals("zoom") != false;
                                                } else {
                                                    currentZoomOnly = p2.equals("zoom") != false;
                                                }
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                            this.a.calque.newPlanContour(label != null ? label : "Contours", null, levels, new ContourPlot(), useSmoothing, 2, currentZoomOnly, true, null);
                                        } else if (cmd.equals("filter")) {
                                            correctSyntax = "Syntax is : filter [filter name] on|off";
                                            nbParam = st.countTokens();
                                            if (nbParam == 1) {
                                                onOff = st.nextToken().toLowerCase();
                                                if (onOff.equals("on")) {
                                                    PlanFilter.activateAllFilters();
                                                } else if (onOff.equals("off")) {
                                                    PlanFilter.desactivateAllFilters();
                                                    PlanCatalog.desactivateAllDedicatedFilters(this.a);
                                                } else {
                                                    this.printConsole("!!! filter error: incorrect parameter \"" + onOff + "\"");
                                                    this.println(correctSyntax);
                                                }
                                            } else if (nbParam == 2) {
                                                fName = st.nextToken();
                                                onOff = st.nextToken().toLowerCase();
                                                pf = null;
                                                pf = PlanFilter.getFilterByName(fName, this.a);
                                                if (pf != null) {
                                                    if (onOff.equals("on")) {
                                                        pf.setActivated(true);
                                                        pf.updateState();
                                                        this.a.calque.select.repaint();
                                                    } else if (onOff.equals("off")) {
                                                        pf.setActivated(false);
                                                        pf.updateState();
                                                        this.a.calque.select.repaint();
                                                    } else {
                                                        this.printConsole("!!! filter error: incorrect parameter \"" + onOff + "\"");
                                                        this.println(correctSyntax);
                                                    }
                                                } else {
                                                    this.printConsole("!!! filter error: the filter " + fName + " does not exist");
                                                }
                                            } else {
                                                this.printConsole("!!! filter error: incorrect number of parameters");
                                                this.println(correctSyntax);
                                            }
                                        } else {
                                            if (this.a.plugins != null && this.a.plugins.findScript(cmd) != null) {
                                                st = new Tok(param);
                                                p = st.getStrings();
                                                return this.a.plugins.execPluginByScript(cmd, p);
                                            }
                                            if (this.execVar(s)) {
                                                return "";
                                            }
                                            return this.execGetCmd(s, label, false);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
lbl1026:
        // 95 sources

        return "";
    }

    private boolean execVar(String s) {
        return false;
    }

    private ViewSimple[] getViews(String param) {
        StringTokenizer st = new StringTokenizer(param);
        Vector<ViewSimple> tmp = new Vector<ViewSimple>();
        while (st.hasMoreTokens()) {
            int nview = this.getViewNumber(st.nextToken(), false);
            if (nview < 0) continue;
            tmp.addElement(this.a.view.viewSimple[nview]);
        }
        return tmp.toArray(new ViewSimple[tmp.size()]);
    }

    private void execViewCmd(String param, int cmd) {
        ViewSimple[] v = param.length() == 0 ? (cmd == 1 || cmd == 3 || cmd == 5 ? this.a.view.viewSimple : this.a.view.getSelectedView()) : this.getViews(param);
        block8: for (int i = 0; i < v.length; ++i) {
            if (v[i] == null || v[i].isFree()) continue;
            switch (cmd) {
                case 0: {
                    v[i].sticked = true;
                    continue block8;
                }
                case 1: {
                    v[i].sticked = false;
                    continue block8;
                }
                case 2: {
                    v[i].locked = true;
                    continue block8;
                }
                case 3: {
                    v[i].locked = false;
                    continue block8;
                }
                case 4: {
                    v[i].northUp = true;
                    continue block8;
                }
                case 5: {
                    v[i].northUp = false;
                }
            }
        }
        this.a.view.repaintAll();
    }

    protected PlanFilter createFilter(String def) {
        PlanFilter pf = (PlanFilter)this.a.calque.newPlanFilter(null, def);
        if (pf != null && pf.isValid()) {
            this.printConsole("Filter " + pf.label + " created");
            pf.setActivated(true);
            pf.updateState();
        } else {
            this.printConsole("!!! Bad filter syntax !");
            pf = null;
        }
        return pf;
    }

    private void execAddCol(String s) {
        int nbDec;
        s = s.trim();
        s = s.substring(6).trim();
        String syntax = "addcol : syntax is addcol plane,name,expr,unit,ucd,nb decimals";
        String[] param = new String[6];
        for (int i = 0; i < param.length; ++i) {
            param[i] = "";
        }
        StringTokenizer st = new StringTokenizer(s, ",", true);
        String oldToken = "";
        int i = 0;
        while (st.hasMoreTokens()) {
            String curToken = st.nextToken();
            if (curToken.equals(",")) {
                if (oldToken.equals(",")) {
                    param[i++] = "";
                }
            } else {
                param[i++] = curToken;
            }
            oldToken = curToken;
        }
        String plane = param[0].trim();
        String name = param[1].trim();
        String expr = param[2].trim();
        String unit = param[3].trim();
        String ucd = param[4].trim();
        try {
            nbDec = Integer.parseInt(param[5].trim());
        }
        catch (NumberFormatException e) {
            nbDec = 4;
        }
        Aladin.trace(3, "expr: " + expr);
        Plan plan = this.getNumber(plane);
        if (plan == null) {
            this.printConsole("!!! addcol error : plane " + plane + " is not in current stack");
            this.println(syntax);
            return;
        }
        if (!plan.isSimpleCatalog()) {
            this.printConsole("!!! addcol error : plane " + plane + " is not a catalogue plane");
            this.println(syntax);
            return;
        }
        PlanCatalog pc = (PlanCatalog)plan;
        if (FrameColumnCalculator.colExist(name, pc)) {
            this.printConsole("!!! addcol error : A column with label \"" + name + "\"already exists in this plane !");
            this.println(syntax);
            return;
        }
        SavotField f = new SavotField();
        f.setName(name);
        f.setUcd(ucd);
        f.setUnit(unit);
        ColumnCalculator cc = new ColumnCalculator(new SavotField[]{f}, new String[]{expr}, pc, nbDec, this.a);
        if (!cc.createParser()) {
            this.printConsole("!!! addcol error : " + cc.getError());
            this.println(syntax);
            return;
        }
        cc.compute();
    }

    protected void reset() {
        if (this.robotInfo != null && this.infoTxt != null) {
            this.infoTxt.setText("");
        }
    }

    protected void goTo(String param) {
        StringTokenizer st = new StringTokenizer(param);
        this.a.view.gotoThere(param);
    }

    public void setFunctionLocalDefinition(boolean flag) {
        this.functionLocalDefinition = flag;
    }

    public boolean getFunctionLocalDefinition() {
        return this.functionLocalDefinition;
    }

    public int getNbFunctions() {
        return this.function.size();
    }

    public Function getFunction(int i) {
        if (this.function == null || i < 0 || i >= this.function.size()) {
            return null;
        }
        return this.function.get(i);
    }

    public Function getFunction(String name) {
        int i = this.findFunction(name);
        return i < 0 ? null : this.getFunction(i);
    }

    private int findFunction(String name) {
        for (int i = 0; i < this.function.size(); ++i) {
            if (!this.function.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void addFunction(Function f) {
        String name = f.getName();
        f.setLocalDefinition(this.functionLocalDefinition);
        int i = this.findFunction(name);
        if (i >= 0) {
            this.function.set(i, f);
        } else {
            this.function.add(f);
        }
        this.functionModif = true;
    }

    public void removeFunction(Function f) {
        int i = this.findFunction(f.getName());
        if (i < 0) {
            return;
        }
        this.function.remove(i);
        this.functionModif = true;
    }

    public void setFunctionModif(boolean flag) {
        this.functionModif = flag;
        for (Function f : this.function) {
            if (!f.isLocalDefinition()) continue;
            f.setModif(false);
        }
    }

    public boolean functionModif() {
        if (this.functionModif) {
            return true;
        }
        for (Function f : this.function) {
            if (!f.isLocalDefinition() || !f.hasBeenModif()) continue;
            return true;
        }
        return false;
    }

    private String convertAdjust(String s) {
        if (s.indexOf("convert") == 0) {
            return s;
        }
        int n = s.indexOf(" to ");
        if (n <= 0) {
            return s;
        }
        return "convert " + s.substring(0, n) + " to " + s.substring(n + 4);
    }

    private String execConvert(String s) {
        String res;
        if (s.trim().length() == 0) {
            StringBuffer s1 = new StringBuffer();
            Enumeration e1 = Unit.symbols();
            while (e1.hasMoreElements()) {
                String k = (String)e1.nextElement();
                String d = Unit.explainUnit(k);
                s1.append(k + " - " + d + "\n");
            }
            res = s1.toString();
            this.print(res);
            this.a.console.printInPad(res);
        } else {
            char c;
            int m;
            int n = s.indexOf(" to ");
            String from = s.substring(0, n);
            for (m = from.length() - 1; m > 0 && !Character.isDigit(c = from.charAt(m)) && c != ')'; --m) {
            }
            String to = s.substring(n + 4);
            try {
                from = Computer.compute(from.substring(0, m + 1)) + from.substring(m + 1);
                Unit m1 = new Unit(from);
                Unit m2 = new Unit();
                m2.setUnit(to);
                m1.convertTo(m2);
                res = m1.getValue() + " " + m1.getUnit();
            }
            catch (Exception e) {
                res = "!!! Conversion error [" + e.getMessage() + "]";
            }
            this.a.localisation.setTextSaisie(res);
            this.a.console.printInPad(s + "\n = " + res + "\n");
        }
        return res;
    }

    private String execEval(String p) {
        String res;
        if (p.trim().length() == 0) {
            res = Computer.help();
            this.print(res);
            this.a.console.printInPad(res);
        } else {
            try {
                res = Computer.compute(p) + "";
            }
            catch (Exception e) {
                res = "!!! Eval error [" + e.getMessage() + "]";
            }
            this.a.localisation.setTextSaisie(res);
            this.a.console.printInPad(p + "\n = " + res + "\n");
        }
        return res;
    }

    private String evalAdjust(String s) {
        int n = s.length();
        if (n == 0 || s.charAt(0) != '=' && s.charAt(n - 1) != '=') {
            return s;
        }
        if (s.charAt(0) == '=' && !Character.isSpace(s.charAt(1))) {
            return "= " + s.substring(1);
        }
        if (s.charAt(n - 1) == '=' && !s.startsWith("http://")) {
            return "= " + s.substring(0, n - 1).trim();
        }
        return s;
    }

    private String execFunction(String p) {
        try {
            Function f;
            String name = p;
            String param = "";
            int i = p.indexOf(40);
            if (i > 0) {
                name = p.substring(0, i);
                int j = p.lastIndexOf(41);
                param = p.substring(i + 1, j);
            }
            if ((f = this.getFunction(name)) == null) {
                return "Function unknown [" + name + "]";
            }
            return f.exec(this.a, param, false);
        }
        catch (Exception e) {
            return "Function syntax error [" + p + "]";
        }
    }

    private String listFunction(String mask) {
        try {
            boolean verbose = false;
            if (mask != null && mask.length() > 0) {
                verbose = true;
            } else {
                mask = null;
            }
            StringBuffer s = new StringBuffer(1000);
            for (Function f : this.function) {
                String name = f.getName();
                if (mask != null && !Util.matchMask(mask, f.getName())) continue;
                if (verbose) {
                    s.append(f + "\n");
                    continue;
                }
                s.append(name + (f.getDescription().length() > 0 ? " - " + f.getDescription() : "") + "\n");
            }
            this.print(s.toString());
            this.a.console.printInPad(s.toString());
            return s.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public void resetBookmarks() {
        if (this.function == null) {
            return;
        }
        Iterator<Function> e = this.function.iterator();
        while (e.hasNext()) {
            e.next().setBookmark(false);
        }
    }

    public Vector<Function> getBookmarkFunctions() {
        return this.getFunctions(0);
    }

    protected Vector<Function> getLocalFunctions() {
        return this.getFunctions(1);
    }

    private Vector<Function> getFunctions(int mode) {
        Vector<Function> v = new Vector<Function>(10);
        if (this.getNbFunctions() == 0) {
            return v;
        }
        for (Function f : this.function) {
            if (mode == 0 && f.isBookmark()) {
                v.addElement(f);
                continue;
            }
            if (mode != 1 || !f.isLocalDefinition()) continue;
            v.addElement(f);
        }
        return v;
    }

    protected void testscript(String param) {
        this.a.console.setVisible(true);
        this.a.console.clearPad();
        this.a.console.printInPad(this.TEST.replace(';', '\n'));
        this.execScript(this.TEST);
        this.a.glu.showDocument("Http", "http://aladin.u-strasbg.fr/java/Testscript.jpg", true);
    }

    protected void testnet() {
        block3: {
            Plan p = this.a.calque.getPlanBase();
            if (!(p instanceof PlanBG)) {
                this.a.console.printError("testnet only on HiPS");
                return;
            }
            try {
                ((PlanBG)p).testnet();
            }
            catch (Exception e) {
                this.a.console.printError("testnet error: " + e.getMessage());
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
    }

    private void testperf(final String param) {
        long GB = 0x40000000L;
        new Thread(){

            @Override
            public void run() {
                String filename = param == null || param.trim().length() == 0 ? "AladinTestDisk.tmp" : param;
                File file = new File(filename);
                try {
                    long size;
                    if (file.exists()) {
                        if (param == null || param.trim().length() == 0) {
                            file.delete();
                        } else {
                            if (!file.isDirectory()) {
                                Command.this.printConsole("!!! testperf error: test file is already existing [" + param + "]");
                                return;
                            }
                            file = new File(filename = Util.concatDir(filename, "AladinTestDisk.tmp"));
                            if (file.exists()) {
                                file.delete();
                            }
                        }
                    }
                    byte[] buf = new byte[512];
                    for (int i = 0; i < buf.length; ++i) {
                        buf[i] = (byte)i;
                    }
                    int cpt = 0;
                    Command.this.print("testperf disk writing...");
                    long t = System.currentTimeMillis();
                    RandomAccessFile f = new RandomAccessFile(filename, "rw");
                    for (size = 0x40000000L; size > 0L; size -= (long)buf.length) {
                        f.write(buf);
                        if ((cpt += buf.length) < 0xA00000) continue;
                        Command.this.print(".");
                        cpt = 0;
                    }
                    Command.this.println("");
                    f.close();
                    long msw = System.currentTimeMillis() - t;
                    double debitw = 1.073741824E9 / ((double)msw / 1000.0) / 1048576.0;
                    Command.this.print("testperf disk reading...");
                    t = System.currentTimeMillis();
                    f = new RandomAccessFile(filename, "rw");
                    for (size = f.length(); size > 0L; size -= (long)buf.length) {
                        f.read(buf);
                        if ((cpt += buf.length) < 0xA00000) continue;
                        Command.this.print(".");
                        cpt = 0;
                    }
                    Command.this.println("");
                    f.close();
                    long msr = System.currentTimeMillis() - t;
                    double debitr = 1.073741824E9 / ((double)msr / 1000.0) / 1048576.0;
                    double debitmw = 0.0;
                    try {
                        int j;
                        Command.this.println("testperf memory...");
                        long MEM = 0x10000000L;
                        int NBTEST = 10;
                        buf = new byte[(int)MEM];
                        for (j = 0; j < buf.length; ++j) {
                            buf[j] = (byte)j;
                        }
                        t = System.currentTimeMillis();
                        for (int i = 0; i < NBTEST; ++i) {
                            for (int j2 = 0; j2 < buf.length; ++j2) {
                                buf[j2] = (byte)(buf[j2] + j2);
                            }
                        }
                        size = 0L;
                        for (j = 0; j < buf.length; ++j) {
                            size += (long)buf[j];
                        }
                        Command.this.println("Optimiser obfuscator...(" + size + ")...");
                        long msmw = System.currentTimeMillis() - t;
                        debitmw = (double)MEM / ((double)msmw / 1000.0) / 1.073741824E9 * (double)NBTEST;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Command.this.printConsole("testperf: Disk: w=" + Util.myRound(debitw) + "MB/s r=" + Util.myRound(debitr) + "MB/s" + " - Memory: r/w=" + Util.myRound(debitmw) + "GB/s");
                    file.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    file.delete();
                }
            }
        }.start();
    }

    private long testDiskFlush(File dir, long size) {
        if (size <= 0L) {
            return size;
        }
        File[] f = dir.listFiles();
        for (int i = 0; f != null && i < f.length; ++i) {
            if (f[i].isDirectory()) {
                size = this.testDiskFlush(f[i], size);
            } else {
                if (f[i].length() < 0x100000L) continue;
                try {
                    RandomAccessFile a = new RandomAccessFile(f[i], "r");
                    byte[] buf = new byte[512];
                    for (long length = a.length(); length > 0L; length -= (long)buf.length) {
                        a.read(buf, 0, length > (long)buf.length ? buf.length : (int)length);
                    }
                    size -= a.length();
                    a.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (size > 0L) continue;
            return size;
        }
        return size;
    }

    protected void testCalib(String label, String param, int mode) {
        boolean flagImg;
        int w = 50;
        int h = 30;
        int bitpix = 16;
        Coord coo = new Coord();
        double szPixel = 0.016666666666666666;
        int type = 2;
        boolean flagCat = mode == 1 || mode == 2;
        boolean bl = flagImg = mode == 0 || mode == 2;
        if (label == null) {
            label = "Test";
        }
        try {
            StringTokenizer st = new StringTokenizer(param);
            w = Integer.parseInt(st.nextToken());
            h = Integer.parseInt(st.nextToken());
            String s = st.nextToken() + " " + st.nextToken();
            coo = new Coord(s);
            szPixel = Double.parseDouble(st.nextToken()) / 60.0;
            type = Calib.getProjType(st.nextToken()) - 1;
            if (type < 0) {
                type = 2;
            }
            bitpix = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            // empty catch block
        }
        String fileImg = "Test.fits";
        String fileCat = "Test.txt";
        String s = "Calibration grid test:\n" + (flagCat ? "- Catalog file: " + fileCat + "\n" + "   .catalog size        : " + w * h / 25 + " objects\n" + "   .Dist. between ojects: " + szPixel * 300.0 + "\"\n" : "") + (flagImg ? "- Image file  : " + fileImg + "\n" + "   .bitpix              : " + bitpix + "\n" + "   .Image size          : " + w + "x" + h + "\n" + "   .Central coord       : " + coo + "\n" + "   .Pixel size          : " + szPixel * 60.0 + "\"\n" + "   .Projection          : " + Calib.projType[type] : "");
        System.out.println(s);
        if (flagImg) {
            this.createFitsTest(fileImg, w, h, bitpix, coo.al, coo.del, szPixel, type);
            this.a.load(fileImg, label);
        }
        if (flagCat) {
            this.createTSVTest(fileCat, w, h, coo.al, coo.del, szPixel);
            this.a.load(fileCat, label + (mode == 2 ? " cat" : ""));
        }
    }

    protected void createTSVTest(String file, int width, int height, double raj, double dej, double pxSize) {
        try {
            int cx = width / 2 - 1;
            int cy = height / 2 - 1;
            double pxDegSize = pxSize / 60.0;
            Astrocoo c = new Astrocoo();
            int nl = 1;
            File g = new File(this.a.getDefaultDirectory() + Util.FS + file);
            g.delete();
            RandomAccessFile gf = new RandomAccessFile(g, "rw");
            StringBuffer s = new StringBuffer();
            s.append("RA\tDEC\tX Fits\tY Fits\tSexa\n");
            for (int lig = 0; lig < height; ++lig) {
                double del = dej + (double)(lig - cy) * pxDegSize;
                double cosd = Math.cos(del * Math.PI / 180.0);
                for (int col = 0; col < width; ++col) {
                    if ((col - cx) % 5 != 0 || (lig - cy) % 5 != 0) continue;
                    double al = (raj + (double)(col - cx) * pxDegSize) / cosd;
                    if (del > 90.0) {
                        del = 180.0 - del;
                        al += 180.0;
                    }
                    if (del < -90.0) {
                        del = -180.0 - del;
                        al += 180.0;
                    }
                    if (al < 0.0) {
                        al += 360.0;
                    } else if (al > 360.0) {
                        al -= 360.0;
                    }
                    c.set(al, del);
                    s.append(c.getLon() + "\t" + c.getLat() + "\t" + (col + 1) + "\t" + (lig + 1) + "\t" + c.toString("2s") + "\n");
                    if (++nl != 1000) continue;
                    this.writeString(gf, s.toString());
                    nl = 0;
                    s = new StringBuffer();
                }
            }
            if (nl != 0) {
                this.writeString(gf, s.toString());
            }
            gf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeString(RandomAccessFile gf, String s) throws Exception {
        char[] a = s.toString().toCharArray();
        byte[] b = new byte[a.length];
        for (int j = 0; j < a.length; ++j) {
            b[j] = (byte)a[j];
        }
        gf.write(b);
    }

    protected void createFitsTest(String file, int width, int height, int bitpix, double raj, double dej, double pxSize, int type) {
        try {
            double rm = pxSize * (double)width;
            double rm1 = pxSize * (double)height;
            int cx = width / 2;
            int cy = height / 2;
            Projection p = new Projection("Test", 3, raj, dej, rm, rm1, (double)cx - 0.5, (double)cy - 0.5, width, height, 0.0, true, type, Calib.FK5);
            File g = new File(this.a.getDefaultDirectory() + Util.FS + file);
            g.delete();
            RandomAccessFile gf = new RandomAccessFile(g, "rw");
            Vector key = new Vector(20);
            Vector value = new Vector(20);
            try {
                p.getWCS(key, value);
            }
            catch (Exception e) {
                System.err.println("GetWCS error");
            }
            Vector<byte[]> v = new Vector<byte[]>();
            v.addElement(Save.getFitsLine("SIMPLE", "T", "Aladin image test"));
            v.addElement(Save.getFitsLine("BITPIX", bitpix + "", null));
            v.addElement(Save.getFitsLine("NAXIS", "2", null));
            Enumeration ekey = key.elements();
            Enumeration evalue = value.elements();
            while (ekey.hasMoreElements()) {
                String skey = (String)ekey.nextElement();
                String svalue = (String)evalue.nextElement();
                v.addElement(Save.getFitsLine(skey, svalue, ""));
            }
            long size = 0L;
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                byte[] b = (byte[])e.nextElement();
                gf.write(b);
                size += (long)b.length;
            }
            byte[] end = new byte[]{69, 78, 68};
            gf.write(end);
            byte[] bb = new byte[2880 - (int)(size += 3L) % 2880];
            for (int i = 0; i < bb.length; ++i) {
                bb[i] = 32;
            }
            gf.write(bb);
            int n = Math.abs(bitpix) / 8;
            boolean flagHuge = (long)(width * height * n) > Aladin.LIMIT_HUGEFILE;
            byte[] out = new byte[width * n * (flagHuge ? 1 : height)];
            --cx;
            --cy;
            double fct = (double)(width + height) / 1600.0;
            int pos = 0;
            for (int lig = 0; lig < height; ++lig) {
                for (int col = 0; col < width; ++col) {
                    double c;
                    double d = lig == cy && col == cx ? 900.0 : (lig == cy || col == cx ? 700.0 : (lig > cy - 100 && lig < cy && col > cx && col < cx + 100 ? -100.0 : ((lig - cy) % 100 == 0 || (col - cx) % 100 == 0 ? 500.0 : ((lig - cy) % 10 == 0 || (col - cx) % 10 == 0 ? 300.0 : ((lig - cy) % 5 == 0 || (col - cx) % 5 == 0 ? 200.0 : (lig < cy && col < cx ? (double)(lig + col) / fct - 100.0 : (c = lig % 2 == 0 || col % 2 == 0 ? 0.0 : -100.0)))))));
                    if (bitpix == 8) {
                        c = (c + 100.0) / 4.0;
                    }
                    PlanImage.setPixVal(out, bitpix, pos++, c);
                }
                if (!flagHuge) continue;
                gf.write(out);
                pos = 0;
            }
            if (!flagHuge) {
                int sens = 1;
                int ik = 1;
                for (int col = 10; col < 100; col += 10) {
                    int lig = col;
                    double[][] k = this.a.kernelList.getKernel(ik);
                    if ((ik += sens) == 6) {
                        sens = -1;
                        ik = 5;
                    }
                    if (ik == 0) break;
                    int m = k[0].length;
                    for (int lk = 0; lk < m; ++lk) {
                        for (int ck = 0; ck < m; ++ck) {
                            double c = k[lk][ck] * 1000.0 - 100.0;
                            if (bitpix == 8) {
                                c = (c + 100.0) / 4.0;
                            }
                            int x = cx + (col - m / 2 + ck);
                            int y = cy - (lig - m / 2 + lk);
                            if (y < height && y >= 0 && x < width && x >= 0) {
                                PlanImage.setPixVal(out, bitpix, y * width + x, c);
                            }
                            x = cx + (col - m / 2 + ck);
                            y = cy - (100 - (lig - m / 2 + lk));
                            if (y >= height || y < 0 || x >= width || x < 0) continue;
                            PlanImage.setPixVal(out, bitpix, y * width + x, c);
                        }
                    }
                }
                gf.write(out);
            }
            gf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hop() {
        try {
            AladinData adRef = Aladin.aladin.getAladinData("toto");
            Iterator<Obj> itRef = adRef.iteratorObj();
            while (itRef.hasNext()) {
                Obj objRef = itRef.next();
                double ra = objRef.getRa();
                double dec = objRef.getDec();
                System.out.println(ra + " | " + dec);
                objRef.setRaDec(ra + 0.1, dec + 0.1);
            }
            adRef.repaint();
        }
        catch (AladinException e) {
            e.printStackTrace();
        }
    }

    static {
        drawMode = DRAWRADEC = 1;
        CMD = new String[]{"addcol", "backup", "bitpix", "blink", "call", "cm", "collapse", "conv", "contour", "coord", "copy", "cplane", "cview", "crop", "demo", "draw", "expand", "export", "filter", "moreonfilter", "function", "flipflop", "get", "grey", "grid", "help", "hide", "hist", "info", "kernel", "list", "load", "lock", "macro", "md", "mem", "northup", "match", "mosaic", "mv", "norm", "overlay", "pause", "print", "quit", "resamp", "reset", "reticle", "RGB", "RGBdiff", "rm", "save", "scale", "search", "select", "set", "setconf", "show", "status", "sync", "tag", "thumbnail", "trace", "unlock", "untag", "xmatch", "moreonxmatch", "zoom", "+", "-", "*", "/", "="};
        NOSYNCCMD = new String[]{"call", "collapse", "demo", "expand", "function", "=", "get", "grid", "help", "hist", "info", "list", "kernel", "load", "lock", "md", "mem", "pause", "reticle", "scale", "status", "stick", "sync", "timeout", "trace", "unlock", "unstick"};
        UNIT = new String[]{"m", "arcmin", "'", "s", "sec", "\"", "d", "deg", "\u00b0"};
    }
}

