/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.astro.Astrocoo;
import cds.astro.Astroframe;
import cds.astro.Ecliptic;
import cds.astro.FK4;
import cds.astro.FK5;
import cds.astro.Galactic;
import cds.astro.ICRS;
import cds.astro.Supergal;
import cds.fits.HeaderFits;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import healpix.essentials.FastMath;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Calib
implements Cloneable {
    int aladin;
    double[] xyapoly = new double[10];
    double[] xydpoly = new double[10];
    double[] adypoly = new double[10];
    double[] adxpoly = new double[10];
    double[][] sip_a = new double[10][10];
    int order_a;
    double[][] sip_b = new double[10][10];
    int order_b;
    double[][] sip_ap = new double[10][10];
    int order_ap;
    double[][] sip_bp = new double[10][10];
    int order_bp;
    double epoch;
    int flagepoc = 0;
    double equinox;
    double alpha;
    double delta;
    double yz;
    double xz;
    double focale;
    double Xorg;
    double Yorg;
    double incX;
    double incY;
    double alphai;
    double deltai;
    double incA;
    double incD;
    double Xcen;
    double Ycen;
    double widtha;
    double widthd;
    int xnpix;
    int ynpix;
    double rota;
    double cdelz;
    double sdelz;
    String type1;
    String type2;
    double[][] CD = new double[2][2];
    double[][] ID = new double[2][2];
    public static int FK4 = 1;
    public static int GALACTIC = 2;
    public static int SUPERGALACTIC = 3;
    public static int ECLIPTIC = 4;
    public static int FK5 = 5;
    public static int ICRS = 6;
    public static int XYLINEAR = 7;
    static final String[] RADECSYS = new String[]{"", "FK4", "", "", "", "FK5", "ICRS", ""};
    protected int system = ICRS;
    protected int proj;
    private static double deg_to_rad = Math.PI / 180;
    private static double rad_to_deg = 57.29577951308232;
    static String[] WCSKeys = new String[]{"NAXIS1", "NAXIS2", "CRPIX1", "CRPIX2", "CRVAL1", "CRVAL2", "CD1_1", "CD1_2", "CD2_1", "CD2_1", "CD2_2", "CDELT1", "CDELT2", "CROTA1", "CROTA2", "PC001001", "PC001002", "PC002001", "PC002002", "EPOCH", "EQUINOX", "EPOCH", "CTYPE1", "CTYPE2", "RADECSYS", "PLTRAM", "PLTRAH", "PLTDECSN", "PLTDECS", "PLTDECM", "PLTDECD", "PLTSCALE", "PPO3", "PPO6", "AMDX1", "AMDY1", "AMDX2", "AMDY2", "AMDX3", "AMDY3", "AMDX4", "AMDY4", "AMDX5", "AMDY5", "AMDX6", "AMDY6", "AMDX7", "AMDY8", "AMDY8", "AMDX9", "AMDY9", "AMDX10", "AMDY10", "AMDX11", "AMDY11", "AMDX12", "AMDY12", "XPIXELSZ", "YPIXELSZ", "CNPIX1", "CNPIX2"};
    public static final int SIN = 1;
    public static final int TAN = 2;
    public static final int ARC = 3;
    public static final int AIT = 4;
    public static final int ZEA = 5;
    public static final int STG = 6;
    public static final int CAR = 7;
    public static final int NCP = 8;
    public static final int ZPN = 9;
    public static final int SOL = 10;
    public static final int MOL = 11;
    public static final int SIP = 12;
    static final String[] projType = new String[]{"", "SIN", "TAN", "ARC", "AIT", "ZEA", "STG", "CAR", "NCP", "ZPN", "SOL", "MOL", "TAN-SIP"};
    private static Astroframe AF_FK4 = new FK4();
    private static Astroframe AF_FK5 = new FK5();
    private static Astroframe AF_ICRS = new ICRS();
    private static Astroframe AF_GAL = new Galactic();
    private static Astroframe AF_SGAL = new Supergal();
    private static Astroframe AF_ECL = new Ecliptic();
    static double[][] testCenter = new double[][]{{0.0, 0.0}, {15.0, -1.0}, {259.9, 89.99}, {0.1, -89.99}};
    static double EPSILON = 2.7777777777777777E-10;

    public long getMem() {
        return 3672L;
    }

    static int getProjType(String s) {
        return Util.indexInArrayOf(s, projType);
    }

    static int getSubProjType(String s1) {
        int i = Calib.getProjType(s1);
        if (i >= 0) {
            return i;
        }
        String[] array = projType;
        String s = s1.toUpperCase();
        for (i = 1; i < array.length; ++i) {
            if (s.indexOf(array[i]) < 0) continue;
            Aladin.aladin.command.printConsole("!!! Unknown projection [" + s1 + "] : assume " + projType[i]);
            return i;
        }
        if (s.indexOf("TNX") >= 0 || s.indexOf("COE") >= 0) {
            i = 2;
            Aladin.aladin.command.printConsole("!!! Unknown projection [" + s1 + "] : assume " + projType[i]);
            return i;
        }
        return -1;
    }

    static String getProjName(int indice) {
        return projType[indice];
    }

    public static Calib copy(Calib c) {
        int i;
        Calib a = new Calib();
        a.aladin = c.aladin;
        a.xyapoly = new double[11];
        System.arraycopy(c.xyapoly, 0, a.xyapoly, 0, 10);
        a.xydpoly = new double[11];
        System.arraycopy(c.xydpoly, 0, a.xydpoly, 0, 10);
        a.adypoly = new double[11];
        System.arraycopy(c.adypoly, 0, a.adypoly, 0, 10);
        a.adxpoly = new double[11];
        System.arraycopy(c.adxpoly, 0, a.adxpoly, 0, 10);
        a.epoch = c.epoch;
        a.flagepoc = c.flagepoc;
        a.equinox = c.equinox;
        a.alpha = c.alpha;
        a.delta = c.delta;
        a.yz = c.yz;
        a.xz = c.xz;
        a.focale = c.focale;
        a.Xorg = c.Xorg;
        a.Yorg = c.Yorg;
        a.incX = c.incX;
        a.incY = c.incY;
        a.alphai = c.alphai;
        a.deltai = c.deltai;
        a.incA = c.incA;
        a.incD = c.incD;
        a.Xcen = c.Xcen;
        a.Ycen = c.Ycen;
        a.widtha = c.widtha;
        a.widthd = c.widthd;
        a.xnpix = c.xnpix;
        a.ynpix = c.ynpix;
        a.rota = c.rota;
        a.cdelz = c.cdelz;
        a.sdelz = c.sdelz;
        a.type1 = c.type1;
        a.type2 = c.type2;
        a.CD = new double[2][2];
        for (i = 0; i < 2; ++i) {
            System.arraycopy(c.CD[i], 0, a.CD[i], 0, 2);
        }
        a.ID = new double[2][2];
        for (i = 0; i < 2; ++i) {
            System.arraycopy(c.ID[i], 0, a.ID[i], 0, 2);
        }
        a.system = c.system;
        a.proj = c.proj;
        return a;
    }

    public static String[] getWCSKeys() {
        return WCSKeys;
    }

    public Calib flipBU() {
        Calib a = new Calib();
        try {
            a = (Calib)this.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.aladin == 1) {
            a.Yorg += (double)this.ynpix * a.incY;
            a.incY = -a.incY;
        } else {
            a.CD[1][1] = -a.CD[1][1];
            a.CD[0][1] = -a.CD[0][1];
            a.ID[1][1] = -a.ID[1][1];
            a.ID[1][0] = -a.ID[1][0];
            a.Ycen = (double)a.ynpix - (a.Ycen - 1.0);
        }
        return a;
    }

    public Calib flipRL() {
        Calib b = new Calib();
        try {
            b = (Calib)this.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.aladin == 1) {
            b.Xorg += (double)this.xnpix * b.incX;
            b.incX = -b.incX;
        } else {
            b.CD[1][0] = -b.CD[1][0];
            b.CD[0][0] = -b.CD[0][0];
            b.ID[0][1] = -b.ID[0][1];
            b.ID[0][0] = -b.ID[0][0];
            b.Xcen = (double)b.xnpix - (b.Xcen - 1.0);
        }
        return b;
    }

    public Calib resize(int scale) {
        if (this.aladin == 1) {
            try {
                this.GetWCS_i();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        double X_cen = this.Xcen / (double)scale;
        double Y_cen = this.Ycen / (double)scale;
        int xpix = this.xnpix / scale;
        int ypix = this.ynpix / scale;
        double cd00 = this.CD[0][0] * (double)scale;
        double cd01 = this.CD[0][1] * (double)scale;
        double cd10 = this.CD[1][0] * (double)scale;
        double cd11 = this.CD[1][1] * (double)scale;
        Calib newcal = new Calib(this.alphai, this.deltai, X_cen, Y_cen, xpix, ypix, cd00, cd01, cd10, cd11, this.equinox, this.epoch, this.proj);
        return newcal;
    }

    public Calib resize(int scale, double cx, double cy, int xpix, int ypix) {
        double X_cen = (this.Xcen - cx) * (double)scale;
        double Y_cen = (this.Ycen - cy) * (double)scale;
        double cd00 = this.CD[0][0] / (double)scale;
        double cd01 = this.CD[0][1] / (double)scale;
        double cd10 = this.CD[1][0] / (double)scale;
        double cd11 = this.CD[1][1] / (double)scale;
        Calib newcal = new Calib(this.alphai, this.deltai, X_cen, Y_cen, xpix *= scale, ypix *= scale, cd00, cd01, cd10, cd11, this.equinox, this.epoch, this.proj);
        return newcal;
    }

    public Calib recalibrate(Coord[] coo) {
        double A = 0.0;
        double B = 0.0;
        double x = 0.0;
        double y = 0.0;
        double X = 0.0;
        double Y = 0.0;
        double z = 0.0;
        double XxYy = 0.0;
        double XyYx = 0.0;
        double x0 = 0.0;
        double y0 = 0.0;
        int sign1 = 0;
        int sign2 = 0;
        int i = 0;
        try {
            double det;
            if (this.aladin == 1) {
                this.GetWCS_i();
                det = this.CD[0][0] * this.CD[1][1] - this.CD[0][1] * this.CD[1][0];
                this.ID[0][0] = this.CD[1][1] / det;
                this.ID[0][1] = -this.CD[0][1] / det;
                this.ID[1][0] = -this.CD[1][0] / det;
                this.ID[1][1] = this.CD[0][0] / det;
                this.incA = Math.sqrt(this.CD[0][0] * this.CD[0][0] + this.CD[0][1] * this.CD[0][1]);
                this.incD = Math.sqrt(this.CD[1][0] * this.CD[1][0] + this.CD[1][1] * this.CD[1][1]);
                this.widtha = (double)this.xnpix * Math.abs(this.incA);
                this.widthd = (double)this.ynpix * Math.abs(this.incD);
                this.cdelz = FastMath.cos(this.deltai * deg_to_rad);
                this.sdelz = FastMath.sin(this.deltai * deg_to_rad);
                this.aladin = 0;
            }
            double inx = coo[0].dx;
            double iny = coo[0].dy;
            double inX = coo[0].xstand;
            double inY = coo[0].ystand;
            double AAx = 0.0;
            double BBx = 0.0;
            double AAy = 0.0;
            double BBy = 0.0;
            for (i = 1; i < coo.length; ++i) {
                this.GetXYstand(coo[i]);
                double Detx = -coo[i].dx * iny + coo[i].dy * inx;
                if (Detx != 0.0) {
                    AAx += (-iny * coo[i].xstand + inX * coo[i].dy) / Detx;
                    BBx += (-coo[i].dx * inX + coo[i].xstand * inx) / Detx;
                    double Dety = coo[i].dx * iny - coo[i].dy * inx;
                    AAy += (inY * coo[i].dx - inx * coo[i].ystand) / Dety;
                    BBy += (coo[i].ystand * iny - coo[i].dy * inY) / Dety;
                }
                inx = coo[i].dx;
                iny = coo[i].dy;
                inX = coo[i].xstand;
                inY = coo[i].ystand;
            }
            sign1 = AAx < 0.0 ? -1 : 1;
            sign2 = AAy < 0.0 ? -1 : 1;
            for (i = 1; i < coo.length; ++i) {
                this.GetXYstand(coo[i]);
                x += (double)sign1 * coo[i].dx;
                y += (double)sign2 * coo[i].dy;
                X += coo[i].xstand;
                Y += coo[i].ystand;
                z += coo[i].dx * coo[i].dx + coo[i].dy * coo[i].dy;
                XxYy += (double)sign1 * coo[i].dx * coo[i].xstand + (double)sign2 * coo[i].dy * coo[i].ystand;
                XyYx += (double)(-sign1) * coo[i].dx * coo[i].ystand + (double)sign2 * coo[i].dy * coo[i].xstand;
            }
            double b1 = X / (double)coo.length;
            double b2 = Y / (double)coo.length;
            double b3 = XxYy / (double)coo.length;
            double b4 = XyYx / (double)coo.length;
            double c1 = x * x * x + x * (y /= (double)coo.length) * y - (x /= (double)coo.length) * (z /= (double)coo.length);
            double c2 = x * x * y + y * y * y - y * z;
            double c3 = -x * x - y * y + z;
            double c4 = -x * x * z - y * y * z + z * z;
            det = x * x * x * x + 2.0 * x * x * y * y + y * y * y * y - 2.0 * x * x * z - 2.0 * y * y * z + z * z;
            A = (b1 * c1 + b2 * c2 + b3 * c3) / det;
            B = (-b2 * c1 + b1 * c2 + b4 * c3) / det;
            x0 = (b3 * c1 + b4 * c2 + b1 * c4) / det;
            y0 = (-b4 * c1 + b3 * c2 + b2 * c4) / det;
            double X_cen = this.Xcen + (double)sign1 * (-A * x0 + B * y0) / (A * A + B * B);
            double Y_cen = this.Ycen + (double)sign2 * (-B * x0 - A * y0) / (A * A + B * B);
            double CD00 = (double)sign1 * A * rad_to_deg;
            double CD10 = (double)(-sign1) * B * rad_to_deg;
            double CD01 = (double)sign2 * B * rad_to_deg;
            double CD11 = (double)sign2 * A * rad_to_deg;
            Calib newcal = new Calib(this.alphai, this.deltai, X_cen, Y_cen, this.xnpix, this.ynpix, CD00, CD01, CD10, CD11, this.equinox, this.epoch, this.proj);
            return newcal;
        }
        catch (Exception e) {
            return this;
        }
    }

    public Calib(double ra, double de, double cx, double cy, int xpix, int ypix, double cd00, double cd01, double cd10, double cd11, double equin, double epo, int proje) {
        this.aladin = 0;
        this.xnpix = xpix;
        this.ynpix = ypix;
        this.Xcen = cx;
        this.Ycen = cy;
        this.alphai = ra;
        this.deltai = de;
        this.CD[0][0] = cd00;
        this.CD[0][1] = cd01;
        this.CD[1][0] = cd10;
        this.CD[1][1] = cd11;
        this.equinox = equin;
        this.epoch = epo;
        this.proj = proje;
        this.incA = Math.sqrt(this.CD[0][0] * this.CD[0][0] + this.CD[0][1] * this.CD[0][1]) * (this.CD[0][0] / Math.abs(this.CD[0][0]));
        this.incD = Math.sqrt(this.CD[1][0] * this.CD[1][0] + this.CD[1][1] * this.CD[1][1]) * (this.CD[1][1] / Math.abs(this.CD[1][1]));
        this.rota = Math.atan2(this.CD[0][1] / this.incA, this.CD[1][1] / this.incD) * 57.29577951308232;
        this.widtha = (double)this.xnpix * Math.abs(this.incA);
        this.widthd = (double)this.ynpix * Math.abs(this.incD);
        this.cdelz = FastMath.cos(this.deltai * deg_to_rad);
        this.sdelz = FastMath.sin(this.deltai * deg_to_rad);
        double det = this.CD[0][0] * this.CD[1][1] - this.CD[0][1] * this.CD[1][0];
        this.ID[0][0] = this.CD[1][1] / det;
        this.ID[0][1] = -this.CD[0][1] / det;
        this.ID[1][0] = -this.CD[1][0] / det;
        this.ID[1][1] = this.CD[0][0] / det;
        this.type1 = "RA---" + projType[this.proj];
        this.type2 = "DEC--" + projType[this.proj];
        this.flagepoc = 1;
    }

    public Calib(double ra, double de, double cx, double cy, double width, double height, double radius, double radius1, double rot, int proje, boolean sym, int systeme) {
        this.aladin = 0;
        this.xnpix = (int)width;
        this.ynpix = (int)height;
        this.Xcen = cx;
        this.Ycen = cy;
        this.alphai = ra;
        this.deltai = de;
        this.cdelz = FastMath.cos(this.deltai * deg_to_rad);
        this.sdelz = FastMath.sin(this.deltai * deg_to_rad);
        double cosdd = FastMath.cos(rot * deg_to_rad);
        double sindd = FastMath.sin(rot * deg_to_rad);
        this.incA = !sym ? -radius / width : (radius /= 60.0) / width;
        this.incD = (radius1 /= 60.0) / height;
        this.widtha = radius;
        this.widthd = radius1;
        this.CD[0][0] = this.incA * cosdd;
        this.CD[0][1] = this.incA * sindd;
        this.CD[1][0] = -this.incD * sindd;
        this.CD[1][1] = this.incD * cosdd;
        double det = this.CD[0][0] * this.CD[1][1] - this.CD[0][1] * this.CD[1][0];
        this.ID[0][0] = this.CD[1][1] / det;
        this.ID[0][1] = -this.CD[0][1] / det;
        this.ID[1][0] = -this.CD[1][0] / det;
        this.ID[1][1] = this.CD[0][0] / det;
        this.rota = rot;
        this.equinox = 2000.0;
        this.epoch = 2000.0;
        this.flagepoc = 0;
        this.proj = proje;
        this.system = systeme;
        this.type1 = "RA---" + projType[this.proj];
        this.type2 = "DEC--" + projType[this.proj];
    }

    public Calib(double ra, double de, double cx, double cy, double width, double radius, double rot, int proj, boolean sym) {
        this(ra, de, cx, cy, width, width, radius, radius, rot, proj, sym, FK5);
    }

    public Calib(DataInputStream dataflux) throws Exception {
        int i;
        int sign = 1;
        this.aladin = 1;
        this.equinox = 2000.0;
        String s = dataflux.readLine();
        this.epoch = new Double(s);
        this.flagepoc = 1;
        s = dataflux.readLine();
        this.focale = new Double(s);
        s = dataflux.readLine();
        StringTokenizer tok = new StringTokenizer(s, " ");
        String st = tok.nextToken();
        this.alpha = new Double(st);
        st = tok.nextToken();
        this.alpha += new Double(st) / 60.0;
        st = tok.nextToken();
        this.alpha += new Double(st) / 3600.0;
        this.alpha *= 15.0;
        s = dataflux.readLine();
        tok = new StringTokenizer(s, " ");
        st = tok.nextToken();
        if (st.startsWith("-")) {
            sign = -1;
        }
        this.delta = new Double(st);
        if (sign == -1) {
            this.delta = -this.delta;
        }
        st = tok.nextToken();
        this.delta += new Double(st) / 60.0;
        st = tok.nextToken();
        this.delta += new Double(st) / 3600.0;
        if (sign == -1) {
            this.delta = -this.delta;
        }
        s = dataflux.readLine();
        tok = new StringTokenizer(s, " ");
        st = tok.nextToken();
        this.yz = new Double(st);
        st = tok.nextToken();
        this.xz = new Double(st);
        for (i = 0; i < 6; ++i) {
            dataflux.readLine();
        }
        for (i = 0; i < 10; ++i) {
            s = dataflux.readLine();
            tok = new StringTokenizer(s, " ");
            st = tok.nextToken();
            this.adypoly[i] = new Double(st);
            st = tok.nextToken();
            this.adxpoly[i] = new Double(st);
        }
        for (i = 0; i < 10; ++i) {
            s = dataflux.readLine();
            tok = new StringTokenizer(s, " ");
            st = tok.nextToken();
            this.xyapoly[i] = new Double(st);
            st = tok.nextToken();
            this.xydpoly[i] = new Double(st);
        }
        s = dataflux.readLine();
        tok = new StringTokenizer(s, " ");
        st = tok.nextToken();
        this.incY = new Double(st);
        st = tok.nextToken();
        this.incX = new Double(st);
        s = dataflux.readLine();
        tok = new StringTokenizer(s, " ");
        st = tok.nextToken();
        st = tok.nextToken();
        this.Yorg = new Double(st);
        st = tok.nextToken();
        this.Xorg = new Double(st);
        s = dataflux.readLine();
        tok = new StringTokenizer(s, " ,=/");
        st = tok.nextToken();
        st = tok.nextToken();
        this.alphai = new Double(st);
        st = tok.nextToken();
        this.deltai = new Double(st);
        st = tok.nextToken();
        st = tok.nextToken();
        this.widtha = new Double(st);
        st = tok.nextToken();
        this.widthd = new Double(st);
        s = dataflux.readLine();
        tok = new StringTokenizer(s, " ,=/");
        st = tok.nextToken();
        st = tok.nextToken();
        this.xnpix = new Integer(st);
        st = tok.nextToken();
        this.ynpix = new Integer(st);
        this.cdelz = FastMath.cos(this.delta * deg_to_rad);
        this.sdelz = FastMath.sin(this.delta * deg_to_rad);
        this.incA = this.xyapoly[2] * this.incX / this.focale / 1000.0 * rad_to_deg;
        this.incD = this.xydpoly[1] * this.incY / this.focale / 1000.0 * rad_to_deg;
        Coord cc = new Coord();
        cc.al = this.alphai;
        cc.del = this.deltai;
        this.GetXY(cc);
        this.Xcen = cc.x;
        this.Ycen = cc.y;
    }

    public Calib() {
    }

    public Calib(HeaderFits hf) throws Exception {
        this.aladin = 0;
        this.xnpix = hf.getIntFromHeader("NAXIS1  ");
        this.ynpix = hf.getIntFromHeader("NAXIS2  ");
        String plate = hf.getStringFromHeader("PLATE");
        this.aladin = plate != null ? 3 : 0;
        try {
            this.alpha = hf.getDoubleFromHeader("PLTRAS  ");
            this.Dss(hf);
            return;
        }
        catch (Exception e0) {
            block152: {
                this.Xcen = hf.getDoubleFromHeader("CRPIX1  ");
                this.Ycen = hf.getDoubleFromHeader("CRPIX2  ");
                this.type1 = hf.getStringFromHeader("CTYPE1  ");
                this.type2 = hf.getStringFromHeader("CTYPE2  ");
                if (this.type1.startsWith("Solar") || this.type1.startsWith("solar")) {
                    try {
                        this.alphai = hf.getDoubleFromHeader("CRVAL1  ");
                        this.deltai = hf.getDoubleFromHeader("CRVAL2  ");
                    }
                    catch (Exception e00) {
                        this.alphai = 0.0;
                        this.deltai = 0.0;
                    }
                } else {
                    this.alphai = hf.getDoubleFromHeader("CRVAL1  ");
                    this.deltai = hf.getDoubleFromHeader("CRVAL2  ");
                }
                try {
                    this.CD[0][0] = hf.getDoubleFromHeader("CD1_1    ");
                    try {
                        this.CD[0][1] = hf.getDoubleFromHeader("CD1_2    ");
                    }
                    catch (Exception e112) {
                        this.CD[0][1] = 0.0;
                    }
                    try {
                        this.CD[1][0] = hf.getDoubleFromHeader("CD2_1    ");
                    }
                    catch (Exception e113) {
                        this.CD[1][0] = 0.0;
                    }
                    this.CD[1][1] = hf.getDoubleFromHeader("CD2_2    ");
                    int sgnA = this.CD[0][0] < 0.0 ? -1 : 1;
                    int sgnD = this.CD[1][1] < 0.0 ? -1 : 1;
                    this.incA = Math.sqrt(this.CD[0][0] * this.CD[0][0] + this.CD[0][1] * this.CD[0][1]) * (double)sgnA;
                    this.incD = Math.sqrt(this.CD[1][0] * this.CD[1][0] + this.CD[1][1] * this.CD[1][1]) * (double)sgnD;
                    this.rota = Math.atan2(this.CD[0][1] / this.incA, this.CD[1][1] / this.incD) * 180.0 / Math.PI;
                }
                catch (Exception e1) {
                    this.incA = hf.getDoubleFromHeader("CDELT1  ");
                    this.incD = hf.getDoubleFromHeader("CDELT2  ");
                    try {
                        double rota1 = 0.0;
                        double rota2 = 0.0;
                        try {
                            rota1 = hf.getDoubleFromHeader("CROTA1  ");
                            rota2 = hf.getDoubleFromHeader("CROTA2  ");
                        }
                        catch (Exception e6) {
                            try {
                                rota1 = hf.getDoubleFromHeader("CROTA1  ");
                            }
                            catch (Exception e7) {
                                rota2 = hf.getDoubleFromHeader("CROTA2  ");
                            }
                        }
                        this.rota = rota1;
                        if (rota1 == 0.0) {
                            this.rota = rota2;
                        } else if (rota2 != 0.0) {
                            this.rota = (rota1 + rota2) / 2.0;
                        }
                        this.CD[0][0] = this.incA * FastMath.cos(this.rota / 180.0 * Math.PI);
                        this.CD[0][1] = -this.incD * FastMath.sin(this.rota / 180.0 * Math.PI);
                        this.CD[1][0] = this.incA * FastMath.sin(this.rota / 180.0 * Math.PI);
                        this.CD[1][1] = this.incD * FastMath.cos(this.rota / 180.0 * Math.PI);
                    }
                    catch (Exception e2) {
                        try {
                            this.CD[0][0] = hf.getDoubleFromHeader("PC001001") * this.incA;
                            this.CD[0][1] = hf.getDoubleFromHeader("PC001002") * this.incA;
                            this.CD[1][0] = hf.getDoubleFromHeader("PC002001") * this.incD;
                            this.CD[1][1] = hf.getDoubleFromHeader("PC002002") * this.incD;
                            this.rota = Math.acos(hf.getDoubleFromHeader("PC001001")) * 57.29577951308232;
                        }
                        catch (Exception e22) {
                            try {
                                try {
                                    this.CD[0][0] = hf.getDoubleFromHeader("PC1_1") * this.incA;
                                }
                                catch (Exception e222) {
                                    this.CD[0][0] = this.incA;
                                }
                                try {
                                    this.CD[0][1] = hf.getDoubleFromHeader("PC1_2") * this.incA;
                                }
                                catch (Exception e223) {
                                    this.CD[0][1] = 0.0;
                                }
                                try {
                                    this.CD[1][0] = hf.getDoubleFromHeader("PC2_1") * this.incD;
                                }
                                catch (Exception e224) {
                                    this.CD[1][0] = 0.0;
                                }
                                try {
                                    this.CD[1][1] = hf.getDoubleFromHeader("PC2_2") * this.incD;
                                }
                                catch (Exception e225) {
                                    this.CD[1][1] = this.incA;
                                }
                                this.rota = Math.acos(hf.getDoubleFromHeader("PC1_1")) * 57.29577951308232;
                            }
                            catch (Exception e3) {
                                this.rota = 0.0;
                                this.CD[0][0] = this.incA;
                                this.CD[0][1] = 0.0;
                                this.CD[1][0] = 0.0;
                                this.CD[1][1] = this.incD;
                                String origin = hf.getStringFromHeader("ORIGIN  ");
                                if (origin == null || !origin.startsWith("DeNIS")) break block152;
                                if (this.CD[0][0] > 0.0) {
                                    this.CD[0][0] = -this.CD[0][0];
                                }
                                if (!(this.CD[1][1] > 0.0)) break block152;
                                this.CD[1][1] = -this.CD[1][1];
                            }
                        }
                    }
                }
            }
            try {
                this.epoch = hf.getDoubleFromHeader("EPOCH   ");
                this.flagepoc = 1;
            }
            catch (Exception e6) {
                this.epoch = 0.0;
            }
            try {
                this.equinox = hf.getDoubleFromHeader("EQUINOX ");
            }
            catch (Exception e5) {
                try {
                    this.epoch = this.equinox = hf.getDoubleFromHeader("EPOCH  ");
                    this.flagepoc = 1;
                }
                catch (Exception e4) {
                    this.equinox = 2000.0;
                    this.epoch = 2000.0;
                    this.flagepoc = 0;
                }
            }
            if (this.type1.startsWith("DEC")) {
                double tmp_invert = this.deltai;
                this.deltai = this.alphai;
                this.alphai = tmp_invert;
                tmp_invert = this.CD[0][0];
                this.CD[0][0] = this.CD[1][0];
                this.CD[1][0] = tmp_invert;
                tmp_invert = this.CD[1][1];
                this.CD[1][1] = this.CD[0][1];
                this.CD[0][1] = tmp_invert;
                tmp_invert = this.incA;
                this.incA = this.incD;
                this.incD = tmp_invert;
            }
            try {
                String Syst = hf.getStringFromHeader("RADECSYS");
                if (Syst.indexOf("ICRS") >= 0) {
                    this.system = ICRS;
                }
                if (Syst.indexOf("FK5") >= 0) {
                    this.system = FK5;
                }
                if (Syst.indexOf("FK4") >= 0) {
                    this.system = FK4;
                }
            }
            catch (Exception e10) {
                // empty catch block
            }
            if (this.type1.startsWith("ELON")) {
                this.system = ECLIPTIC;
            }
            if (this.type1.startsWith("GLON")) {
                this.system = GALACTIC;
            }
            if (this.type1.startsWith("SLON")) {
                this.system = SUPERGALACTIC;
            }
            if (this.type1.startsWith("Solar")) {
                this.system = XYLINEAR;
            }
            if (this.type1.startsWith("solar")) {
                this.system = XYLINEAR;
            }
            if (this.equinox == 1950.0 && this.system != GALACTIC && this.system != ECLIPTIC && this.system != SUPERGALACTIC && this.system != XYLINEAR) {
                this.system = FK4;
            }
            try {
                this.adxpoly[0] = hf.getDoubleFromHeader("PV2_0   ");
                this.xydpoly[0] = this.adxpoly[0];
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.adxpoly[1] = hf.getDoubleFromHeader("PV2_1   ");
                this.xydpoly[1] = this.adxpoly[1];
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.adxpoly[2] = hf.getDoubleFromHeader("PV2_2   ");
                this.xydpoly[2] = this.adxpoly[2];
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.adxpoly[3] = hf.getDoubleFromHeader("PV2_3   ");
                this.xydpoly[3] = this.adxpoly[3];
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.adxpoly[4] = hf.getDoubleFromHeader("PV2_4   ");
                this.xydpoly[4] = this.adxpoly[4];
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.adxpoly[5] = hf.getDoubleFromHeader("PV2_5   ");
                this.xydpoly[5] = this.adxpoly[5];
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.adxpoly[6] = hf.getDoubleFromHeader("PV2_6   ");
                this.xydpoly[6] = this.adxpoly[6];
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.adxpoly[7] = hf.getDoubleFromHeader("PV2_7   ");
                this.xydpoly[7] = this.adxpoly[7];
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.adxpoly[8] = hf.getDoubleFromHeader("PV2_8   ");
                this.xydpoly[8] = this.adxpoly[8];
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.adxpoly[9] = hf.getDoubleFromHeader("PV2_9   ");
                this.xydpoly[9] = this.adxpoly[9];
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.adxpoly[10] = hf.getDoubleFromHeader("PV2_10   ");
                this.xydpoly[10] = this.adxpoly[10];
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xyapoly[0] = hf.getDoubleFromHeader("PV1_0   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xydpoly[0] = hf.getDoubleFromHeader("PV2_0   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xyapoly[1] = hf.getDoubleFromHeader("PV1_1   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xydpoly[1] = hf.getDoubleFromHeader("PV2_1   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xyapoly[2] = hf.getDoubleFromHeader("PV1_2   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xydpoly[2] = hf.getDoubleFromHeader("PV2_2   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xyapoly[3] = hf.getDoubleFromHeader("PV1_3   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xydpoly[3] = hf.getDoubleFromHeader("PV2_3   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xyapoly[4] = hf.getDoubleFromHeader("PV1_4   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xydpoly[4] = hf.getDoubleFromHeader("PV2_4   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xyapoly[5] = hf.getDoubleFromHeader("PV1_5   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xydpoly[5] = hf.getDoubleFromHeader("PV2_5   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xyapoly[6] = hf.getDoubleFromHeader("PV1_6   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xydpoly[6] = hf.getDoubleFromHeader("PV2_6   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xyapoly[7] = hf.getDoubleFromHeader("PV1_7   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xydpoly[7] = hf.getDoubleFromHeader("PV2_7   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xyapoly[8] = hf.getDoubleFromHeader("PV1_8   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xydpoly[8] = hf.getDoubleFromHeader("PV2_8   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xyapoly[9] = hf.getDoubleFromHeader("PV1_9   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xydpoly[9] = hf.getDoubleFromHeader("PV2_9   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xyapoly[10] = hf.getDoubleFromHeader("PV1_10   ");
            }
            catch (Exception e11) {
                // empty catch block
            }
            try {
                this.xydpoly[10] = hf.getDoubleFromHeader("PV2_10   ");
            }
            catch (Exception e12) {
                // empty catch block
            }
            try {
                this.proj = Calib.getSubProjType(this.type2.substring(5));
            }
            catch (Exception e) {
                this.proj = -1;
            }
            if (this.proj != -1) {
                try {
                    this.proj = Calib.getSubProjType(this.type1.substring(5));
                }
                catch (Exception e) {
                    this.proj = -1;
                }
            }
            if (this.proj == -1 && hf.getStringFromHeader("GRIDTYPE") != null) {
                this.proj = 7;
                System.err.println("No projection specified in CTYPE, GRIDTYPE present => assuming CAR");
            }
            if (Util.indexOfIgnoreCase(this.type1, "solar") >= 0) {
                this.proj = 10;
            }
            if (this.proj == 12) {
                int j;
                try {
                    int order;
                    this.order_a = hf.getIntFromHeader("A_ORDER");
                    this.order_b = hf.getIntFromHeader("B_ORDER");
                    for (order = 2; order < this.order_a + 1; ++order) {
                        for (int powx = 0; powx < order + 1; ++powx) {
                            for (j = 0; j < order - powx + 1; ++j) {
                                try {
                                    this.sip_a[powx][j] = hf.getDoubleFromHeader("A_" + new Integer(powx).toString() + "_" + new Integer(j).toString() + "  ");
                                    continue;
                                }
                                catch (Exception ee) {
                                    this.sip_a[powx][j] = 0.0;
                                }
                            }
                        }
                    }
                    for (order = 2; order < this.order_b + 1; ++order) {
                        for (int powx = 0; powx < order + 1; ++powx) {
                            for (j = 0; j < order - powx + 1; ++j) {
                                try {
                                    this.sip_b[powx][j] = hf.getDoubleFromHeader("B_" + new Integer(powx).toString() + "_" + new Integer(j).toString() + "  ");
                                    continue;
                                }
                                catch (Exception ee) {
                                    this.sip_b[powx][j] = 0.0;
                                }
                            }
                        }
                    }
                }
                catch (Exception e13) {
                    this.proj = -1;
                }
                try {
                    int order;
                    this.order_ap = hf.getIntFromHeader("AP_ORDER");
                    this.order_bp = hf.getIntFromHeader("BP_ORDER");
                    for (order = 2; order < this.order_ap + 1; ++order) {
                        for (int powx = 0; powx < order + 1; ++powx) {
                            for (j = 0; j < order - powx + 1; ++j) {
                                try {
                                    this.sip_ap[powx][j] = hf.getDoubleFromHeader("AP_" + new Integer(powx).toString() + "_" + new Integer(j).toString() + "  ");
                                    continue;
                                }
                                catch (Exception ee) {
                                    this.sip_ap[powx][j] = 0.0;
                                }
                            }
                        }
                    }
                    for (order = 2; order < this.order_bp + 1; ++order) {
                        for (int powx = 0; powx < order + 1; ++powx) {
                            for (j = 0; j < order - powx + 1; ++j) {
                                try {
                                    this.sip_bp[powx][j] = hf.getDoubleFromHeader("BP_" + new Integer(powx).toString() + "_" + new Integer(j).toString() + "  ");
                                    continue;
                                }
                                catch (Exception ee) {
                                    this.sip_bp[powx][j] = 0.0;
                                }
                            }
                        }
                    }
                }
                catch (Exception e14) {
                    // empty catch block
                }
            }
            if (this.type1.indexOf("COE") >= 0 && this.type2.indexOf("COE") >= 0) {
                this.proj = 2;
            }
            if (this.proj == -1) {
                System.err.println("Calib warning:CTYPE " + this.type1 + "/" + this.type2 + " is not yet supported " + "by Aladin");
                throw new Exception("CTYPE " + this.type1 + "/" + this.type2 + " is not yet supported " + "by Aladin");
            }
            this.widtha = (double)this.xnpix * Math.abs(this.incA);
            this.widthd = (double)this.ynpix * Math.abs(this.incD);
            this.cdelz = FastMath.cos(this.deltai * deg_to_rad);
            this.sdelz = FastMath.sin(this.deltai * deg_to_rad);
            double det = this.CD[0][0] * this.CD[1][1] - this.CD[0][1] * this.CD[1][0];
            this.ID[0][0] = this.CD[1][1] / det;
            this.ID[0][1] = -this.CD[0][1] / det;
            this.ID[1][0] = -this.CD[1][0] / det;
            this.ID[1][1] = this.CD[0][0] / det;
            return;
        }
    }

    public Calib(long nside, long npix, int frame, int width) {
        try {
            double[][] bord = CDSHealpix.borders(nside, npix, 2);
            double[] center = CDSHealpix.pix2ang_nest(nside, npix);
            double[] centerRadec = CDSHealpix.polarToRadec(center);
            this.alphai = centerRadec[0];
            this.deltai = centerRadec[1];
            double X1 = bord[0][0];
            double Y1 = bord[0][1];
            double X2 = bord[1][0];
            double Y2 = bord[1][1];
            double X3 = bord[2][0];
            double Y3 = bord[2][1];
            double X4 = bord[3][0];
            double Y4 = bord[3][1];
            double X5 = bord[4][0];
            double Y5 = bord[4][1];
            double X6 = bord[5][0];
            double Y6 = bord[5][1];
            double X7 = bord[6][0];
            double Y7 = bord[6][1];
            double X8 = bord[7][0];
            double Y8 = bord[7][1];
            this.cdelz = FastMath.cos(this.deltai / 180.0 * Math.PI);
            this.sdelz = FastMath.sin(this.deltai / 180.0 * Math.PI);
            double cdelz1 = this.cdelz;
            double sdelz1 = this.sdelz;
            double deno = FastMath.sin(Y1 * Math.PI / 180.0) * sdelz1 + FastMath.cos(Y1 * Math.PI / 180.0) * cdelz1 * FastMath.cos((X1 - this.alphai) * Math.PI / 180.0);
            double xst1 = FastMath.cos(Y1 * Math.PI / 180.0) * FastMath.sin((X1 - this.alphai) * Math.PI / 180.0) / deno;
            double yst1 = (FastMath.sin(Y1 * Math.PI / 180.0) * cdelz1 - FastMath.cos(Y1 * Math.PI / 180.0) * sdelz1 * FastMath.cos((X1 - this.alphai) * Math.PI / 180.0)) / deno;
            deno = FastMath.sin(Y2 * Math.PI / 180.0) * sdelz1 + FastMath.cos(Y2 * Math.PI / 180.0) * cdelz1 * FastMath.cos((X2 - this.alphai) * Math.PI / 180.0);
            double xst2 = FastMath.cos(Y2 * Math.PI / 180.0) * FastMath.sin((X2 - this.alphai) * Math.PI / 180.0) / deno;
            double yst2 = (FastMath.sin(Y2 * Math.PI / 180.0) * cdelz1 - FastMath.cos(Y2 * Math.PI / 180.0) * sdelz1 * FastMath.cos((X2 - this.alphai) * Math.PI / 180.0)) / deno;
            deno = FastMath.sin(Y3 * Math.PI / 180.0) * sdelz1 + FastMath.cos(Y3 * Math.PI / 180.0) * cdelz1 * FastMath.cos((X3 - this.alphai) * Math.PI / 180.0);
            double xst3 = FastMath.cos(Y3 * Math.PI / 180.0) * FastMath.sin((X3 - this.alphai) * Math.PI / 180.0) / deno;
            double yst3 = FastMath.sin(Y3 * Math.PI / 180.0) * cdelz1 - FastMath.cos(Y3 * Math.PI / 180.0) * sdelz1 * FastMath.cos((X3 - this.alphai) * Math.PI / 180.0) / deno;
            deno = FastMath.sin(Y4 * Math.PI / 180.0) * sdelz1 + FastMath.cos(Y4 * Math.PI / 180.0) * cdelz1 * FastMath.cos((X4 - this.alphai) * Math.PI / 180.0);
            double xst4 = FastMath.cos(Y4 * Math.PI / 180.0) * FastMath.sin((X4 - this.alphai) * Math.PI / 180.0) / deno;
            double yst4 = (FastMath.sin(Y4 * Math.PI / 180.0) * cdelz1 - FastMath.cos(Y4 * Math.PI / 180.0) * sdelz1 * FastMath.cos((X4 - this.alphai) * Math.PI / 180.0)) / deno;
            deno = FastMath.sin(Y5 * Math.PI / 180.0) * sdelz1 + FastMath.cos(Y5 * Math.PI / 180.0) * cdelz1 * FastMath.cos((X5 - this.alphai) * Math.PI / 180.0);
            double xst5 = FastMath.cos(Y5 * Math.PI / 180.0) * FastMath.sin((X5 - this.alphai) * Math.PI / 180.0) / deno;
            double yst5 = (FastMath.sin(Y5 * Math.PI / 180.0) * cdelz1 - FastMath.cos(Y5 * Math.PI / 180.0) * sdelz1 * FastMath.cos((X5 - this.alphai) * Math.PI / 180.0)) / deno;
            deno = FastMath.sin(Y6 * Math.PI / 180.0) * sdelz1 + FastMath.cos(Y6 * Math.PI / 180.0) * cdelz1 * FastMath.cos((X6 - this.alphai) * Math.PI / 180.0);
            double xst6 = FastMath.cos(Y6 * Math.PI / 180.0) * FastMath.sin((X6 - this.alphai) * Math.PI / 180.0) / deno;
            double yst6 = (FastMath.sin(Y6 * Math.PI / 180.0) * cdelz1 - FastMath.cos(Y6 * Math.PI / 180.0) * sdelz1 * FastMath.cos((X6 - this.alphai) * Math.PI / 180.0)) / deno;
            deno = FastMath.sin(Y7 * Math.PI / 180.0) * sdelz1 + FastMath.cos(Y7 * Math.PI / 180.0) * cdelz1 * FastMath.cos((X7 - this.alphai) * Math.PI / 180.0);
            double xst7 = FastMath.cos(Y7 * Math.PI / 180.0) * FastMath.sin((X7 - this.alphai) * Math.PI / 180.0) / deno;
            double yst7 = (FastMath.sin(Y7 * Math.PI / 180.0) * cdelz1 - FastMath.cos(Y7 * Math.PI / 180.0) * sdelz1 * FastMath.cos((X7 - this.alphai) * Math.PI / 180.0)) / deno;
            deno = FastMath.sin(Y8 * Math.PI / 180.0) * sdelz1 + FastMath.cos(Y8 * Math.PI / 180.0) * cdelz1 * FastMath.cos((X8 - this.alphai) * Math.PI / 180.0);
            double xst8 = FastMath.cos(Y8 * Math.PI / 180.0) * FastMath.sin((X8 - this.alphai) * Math.PI / 180.0) / deno;
            double yst8 = (FastMath.sin(Y8 * Math.PI / 180.0) * cdelz1 - FastMath.cos(Y8 * Math.PI / 180.0) * sdelz1 * FastMath.cos((X8 - this.alphai) * Math.PI / 180.0)) / deno;
            this.CD[0][0] = rad_to_deg * (-xst1 - xst2 - xst3 + xst5 + xst6 + xst7) / 6.0 / 256.0;
            this.CD[0][1] = rad_to_deg * (xst1 - xst3 - xst4 - xst5 + xst7 + xst8) / 6.0 / 256.0;
            this.CD[1][0] = -rad_to_deg * (-yst1 - yst2 - yst3 + yst5 + yst6 + yst7) / 6.0 / 256.0;
            this.CD[1][1] = rad_to_deg * (yst1 - yst3 - yst4 - yst5 + yst7 + yst8) / 6.0 / 256.0;
            this.xnpix = 512;
            this.ynpix = 512;
            this.Xcen = 255.0;
            this.Ycen = 255.0;
            this.proj = 2;
            this.equinox = 2000.0;
            Coord ccc = new Coord();
            ccc.x = 0.0;
            ccc.y = 0.0;
            this.GetCoord(ccc);
            ccc.x = 0.0;
            ccc.y = 256.0;
            this.GetCoord(ccc);
            ccc.x = 0.0;
            ccc.y = 128.0;
            this.GetCoord(ccc);
            ccc.x = 512.0;
            ccc.y = 512.0;
            this.GetCoord(ccc);
            double[][] bord1 = CDSHealpix.borders(nside, npix, 2);
        }
        catch (Exception e17) {
            // empty catch block
        }
    }

    protected void Dss(HeaderFits hf) throws Exception {
        int sign = 1;
        this.proj = 2;
        this.alpha += (double)hf.getIntFromHeader("PLTRAM  ") * 60.0;
        this.alpha += (double)hf.getIntFromHeader("PLTRAH  ") * 3600.0;
        this.alpha /= 240.0;
        if (hf.getStringFromHeader("PLTDECSN").startsWith("-")) {
            sign = -1;
        }
        this.delta = hf.getDoubleFromHeader("PLTDECS ");
        this.delta += (double)hf.getIntFromHeader("PLTDECM ") * 60.0;
        this.delta += (double)hf.getIntFromHeader("PLTDECD ") * 3600.0;
        this.delta /= 3600.0;
        this.delta *= (double)sign;
        this.focale = hf.getDoubleFromHeader("PLTSCALE");
        this.focale = 206264.80624709636 / this.focale;
        this.equinox = hf.getDoubleFromHeader("EQUINOX ");
        try {
            this.epoch = hf.getDoubleFromHeader("EPOCH  ");
            this.flagepoc = 1;
        }
        catch (Exception e1) {
            this.epoch = this.equinox;
            this.flagepoc = 0;
        }
        this.xz = hf.getDoubleFromHeader("PPO3    ");
        this.xz /= 1000.0;
        this.yz = hf.getDoubleFromHeader("PPO6    ");
        this.yz /= 1000.0;
        this.xyapoly[2] = hf.getDoubleFromHeader("AMDX1   ");
        this.xydpoly[1] = hf.getDoubleFromHeader("AMDY1   ");
        this.xyapoly[1] = hf.getDoubleFromHeader("AMDX2   ");
        this.xydpoly[2] = hf.getDoubleFromHeader("AMDY2   ");
        this.xyapoly[0] = hf.getDoubleFromHeader("AMDX3   ");
        this.xydpoly[0] = hf.getDoubleFromHeader("AMDY3   ");
        this.xyapoly[4] = hf.getDoubleFromHeader("AMDX4   ");
        this.xydpoly[3] = hf.getDoubleFromHeader("AMDY4   ");
        this.xyapoly[5] = hf.getDoubleFromHeader("AMDX5   ");
        this.xydpoly[5] = hf.getDoubleFromHeader("AMDY5   ");
        this.xyapoly[3] = hf.getDoubleFromHeader("AMDX6   ");
        this.xydpoly[4] = hf.getDoubleFromHeader("AMDY6   ");
        this.xyapoly[4] = this.xyapoly[4] + hf.getDoubleFromHeader("AMDX7   ");
        this.xydpoly[4] = this.xydpoly[4] + hf.getDoubleFromHeader("AMDY7   ");
        this.xyapoly[3] = this.xyapoly[3] + hf.getDoubleFromHeader("AMDX7   ");
        this.xydpoly[3] = this.xydpoly[3] + hf.getDoubleFromHeader("AMDY7   ");
        this.xyapoly[7] = hf.getDoubleFromHeader("AMDX8   ");
        this.xydpoly[6] = hf.getDoubleFromHeader("AMDY8   ");
        this.xyapoly[9] = hf.getDoubleFromHeader("AMDX9   ");
        this.xydpoly[8] = hf.getDoubleFromHeader("AMDY9   ");
        this.xyapoly[8] = hf.getDoubleFromHeader("AMDX10  ");
        this.xydpoly[9] = hf.getDoubleFromHeader("AMDY10  ");
        this.xyapoly[6] = hf.getDoubleFromHeader("AMDX11  ");
        this.xydpoly[7] = hf.getDoubleFromHeader("AMDY11  ");
        this.xyapoly[7] = this.xyapoly[7] + hf.getDoubleFromHeader("AMDX12  ");
        this.xydpoly[6] = this.xydpoly[6] + hf.getDoubleFromHeader("AMDY12  ");
        this.xyapoly[8] = this.xyapoly[8] + hf.getDoubleFromHeader("AMDX12  ");
        this.xydpoly[9] = this.xydpoly[9] + hf.getDoubleFromHeader("AMDY12  ");
        this.xyapoly[0] = this.xyapoly[0] / this.focale;
        this.xydpoly[0] = this.xydpoly[0] / this.focale;
        this.xyapoly[1] = this.xyapoly[1] * -1.0;
        this.xydpoly[1] = this.xydpoly[1] * -1.0;
        this.xyapoly[2] = this.xyapoly[2] * -1.0;
        this.xydpoly[2] = this.xydpoly[2] * -1.0;
        this.xyapoly[3] = this.xyapoly[3] * this.focale;
        this.xydpoly[3] = this.xydpoly[3] * this.focale;
        this.xyapoly[4] = this.xyapoly[4] * this.focale;
        this.xydpoly[4] = this.xydpoly[4] * this.focale;
        this.xyapoly[5] = this.xyapoly[5] * this.focale;
        this.xydpoly[5] = this.xydpoly[5] * this.focale;
        this.xyapoly[6] = this.xyapoly[6] * (-this.focale * this.focale);
        this.xydpoly[6] = this.xydpoly[6] * (-this.focale * this.focale);
        this.xyapoly[7] = this.xyapoly[7] * (-this.focale * this.focale);
        this.xydpoly[7] = this.xydpoly[7] * (-this.focale * this.focale);
        this.xyapoly[8] = this.xyapoly[8] * (-this.focale * this.focale);
        this.xydpoly[8] = this.xydpoly[8] * (-this.focale * this.focale);
        this.xyapoly[9] = this.xyapoly[9] * (-this.focale * this.focale);
        this.xydpoly[9] = this.xydpoly[9] * (-this.focale * this.focale);
        int i = 0;
        while (i <= 9) {
            int n = i;
            this.xyapoly[n] = this.xyapoly[n] / (206264.80624709636 / this.focale);
            int n2 = i++;
            this.xydpoly[n2] = this.xydpoly[n2] / (206264.80624709636 / this.focale);
        }
        this.incX = hf.getDoubleFromHeader("XPIXELSZ");
        this.incY = hf.getDoubleFromHeader("YPIXELSZ");
        this.xnpix = hf.getIntFromHeader("NAXIS1  ");
        this.ynpix = hf.getIntFromHeader("NAXIS2  ");
        this.Xorg = this.incX * hf.getDoubleFromHeader("CNPIX1  ");
        this.Yorg = this.incY * (23040.0 - hf.getDoubleFromHeader("CNPIX2  ") - (double)this.ynpix);
        this.yz = this.incY * 23040.0 / 1000.0 - this.yz;
        this.cdelz = FastMath.cos(this.delta * deg_to_rad);
        this.sdelz = FastMath.sin(this.delta * deg_to_rad);
        this.alphai = this.alpha;
        this.deltai = this.delta;
        this.incA = this.xyapoly[2] * this.incX / this.focale / 1000.0 * rad_to_deg;
        this.incD = this.xydpoly[1] * this.incY / this.focale / 1000.0 * rad_to_deg;
        this.widtha = (double)this.xnpix * Math.abs(this.incA);
        this.widthd = (double)this.ynpix * Math.abs(this.incD);
        this.aladin = 2;
    }

    protected void GetXYstand(Coord c) throws Exception {
        double x_obj = 1.0;
        double y_obj = 1.0;
        double y_stand = 0.03;
        double x_stand = 0.03;
        if (this.aladin == 1) {
            double delrad = c.del * deg_to_rad;
            double alrad = (c.al - this.alpha) * deg_to_rad;
            double sin_delrad = FastMath.sin(delrad);
            double cos_delrad = FastMath.cos(delrad);
            double sin_alrad = FastMath.sin(alrad);
            double cos_alrad = FastMath.cos(alrad);
            double dr = sin_delrad * this.sdelz + cos_delrad * this.cdelz * cos_alrad;
            x_stand = cos_delrad * sin_alrad / dr;
            y_stand = (sin_delrad * this.cdelz - cos_delrad * this.sdelz * cos_alrad) / dr;
        } else {
            Astrocoo ac;
            double al = c.al;
            double del = c.del;
            c.dx = c.x - this.Xcen;
            c.dy = c.y - this.Ycen;
            if (this.system == FK4) {
                ac = new Astrocoo(AF_ICRS, c.al, c.del);
                ac.setPrecision(9);
                ac.convertTo(AF_FK4);
                al = ac.getLon();
                del = ac.getLat();
            }
            if (this.system == FK5) {
                ac = new Astrocoo(AF_ICRS, c.al, c.del);
                ac.setPrecision(9);
                ac.convertTo(AF_FK5);
                al = ac.getLon();
                del = ac.getLat();
            }
            if (this.system == GALACTIC) {
                ac = new Astrocoo(AF_ICRS, c.al, c.del);
                ac.setPrecision(9);
                ac.convertTo(AF_GAL);
                al = ac.getLon();
                del = ac.getLat();
            }
            if (this.system == ECLIPTIC) {
                ac = new Astrocoo(AF_ICRS, c.al, c.del);
                ac.setPrecision(9);
                ac.convertTo(AF_ECL);
                al = ac.getLon();
                del = ac.getLat();
            }
            if (this.system == SUPERGALACTIC) {
                ac = new Astrocoo(AF_ICRS, c.al, c.del);
                ac.setPrecision(9);
                ac.convertTo(AF_SGAL);
                al = ac.getLon();
                del = ac.getLat();
            }
            double ddel = (del - this.deltai) * deg_to_rad;
            double dalpha = (al - this.alphai) * deg_to_rad;
            double cos_del = FastMath.cos(del * deg_to_rad);
            double sin_del = FastMath.sin(del * deg_to_rad);
            double sin_dalpha = FastMath.sin(dalpha);
            double cos_dalpha = FastMath.cos(dalpha);
            double x_tet_phi = cos_del * sin_dalpha;
            double y_tet_phi = sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha;
            switch (this.proj) {
                case 1: 
                case 8: {
                    x_stand = x_tet_phi;
                    y_stand = y_tet_phi;
                    if (this.xydpoly[1] == 0.0 || this.xydpoly[2] == 0.0) break;
                    x_stand += this.xydpoly[1] * (1.0 - (sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha));
                    y_stand += this.xydpoly[2] * (1.0 - (sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha));
                    break;
                }
                case 2: {
                    double den = sin_del * this.sdelz + cos_del * this.cdelz;
                    x_stand = x_tet_phi / den;
                    y_stand = y_tet_phi / den;
                    break;
                }
                case 3: 
                case 9: {
                    double rteta;
                    double phi = sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha != 0.0 ? Math.atan(-cos_del * sin_dalpha / (sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha)) : (-cos_del * sin_dalpha < 0.0 ? 1.5707963267948966 : -1.5707963267948966);
                    if (sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha >= 0.0) {
                        phi = Math.PI + phi;
                    }
                    double tet = Math.asin(sin_del * this.sdelz + cos_del * this.cdelz * cos_dalpha);
                    if (this.proj == 9) {
                        rteta = 0.0;
                        for (int order = 9; order >= 0; --order) {
                            rteta = rteta * (1.5707963267948966 - tet) + this.adxpoly[order];
                        }
                    } else {
                        rteta = 1.5707963267948966 - tet;
                    }
                    x_stand = rteta * FastMath.sin(phi);
                    y_stand = -rteta * FastMath.cos(phi);
                    break;
                }
                case 4: {
                    if (al > 180.0) {
                        dalpha -= Math.PI * 2;
                    }
                    double cos_ddel = FastMath.cos(ddel);
                    double alph = Math.sqrt(2.0 / (1.0 + cos_ddel * FastMath.cos(dalpha / 2.0)));
                    x_stand = 2.0 * alph * cos_ddel * FastMath.sin(dalpha / 2.0);
                    y_stand = alph * FastMath.sin(ddel);
                    if (!(dalpha / 2.0 > Math.PI)) break;
                    x_stand = -x_stand;
                    break;
                }
                case 5: {
                    double phi = sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha != 0.0 ? Math.atan(-cos_del * sin_dalpha / (sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha)) : (-cos_del * sin_dalpha < 0.0 ? 1.5707963267948966 : -1.5707963267948966);
                    if (sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha > 0.0) {
                        phi = Math.PI + phi;
                    }
                    double tet = Math.asin(sin_del * this.sdelz + cos_del * this.cdelz * cos_dalpha);
                    double rtet = Math.sqrt(2.0 * (1.0 - FastMath.sin(tet)));
                    x_stand = rtet * FastMath.sin(phi);
                    y_stand = -rtet * FastMath.cos(phi);
                    break;
                }
                case 6: {
                    double den = 1.0 + sin_del * this.sdelz + cos_del * this.cdelz * cos_dalpha;
                    x_stand = 2.0 * x_tet_phi / den;
                    y_stand = 2.0 * y_tet_phi / den;
                    break;
                }
                case 7: {
                    x_stand = (al - this.alphai) * deg_to_rad;
                    y_stand = (del - this.deltai) * deg_to_rad;
                    break;
                }
            }
        }
        c.xstand = x_stand;
        c.ystand = y_stand;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public void GetCoord(Coord c) throws Exception {
        block46: {
            x_obj = 1.0;
            y_obj = 1.0;
            if (this.aladin == 1 || this.aladin == 2) {
                x_obj = (c.x * this.incX + this.Xorg) / 1000.0;
                x_objr = (x_obj - this.xz) / this.focale;
                y_obj = (c.y * this.incY + this.Yorg) / 1000.0;
                y_objr = (y_obj - this.yz) / this.focale;
                if (x_objr * x_objr + y_objr * y_objr > 0.19) {
                    throw new Exception("No coordinates");
                }
                posx = this.xyapoly[0] + this.xyapoly[1] * y_objr + this.xyapoly[2] * x_objr + this.xyapoly[3] * y_objr * y_objr + this.xyapoly[4] * x_objr * x_objr + this.xyapoly[5] * y_objr * x_objr + this.xyapoly[6] * y_objr * y_objr * y_objr + this.xyapoly[7] * x_objr * x_objr * x_objr + this.xyapoly[8] * y_objr * y_objr * x_objr + this.xyapoly[9] * y_objr * x_objr * x_objr;
                posy = this.xydpoly[0] + this.xydpoly[1] * y_objr + this.xydpoly[2] * x_objr + this.xydpoly[3] * y_objr * y_objr + this.xydpoly[4] * x_objr * x_objr + this.xydpoly[5] * y_objr * x_objr + this.xydpoly[6] * y_objr * y_objr * y_objr + this.xydpoly[7] * x_objr * x_objr * x_objr + this.xydpoly[8] * y_objr * y_objr * x_objr + this.xydpoly[9] * y_objr * x_objr * x_objr;
                c.al = this.alpha + Math.atan(posx / (this.cdelz - posy * this.sdelz)) * Calib.rad_to_deg;
                c.del = Math.atan(FastMath.cos((c.al - this.alpha) * Calib.deg_to_rad) * (this.sdelz + posy * this.cdelz) / (this.cdelz - posy * this.sdelz)) * Calib.rad_to_deg;
                if (c.del * this.delta < 0.0 && Math.abs(this.delta) > 87.0) {
                    c.al += 180.0;
                    c.del = -c.del;
                }
                if (c.al > 360.0) {
                    c.al -= 360.0;
                }
                if (!(c.al < 0.0)) return;
                c.al += 360.0;
                return;
            }
            x_obj = c.x - this.Xcen;
            y_obj = (double)this.ynpix - this.Ycen - c.y;
            if (this.proj == 2 && this.xyapoly[1] != 0.0 && this.xyapoly[1] != 1.0 && this.aladin == 3 && this.xydpoly[2] * this.CD[1][1] < 0.0) {
                y_obj = c.y - this.Ycen;
            }
            if (this.proj == 12) {
                xint = x_obj;
                yint = y_obj;
                for (order = 2; order < this.order_a + 1; ++order) {
                    for (powx = 0; powx < order + 1; x_obj += this.sip_a[powx][order - powx] * Math.pow(xint, powx) * Math.pow(yint, order - powx), ++powx) {
                    }
                }
                for (order = 2; order < this.order_b + 1; ++order) {
                    for (powx = 0; powx < order + 1; y_obj += this.sip_b[powx][order - powx] * Math.pow(xint, powx) * Math.pow(yint, order - powx), ++powx) {
                    }
                }
            }
            x_objr = this.CD[0][0] * x_obj + this.CD[0][1] * y_obj;
            y_objr = this.CD[1][0] * x_obj + this.CD[1][1] * y_obj;
            x_objr *= Calib.deg_to_rad;
            yy = y_objr *= Calib.deg_to_rad;
            block0 : switch (this.proj) {
                case 1: {
                    c.del = Calib.rad_to_deg * Math.asin(y_objr * this.cdelz + this.sdelz * Math.sqrt(1.0 - y_objr * y_objr - x_objr * x_objr));
                    X = x_objr / (this.cdelz * Math.sqrt(1.0 - y_objr * y_objr - x_objr * x_objr) - y_objr * this.sdelz);
                    c.al = this.alphai + Calib.rad_to_deg * Math.atan(X);
                    if (this.cdelz * Math.sqrt(1.0 - y_objr * y_objr - x_objr * x_objr) - y_objr * this.sdelz < 0.0) {
                        c.al += 180.0;
                    }
                    if (this.xydpoly[1] == 0.0 || this.xydpoly[2] == 0.0) break;
                    xi = this.xydpoly[1];
                    eta = this.xydpoly[2];
                    a = xi * xi + eta * eta + 1.0;
                    b = (x_objr - xi) * xi + eta * (y_objr - eta);
                    C = (x_objr - xi) * (x_objr - xi) + (y_objr - eta) * (y_objr - eta) - 1.0;
                    arg = (-b + Math.sqrt(b * b - a * C)) / a;
                    tet = Math.asin(arg);
                    phi = Math.atan2(x_objr - xi * (1.0 - arg), -(y_objr - eta * (1.0 - arg)));
                    c.del = -Calib.rad_to_deg * Math.asin(-this.sdelz * FastMath.sin(tet) + this.cdelz * FastMath.cos(tet) * FastMath.cos(phi));
                    arg11 = FastMath.sin(tet) * this.cdelz - FastMath.cos(tet) * this.sdelz * FastMath.cos(phi);
                    argg = -(FastMath.cos(tet) * FastMath.sin(phi));
                    c.al = Math.abs(this.deltai) != 90.0 ? this.alphai - Calib.rad_to_deg * Math.atan2(argg, arg11) : (this.deltai == 90.0 ? Calib.rad_to_deg * (phi + 3.141592653589793) : Calib.rad_to_deg * -phi);
                    if (!(c.del * c.del > 8100.0) || !(Math.abs(this.deltai) > 65.0)) break;
                    c.al = 180.0 - c.al;
                    c.del = 2.0 * this.deltai - c.del;
                    break;
                }
                case 8: {
                    X = x_objr / (this.cdelz - y_objr * this.sdelz);
                    c.al = this.alphai + Calib.rad_to_deg * Math.atan(X);
                    c.del = Calib.rad_to_deg * Math.acos((this.cdelz - yy * this.sdelz) / FastMath.cos((c.al - this.alphai) * Calib.deg_to_rad));
                    if ((this.cdelz - yy * this.sdelz) / FastMath.cos((c.al - this.alphai) * Calib.deg_to_rad) > 1.0) {
                        c.del = -32000.0;
                        c.al = -32000.0;
                    }
                    if (this.sdelz < 0.0) {
                        c.del = -c.del;
                    }
                    if (c.del > 90.0) {
                        c.del = 180.0 - c.del;
                        c.al = 180.0 + c.al;
                    }
                    if (!(c.del < -90.0)) break;
                    c.del = -180.0 - c.del;
                    c.al = 180.0 + c.al;
                    break;
                }
                case 2: 
                case 12: {
                    if (this.xyapoly[1] != 0.0 && this.xyapoly[1] != 1.0 && this.aladin == 0) {
                        posx = this.xyapoly[0] + this.xyapoly[1] * (x_objr *= Calib.rad_to_deg) + this.xyapoly[2] * (yy *= Calib.rad_to_deg) + this.xyapoly[3] * Math.sqrt(x_objr * x_objr + yy * yy) + this.xyapoly[4] * x_objr * x_objr + this.xyapoly[5] * yy * x_objr + this.xyapoly[6] * yy * yy + this.xyapoly[7] * x_objr * x_objr * x_objr + this.xyapoly[8] * yy * x_objr * x_objr + this.xyapoly[9] * yy * yy * x_objr;
                        posy = this.xydpoly[0] + this.xydpoly[1] * yy + this.xydpoly[2] * x_objr + this.xydpoly[3] * Math.sqrt(x_objr * x_objr + yy * yy) + this.xydpoly[4] * yy * yy + this.xydpoly[5] * yy * x_objr + this.xydpoly[6] * x_objr * x_objr + this.xydpoly[7] * yy * yy * yy + this.xydpoly[8] * yy * yy * x_objr + this.xydpoly[9] * yy * x_objr * x_objr;
                        x_objr = posx * Calib.deg_to_rad;
                        yy = posy * Calib.deg_to_rad;
                    }
                    if (this.xyapoly[1] != 0.0 && this.xyapoly[1] != 1.0 && this.aladin == 3) {
                        posx = this.xyapoly[0] + this.xyapoly[2] * (yy *= Calib.rad_to_deg) + this.xyapoly[1] * (x_objr *= Calib.rad_to_deg) + this.xyapoly[5] * yy * yy + this.xyapoly[3] * x_objr * x_objr + this.xyapoly[4] * yy * x_objr + this.xyapoly[9] * yy * yy * yy + this.xyapoly[6] * x_objr * x_objr * x_objr + this.xyapoly[8] * yy * yy * x_objr + this.xyapoly[7] * yy * x_objr * x_objr;
                        posy = this.xydpoly[0] + this.xydpoly[2] * yy + this.xydpoly[1] * x_objr + this.xydpoly[5] * yy * yy + this.xydpoly[3] * x_objr * x_objr + this.xydpoly[4] * yy * x_objr + this.xydpoly[9] * yy * yy * yy + this.xydpoly[6] * x_objr * x_objr * x_objr + this.xydpoly[8] * yy * yy * x_objr + this.xydpoly[7] * yy * x_objr * x_objr;
                        x_objr = posx;
                        yy = posy;
                    }
                    deno = this.cdelz - yy * this.sdelz;
                    d_al = Math.atan(x_objr / deno);
                    c.del = 57.29577951308232 * Math.atan(FastMath.cos(d_al) * (this.sdelz + yy * this.cdelz) / deno);
                    c.al = this.alphai + d_al * Calib.rad_to_deg;
                    if (!(deno < 0.0)) break;
                    c.al += 180.0;
                    c.del = -c.del;
                    break;
                }
                case 3: 
                case 9: {
                    rteta = Math.sqrt(x_objr * x_objr + y_objr * y_objr);
                    if (this.proj != 9) ** GOTO lbl107
                    tet = 0.0;
                    niter = 20;
                    iter = 0;
                    break block46;
lbl107:
                    // 1 sources

                    tet = rteta;
                    while (true) {
                        c.del = rteta == 0.0 ? this.deltai : Calib.rad_to_deg * Math.asin(y_objr * this.cdelz * FastMath.sin(tet) / rteta + this.sdelz * FastMath.cos(tet));
                        if (tet < 1.5707963267948966) {
                            c.al = this.alphai + Calib.rad_to_deg * Math.asin(FastMath.sin(tet) * x_objr / (rteta * FastMath.cos(c.del * Calib.deg_to_rad)));
                            break block0;
                        }
                        c.al = this.alphai + 180.0 - Calib.rad_to_deg * Math.asin(FastMath.sin(tet) * x_objr / (rteta * FastMath.cos(c.del * Calib.deg_to_rad)));
                        break block0;
                        break;
                    }
                }
                case 4: {
                    cdelp = FastMath.cos(this.deltai * Calib.deg_to_rad + 1.5707963267948966);
                    sdelp = FastMath.sin(this.deltai * Calib.deg_to_rad + 1.5707963267948966);
                    if (this.deltai > 0.0) {
                        cdelp = FastMath.cos((90.0 - this.deltai) * Calib.deg_to_rad);
                        sdelp = FastMath.sin((90.0 - this.deltai) * Calib.deg_to_rad);
                    }
                    if ((z = 1.0 - x_objr * x_objr / 16.0 - y_objr * y_objr / 4.0) < 0.5) {
                        throw new Exception("No coordinates");
                    }
                    Z = Math.sqrt(z);
                    tet = Math.asin(y_objr * Z);
                    phi = 2.0 * Math.atan(x_objr * Z / 2.0 / (2.0 * Z * Z - 1.0));
                    if (this.deltai < 0.0) {
                        phi += 3.141592653589793;
                    }
                    c.del = Calib.rad_to_deg * Math.asin(sdelp * FastMath.sin(tet) + cdelp * FastMath.cos(tet) * FastMath.cos(phi));
                    arg1 = -(FastMath.sin(tet) * cdelp - FastMath.cos(tet) * sdelp * FastMath.cos(phi));
                    arg = FastMath.cos(tet) * FastMath.sin(phi);
                    c.al = this.alphai + Calib.rad_to_deg * Math.atan2(arg, arg1);
                    if (this.deltai < 0.0) {
                        c.al += 180.0;
                    }
                    if (!(c.del * c.del > 8100.0) || Math.abs(this.deltai) > 65.0) break;
                    break;
                }
                case 11: {
                    cdelp = FastMath.cos(this.deltai * Calib.deg_to_rad + 1.5707963267948966);
                    sdelp = FastMath.sin(this.deltai * Calib.deg_to_rad + 1.5707963267948966);
                    x = x_objr;
                    y = y_objr;
                    rSq = x * x / 8.0 + y * y / 2.0;
                    if (rSq > 1.0) {
                        throw new Exception("No coordinates");
                    }
                    theta = Math.asin(y / Math.sqrt(2.0));
                    psi = theta * 2.0;
                    Tetha = Math.asin((psi + FastMath.sin(psi)) / 3.141592653589793);
                    Phi = 3.141592653589793 / (2.0 * Math.sqrt(2.0)) * (x / FastMath.cos(theta));
                    c.del = Calib.rad_to_deg * Math.asin(sdelp * FastMath.sin(Tetha) - cdelp * FastMath.cos(Tetha) * FastMath.cos(Phi));
                    arg3 = FastMath.sin(Tetha) * cdelp + FastMath.cos(Tetha) * sdelp * FastMath.cos(Phi);
                    arg2 = FastMath.cos(Tetha) * FastMath.sin(Phi);
                    c.al = this.alphai + Calib.rad_to_deg * Math.atan2(arg2, arg3);
                    break;
                }
                case 5: {
                    rtet = Math.sqrt(x_objr * x_objr + y_objr * y_objr) / 2.0;
                    tet = 1.5707963267948966 - 2.0 * Math.asin(rtet);
                    phi = y_objr != 0.0 ? Math.atan(-x_objr / y_objr) : (x_objr != 0.0 ? 1.5707963267948966 * (-x_objr / x_objr) : 1.5707963267948966);
                    if (y_objr < 0.0) {
                        phi += 3.141592653589793;
                    }
                    c.del = Calib.rad_to_deg * Math.asin(this.sdelz * FastMath.sin(tet) + this.cdelz * FastMath.cos(tet) * FastMath.cos(phi));
                    arg1 = FastMath.sin(tet) * this.cdelz - FastMath.cos(tet) * this.sdelz * FastMath.cos(phi);
                    arg = -(FastMath.cos(tet) * FastMath.sin(phi));
                    c.al = Math.abs(this.deltai) != 90.0 ? this.alphai + Calib.rad_to_deg * Math.atan2(arg, arg1) : (this.deltai == 90.0 ? Calib.rad_to_deg * (phi + 3.141592653589793) : Calib.rad_to_deg * -phi);
                    if (!(c.del * c.del > 8100.0) || !(Math.abs(this.deltai) > 65.0)) break;
                    c.al = 180.0 - c.al;
                    c.del = 2.0 * this.deltai - c.del;
                    break;
                }
                case 6: {
                    sintet = FastMath.sin(1.5707963267948966 - 2.0 * Math.atan(Math.sqrt(y_objr * y_objr + x_objr * x_objr) / 2.0));
                    c.del = Calib.rad_to_deg * Math.asin(this.cdelz * y_objr / 2.0 + sintet * (this.sdelz + this.cdelz * y_objr / 2.0));
                    deno = sintet * (2.0 * this.cdelz - y_objr * this.sdelz) - y_objr * this.sdelz;
                    c.al = this.alphai + Calib.rad_to_deg * Math.atan2(x_objr * (1.0 + sintet), deno);
                    break;
                }
                case 7: {
                    c.al = this.alphai + x_objr * Calib.rad_to_deg;
                    c.del = this.deltai + y_objr * Calib.rad_to_deg;
                    break;
                }
                case 10: {
                    c.al = this.alphai + x_objr * Calib.rad_to_deg;
                    c.del = this.deltai + y_objr * Calib.rad_to_deg;
                    break;
                }
            }
            if (this.system == Calib.XYLINEAR) {
                return;
            }
            if (this.system == Calib.FK4) {
                ac = new Astrocoo(Calib.AF_FK4, c.al, c.del);
                ac.setPrecision(9);
                ac.convertTo(Calib.AF_ICRS);
                c.al = ac.getLon();
                c.del = ac.getLat();
            }
            if (this.system == Calib.FK5) {
                ac = new Astrocoo(Calib.AF_FK5, c.al, c.del);
                ac.setPrecision(9);
                ac.convertTo(Calib.AF_ICRS);
                c.al = ac.getLon();
                c.del = ac.getLat();
            }
            if (this.system == Calib.GALACTIC) {
                ac = new Astrocoo(Calib.AF_GAL, c.al, c.del);
                ac.setPrecision(9);
                ac.convertTo(Calib.AF_ICRS);
                c.al = ac.getLon();
                c.del = ac.getLat();
            }
            if (this.system == Calib.SUPERGALACTIC) {
                ac = new Astrocoo(Calib.AF_SGAL, c.al, c.del);
                ac.setPrecision(9);
                ac.convertTo(Calib.AF_ICRS);
                c.al = ac.getLon();
                c.del = ac.getLat();
            }
            if (this.system == Calib.ECLIPTIC) {
                ac = new Astrocoo(Calib.AF_ECL, c.al, c.del);
                ac.setPrecision(9);
                ac.convertTo(Calib.AF_ICRS);
                c.al = ac.getLon();
                c.del = ac.getLat();
            }
            if (c.al >= 360.0) {
                c.al -= 360.0;
            }
            if (!(c.al < 0.0)) return;
            c.al += 360.0;
            return;
        }
        while (true) {
            if (iter >= niter) ** continue;
            rrr = 0.0;
            drrr = 0.0;
            for (order = 9; order >= 0; --order) {
                rrr = rrr * tet + this.adxpoly[order];
            }
            for (order = 8; order >= 0; --order) {
                drrr = drrr * tet + (double)(order + 1) * this.adxpoly[order + 1];
            }
            dtet = (rteta - rrr) / drrr;
            tet += dtet;
            ++iter;
        }
    }

    protected boolean TheSame(Calib cal) {
        if (this.aladin == 1) {
            return false;
        }
        if (this.xnpix != cal.xnpix) {
            return false;
        }
        if (this.ynpix != cal.ynpix) {
            return false;
        }
        if (this.Xcen != cal.Xcen) {
            return false;
        }
        if (this.Ycen != cal.Ycen) {
            return false;
        }
        if (this.alphai != cal.alphai) {
            return false;
        }
        if (this.deltai != cal.deltai) {
            return false;
        }
        if (this.CD[0][0] != cal.CD[0][0]) {
            return false;
        }
        if (this.CD[0][1] != cal.CD[0][1]) {
            return false;
        }
        if (this.CD[1][0] != cal.CD[1][0]) {
            return false;
        }
        if (this.CD[1][1] != cal.CD[1][1]) {
            return false;
        }
        if (this.equinox != cal.equinox) {
            return false;
        }
        return this.proj == cal.proj;
    }

    public void GetXY(Coord c) throws Exception {
        this.GetXY(c, true);
    }

    public void GetXY(Coord c, boolean withTest) throws Exception {
        double x_obj = 1.0;
        double y_obj = 1.0;
        double y_stand = 0.03;
        double x_stand = 0.03;
        if (this.aladin == 1) {
            double distalpha;
            double cos_del = FastMath.cos(c.del * deg_to_rad);
            if (cos_del * (distalpha = Math.min(Math.abs(c.al - this.alphai), 360.0 - Math.abs(c.al - this.alphai))) * cos_del * distalpha + (c.del - this.deltai) * (c.del - this.deltai) > 625.0) {
                throw new Exception("Outside the projection");
            }
            double delrad = c.del * deg_to_rad;
            double alrad = (c.al - this.alpha) * deg_to_rad;
            double sin_delrad = FastMath.sin(delrad);
            double cos_delrad = FastMath.cos(delrad);
            double sin_alrad = FastMath.sin(alrad);
            double cos_alrad = FastMath.cos(alrad);
            double dr = sin_delrad * this.sdelz + cos_delrad * this.cdelz * cos_alrad;
            x_stand = cos_delrad * sin_alrad / dr;
            y_stand = (sin_delrad * this.cdelz - cos_delrad * this.sdelz * cos_alrad) / dr;
            x_obj = this.adxpoly[0] + this.adxpoly[1] * x_stand + this.adxpoly[2] * y_stand + this.adxpoly[3] * x_stand * x_stand + this.adxpoly[4] * y_stand * y_stand + this.adxpoly[5] * y_stand * x_stand + this.adxpoly[6] * x_stand * x_stand * x_stand + this.adxpoly[7] * y_stand * y_stand * y_stand + this.adxpoly[8] * y_stand * x_stand * x_stand + this.adxpoly[9] * y_stand * y_stand * x_stand;
            y_obj = this.adypoly[0] + this.adypoly[1] * x_stand + this.adypoly[2] * y_stand + this.adypoly[3] * x_stand * x_stand + this.adypoly[4] * y_stand * y_stand + this.adypoly[5] * y_stand * x_stand + this.adypoly[6] * x_stand * x_stand * x_stand + this.adypoly[7] * y_stand * y_stand * y_stand + this.adypoly[8] * y_stand * x_stand * x_stand + this.adypoly[9] * y_stand * y_stand * x_stand;
            x_obj = x_obj * this.focale + this.xz;
            y_obj = y_obj * this.focale + this.yz;
            c.x = (x_obj * 1000.0 - this.Xorg) / this.incX;
            c.y = (y_obj * 1000.0 - this.Yorg) / this.incY;
        } else {
            double al = c.al;
            double del = c.del;
            if (this.system != ICRS && this.system != XYLINEAR) {
                Astroframe af = this.system == FK4 ? AF_FK4 : (this.system == FK5 ? AF_FK5 : (this.system == GALACTIC ? AF_GAL : (this.system == SUPERGALACTIC ? AF_SGAL : (this.system == ECLIPTIC ? AF_ECL : null))));
                Astrocoo ac = new Astrocoo(AF_ICRS, c.al, c.del);
                ac.setPrecision(9);
                ac.convertTo(af);
                al = ac.getLon();
                del = ac.getLat();
            }
            double dalpha = (al - this.alphai) * deg_to_rad;
            double cos_del = FastMath.cos(del * deg_to_rad);
            double sin_del = FastMath.sin(del * deg_to_rad);
            double sin_dalpha = FastMath.sin(dalpha);
            double cos_dalpha = FastMath.cos(dalpha);
            double x_tet_phi = cos_del * sin_dalpha;
            double y_tet_phi = sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha;
            if (withTest) {
                switch (this.proj) {
                    case 1: 
                    case 2: 
                    case 8: 
                    case 12: {
                        if (dalpha > Math.PI) {
                            dalpha = Math.PI * -2 + dalpha;
                        }
                        if (dalpha < -Math.PI) {
                            dalpha = Math.PI * 2 + dalpha;
                        }
                        if (-sin_del * this.sdelz / (cos_del * this.cdelz) > 1.0) {
                            throw new Exception("Outside the projection");
                        }
                        if (!(-sin_del * this.sdelz / (cos_del * this.cdelz) > -1.0) || !(Math.abs(dalpha) > Math.acos(-sin_del * this.sdelz / (cos_del * this.cdelz)))) break;
                        throw new Exception("Outside the projection");
                    }
                }
            }
            switch (this.proj) {
                case 1: {
                    x_stand = rad_to_deg * x_tet_phi;
                    y_stand = rad_to_deg * y_tet_phi;
                    if (this.xydpoly[1] == 0.0 || this.xydpoly[2] == 0.0) break;
                    x_stand += rad_to_deg * this.xydpoly[1] * (1.0 - (sin_del * this.sdelz + cos_del * this.cdelz * cos_dalpha));
                    y_stand += rad_to_deg * this.xydpoly[2] * (1.0 - (sin_del * this.sdelz + cos_del * this.cdelz * cos_dalpha));
                    break;
                }
                case 8: {
                    x_stand = rad_to_deg * x_tet_phi;
                    if (this.sdelz == 0.0) {
                        y_stand = rad_to_deg * y_tet_phi;
                        break;
                    }
                    if (this.sdelz * sin_del > 0.0) {
                        y_stand = rad_to_deg * y_tet_phi + this.cdelz / this.sdelz * rad_to_deg * (1.0 - Math.sqrt(1.0 - cos_del * cos_del * sin_dalpha * sin_dalpha - sin_del * sin_del * this.cdelz * this.cdelz - cos_del * cos_del * this.sdelz * this.sdelz * cos_dalpha * cos_dalpha + 2.0 * sin_del * cos_del * this.sdelz * this.cdelz * cos_dalpha));
                        break;
                    }
                    x_stand = 0.0;
                    y_stand = 0.0;
                    break;
                }
                case 2: 
                case 12: {
                    double dy;
                    double dx;
                    double tmp;
                    double det;
                    double m4;
                    double m3;
                    double m2;
                    double m1;
                    int iter;
                    double yy;
                    double xx;
                    double X;
                    double den = sin_del * this.sdelz + cos_del * this.cdelz * cos_dalpha;
                    x_stand = x_tet_phi / den;
                    y_stand = y_tet_phi / den;
                    if (this.xyapoly[1] != 0.0 && this.xyapoly[1] != 1.0 && this.aladin == 0) {
                        x_stand *= rad_to_deg;
                        y_stand *= rad_to_deg;
                        X = this.xyapoly[0];
                        double Y = this.xydpoly[0];
                        xx = 0.0;
                        yy = 0.0;
                        int niter = 20;
                        for (iter = 0; iter < niter; ++iter) {
                            m1 = this.xyapoly[1] + 2.0 * this.xyapoly[4] * xx + this.xyapoly[5] * yy + 3.0 * this.xyapoly[7] * xx * xx + this.xyapoly[9] * yy * yy + 2.0 * this.xyapoly[8] * yy * xx;
                            m2 = this.xydpoly[2] + 2.0 * this.xydpoly[6] * xx + this.xydpoly[5] * yy + this.xydpoly[8] * yy * yy + 2.0 * this.xydpoly[9] * yy * xx;
                            m3 = this.xyapoly[2] + 2.0 * this.xyapoly[6] * yy + this.xyapoly[5] * xx + 2.0 * this.xyapoly[9] * yy * xx + this.xyapoly[8] * xx * xx;
                            m4 = this.xydpoly[1] + 2.0 * this.xydpoly[4] * yy + this.xydpoly[5] * xx + 3.0 * this.xydpoly[7] * yy * yy + 2.0 * this.xydpoly[8] * yy * xx + this.xydpoly[9] * xx * xx;
                            det = m1 * m4 - m2 * m3;
                            tmp = m4 / det;
                            m4 = m1 / det;
                            m1 = tmp;
                            dx = m1 * (x_stand - X) + (m3 /= -det) * (y_stand - Y);
                            dy = (m2 /= -det) * (x_stand - X) + m4 * (y_stand - Y);
                            X = this.xyapoly[0] + this.xyapoly[2] * (yy += dy) + this.xyapoly[1] * (xx += dx) + this.xyapoly[6] * yy * yy + this.xyapoly[4] * xx * xx + this.xyapoly[5] * yy * xx + this.xyapoly[7] * xx * xx * xx + this.xyapoly[9] * yy * yy * xx + this.xyapoly[8] * yy * xx * xx;
                            Y = this.xydpoly[0] + this.xydpoly[1] * yy + this.xydpoly[2] * xx + this.xydpoly[4] * yy * yy + this.xydpoly[6] * xx * xx + this.xydpoly[5] * yy * xx + this.xydpoly[7] * yy * yy * yy + this.xydpoly[8] * yy * yy * xx + this.xydpoly[9] * yy * xx * xx;
                        }
                        x_stand = xx;
                        y_stand = yy;
                        break;
                    }
                    if (this.xyapoly[1] != 0.0 && this.xyapoly[1] != 1.0 && this.aladin == 3) {
                        X = this.xyapoly[0];
                        double Y = this.xydpoly[0];
                        xx = 0.0;
                        yy = 0.0;
                        int niter = 20;
                        for (iter = 0; iter < niter; ++iter) {
                            m1 = this.xyapoly[1] + 2.0 * this.xyapoly[3] * xx + this.xyapoly[4] * yy + 3.0 * this.xyapoly[6] * xx * xx + this.xyapoly[8] * yy * yy + 2.0 * this.xyapoly[7] * yy * xx;
                            m2 = this.xydpoly[1] + 2.0 * this.xydpoly[3] * xx + this.xydpoly[4] * yy + 3.0 * this.xydpoly[6] * xx * xx + this.xydpoly[8] * yy * yy + 2.0 * this.xydpoly[7] * yy * xx;
                            m3 = this.xyapoly[2] + 2.0 * this.xyapoly[5] * yy + this.xyapoly[4] * xx + 3.0 * this.xyapoly[9] * yy * yy + 2.0 * this.xyapoly[8] * yy * xx + this.xyapoly[7] * xx * xx;
                            m4 = this.xydpoly[2] + 2.0 * this.xydpoly[5] * yy + this.xydpoly[4] * xx + 3.0 * this.xydpoly[9] * yy * yy + 2.0 * this.xydpoly[8] * yy * xx + this.xydpoly[7] * xx * xx;
                            det = m1 * m4 - m2 * m3;
                            tmp = m4 / det;
                            m4 = m1 / det;
                            m1 = tmp;
                            dx = m1 * (x_stand - X) + (m3 /= -det) * (y_stand - Y);
                            dy = (m2 /= -det) * (x_stand - X) + m4 * (y_stand - Y);
                            X = this.xyapoly[0] + this.xyapoly[2] * (yy += dy) + this.xyapoly[1] * (xx += dx) + this.xyapoly[5] * yy * yy + this.xyapoly[3] * xx * xx + this.xyapoly[4] * yy * xx + this.xyapoly[9] * yy * yy * yy + this.xyapoly[6] * xx * xx * xx + this.xyapoly[8] * yy * yy * xx + this.xyapoly[7] * yy * xx * xx;
                            Y = this.xydpoly[0] + this.xydpoly[2] * yy + this.xydpoly[1] * xx + this.xydpoly[5] * yy * yy + this.xydpoly[3] * xx * xx + this.xydpoly[4] * yy * xx + this.xydpoly[9] * yy * yy * yy + this.xydpoly[6] * xx * xx * xx + this.xydpoly[8] * yy * yy * xx + this.xydpoly[7] * yy * xx * xx;
                        }
                        x_stand = xx;
                        y_stand = yy;
                        break;
                    }
                    if (this.xyapoly[1] != 0.0 && this.xyapoly[1] != 1.0 && this.aladin == 2) {
                        X = this.xyapoly[0];
                        double Y = this.xydpoly[0];
                        xx = 0.0;
                        yy = 0.0;
                        int niter = 5;
                        for (iter = 0; iter < niter; ++iter) {
                            m1 = this.xyapoly[2] + 2.0 * this.xyapoly[4] * xx + this.xyapoly[5] * yy + 3.0 * this.xyapoly[7] * xx * xx + this.xyapoly[8] * yy * yy + 2.0 * this.xyapoly[9] * yy * xx;
                            m2 = this.xydpoly[2] + 2.0 * this.xydpoly[4] * xx + this.xydpoly[5] * yy + 3.0 * this.xydpoly[7] * xx * xx + this.xydpoly[8] * yy * yy + 2.0 * this.xydpoly[9] * yy * xx;
                            m3 = this.xyapoly[1] + 2.0 * this.xyapoly[3] * yy + this.xyapoly[5] * xx + 3.0 * this.xyapoly[6] * yy * yy + 2.0 * this.xyapoly[8] * yy * xx + this.xyapoly[9] * xx * xx;
                            m4 = this.xydpoly[1] + 2.0 * this.xydpoly[3] * yy + this.xydpoly[5] * xx + 3.0 * this.xydpoly[6] * yy * yy + 2.0 * this.xydpoly[8] * yy * xx + this.xydpoly[9] * xx * xx;
                            det = m1 * m4 - m2 * m3;
                            tmp = m4 / det;
                            m4 = m1 / det;
                            m1 = tmp;
                            dx = m1 * (x_stand - X) + (m3 /= -det) * (y_stand - Y);
                            dy = (m2 /= -det) * (x_stand - X) + m4 * (y_stand - Y);
                            X = this.xyapoly[0] + this.xyapoly[1] * (yy += dy) + this.xyapoly[2] * (xx += dx) + this.xyapoly[3] * yy * yy + this.xyapoly[4] * xx * xx + this.xyapoly[5] * yy * xx + this.xyapoly[6] * yy * yy * yy + this.xyapoly[7] * xx * xx * xx + this.xyapoly[8] * yy * yy * xx + this.xyapoly[9] * yy * xx * xx;
                            Y = this.xydpoly[0] + this.xydpoly[1] * yy + this.xydpoly[2] * xx + this.xydpoly[3] * yy * yy + this.xydpoly[4] * xx * xx + this.xydpoly[5] * yy * xx + this.xydpoly[6] * yy * yy * yy + this.xydpoly[7] * xx * xx * xx + this.xydpoly[8] * yy * yy * xx + this.xydpoly[9] * yy * xx * xx;
                        }
                        x_stand = xx;
                        y_stand = yy;
                        break;
                    }
                    x_stand *= rad_to_deg;
                    y_stand *= rad_to_deg;
                    break;
                }
                case 3: 
                case 9: {
                    double rteta;
                    double phi = sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha != 0.0 ? Math.atan(-cos_del * sin_dalpha / (sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha)) : (-cos_del * sin_dalpha < 0.0 ? 1.5707963267948966 : -1.5707963267948966);
                    if (sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha > 0.0) {
                        phi = Math.PI + phi;
                    }
                    double tet = Math.asin(sin_del * this.sdelz + cos_del * this.cdelz * cos_dalpha);
                    if (this.proj == 9) {
                        rteta = 0.0;
                        for (int order = 9; order >= 0; --order) {
                            rteta = rteta * (1.5707963267948966 - tet) + this.adxpoly[order];
                        }
                    } else {
                        rteta = 1.5707963267948966 - tet;
                    }
                    x_stand = rteta * FastMath.sin(phi);
                    y_stand = -rteta * FastMath.cos(phi);
                    x_stand *= rad_to_deg;
                    y_stand *= rad_to_deg;
                    break;
                }
                case 4: {
                    double cdelp = FastMath.cos(this.deltai * deg_to_rad + 1.5707963267948966);
                    double sdelp = FastMath.sin(this.deltai * deg_to_rad + 1.5707963267948966);
                    double phi = Math.atan2(cos_del * sin_dalpha, -(sin_del * cdelp - cos_del * sdelp * cos_dalpha));
                    double tet = Math.asin(sin_del * sdelp + cos_del * cdelp * cos_dalpha);
                    if (phi > Math.PI) {
                        phi = Math.PI * -2 + phi;
                    }
                    double alph = Math.sqrt(2.0 / (1.0 + FastMath.cos(tet) * FastMath.cos(phi / 2.0)));
                    x_stand = 2.0 * alph * FastMath.cos(tet) * FastMath.sin(phi / 2.0);
                    y_stand = alph * FastMath.sin(tet);
                    x_stand *= rad_to_deg;
                    y_stand *= rad_to_deg;
                    break;
                }
                case 11: {
                    double cdelp = FastMath.cos(this.deltai * deg_to_rad + 1.5707963267948966);
                    double sdelp = FastMath.sin(this.deltai * deg_to_rad + 1.5707963267948966);
                    double phi = Math.atan2(cos_del * sin_dalpha, -(sin_del * cdelp - cos_del * sdelp * cos_dalpha));
                    double tet = Math.asin(sin_del * sdelp + cos_del * cdelp * cos_dalpha);
                    double psi = 2.0 * Math.asin(2.0 * tet / Math.PI);
                    double previous = 0.0;
                    for (int i = 0; i < 200; ++i) {
                        previous = psi;
                        if (Double.isNaN(psi -= (psi + FastMath.sin(psi) - Math.PI * FastMath.sin(tet)) / (1.0 + FastMath.cos(psi)))) {
                            psi = previous;
                            break;
                        }
                        if (Math.abs(psi - previous) > 1.0E-4) break;
                    }
                    double theta = psi / 2.0;
                    x_stand = 2.0 * Math.sqrt(2.0) / Math.PI * phi * FastMath.cos(theta) * rad_to_deg;
                    y_stand = Math.sqrt(2.0) * FastMath.sin(theta) * rad_to_deg;
                    break;
                }
                case 5: {
                    double phi = sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha != 0.0 ? Math.atan(-cos_del * sin_dalpha / (sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha)) : (-cos_del * sin_dalpha < 0.0 ? 1.5707963267948966 : -1.5707963267948966);
                    if (sin_del * this.cdelz - cos_del * this.sdelz * cos_dalpha > 0.0 && Math.abs(FastMath.sin(phi)) != 1.0) {
                        phi = Math.PI + phi;
                    }
                    double tet = Math.asin(sin_del * this.sdelz + cos_del * this.cdelz * cos_dalpha);
                    double rtet = rad_to_deg * Math.sqrt(2.0 * (1.0 - FastMath.sin(tet)));
                    x_stand = rtet * FastMath.sin(phi);
                    y_stand = -rtet * FastMath.cos(phi);
                    break;
                }
                case 6: {
                    double den = 1.0 + sin_del * this.sdelz + cos_del * this.cdelz * cos_dalpha;
                    x_stand = 2.0 * x_tet_phi / den;
                    y_stand = 2.0 * y_tet_phi / den;
                    x_stand *= rad_to_deg;
                    y_stand *= rad_to_deg;
                    break;
                }
                case 7: {
                    x_stand = al - this.alphai;
                    y_stand = del - this.deltai;
                    double xshift = 0.0;
                    if (x_stand + 360.0 > Math.min(this.CD[0][0] * -this.Xcen + this.CD[0][1] * this.Ycen, this.CD[0][0] * ((double)this.xnpix - this.Xcen) + this.CD[0][1] * this.Ycen) && x_stand + 360.0 < Math.max(this.CD[0][0] * -this.Xcen + this.CD[0][1] * this.Ycen, this.CD[0][0] * ((double)this.xnpix - this.Xcen) + this.CD[0][1] * this.Ycen)) {
                        xshift = 360.0;
                    }
                    if (x_stand - 360.0 > Math.min(this.CD[0][0] * -this.Xcen + this.CD[0][1] * this.Ycen, this.CD[0][0] * ((double)this.xnpix - this.Xcen) + this.CD[0][1] * this.Ycen) && x_stand - 360.0 < Math.max(this.CD[0][0] * -this.Xcen + this.CD[0][1] * this.Ycen, this.CD[0][0] * ((double)this.xnpix - this.Xcen) + this.CD[0][1] * this.Ycen)) {
                        xshift = -360.0;
                    }
                    x_stand += xshift;
                    break;
                }
                case 10: {
                    x_stand = al - this.alphai;
                    y_stand = del - this.deltai;
                    break;
                }
            }
            if (this.aladin != 2) {
                c.x = this.ID[0][0] * x_stand + this.ID[0][1] * y_stand + this.Xcen;
                c.y = -(this.ID[1][0] * x_stand + this.ID[1][1] * y_stand) + (double)this.ynpix - this.Ycen;
                if (this.xyapoly[1] != 0.0 && this.xyapoly[1] != 1.0 && (this.proj == 2 || this.proj == 12) && this.aladin == 3 && this.xydpoly[2] * this.ID[1][1] < 0.0) {
                    c.y = this.ID[1][0] * x_stand + this.ID[1][1] * y_stand + this.Ycen;
                }
                if (this.proj == 12) {
                    if (this.order_ap == 0 || this.order_bp == 0) {
                        double X = 0.0;
                        double Y = 0.0;
                        double xx = 0.0;
                        double yy = 0.0;
                        int niter = 20;
                        int iter = 0;
                        while (iter < niter) {
                            int powx;
                            int order;
                            int powx2;
                            int order2;
                            ++iter;
                            double m1 = 1.0;
                            for (order2 = 2; order2 < this.order_a + 1; ++order2) {
                                for (powx2 = 0; powx2 < order2 + 1; ++powx2) {
                                    m1 += (double)powx2 * this.sip_a[powx2][order2 - powx2] * Math.pow(xx, powx2 - 1) * Math.pow(yy, order2 - powx2);
                                }
                            }
                            double m2 = 0.0;
                            for (order2 = 2; order2 < this.order_a + 1; ++order2) {
                                for (powx2 = 0; powx2 < order2 + 1; ++powx2) {
                                    m2 += (double)(order2 - powx2) * this.sip_a[powx2][order2 - powx2] * Math.pow(xx, powx2) * Math.pow(yy, order2 - powx2 - 1);
                                }
                            }
                            double m3 = 1.0;
                            for (order2 = 2; order2 < this.order_b + 1; ++order2) {
                                for (powx2 = 0; powx2 < order2 + 1; ++powx2) {
                                    m3 += (double)powx2 * this.sip_b[powx2][order2 - powx2] * Math.pow(xx, powx2 - 1) * Math.pow(yy, order2 - powx2);
                                }
                            }
                            double m4 = 0.0;
                            for (order2 = 2; order2 < this.order_b + 1; ++order2) {
                                for (powx2 = 0; powx2 < order2 + 1; ++powx2) {
                                    m4 += (double)(order2 - powx2) * this.sip_b[powx2][order2 - powx2] * Math.pow(xx, powx2) * Math.pow(yy, order2 - powx2 - 1);
                                }
                            }
                            double det = m1 * m4 - m2 * m3;
                            double tmp = m4 / det;
                            m2 /= -det;
                            m4 = m1 / det;
                            m1 = tmp;
                            double DX = this.ID[0][0] * (x_stand - X) + this.ID[0][1] * (y_stand - Y);
                            double DY = this.ID[1][0] * (x_stand - X) + this.ID[1][1] * (y_stand - Y);
                            double dx = m1 * DX + (m3 /= -det) * DY;
                            double dy = m2 * DX + m4 * DY;
                            double xint = xx += dx;
                            double yint = yy += dy;
                            double px = xint;
                            double py = yint;
                            for (order = 2; order < this.order_a + 1; ++order) {
                                for (powx = 0; powx < order + 1; ++powx) {
                                    px += this.sip_a[powx][order - powx] * Math.pow(xint, powx) * Math.pow(yint, order - powx);
                                }
                            }
                            for (order = 2; order < this.order_b + 1; ++order) {
                                for (powx = 0; powx < order + 1; ++powx) {
                                    py += this.sip_b[powx][order - powx] * Math.pow(xint, powx) * Math.pow(yint, order - powx);
                                }
                            }
                            X = this.CD[0][0] * px + this.CD[0][1] * py;
                            Y = this.CD[1][0] * px + this.CD[1][1] * py;
                        }
                        c.x = xx + this.Xcen;
                        c.y = yy + (double)this.ynpix - this.Ycen;
                    } else {
                        int powx;
                        int order;
                        double xint = c.x - this.Xcen;
                        double yint = -(c.y - (double)this.ynpix + this.Ycen);
                        c.x = xint;
                        for (order = 2; order < this.order_ap + 1; ++order) {
                            for (powx = 0; powx < order + 1; ++powx) {
                                for (int j = 0; j < order - powx + 1; ++j) {
                                    c.x += this.sip_ap[powx][j] * Math.pow(xint, powx) * Math.pow(yint, j);
                                }
                            }
                        }
                        c.x += this.Xcen;
                        c.y = yint;
                        for (order = 2; order < this.order_bp + 1; ++order) {
                            for (powx = 0; powx < order + 1; ++powx) {
                                for (int j = 0; j < order - powx + 1; ++j) {
                                    c.y += this.sip_bp[powx][j] * Math.pow(xint, powx) * Math.pow(yint, j);
                                }
                            }
                        }
                        c.y = -c.y + (double)this.ynpix - this.Ycen;
                    }
                }
            } else {
                c.x = (x_stand * this.focale * 1000.0 + this.xz * 1000.0 - this.Xorg) / this.incX;
                c.y = (y_stand * this.focale * 1000.0 + this.yz * 1000.0 - this.Yorg) / this.incY;
            }
        }
    }

    public double[] GetResol() {
        double[] inc = new double[]{Math.abs(this.incA), Math.abs(this.incD)};
        return inc;
    }

    protected void GetWCS_i() throws Exception {
        Coord a_d = new Coord();
        Coord x_y_1 = new Coord();
        Coord x_y_2 = new Coord();
        Coord x_y_3 = new Coord();
        Coord x_y_4 = new Coord();
        if (this.aladin == 1) {
            this.Xcen = (this.xz * 1000.0 - this.Xorg) / this.incX;
            this.Ycen = (this.yz * 1000.0 - this.Yorg) / this.incY;
            this.alphai = this.alpha;
            this.deltai = this.delta;
            this.CD[0][0] = 1.0;
            this.CD[0][1] = 0.0;
            this.CD[1][0] = 0.0;
            this.CD[1][1] = 1.0;
            this.ID[0][0] = 1.0;
            this.ID[0][1] = 0.0;
            this.ID[1][0] = 0.0;
            this.ID[1][1] = 1.0;
            this.Xcen = (double)this.xnpix / 2.0;
            this.Ycen = (double)this.ynpix / 2.0;
            a_d.x = this.Xcen;
            a_d.y = this.Ycen;
            this.GetCoord(a_d);
            this.alphai = a_d.al;
            this.deltai = a_d.del;
            x_y_1.x = this.Xcen - (double)this.xnpix / 4.0;
            x_y_1.y = this.Ycen - (double)this.ynpix / 4.0;
            this.GetCoord(x_y_1);
            double cdelz1 = FastMath.cos(this.deltai / 180.0 * Math.PI);
            double sdelz1 = FastMath.sin(this.deltai / 180.0 * Math.PI);
            double deno = FastMath.sin(x_y_1.del * Math.PI / 180.0) * sdelz1 + FastMath.cos(x_y_1.del * Math.PI / 180.0) * cdelz1 * FastMath.cos((x_y_1.al - this.alphai) * Math.PI / 180.0);
            double xst = FastMath.cos(x_y_1.del * Math.PI / 180.0) * FastMath.sin((x_y_1.al - this.alphai) * Math.PI / 180.0) / deno;
            double yst = FastMath.sin(x_y_1.del * Math.PI / 180.0) * cdelz1 - FastMath.cos(x_y_1.del * Math.PI / 180.0) * sdelz1 * FastMath.cos((x_y_1.al - this.alphai) * Math.PI / 180.0) / deno;
            this.CD[0][0] = -((double)this.ynpix * xst + (double)this.xnpix * yst) * 2.0 / (double)this.ynpix / (double)this.xnpix;
            this.CD[0][1] = ((double)this.ynpix * xst - (double)this.xnpix * yst) * 2.0 / (double)this.xnpix / (double)this.ynpix;
            x_y_2.x = this.Xcen + (double)this.xnpix / 4.0;
            x_y_2.y = this.Ycen - (double)this.ynpix / 4.0;
            this.GetCoord(x_y_2);
            deno = FastMath.sin(x_y_2.del * Math.PI / 180.0) * sdelz1 + FastMath.cos(x_y_2.del * Math.PI / 180.0) * cdelz1 * FastMath.cos((x_y_2.al - this.alphai) * Math.PI / 180.0);
            xst = FastMath.cos(x_y_2.del * Math.PI / 180.0) * FastMath.sin((x_y_2.al - this.alphai) * Math.PI / 180.0) / deno;
            yst = FastMath.sin(x_y_2.del * Math.PI / 180.0) * cdelz1 - FastMath.cos(x_y_2.del * Math.PI / 180.0) * sdelz1 * FastMath.cos((x_y_2.al - this.alphai) * Math.PI / 180.0) / deno;
            double[] dArray = this.CD[0];
            dArray[0] = dArray[0] + ((double)this.ynpix * xst - (double)this.xnpix * yst) * 2.0 / (double)this.ynpix / (double)this.xnpix;
            double[] dArray2 = this.CD[0];
            dArray2[1] = dArray2[1] + ((double)this.ynpix * xst + (double)this.xnpix * yst) * 2.0 / (double)this.xnpix / (double)this.ynpix;
            x_y_3.x = this.Xcen - (double)this.xnpix / 4.0;
            x_y_3.y = this.Ycen + (double)this.ynpix / 4.0;
            this.GetCoord(x_y_3);
            deno = FastMath.sin(x_y_3.del * Math.PI / 180.0) * sdelz1 + FastMath.cos(x_y_3.del * Math.PI / 180.0) * cdelz1 * FastMath.cos((x_y_3.al - this.alphai) * Math.PI / 180.0);
            xst = FastMath.cos(x_y_3.del * Math.PI / 180.0) * FastMath.sin((x_y_3.al - this.alphai) * Math.PI / 180.0) / deno;
            yst = FastMath.sin(x_y_3.del * Math.PI / 180.0) * cdelz1 - FastMath.cos(x_y_3.del * Math.PI / 180.0) * sdelz1 * FastMath.cos((x_y_3.al - this.alphai) * Math.PI / 180.0) / deno;
            double[] dArray3 = this.CD[0];
            dArray3[0] = dArray3[0] - ((double)this.ynpix * xst - (double)this.xnpix * yst) * 2.0 / (double)this.ynpix / (double)this.xnpix;
            double[] dArray4 = this.CD[0];
            dArray4[1] = dArray4[1] - (xst * (double)this.ynpix + yst * (double)this.xnpix) * 2.0 / (double)this.xnpix / (double)this.ynpix;
            x_y_4.x = this.Xcen + (double)this.xnpix / 4.0;
            x_y_4.y = this.Ycen + (double)this.ynpix / 4.0;
            this.GetCoord(x_y_4);
            deno = FastMath.sin(x_y_4.del * Math.PI / 180.0) * sdelz1 + FastMath.cos(x_y_4.del * Math.PI / 180.0) * cdelz1 * FastMath.cos((x_y_4.al - this.alphai) * Math.PI / 180.0);
            xst = FastMath.cos(x_y_4.del * Math.PI / 180.0) * FastMath.sin((x_y_4.al - this.alphai) * Math.PI / 180.0) / deno;
            yst = FastMath.sin(x_y_4.del * Math.PI / 180.0) * cdelz1 - FastMath.cos(x_y_4.del * Math.PI / 180.0) * sdelz1 * FastMath.cos((x_y_4.al - this.alphai) * Math.PI / 180.0) / deno;
            double[] dArray5 = this.CD[0];
            dArray5[0] = dArray5[0] + ((double)this.ynpix * xst + (double)this.xnpix * yst) * 2.0 / (double)this.ynpix / (double)this.xnpix;
            double[] dArray6 = this.CD[0];
            dArray6[1] = dArray6[1] - (xst * (double)this.ynpix - yst * (double)this.xnpix) * 2.0 / (double)this.xnpix / (double)this.ynpix;
            double[] dArray7 = this.CD[0];
            dArray7[0] = dArray7[0] * 14.32394487827058;
            double[] dArray8 = this.CD[0];
            dArray8[1] = dArray8[1] * 14.32394487827058;
            this.CD[1][0] = this.CD[0][1];
            this.CD[1][1] = -this.CD[0][0];
            this.equinox = 2000.0;
            this.proj = 2;
        }
    }

    protected void GetWCS(Vector key, Vector value) throws Exception {
        this.GetWCS_i();
        key.addElement("NAXIS1  ");
        value.addElement(new Integer(this.xnpix).toString());
        key.addElement("NAXIS2  ");
        value.addElement(new Integer(this.ynpix).toString());
        key.addElement("CRPIX1  ");
        value.addElement(new Double(this.Xcen).toString());
        key.addElement("CRPIX2  ");
        value.addElement(new Double(this.Ycen).toString());
        key.addElement("EQUINOX ");
        value.addElement(new Double(this.equinox).toString());
        boolean flagPermute = this.aladin != 1 && this.type1 != null && this.type1.startsWith("DEC");
        key.addElement("CRVAL1  ");
        value.addElement(new Double(flagPermute ? this.deltai : this.alphai).toString());
        key.addElement("CRVAL2  ");
        value.addElement(new Double(flagPermute ? this.alphai : this.deltai).toString());
        key.addElement("CTYPE1  ");
        if (this.aladin == 1) {
            value.addElement("'RA---TAN'");
        } else {
            value.addElement(this.type1);
        }
        key.addElement("CTYPE2  ");
        if (this.aladin == 1) {
            value.addElement("'DEC--TAN'");
        }
        if (this.aladin == 1) {
            value.addElement("'DEC--TAN'");
        } else {
            value.addElement(this.type2);
        }
        if (RADECSYS[this.system].length() > 0) {
            key.addElement("RADECSYS");
            value.addElement(RADECSYS[this.system]);
        }
        key.addElement("CD1_1   ");
        value.addElement(new Double(this.CD[0][0]).toString());
        key.addElement("CD1_2   ");
        value.addElement(new Double(this.CD[0][1]).toString());
        key.addElement("CD2_1   ");
        value.addElement(new Double(this.CD[1][0]).toString());
        key.addElement("CD2_2   ");
        value.addElement(new Double(this.CD[1][1]).toString());
        if (this.xyapoly[0] != 0.0) {
            key.addElement("PV1_0");
            value.addElement(new Double(this.xyapoly[0]).toString());
        }
        if (this.xydpoly[0] != 0.0) {
            key.addElement("PV2_0");
            value.addElement(new Double(this.xydpoly[0]).toString());
        }
        if (this.xyapoly[1] != 0.0) {
            key.addElement("PV1_1");
            value.addElement(new Double(this.xyapoly[1]).toString());
        }
        if (this.xydpoly[1] != 0.0) {
            key.addElement("PV2_1");
            value.addElement(new Double(this.xydpoly[1]).toString());
        }
        if (this.xyapoly[2] != 0.0) {
            key.addElement("PV1_2");
            value.addElement(new Double(this.xyapoly[2]).toString());
        }
        if (this.xydpoly[2] != 0.0) {
            key.addElement("PV2_2");
            value.addElement(new Double(this.xydpoly[2]).toString());
        }
        if (this.xyapoly[3] != 0.0) {
            key.addElement("PV1_3");
            value.addElement(new Double(this.xyapoly[3]).toString());
        }
        if (this.xydpoly[3] != 0.0) {
            key.addElement("PV2_3");
            value.addElement(new Double(this.xydpoly[3]).toString());
        }
        if (this.xyapoly[4] != 0.0) {
            key.addElement("PV1_4");
            value.addElement(new Double(this.xyapoly[4]).toString());
        }
        if (this.xydpoly[4] != 0.0) {
            key.addElement("PV2_4");
            value.addElement(new Double(this.xydpoly[4]).toString());
        }
        if (this.xyapoly[5] != 0.0) {
            key.addElement("PV1_5");
            value.addElement(new Double(this.xyapoly[5]).toString());
        }
        if (this.xydpoly[5] != 0.0) {
            key.addElement("PV2_5");
            value.addElement(new Double(this.xydpoly[5]).toString());
        }
        if (this.xyapoly[6] != 0.0) {
            key.addElement("PV1_6");
            value.addElement(new Double(this.xyapoly[6]).toString());
        }
        if (this.xydpoly[6] != 0.0) {
            key.addElement("PV2_6");
            value.addElement(new Double(this.xydpoly[6]).toString());
        }
        if (this.xyapoly[7] != 0.0) {
            key.addElement("PV1_7");
            value.addElement(new Double(this.xyapoly[7]).toString());
        }
        if (this.xydpoly[7] != 0.0) {
            key.addElement("PV2_7");
            value.addElement(new Double(this.xydpoly[7]).toString());
        }
        if (this.xyapoly[8] != 0.0) {
            key.addElement("PV1_8");
            value.addElement(new Double(this.xyapoly[8]).toString());
        }
        if (this.xydpoly[8] != 0.0) {
            key.addElement("PV2_8");
            value.addElement(new Double(this.xydpoly[8]).toString());
        }
        if (this.xyapoly[9] != 0.0) {
            key.addElement("PV1_9");
            value.addElement(new Double(this.xyapoly[9]).toString());
        }
        if (this.xydpoly[9] != 0.0) {
            key.addElement("PV2_9");
            value.addElement(new Double(this.xydpoly[9]).toString());
        }
        if (this.xyapoly[10] != 0.0) {
            value.addElement(new Double(this.xyapoly[10]).toString());
        }
        if (this.xydpoly[10] != 0.0) {
            value.addElement(new Double(this.xydpoly[10]).toString());
        }
    }

    protected void GetWCSP(Vector key, Vector value) throws Exception {
        key.addElement("NAXIS1  ");
        value.addElement(new Integer(this.xnpix).toString());
        key.addElement("NAXIS2  ");
        value.addElement(new Integer(this.ynpix).toString());
        key.addElement("CRPIX1  ");
        if (this.aladin != 1) {
            value.addElement(new Double(this.Xcen).toString());
        } else {
            value.addElement(new Double((this.xz * 1000.0 - this.Xorg) / this.incX).toString());
        }
        key.addElement("CRPIX2  ");
        if (this.aladin != 1) {
            value.addElement(new Double(this.Ycen).toString());
        } else {
            value.addElement(new Double((this.yz * 1000.0 - this.Yorg) / this.incY).toString());
        }
        key.addElement("EQUINOX");
        value.addElement(new Double(this.equinox).toString());
        boolean flagPermute = this.aladin != 1 && this.type1 != null && this.type1.startsWith("DEC");
        key.addElement("CRVAL1  ");
        if (this.aladin != 1) {
            value.addElement(new Double(flagPermute ? this.deltai : this.alphai).toString());
        } else {
            value.addElement(new Double(this.alpha).toString());
        }
        key.addElement("CRVAL2  ");
        if (this.aladin != 1) {
            value.addElement(new Double(flagPermute ? this.alphai : this.deltai).toString());
        } else {
            value.addElement(new Double(this.delta).toString());
        }
        key.addElement("CTYPE1  ");
        if (this.aladin == 1) {
            value.addElement("'RA---TAN'");
        } else {
            value.addElement(this.type1);
        }
        key.addElement("CTYPE2  ");
        if (this.aladin == 1) {
            value.addElement("'DEC--TAN'");
        } else {
            value.addElement(this.type2);
        }
        if (RADECSYS[this.system].length() > 0) {
            key.addElement("RADECSYS");
            value.addElement(RADECSYS[this.system]);
        }
        if (this.aladin == 1) {
            this.CD[0][0] = this.incX / (1000.0 * this.focale) * rad_to_deg;
            this.CD[0][1] = 0.0;
            this.CD[1][0] = 0.0;
            this.CD[1][1] = this.incY / (1000.0 * this.focale) * rad_to_deg;
            this.ID[0][0] = 1000.0 * this.focale / this.incX * deg_to_rad;
            this.ID[0][1] = 0.0;
            this.ID[1][0] = 0.0;
            this.ID[1][1] = 1000.0 * this.focale / this.incY * deg_to_rad;
            double sca = deg_to_rad;
            flagPermute = false;
            key.addElement("PV1_0");
            value.addElement(new Double(this.xyapoly[0]).toString());
            key.addElement("PV2_0");
            value.addElement(new Double(this.xydpoly[0]).toString());
            key.addElement("PV1_1");
            value.addElement(new Double(this.xyapoly[2] * sca).toString());
            key.addElement("PV2_1");
            value.addElement(new Double(this.xydpoly[2] * sca).toString());
            key.addElement("PV1_2");
            value.addElement(new Double(this.xyapoly[1] * sca).toString());
            key.addElement("PV2_2");
            value.addElement(new Double(this.xydpoly[1] * sca).toString());
            key.addElement("PV1_3");
            value.addElement(new Double(this.xyapoly[4] * sca * sca).toString());
            key.addElement("PV2_3");
            value.addElement(new Double(this.xydpoly[4] * sca * sca).toString());
            key.addElement("PV1_4");
            value.addElement(new Double(this.xyapoly[5] * sca * sca).toString());
            key.addElement("PV2_4");
            value.addElement(new Double(this.xydpoly[5] * sca * sca).toString());
            key.addElement("PV1_5");
            value.addElement(new Double(this.xyapoly[3] * sca * sca).toString());
            key.addElement("PV2_5");
            value.addElement(new Double(this.xydpoly[3] * sca * sca).toString());
            key.addElement("PV1_6");
            value.addElement(new Double(this.xyapoly[7] * sca * sca * sca).toString());
            key.addElement("PV2_6");
            value.addElement(new Double(this.xydpoly[7] * sca * sca * sca).toString());
            key.addElement("PV1_7");
            value.addElement(new Double(this.xyapoly[9] * sca * sca * sca).toString());
            key.addElement("PV2_7");
            value.addElement(new Double(this.xydpoly[9] * sca * sca * sca).toString());
            key.addElement("PV1_8");
            value.addElement(new Double(this.xyapoly[8] * sca * sca * sca).toString());
            key.addElement("PV2_8");
            value.addElement(new Double(this.xydpoly[8] * sca * sca * sca).toString());
            key.addElement("PV1_9");
            value.addElement(new Double(this.xyapoly[6] * sca * sca * sca).toString());
            key.addElement("PV2_9");
            value.addElement(new Double(this.xydpoly[6] * sca * sca * sca).toString());
        }
        key.addElement("CD1_1   ");
        value.addElement(new Double(this.CD[0][0]).toString());
        key.addElement("CD1_2   ");
        value.addElement(new Double(this.CD[0][1]).toString());
        key.addElement("CD2_1   ");
        value.addElement(new Double(this.CD[1][0]).toString());
        key.addElement("CD2_2   ");
        value.addElement(new Double(this.CD[1][1]).toString());
    }

    protected void SetEquinox(double equin) {
        this.equinox = equin;
    }

    protected double GetEquinox() {
        return this.equinox;
    }

    protected double GetEpoch() {
        if (this.flagepoc != 0) {
            return this.epoch;
        }
        return Double.NaN;
    }

    public Coord getImgCenter() throws Exception {
        Coord c = new Coord();
        c.x = (double)this.xnpix / 2.0;
        c.y = (double)this.ynpix / 2.0;
        this.GetCoord(c);
        return c;
    }

    public Coord getProjCenter() {
        Coord c = new Coord();
        c.x = this.Xcen;
        c.y = this.Ycen;
        try {
            this.GetCoord(c);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    public double getProjRot() {
        return this.rota;
    }

    public double getImgWidth() {
        return this.widtha;
    }

    public double getImgHeight() {
        return this.widthd;
    }

    public boolean getProjSym() {
        return this.incA > 0.0;
    }

    protected int getProj() {
        return this.proj;
    }

    protected int getSystem() {
        return this.system;
    }

    public Dimension getImgSize() {
        return new Dimension(this.xnpix, this.ynpix);
    }

    protected void cropping(double w, double h) {
        this.cropping(((double)this.xnpix - w) / 2.0, ((double)this.ynpix - h) / 2.0, w, h);
    }

    protected void cropping(double offx, double offy, double w, double h) {
        if (this.aladin == 0 || this.aladin == 3) {
            this.Xcen -= offx;
            this.Ycen -= (double)this.ynpix - offy - h;
        } else {
            this.Xorg += offx * this.incX;
            this.Yorg += offy * this.incY;
        }
        this.xnpix = (int)Math.round(w);
        this.ynpix = (int)Math.round(h);
        this.widtha = (double)this.xnpix * Math.abs(this.incA);
        this.widthd = (double)this.ynpix * Math.abs(this.incD);
    }

    protected boolean sensDirect() {
        double xyd = this.xydpoly[2];
        if (this.aladin == 0 || this.aladin == 3) {
            double xya = this.xyapoly[1];
            if (xya > 0.0) {
                return this.CD[0][0] * this.CD[1][1] > 0.0;
            }
            if (xya < 0.0) {
                return -this.CD[0][0] * this.CD[1][1] > 0.0;
            }
            return this.CD[0][0] * this.CD[1][1] > 0.0;
        }
        if (this.aladin == 2) {
            return this.CD[0][0] * this.CD[1][1] > 0.0;
        }
        double xya = this.xyapoly[2];
        return xya * xyd > 0.0;
    }

    protected void cropAndZoom(double deltaX, double deltaY, double w, double h, double zoom) {
        this.incX /= zoom;
        this.incY /= zoom;
        this.Xcen *= zoom;
        this.Ycen *= zoom;
        this.xnpix = (int)Math.round((double)this.xnpix * zoom);
        this.ynpix = (int)Math.round((double)this.ynpix * zoom);
        this.CD[0][0] = this.CD[0][0] / zoom;
        this.CD[0][1] = this.CD[0][1] / zoom;
        this.CD[1][0] = this.CD[1][0] / zoom;
        this.CD[1][1] = this.CD[1][1] / zoom;
        this.ID[0][0] = this.ID[0][0] * zoom;
        this.ID[0][1] = this.ID[0][1] * zoom;
        this.ID[1][0] = this.ID[1][0] * zoom;
        this.ID[1][1] = this.ID[1][1] * zoom;
        this.incA /= zoom;
        this.incD /= zoom;
        this.cropping(deltaX * zoom, deltaY * zoom, w * zoom, h * zoom);
    }

    static boolean equalEpsilon(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return false;
        }
        return Math.abs(a - b) <= EPSILON;
    }

    public static boolean test1() {
        boolean toutestbon = true;
        Calib C = new Calib(8L, 424L, 0, 1);
        Calib Cp = new Calib(8L, 0L, 0, 1);
        return toutestbon;
    }

    public static boolean test() {
        boolean toutestbon = true;
        try {
            System.out.println("> Calib test...");
            for (int proj = 1; proj < projType.length; ++proj) {
                boolean erreur = false;
                System.out.print("   Test" + projType[proj] + "...");
                block5: for (int j = 0; j < testCenter.length; ++j) {
                    double ra = testCenter[j][0];
                    double dec = testCenter[j][1];
                    double cxPix = 250.0;
                    double cyPix = 250.0;
                    double widthPix = 500.0;
                    double heightPix = 500.0;
                    double widthAng = 90.0;
                    double heightAng = 90.0;
                    double rot = 0.0;
                    boolean sym = false;
                    String centre = "   coo=(" + ra + "," + dec + ")<=>xy=(" + cxPix + "," + cyPix + ") : ";
                    Calib c = new Calib(ra, dec, cxPix, cyPix, widthPix, heightPix, widthAng, heightAng, rot, proj, sym, FK5);
                    Coord coo = new Coord();
                    double x = cxPix;
                    double y = cyPix;
                    coo.x = x;
                    coo.y = y;
                    c.GetCoord(coo);
                    System.out.print("\nfixe" + centre + "  coo=(" + coo.al + "," + coo.del + ") => xy=(" + coo.x + "," + coo.y + ")");
                    if (!Calib.equalEpsilon(coo.al, ra) || !Calib.equalEpsilon(coo.del, dec)) {
                        if (!erreur) {
                            System.out.print(" Error");
                        }
                        erreur = true;
                        System.out.print("\nfixe" + centre + " Wrong celestian center: xy=(" + x + "," + y + ") => coo=(" + coo.al + "," + coo.del + ") ");
                    }
                    coo.al = ra;
                    coo.del = dec;
                    c.GetXY(coo);
                    if (!Calib.equalEpsilon(coo.x, x) || !Calib.equalEpsilon(coo.y, y)) {
                        if (!erreur) {
                            System.out.print(" Error");
                        }
                        erreur = true;
                        System.out.print("\nfixe" + centre + " Wrong projected center: coo=(" + coo.al + "," + coo.del + ") => xy=(" + coo.x + "," + coo.y + ")");
                    }
                    try {
                        Random rand = new Random(System.currentTimeMillis());
                        for (int i = 0; i < 1000; ++i) {
                            x = coo.x = rand.nextDouble() * widthPix;
                            y = coo.y = rand.nextDouble() * heightPix;
                            c.GetCoord(coo);
                            c.GetXY(coo);
                            if (Calib.equalEpsilon(coo.x, x) && Calib.equalEpsilon(coo.y, y)) continue;
                            if (!erreur) {
                                System.out.print(" Error");
                            }
                            erreur = true;
                            System.out.print("\n" + centre + " no bijective: xy=(" + x + "," + y + ") => coo=(" + coo.al + "," + coo.del + ") => xy=(" + coo.x + "," + coo.y + ")");
                            continue block5;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        if (!erreur) {
                            System.out.print("random Error");
                        }
                        erreur = true;
                        System.out.print("\n" + centre + " Java exception: xy=(" + x + "," + y + ") => " + e.getMessage());
                    }
                }
                if (!erreur) {
                    System.out.println(" OK");
                } else {
                    System.out.println();
                }
                toutestbon &= erreur;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            toutestbon = false;
        }
        return toutestbon;
    }
}

