/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.BasicNode;
import cds.aladin.MetaDataTree;
import cds.aladin.ResourceNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class BasicTree
extends JComponent
implements MouseMotionListener,
MouseListener,
ActionListener {
    private JScrollPane scroll = null;
    boolean hasSpectraOrImages;
    protected JPopupMenu popup;
    protected JPopupMenu popupPrefs;
    protected static final String DELETE = "Delete";
    protected static final String COLLAPSE_SUBTREE = "Collapse this subtree";
    protected static final String EXPAND_SUBTREE = "Expand this subtree";
    protected static final String COLLAPSE_ALL = "Collapse all";
    protected static final String EXPAND_ALL = "Expand all";
    protected static final String FLAT_VIEW = "Flat view";
    protected static final String HIER_VIEW = "Hierarchical view";
    protected static final String SIAP_EVOL_SORT = "Sort";
    protected static final String CREATE_CATPLANE = "Create a catalog plane with all images/spectra";
    boolean flatView = false;
    private int prefHeight = 600;
    private int prefWidth = 250;
    static final int XSPACE = 22;
    static final int YSPACE = 18;
    static final int LOGOSIZE = 12;
    static final int LOGOPADDING = 4;
    static final Color LITBGCOLOR = new Color(189, 222, 237);
    static final Color LITFGCOLOR = Color.black;
    static final Color selectedColor = new Color(255, 190, 255);
    static final Color mouseOverColor = Color.blue;
    static final Color bkgdLeafColor = Aladin.MYBLUE;
    static final Color bkgdLeafClickedColor = Aladin.LBLUE;
    static final Color lineColor = Color.black;
    static Font nameFont = Aladin.COURIER;
    static Font boldNameFont = Aladin.BCOURIER;
    private BasicNode rootNode;
    BasicNode lastInfoNode;
    private BasicNode ancienCurNode;
    boolean isHistoryTree = false;
    protected Color bkgColor = Aladin.LBLUE;
    private boolean mustInit = true;
    private boolean allowSortByFields = true;
    private int hilightNode;
    int oHilightNode = -1;
    BasicNode selectedNode;
    BasicNode oselectedNode;
    private Vector nodeFullList;
    BasicNode[] nodeFullTab;
    private Vector nodeList;
    BasicNode[] nodeTab;
    private int yCurrent = 0;
    private boolean[] lastChild = new boolean[100];
    Aladin aladin;
    boolean mustScroll = false;
    boolean last = false;
    static Color grayCB = new Color(102, 102, 102);
    static Color grayFill = new Color(192, 192, 192);
    static Color tickColor = Color.red;
    static final int COTE = 12;
    private static Color[] sortFieldColor = new Color[]{Color.decode("0xb7d2ca"), Color.decode("0xd0c2e9"), Color.decode("0xd5e0c4"), Color.decode("0xbccdf0")};
    boolean lastPosInLogo;
    private int maxWidth;
    private int tmpSize;
    static FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(boldNameFont);
    boolean triggerOnNodeSelected = false;
    BasicNode nodeToTrigger = null;
    boolean mustSetLocation = false;

    private BasicTree(Aladin aladin, BasicNode rootNode) {
        this.aladin = aladin;
        this.rootNode = rootNode;
        this.rootNode.hide = true;
        this.setBackground(this.bkgColor);
        this.setOpaque(true);
        this.setDoubleBuffered(false);
        this.createPopup();
        this.traverseTree();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    BasicTree(Aladin aladin, BasicNode rootNode, JScrollPane scroll) {
        this(aladin, rootNode);
        this.scroll = scroll;
    }

    BasicTree(Aladin aladin, BasicNode rootNode, JScrollPane scroll, boolean isHistoryTree) {
        this.aladin = aladin;
        this.rootNode = rootNode;
        this.rootNode.hide = true;
        this.isHistoryTree = isHistoryTree;
        this.setBackground(this.bkgColor);
        this.setOpaque(true);
        this.setDoubleBuffered(false);
        this.createPopup();
        this.traverseTree();
        this.scroll = scroll;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    protected JMenuItem createItem(String s) {
        JMenuItem item = new JMenuItem(s);
        item.setFont(Aladin.PLAIN);
        item.addActionListener(this);
        return item;
    }

    private void createPopup() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
        } else {
            this.popup.removeAll();
        }
        this.popup.add(this.createItem(DELETE));
        this.popup.addSeparator();
        this.popup.add(this.createItem(COLLAPSE_SUBTREE));
        this.popup.add(this.createItem(EXPAND_SUBTREE));
        this.popupPrefs = new JPopupMenu();
        this.popupPrefs.add(this.createItem(COLLAPSE_ALL));
        this.popupPrefs.add(this.createItem(EXPAND_ALL));
        if (!this.isHistoryTree && this.hasSpectraOrImages) {
            this.popupPrefs.addSeparator();
            this.popupPrefs.add(this.createItem(CREATE_CATPLANE));
        }
        this.popupPrefs.addSeparator();
        this.popupPrefs.add(this.flatView ? this.createItem(HIER_VIEW) : this.createItem(FLAT_VIEW));
        if (this.allowSortByFields) {
            this.popupPrefs.addSeparator();
            this.popupPrefs.add(this.createItem(SIAP_EVOL_SORT));
        }
    }

    @Override
    public void setBackground(Color color) {
        this.setOpaque(true);
        super.setBackground(color);
        this.bkgColor = color;
    }

    protected void clearSelected() {
        this.ancienCurNode = null;
        if (this.oHilightNode < 0 || this.oHilightNode >= this.nodeTab.length) {
            return;
        }
        BasicNode node = this.nodeTab[this.oHilightNode];
        this.oHilightNode = -1;
        this.drawNodeName(this.getGraphics(), node, true);
        this.repaint();
    }

    protected void majSize() {
        if (this.nodeList != null) {
            this.prefHeight = this.nodeList.size() * 18 + 20;
        }
        if (this.scroll != null) {
            JViewport vPort = this.scroll.getViewport();
            if (this.prefHeight < vPort.getHeight()) {
                this.prefHeight = vPort.getHeight();
            }
            if (this.prefWidth < vPort.getWidth()) {
                this.prefWidth = vPort.getWidth();
            }
        }
        this.setSize(this.prefWidth, this.prefHeight);
    }

    protected boolean init(Graphics h) {
        this.majSize();
        this.doDisplay(h);
        return true;
    }

    protected Color getMouseOverColor(BasicNode node) {
        return node.isLeaf ? Color.white : mouseOverColor;
    }

    void doDisplay(Graphics h) {
        this.yCurrent = 0;
        this.nodeList = new Vector();
        if (h == null) {
            return;
        }
        h.setColor(this.bkgColor);
        h.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.fullDisplay(h);
    }

    void fullDisplay(Graphics h) {
        JViewport vPort;
        this.last = false;
        h.setColor(Color.black);
        this.displayTree(h, this.rootNode, 0);
        this.hilightNode = -1;
        this.nodeTab = new BasicNode[this.nodeList.size()];
        this.nodeList.copyInto(this.nodeTab);
        this.nodeList = null;
        this.prefHeight = this.nodeTab.length * 18;
        if (this.scroll != null && this.prefHeight < (vPort = this.scroll.getViewport()).getHeight()) {
            this.prefHeight = vPort.getHeight();
        }
        if (this.getWidth() != this.prefWidth || this.getHeight() != this.prefHeight) {
            this.setSize(this.prefWidth, this.prefHeight);
        }
    }

    private void drawVertLine(Graphics h, int x, int y) {
        int xInit = x + 11 - 5;
        h.setColor(lineColor);
        h.drawLine(xInit, y - 4, xInit, y + 18 + 2);
    }

    private void drawHalfVertLine(Graphics h, int x, int y) {
        int xInit = x + 11 - 5;
        h.setColor(lineColor);
        h.drawLine(xInit, y - 4, xInit, y + 9 - 1);
    }

    private void displayTree(Graphics h, BasicNode node, int level) {
        block12: {
            block11: {
                this.nodeList.addElement(node);
                this.lastChild[level] = node.isLastChild();
                node.level = level;
                int x = -21;
                for (int i = 0; i < level; ++i) {
                    if (!this.lastChild[i + 1] && !this.flatView) {
                        this.drawVertLine(h, x + 22, this.yCurrent);
                    } else if (!this.flatView && i == level - 1) {
                        this.drawHalfVertLine(h, x + 22, this.yCurrent);
                    }
                    x += 22;
                }
                if (!(node.hide || node == this.rootNode && this.flatView)) {
                    this.displayIconLabel(h, node, x);
                } else if (!this.flatView && node == this.rootNode && node.getNbOfChildren() > 0) {
                    this.drawVertLine(h, x + 22, this.yCurrent);
                } else {
                    x += 22;
                    node.x = x += 22;
                    node.y = this.yCurrent;
                }
                this.yCurrent += 18;
                if (!this.flatView) break block11;
                BasicNode[] leaves = this.getLeavesForFlatView(node);
                int size = leaves.length;
                for (int i = 0; i < leaves.length; ++i) {
                    if (i == size) {
                        this.last = true;
                    }
                    this.displayTree(h, leaves[i], level + 1);
                }
                break block12;
            }
            if (node.isLeaf || !node.isOpen) break block12;
            Enumeration e = node.getChildren();
            while (e.hasMoreElements()) {
                this.displayTree(h, (BasicNode)e.nextElement(), level + 1);
            }
        }
    }

    BasicNode[] getLeavesForFlatView(BasicNode node) {
        Vector v = new Vector();
        BasicTree.getAllLeaves(node, v);
        int size = v.size();
        Object[] leaves = new BasicNode[size];
        v.copyInto(leaves);
        v = null;
        return leaves;
    }

    protected void drawCheckBox(Graphics h, int x, int y, BasicNode node, boolean efface) {
        int xBegin = x;
        int yBegin = y + 2;
        if (efface) {
            h.setColor(grayFill);
            h.fillRect(xBegin, yBegin, 12, 12);
        }
        h.setColor(Color.white);
        h.drawRect(xBegin + 1, yBegin + 1, 12, 12);
        h.setColor(grayCB);
        h.drawRect(xBegin, yBegin, 12, 12);
        if (node.isSelected()) {
            h.setColor(tickColor);
            h.fillRect(xBegin + 3, yBegin + 6 - 1, 2, 6);
            int x1 = xBegin + 5;
            int y1 = yBegin + 12 - 3;
            int l = 5;
            h.drawLine(x1, y1, x1 + l, y1 - l);
            h.drawLine(x1, y1 - 1, x1 + l, y1 - l - 1);
        }
    }

    protected void drawPreCheckBox(Graphics h, int x, int y, BasicNode node, boolean efface) {
        if (!node.isLeaf) {
            return;
        }
        int xBegin = x;
        int yBegin = y + 2;
        int[] coordx = new int[]{xBegin + 2, xBegin + 5, xBegin + 5, xBegin + 10, xBegin + 11, xBegin + 11, xBegin + 4, xBegin + 2};
        int[] coordy = new int[]{yBegin + 6 - 2, yBegin + 6 - 2, yBegin + 6 - 2 + 3, yBegin + 6 - 4, yBegin + 6 - 4, yBegin + 6 - 2, yBegin + 6 - 2 + 7, yBegin + 6 - 2 + 7};
        if (efface) {
            if (!node.isSelected) {
                h.setColor(grayFill);
                h.fillRect(xBegin, yBegin, 12, 12);
            } else {
                h.setColor(grayFill);
                h.drawPolygon(coordx, coordy, coordx.length);
            }
        }
        h.setColor(Color.white);
        h.drawRect(xBegin + 1, yBegin + 1, 12, 12);
        h.setColor(grayCB);
        h.drawRect(xBegin, yBegin, 12, 12);
        if (efface) {
            return;
        }
        h.setColor(Color.black);
        h.drawPolygon(coordx, coordy, coordx.length);
    }

    private void drawLogo(Graphics h, int x, int y, BasicNode node) {
        int xInit = x;
        h.setColor(Color.white);
        h.fillRect(xInit, y + 2, 12, 12);
        h.setColor(Color.black);
        h.drawRect(xInit, y + 2, 12, 12);
        if (node.isOpen) {
            h.setColor(Color.black);
            h.drawLine(xInit + 4, y + 2 + 6, xInit + 12 - 4, y + 2 + 6);
        } else {
            h.setColor(Color.black);
            h.drawLine(xInit + 6, y + 2 + 4, xInit + 6, y + 2 + 12 - 4);
            h.drawLine(xInit + 4, y + 2 + 6, xInit + 12 - 4, y + 2 + 6);
        }
    }

    private void drawHorizLine(Graphics h, int x, int y, BasicNode node) {
        h.setColor(lineColor);
        if (node.isLeaf) {
            h.drawLine(12 + x - 22 - 5, this.yCurrent + 9 - 1, 16 + x + 11 - 22, this.yCurrent + 9 - 1);
        } else {
            h.drawLine(x - 12 - 3, this.yCurrent + 9 - 1, x, this.yCurrent + 9 - 1);
        }
    }

    private void drawNodeName(Graphics h, BasicNode node) {
        this.drawNodeName(h, node, false);
    }

    protected void drawNodeName(Graphics h, BasicNode node, boolean redrawAll) {
        if (node == this.rootNode && this.flatView) {
            return;
        }
        String name = this.getName(node);
        if (redrawAll) {
            h.setColor(this.bkgColor);
            h.fillRect(node.x - 1, node.y, h.getFontMetrics().stringWidth(name) + 2, 18);
        }
        boolean mouseOver = false;
        if (this.oHilightNode >= 0 && this.oHilightNode < this.nodeTab.length && this.nodeTab != null && node.equals(this.nodeTab[this.oHilightNode])) {
            mouseOver = true;
            if (node.isLeaf) {
                this.drawSelectedLeafNodeName(h, node, name);
            }
        }
        h.setFont(node.equals(this.lastInfoNode) ? boldNameFont : nameFont);
        int idx = name.indexOf("::: ");
        boolean withSortField = idx >= 0 && !node.isLeaf;
        boolean selectedLeaf = false;
        String sortField = "";
        int offset = 0;
        if (withSortField) {
            name = MetaDataTree.replace(name, "///", "", 1);
            sortField = name.substring(0, idx + 1);
            name = name.substring(idx + 3);
            h.setColor(sortFieldColor[node.level % sortFieldColor.length]);
            offset = h.getFontMetrics().stringWidth(sortField) + 1;
            h.fillRect(node.x, node.y + 1, offset, 16);
        } else if (node.isLeaf && node.equals(this.lastInfoNode)) {
            selectedLeaf = true;
        }
        h.setColor(mouseOver ? this.getMouseOverColor(node) : Color.black);
        if (withSortField) {
            h.drawString(sortField, node.x, node.y + 9 + 4);
        }
        if (selectedLeaf) {
            this.drawBorder(h, node, h.getFontMetrics().stringWidth(name));
        }
        h.drawString(name, offset + node.x, node.y + 9 + 4);
    }

    protected void drawSelectedLeafNodeName(Graphics h, BasicNode node, String name) {
        int lineLength = h.getFontMetrics().stringWidth(name);
        h.setColor(bkgdLeafColor);
        h.fillRect(node.x, node.y + 1, lineLength, 16);
        this.drawBorder(h, node, lineLength);
    }

    protected void drawBorder(Graphics h, BasicNode node, int lineLength) {
        Color saveColor = h.getColor();
        h.setColor(Color.black);
        h.drawLine(node.x - 1, node.y, node.x - 1 + lineLength, node.y);
        h.drawLine(node.x - 1, node.y, node.x - 1, node.y + 18 - 2);
        h.setColor(Color.white);
        h.drawLine(node.x - 1, node.y + 18 - 1, node.x - 1 + lineLength, node.y + 18 - 1);
        h.drawLine(node.x + lineLength, node.y, node.x + lineLength, node.y + 18 - 1);
        h.setColor(saveColor);
    }

    protected String getName(BasicNode node) {
        return node.name;
    }

    private void displayIconLabel(Graphics h, BasicNode node, int x) {
        x += 22;
        if (!node.isLeaf) {
            this.drawLogo(h, x, this.yCurrent, node);
        }
        if (node.level > 0 && !this.flatView) {
            this.drawHorizLine(h, x, this.yCurrent, node);
        }
        if (node.isLeaf) {
            this.drawCheckBox(h, x, this.yCurrent, node, true);
        }
        node.x = x += 22;
        node.y = this.yCurrent;
        this.drawNodeName(h, node);
    }

    private boolean inNodeName(Graphics h, int x, BasicNode node) {
        return this.inNodeName(h, x, node, false);
    }

    private boolean inNodeName(Graphics h, int x, BasicNode node, boolean considerBox) {
        int leftLim = considerBox ? node.level * 22 : node.x;
        return x >= leftLim && x <= node.x + h.getFontMetrics().stringWidth(this.getName(node));
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        int ooHilightNode;
        BasicNode curNode;
        int x = evt.getX();
        int y = evt.getY();
        this.hilightNode = y / 18;
        Graphics h = this.getGraphics();
        h.setFont(nameFont);
        try {
            curNode = this.nodeTab[this.hilightNode];
            if (curNode == this.rootNode) {
                this.onMouseMoved(this.rootNode, false);
                BasicNode old = this.nodeTab[this.oHilightNode];
                this.oHilightNode = -1;
                this.ancienCurNode = null;
                this.drawNodeName(h, old, true);
                if (!old.isSelected()) {
                    this.drawPreCheckBox(h, old.x - 22, old.y, old, true);
                }
            }
            if (curNode.hide) {
                return;
            }
            boolean inNodeOrBox = this.inNodeName(h, x, curNode, true);
            boolean inLogo = this.inLogo(curNode, x);
            if (!inNodeOrBox) {
                this.onMouseMoved(curNode, inNodeOrBox);
                BasicNode n = this.nodeTab[this.oHilightNode];
                this.oHilightNode = -1;
                this.ancienCurNode = null;
                this.drawNodeName(h, n, true);
                if (!n.isSelected() && this.lastPosInLogo) {
                    this.drawPreCheckBox(h, n.x - 22, n.y, n, true);
                }
                this.lastPosInLogo = inLogo;
                return;
            }
            if (!(!inLogo || curNode.isSelected() || this.lastPosInLogo && curNode == this.ancienCurNode)) {
                this.drawPreCheckBox(h, curNode.x - 22, curNode.y, curNode, false);
            } else if (!inLogo && !curNode.isSelected() && this.lastPosInLogo) {
                this.drawPreCheckBox(h, curNode.x - 22, curNode.y, curNode, true);
            }
            if (this.ancienCurNode == curNode) {
                this.lastPosInLogo = inLogo;
                return;
            }
            if (this.ancienCurNode != null && !this.ancienCurNode.isSelected() && this.lastPosInLogo) {
                this.drawPreCheckBox(h, this.ancienCurNode.x - 22, this.ancienCurNode.y, this.ancienCurNode, true);
            }
            this.ancienCurNode = curNode;
            ooHilightNode = this.oHilightNode;
            this.oHilightNode = this.hilightNode;
            this.drawNodeName(h, curNode, true);
            this.lastPosInLogo = inLogo;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        this.onMouseMoved(curNode, true);
        if (ooHilightNode != this.hilightNode) {
            try {
                BasicNode oCurNode = this.nodeTab[ooHilightNode];
                this.drawNodeName(h, oCurNode, true);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
    }

    void traverseTree() {
        this.hasSpectraOrImages = false;
        this.nodeFullList = new Vector();
        this.maxWidth = this.initMaxWidth();
        this.recTraverseTree(this.rootNode, 0);
        this.nodeFullTab = new BasicNode[this.nodeFullList.size()];
        this.nodeFullList.copyInto(this.nodeFullTab);
        this.prefWidth = this.maxWidth + 5;
        if (this.scroll != null) {
            JViewport vPort = this.scroll.getViewport();
            JScrollBar verticalScrollBar = this.scroll.getVerticalScrollBar();
            int newWidth = vPort.getWidth() + (verticalScrollBar.isVisible() ? 0 : verticalScrollBar.getWidth());
            if (this.prefWidth < newWidth) {
                this.prefWidth = newWidth;
            }
        }
        this.createPopup();
    }

    protected int initMaxWidth() {
        return 0;
    }

    private void recTraverseTree(BasicNode node, int width) {
        this.nodeFullList.addElement(node);
        width += 22;
        if (!(this.hasSpectraOrImages || ((ResourceNode)node).type != 3 && ((ResourceNode)node).type != 1)) {
            this.hasSpectraOrImages = true;
        }
        this.tmpSize = fm.stringWidth(this.getName(node));
        this.tmpSize = !this.flatView ? (this.tmpSize += width) : (this.tmpSize += 44);
        if (this.tmpSize > this.maxWidth) {
            this.maxWidth = this.tmpSize;
        }
        Enumeration e = node.getChildren();
        while (e.hasMoreElements()) {
            BasicNode child = (BasicNode)e.nextElement();
            this.recTraverseTree(child, width);
        }
    }

    public BasicNode searchNodeByName(String name) {
        for (int i = 0; i < this.nodeFullTab.length; ++i) {
            if (!this.nodeFullTab[i].name.equals(name)) continue;
            return this.nodeFullTab[i];
        }
        return null;
    }

    public void setFlat(boolean b) {
        this.flatView = b;
        if (!((ResourceNode)this.rootNode).isSIAPEvol) {
            this.popupPrefs.remove(this.popupPrefs.getComponentCount() - 1);
            this.popupPrefs.add(this.flatView ? HIER_VIEW : FLAT_VIEW);
        } else {
            this.popupPrefs.remove(this.popupPrefs.getComponentCount() - 1);
            this.popupPrefs.remove(this.popupPrefs.getComponentCount() - 1);
            this.popupPrefs.remove(this.popupPrefs.getComponentCount() - 1);
            this.popupPrefs.add(this.flatView ? this.createItem(HIER_VIEW) : this.createItem(FLAT_VIEW));
            this.popupPrefs.addSeparator();
            this.popupPrefs.add(SIAP_EVOL_SORT);
        }
        this.traverseTree();
        this.repaint();
        if (this.scroll != null) {
            this.scroll.validate();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String o = ae.getActionCommand();
        if (o.equals(DELETE)) {
            this.removeNode(this.selectedNode);
            this.repaint();
        } else if (o.equals(COLLAPSE_SUBTREE)) {
            this.setAllNodes(this.selectedNode, false);
            this.repaint();
        } else if (o.equals(EXPAND_SUBTREE)) {
            this.setAllNodes(this.selectedNode, true);
            this.repaint();
        } else if (o.equals(COLLAPSE_ALL)) {
            this.setAllNodes(this.rootNode, false);
            this.repaint();
        } else if (o.equals(EXPAND_ALL)) {
            this.setAllNodes(this.rootNode, true);
            this.repaint();
        } else if (o.equals(FLAT_VIEW) || o.equals(HIER_VIEW)) {
            this.setFlat(!this.flatView);
        }
    }

    private void removeNode(BasicNode node) {
        if (node == null) {
            return;
        }
        boolean removed = node.getParent().removeChild(node);
        this.onNodeRemoved(node);
        if (removed) {
            this.traverseTree();
        }
        this.repaint();
    }

    protected boolean isEmpty() {
        return this.rootNode.nbChildren == 0;
    }

    public Vector getSelectedLeaves() {
        Vector v = new Vector();
        this.recGetSelectedLeaves(this.rootNode, v);
        return v;
    }

    private void recGetSelectedLeaves(BasicNode start, Vector result) {
        if (start.isSelected()) {
            result.addElement(start);
        }
        if (start.isOpen || this.flatView) {
            Enumeration e = start.getChildren();
            while (e.hasMoreElements()) {
                this.recGetSelectedLeaves((BasicNode)e.nextElement(), result);
            }
        }
    }

    public void openAllNodes(BasicNode node) {
        this.setAllNodes(node, true);
    }

    public void setAllNodes(BasicNode node, boolean open) {
        this.recSetAllNodes(node, open);
    }

    private void recSetAllNodes(BasicNode node, boolean open) {
        if (node != this.rootNode) {
            node.isOpen = open;
        }
        Enumeration e = node.getChildren();
        while (e.hasMoreElements()) {
            this.recSetAllNodes((BasicNode)e.nextElement(), open);
        }
    }

    protected static void getAllLeaves(BasicNode start, Vector result) {
        Enumeration e = start.getChildren();
        while (e.hasMoreElements()) {
            BasicNode n = (BasicNode)e.nextElement();
            if (n.isLeaf) {
                result.addElement(n);
            }
            BasicTree.getAllLeaves(n, result);
        }
    }

    protected static void getAllObs(BasicNode start, Vector result) {
        Enumeration e = start.getChildren();
        while (e.hasMoreElements()) {
            BasicNode n = (BasicNode)e.nextElement();
            if (n.isObs) {
                result.addElement(n);
            }
            BasicTree.getAllObs(n, result);
        }
    }

    protected static void getAllNonLeaves(BasicNode start, Vector result) {
        Enumeration e = start.getChildren();
        while (e.hasMoreElements()) {
            BasicNode n = (BasicNode)e.nextElement();
            if (!n.isLeaf) {
                result.addElement(n);
            }
            BasicTree.getAllNonLeaves(n, result);
        }
    }

    protected void getAllSubnodes(BasicNode start, Vector result) {
        Enumeration e = start.getChildren();
        while (e.hasMoreElements()) {
            BasicNode n = (BasicNode)e.nextElement();
            result.addElement(n);
            this.getAllSubnodes(n, result);
        }
    }

    protected void resetCb() {
        for (int i = 0; i < this.nodeFullTab.length; ++i) {
            if (!this.nodeFullTab[i].isLeaf) continue;
            this.nodeFullTab[i].isSelected = false;
        }
        this.oHilightNode = -1;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        try {
            BasicNode node;
            int x = evt.getX();
            int y = evt.getY();
            Graphics h = this.getGraphics();
            if (this.triggerOnNodeSelected) {
                this.onNodeSelected(this.nodeToTrigger);
                this.triggerOnNodeSelected = false;
            }
            try {
                node = this.nodeTab[y / 18];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if ((evt.getModifiers() & 4) != 0) {
                    this.onRightClickOutNode(x, y);
                }
                return;
            }
            if (node.hide) {
                if ((evt.getModifiers() & 4) != 0) {
                    this.onRightClickOutNode(x, y);
                }
                return;
            }
            boolean inLogo = this.inLogo(node, x);
            boolean inNodeName = this.inNodeName(h, x, node);
            if (!inLogo && (evt.getModifiers() & 4) != 0) {
                if (inNodeName) {
                    this.onRightClickInNode(node, x, y);
                } else {
                    this.onRightClickOutNode(x, y);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        this.oselectedNode = this.selectedNode;
        try {
            this.selectedNode = this.nodeTab[y / 18];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        if (this.selectedNode.hide) {
            return;
        }
        if (this.selectedNode == this.rootNode && this.flatView) {
            return;
        }
        Graphics h = this.getGraphics();
        boolean inLogo = this.inLogo(this.selectedNode, x);
        boolean inNodeName = this.inNodeName(h, x, this.selectedNode);
        if (!inLogo && (evt.getModifiers() & 4) != 0) {
            return;
        }
        if (!inLogo && inNodeName) {
            if (evt.getClickCount() > 1) {
                this.onNodeSelectedDbleClick(this.selectedNode);
            } else {
                this.triggerOnNodeSelected = true;
                this.nodeToTrigger = this.selectedNode;
            }
        }
        if (!this.selectedNode.equals(this.lastInfoNode) && !inLogo && inNodeName) {
            BasicNode oInfoNode = this.lastInfoNode;
            this.lastInfoNode = this.selectedNode;
            try {
                this.drawNodeName(h, this.selectedNode, true);
                if (oInfoNode != null && !oInfoNode.hide && this.nodeTab[oInfoNode.y / 18].equals(oInfoNode)) {
                    this.drawNodeName(h, oInfoNode, true);
                }
            }
            catch (ArrayIndexOutOfBoundsException outExc) {
                // empty catch block
            }
        }
        if (this.selectedNode.isLeaf) {
            if (inLogo) {
                this.selectedNode.isSelected = !this.selectedNode.isSelected;
                this.drawCheckBox(h, this.selectedNode.x - 22, this.selectedNode.y, this.selectedNode, true);
            }
            this.repaint();
        } else {
            if (inLogo) {
                this.selectedNode.changeState();
                if (this.selectedNode.isOpen) {
                    this.onNodeExpanded(this.selectedNode);
                } else {
                    this.onNodeCollapsed(this.selectedNode);
                }
            }
            this.repaint();
        }
    }

    private boolean inLogo(BasicNode node, int x) {
        int min = node.level * 22;
        int max = node.level * 22 + 2 + 12;
        return x >= min && x <= max;
    }

    BasicNode getRootNode() {
        return this.rootNode;
    }

    void setRootNode(BasicNode node) {
        node.isLeaf = false;
        this.rootNode = node;
        this.createPopup();
    }

    @Override
    public Dimension getSize() {
        this.majSize();
        return new Dimension(this.prefWidth, this.prefHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.init(g);
        if (this.mustSetLocation) {
            // empty if block
        }
        this.mustSetLocation = true;
    }

    protected void setAllowSortByFields(boolean b) {
        this.allowSortByFields = b;
    }

    protected void onNodeExpanded(BasicNode node) {
    }

    protected void onNodeCollapsed(BasicNode node) {
    }

    protected void onNodeSelected(BasicNode node) {
    }

    protected void onNodeSelectedDbleClick(BasicNode node) {
    }

    protected void onNodeRemoved(BasicNode node) {
    }

    protected void onMouseMoved(BasicNode node, boolean inNodeName) {
    }

    protected void onRightClickInNode(BasicNode node, int x, int y) {
        this.popup.show(this, x, y);
    }

    protected void onRightClickOutNode(int x, int y) {
        this.popupPrefs.show(this, x, y);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    protected JScrollPane getScroll() {
        return this.scroll;
    }

    protected void setScroll(JScrollPane scroll) {
        this.scroll = scroll;
        this.scroll.getVerticalScrollBar().setUnitIncrement(18);
    }
}

