/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import java.util.Enumeration;
import java.util.Vector;

public abstract class BasicNode {
    Vector children;
    String name;
    String altName;
    BasicNode father = null;
    int level;
    int x;
    int y;
    boolean isOpen = false;
    boolean isLeaf = false;
    boolean isObs = false;
    int nbChildren = 0;
    boolean hide = false;
    boolean isSelected = false;
    boolean litup = false;
    Aladin aladin;

    BasicNode(Aladin aladin, BasicNode n) {
        this.aladin = aladin;
        this.name = n.name;
        this.isLeaf = n.isLeaf;
        this.hide = n.hide;
        this.children = new Vector();
    }

    BasicNode(Aladin aladin) {
        this(aladin, "");
    }

    BasicNode(Aladin aladin, String name) {
        this.aladin = aladin;
        this.name = name;
        this.children = new Vector();
    }

    BasicNode(Aladin aladin, String name, boolean isOpen, boolean isLeaf) {
        this(aladin, name);
        this.isOpen = isOpen;
        this.isLeaf = isLeaf;
    }

    public abstract BasicNode createNode(String var1);

    public BasicNode addChild(String childName) {
        BasicNode newNode = this.createNode(childName);
        newNode.father = this;
        this.children.addElement(newNode);
        ++this.nbChildren;
        return newNode;
    }

    public BasicNode addChild(String childName, boolean isOpen, boolean isLeaf) {
        BasicNode newNode = this.createNode(childName);
        newNode.isOpen = isOpen;
        newNode.isLeaf = isLeaf;
        newNode.father = this;
        this.children.addElement(newNode);
        ++this.nbChildren;
        return newNode;
    }

    public BasicNode addChild(BasicNode child) {
        child.father = this;
        this.children.addElement(child);
        ++this.nbChildren;
        return child;
    }

    public Enumeration getChildren() {
        return this.children.elements();
    }

    public int getNbOfChildren() {
        return this.children.size();
    }

    public BasicNode getChildrenAt(int index) {
        return (BasicNode)this.children.elementAt(index);
    }

    public BasicNode getParent() {
        return this.father;
    }

    public boolean removeChild(BasicNode child) {
        int index = this.children.indexOf(child);
        if (index >= 0) {
            this.children.removeElementAt(index);
            --this.nbChildren;
            return true;
        }
        return false;
    }

    public void removeAllChild() {
        this.children.removeAllElements();
        this.nbChildren = 0;
    }

    public void changeState() {
        this.isOpen = !this.isOpen;
    }

    public boolean isLastChild() {
        if (this.father == null) {
            return false;
        }
        BasicNode last = this.father.lastChild();
        return last != null && last.equals(this);
    }

    public BasicNode lastChild() {
        if (this.nbChildren > 0) {
            return (BasicNode)this.children.elementAt(this.children.size() - 1);
        }
        return null;
    }

    public BasicNode getChild(String s) {
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            BasicNode current = (BasicNode)e.nextElement();
            if (current.name == null || !current.name.equals(s)) continue;
            return current;
        }
        return null;
    }

    public boolean isSelected() {
        if (!this.isLeaf) {
            return false;
        }
        return this.isSelected;
    }
}

