/*
 * Decompiled with CFR 0.152.
 */
import cds.aladin.AladinData;
import cds.aladin.AladinPlugin;
import java.util.Enumeration;
import java.util.Hashtable;

public class ImageCreationPlug
extends AladinPlugin {
    @Override
    public String menu() {
        return "CreationPlug";
    }

    @Override
    public String description() {
        return "PLUGIN TUTORIAL:\nThis plugin is an example of an image plane creation.\nIt will create an image and will provide an astrometrical solution for it.";
    }

    @Override
    public String author() {
        return "Pierre Fernique [CDS]";
    }

    @Override
    public String version() {
        return "1.0 - nov 2013";
    }

    @Override
    public String url() {
        return "http://aladin.u-strasbg.fr/java/Plugins/ImageCreationPlug.java";
    }

    @Override
    public void exec() {
        try {
            this.createImage("x1", 100, 150, 100.0, 0.33, 10.0, 10.0, 3.0);
            this.createImage("x2", 120, 170, 100.0, 0.33, 10.0, 20.0, 1.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createImage(String name, int crpix1, int crpix2, double bzero, double bscale, double blank, double skyval, double exptime) throws Exception {
        AladinData ad = this.aladin.createAladinData(name);
        int width = 200;
        int height = 400;
        double[][] pix = new double[width][400];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double v = x < 30 || x > width - 30 ? 30.0 : (y < 50 || y > height - 50 ? 50.0 : ((x - width / 2) * (x - width / 2) + (y - height / 2) * (y - height / 2) < 30 ? blank : 80.0));
                if (v != blank && (skyval != 0.0 || exptime != 1.0)) {
                    double vv = v * bscale + bzero;
                    vv = vv * exptime + skyval;
                    v = (vv - bzero) / bscale;
                }
                pix[x][y] = v;
            }
        }
        ad.setPixels(pix, -32);
        System.out.println("----------Cr\u00e9ation via setFitsHeader(String) -----------");
        String header = "SIMPLE  = T\nBITPIX  = -32\nNAXIS   = 2\nNAXIS1  = " + width + "\n" + "NAXIS2  = " + height + "\n" + "CRPIX1  = " + crpix1 + "\n" + "CRPIX2  = " + crpix2 + "\n" + "CRVAL1  = 83.63310542835717\n" + "CRVAL2  = 22.014486753213667\n" + "CTYPE1  = RA---TAN\n" + "CTYPE2  = DEC--TAN\n" + "CD1_1   = -2.8004558788238224E-4\n" + "CD1_2   = -3.078969511615841E-6\n" + "CD2_1   = -3.078969511615841E-6\n" + "CD2_2   = 2.8004558788238224E-4\n" + "RADECSYS= FK5\n";
        if (bzero != 0.0) {
            header = header + "BZERO   = " + bzero + "\n";
        }
        if (bscale != 1.0) {
            header = header + "BSCALE  = " + bscale + "\n";
        }
        if (!Double.isNaN(blank)) {
            header = header + "BLANK   = " + blank + "\n";
        }
        if (skyval != 0.0) {
            header = header + "SKYVAL  = " + skyval + "\n";
        }
        if (exptime != 1.0) {
            header = header + "EXPTIME = " + exptime + "\n";
        }
        ad.setFitsHeader(header);
        Hashtable h = ad.seeFitsKeys();
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            System.out.println(k + " = [" + (String)h.get(k) + "]");
        }
    }
}

