/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import jsky.util.gui.BasicWindowMonitor;

public class SingleSelectComboBox
extends JComboBox {
    private HashSet _disabledSet = new HashSet();
    private ListCellRenderer _renderer = new DefaultListCellRenderer(){

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            boolean disabled = SingleSelectComboBox.this._disabledSet.contains(value);
            if (disabled) {
                isSelected = false;
            }
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setEnabled(!disabled);
            return label;
        }
    };

    public SingleSelectComboBox() {
        this.setRenderer(this._renderer);
    }

    public SingleSelectComboBox(ComboBoxModel model) {
        super(model);
        this.setRenderer(this._renderer);
    }

    public SingleSelectComboBox(Object[] ar) {
        super(ar);
        this.setRenderer(this._renderer);
    }

    public SingleSelectComboBox(Vector v) {
        super(v);
        this.setRenderer(this._renderer);
    }

    public void setEnabledIndex(int index, boolean enabled) {
        this.setEnabledObject(this.getModel().getElementAt(index), enabled);
    }

    public void setEnabledObject(Object o, boolean enabled) {
        if (enabled) {
            this._disabledSet.remove(o);
        } else {
            this._disabledSet.add(o);
        }
    }

    public void setEnabled(String s, boolean enabled) {
        ComboBoxModel model = this.getModel();
        int n = model.getSize();
        for (int i = 0; i < n; ++i) {
            Object o = model.getElementAt(i);
            if (o == null || !o.toString().equals(s)) continue;
            this.setEnabledObject(o, enabled);
            break;
        }
    }

    public void setChoices(Vector v) {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        for (int i = 0; i < v.size(); ++i) {
            model.addElement(v.get(i));
        }
        super.setModel(model);
    }

    public void setChoices(Object[] ar) {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
        for (int i = 0; i < ar.length; ++i) {
            model.addElement(ar[i]);
        }
        super.setModel(model);
    }

    public String getSelected() {
        Object o = this.getSelectedItem();
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    protected void fireActionEvent() {
        Object o = this.getSelectedItem();
        if (!this._disabledSet.contains(o)) {
            super.fireActionEvent();
        }
    }

    public void setSelectedIndex(int anIndex) {
        Object o = this.getModel().getElementAt(anIndex);
        if (o != null && this._disabledSet.contains(o)) {
            return;
        }
        super.setSelectedIndex(anIndex);
    }

    public static void main(String[] args) {
        Object[] ar = new String[]{"Test", "First Item", "Second Item", "Third Item", "Fourth Item", "Fifth Item"};
        final SingleSelectComboBox sscb = new SingleSelectComboBox(ar);
        sscb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("XXX selected " + sscb.getSelectedItem());
            }
        });
        sscb.setSelectedIndex(3);
        sscb.setEnabledIndex(4, false);
        sscb.setEnabledIndex(5, false);
        JFrame f = new JFrame("Test SingleSelectComboBox");
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        f.getContentPane().add(p);
        p.add((Component)sscb, "South");
        f.pack();
        f.setVisible(true);
        f.addWindowListener(new BasicWindowMonitor());
    }
}

