/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import jsky.coords.HMS;

public class SexagesimalTableCellRenderer
extends DefaultTableCellRenderer {
    private float _f = 1.0f;
    private boolean _showSeconds = true;

    public SexagesimalTableCellRenderer(boolean hoursFlag) {
        if (hoursFlag) {
            this._f = 15.0f;
        }
    }

    public SexagesimalTableCellRenderer(boolean hoursFlag, boolean showSeconds) {
        this(hoursFlag);
        this._showSeconds = showSeconds;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        double val = Double.NaN;
        if (value != null) {
            if (value instanceof Float) {
                val = ((Float)value).doubleValue();
            } else if (value instanceof Double) {
                val = (Double)value;
            }
        }
        if (!Double.isNaN(val)) {
            HMS hms = new HMS(val / (double)this._f);
            ((JLabel)component).setText(hms.toString(this._showSeconds));
        }
        return component;
    }
}

