/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.multi.MultiLookAndFeel;
import jsky.util.gui.BasicRangeSliderUI;
import jsky.util.gui.MetalRangeSliderUI;
import jsky.util.gui.MultiRangeSliderUI;
import jsky.util.gui.RangeSliderUI;

public class RangeSlider
extends JSlider {
    boolean showExtent;

    public String getUIClassID() {
        return "RangeSliderUI";
    }

    public void updateUI() {
        this.updateLabelUIs();
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof MetalLookAndFeel) {
            this.setUI(new MetalRangeSliderUI(this, this.showExtent));
        } else if (laf instanceof MultiLookAndFeel) {
            this.setUI(new MultiRangeSliderUI());
        } else {
            this.setUI(new BasicRangeSliderUI(this, this.showExtent));
        }
    }

    public RangeSlider() {
        this(0, 0, 100, 50, 0, false);
    }

    public RangeSlider(int orientation) {
        this(orientation, 0, 100, 50, 0, false);
    }

    public RangeSlider(int min, int max) {
        this(0, min, max, 50, 0, false);
    }

    public RangeSlider(int min, int max, int value) {
        this(0, min, max, value, 0, false);
    }

    public RangeSlider(int orientation, int min, int max, int value, int extent) {
        this(orientation, min, max, value, extent, extent != 0);
    }

    public boolean thumbContains(int x, int y) {
        return ((RangeSliderUI)((Object)this.getUI())).thumbContains(x, y);
    }

    public boolean extentContains(int x, int y) {
        return ((RangeSliderUI)((Object)this.getUI())).extentContains(x, y);
    }

    public RangeSlider(int orientation, int min, int max, int value, int extent, boolean doExtent) {
        this(orientation, new DefaultBoundedRangeModel(value, extent, min, max), doExtent);
    }

    public RangeSlider(BoundedRangeModel brm) {
        this(0, brm, brm.getExtent() != 0);
    }

    public RangeSlider(BoundedRangeModel brm, boolean doExtent) {
        this(0, brm, doExtent);
    }

    public RangeSlider(int orient, BoundedRangeModel brm, boolean doExtent) {
        this.orientation = orient;
        this.setModel(brm);
        this.sliderModel.addChangeListener(this.changeListener);
        this.showExtent = doExtent;
        this.updateUI();
        this.setPaintLabels(true);
        this.setPaintTicks(true);
        this.setPaintTrack(false);
    }

    public static void main(String[] args) {
        int sz = UIManager.getInstalledLookAndFeels().length;
        for (int i = 0; i < 1; ++i) {
            try {
                String laf = UIManager.getInstalledLookAndFeels()[i].getClassName();
                UIManager.setLookAndFeel(laf);
                System.out.println(laf);
                RangeSlider s = new RangeSlider(1, 0, 100, 50, 20, true);
                s.setPaintLabels(true);
                s.setPaintTicks(true);
                s.setPaintTrack(true);
                JOptionPane.showMessageDialog(null, s);
                continue;
            }
            catch (Exception e) {
                System.out.println("   exception=" + e);
            }
        }
        System.exit(0);
    }
}

