/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jsky.util.Preferences;
import jsky.util.ProxyServerUtil;
import jsky.util.gui.DialogUtil;

public class ProxyServerDialog
extends JDialog {
    JPanel panel1 = new JPanel();
    JTextArea jTextArea1 = new JTextArea();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    JTextField proxyServerField = new JTextField();
    JLabel jLabel2 = new JLabel();
    JTextField proxyPortField = new JTextField();
    JTextArea jTextArea2 = new JTextArea();
    JLabel jLabel3 = new JLabel();
    JTextField nonProxyHostsField = new JTextField();
    JPanel jPanel1 = new JPanel();
    JButton cancelButton = new JButton();
    JButton applyButton = new JButton();
    JButton resetButton = new JButton();
    JButton okButton = new JButton();

    public ProxyServerDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.reset();
        Preferences.manageLocation(this);
    }

    public ProxyServerDialog() {
        this((Frame)null, "", false);
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout1);
        this.jTextArea1.setBackground(new Color(204, 204, 204));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setText("If your host is behind a firewall, you may need to use a proxy server to access remote catalogs via HTTP. Please enter the hostname and port number for the proxy server:");
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setWrapStyleWord(true);
        this.jLabel1.setLabelFor(this.proxyServerField);
        this.jLabel1.setText("HTTP Proxy Server:");
        this.jLabel2.setLabelFor(this.proxyPortField);
        this.jLabel2.setText("Port:");
        this.jTextArea2.setBackground(new Color(204, 204, 204));
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setText("The value below can be a list of hosts, each seperated by a |. In addition, a wildcard character (*) can be used for matching. For example: *.foo.com|localhost :");
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setWrapStyleWord(true);
        this.jLabel3.setLabelFor(this.nonProxyHostsField);
        this.jLabel3.setText("No Proxy for:");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProxyServerDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProxyServerDialog.this.applyButton_actionPerformed(e);
            }
        });
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProxyServerDialog.this.resetButton_actionPerformed(e);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProxyServerDialog.this.okButton_actionPerformed(e);
            }
        });
        this.setTitle("Proxy Server");
        this.panel1.setMinimumSize(new Dimension(521, 220));
        this.panel1.setPreferredSize(new Dimension(521, 220));
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jTextArea1, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 17, 2, new Insets(11, 11, 0, 11), 0, 0));
        this.panel1.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 11, 0, 0), 0, 0));
        this.panel1.add((Component)this.proxyServerField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(11, 11, 0, 0), 0, 0));
        this.panel1.add((Component)this.jLabel2, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(11, 11, 0, 0), 0, 0));
        this.panel1.add((Component)this.proxyPortField, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(11, 11, 0, 11), 0, 0));
        this.panel1.add((Component)this.jTextArea2, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 17, 2, new Insets(11, 11, 0, 11), 0, 0));
        this.panel1.add((Component)this.jLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 11, 0, 0), 0, 0));
        this.panel1.add((Component)this.nonProxyHostsField, new GridBagConstraints(1, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(11, 11, 0, 11), 0, 0));
        this.panel1.add((Component)this.jPanel1, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 14, 0, new Insets(17, 11, 11, 11), 0, 0));
        this.jPanel1.add((Component)this.okButton, null);
        this.jPanel1.add((Component)this.resetButton, null);
        this.jPanel1.add((Component)this.applyButton, null);
        this.jPanel1.add((Component)this.cancelButton, null);
    }

    void okButton_actionPerformed(ActionEvent e) {
        if (this.apply()) {
            this.close();
        }
    }

    void resetButton_actionPerformed(ActionEvent e) {
        this.reset();
    }

    void applyButton_actionPerformed(ActionEvent e) {
        this.apply();
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.close();
    }

    public boolean apply() {
        String host = this.proxyServerField.getText();
        int port = 80;
        String s = this.proxyPortField.getText();
        if (s != null && s.length() != 0) {
            try {
                port = Integer.parseInt(this.proxyPortField.getText());
            }
            catch (Exception e) {
                DialogUtil.error("Please enter a valid proxy port number.");
                return false;
            }
        }
        String nonProxyHosts = this.nonProxyHostsField.getText();
        ProxyServerUtil.setProxy(host, port, nonProxyHosts);
        return true;
    }

    public void reset() {
        String host = ProxyServerUtil.getHost();
        if (host == null) {
            host = "";
        }
        int port = ProxyServerUtil.getPort();
        String nonProxyHosts = ProxyServerUtil.getNonProxyHosts();
        if (nonProxyHosts == null) {
            nonProxyHosts = "";
        }
        this.proxyServerField.setText(host);
        this.proxyPortField.setText("" + port);
        this.nonProxyHostsField.setText(nonProxyHosts);
    }

    public void close() {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        ProxyServerUtil.init();
        new ProxyServerDialog(){

            public void close() {
                System.exit(0);
            }
        }.setVisible(true);
    }
}

