/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jsky.util.Resources;
import jsky.util.StatusLogger;
import jsky.util.gui.BusyWin;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ProgressBarFilterInputStream;
import jsky.util.gui.ProgressException;
import jsky.util.gui.ProgressPanelDialog;
import jsky.util.gui.StatusPanel;
import jsky.util.gui.SwingUtil;

public class ProgressPanel
extends JPanel
implements ActionListener,
StatusLogger {
    private Component _parent;
    private String _title;
    private JLabel _titleLabel;
    private JLabel _iconLabel;
    private JButton _stopButton;
    private StatusPanel _statusPanel;
    private ProgressBarFilterInputStream _loggedInputStream;
    private boolean _interrupted;
    private static ProgressPanel _newPanel;

    public ProgressPanel(Component parent, String title) {
        this._parent = parent;
        this._title = title;
        this.init();
    }

    public ProgressPanel() {
        this(null, "Download in Progress...");
    }

    public JButton getStopButton() {
        return this._stopButton;
    }

    protected void init() {
        if (!SwingUtilities.isEventDispatchThread()) {
            ProgressPanel.invokeAndWait(new Runnable(){

                public void run() {
                    ProgressPanel.this.init();
                }
            });
            return;
        }
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        JPanel top = new JPanel();
        top.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        top.setLayout(new BorderLayout());
        this._titleLabel = new JLabel(this._title, 0);
        this._titleLabel.setForeground(Color.black);
        top.add((Component)this._titleLabel, "West");
        this._iconLabel = new JLabel(Resources.getIcon("TaskStatusOn.gif"));
        top.add((Component)this._iconLabel, "East");
        JPanel center = new JPanel();
        this._stopButton = new JButton("Stop");
        this._stopButton.addActionListener(this);
        center.add(this._stopButton);
        top.add((Component)center, "South");
        this._statusPanel = new StatusPanel();
        this._statusPanel.getTextField().setColumns(25);
        this.add((Component)top, "North");
        this.add((Component)this._statusPanel, "South");
    }

    protected static void invokeAndWait(Runnable r) {
        try {
            SwingUtilities.invokeAndWait(r);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setParent(Component parent) {
        this._parent = parent;
    }

    public void setTitle(final String title) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressPanel.this.setTitle(title);
                }
            });
            return;
        }
        this._title = title;
        this._titleLabel.setText(title);
    }

    public void logMessage(final String msg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressPanel.this._statusPanel.setText(msg);
                }
            });
            return;
        }
        this._statusPanel.setText(msg);
    }

    public void setText(final String s) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressPanel.this._statusPanel.setText(s);
                }
            });
            return;
        }
        this._statusPanel.setText(s);
    }

    public void addActionListener(ActionListener l) {
        this._stopButton.addActionListener(l);
    }

    public StatusPanel getStatusPanel() {
        return this._statusPanel;
    }

    public void actionPerformed(ActionEvent e) {
        this._interrupted = true;
        this.stop();
    }

    public boolean isInterrupted() {
        return this._interrupted;
    }

    public URLConnection openConnection(URL url) throws IOException {
        this.start();
        URLConnection connection = this._statusPanel.openConnection(url);
        if (this._interrupted) {
            throw new ProgressException("Interrupted");
        }
        return connection;
    }

    public void start() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressPanel.this.start();
                }
            });
            return;
        }
        this._interrupted = false;
        if (this._parent instanceof JFrame) {
            ((JFrame)this._parent).setState(0);
        }
        this._parent.setVisible(true);
        this._statusPanel.getProgressBar().startAnimation();
        BusyWin.setBusy(true, this._parent);
    }

    public void stop() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressPanel.this.stop();
                }
            });
            return;
        }
        BusyWin.setBusy(false, this._parent);
        if (this._loggedInputStream != null) {
            this._loggedInputStream.interrupt();
            this._loggedInputStream = null;
        }
        this._parent.setVisible(false);
        this._statusPanel.interrupt();
        this._statusPanel.getProgressBar().stopAnimation();
        this._statusPanel.setText("");
        this._statusPanel.getProgressBar().setStringPainted(false);
        this._statusPanel.getProgressBar().setValue(0);
    }

    public static ProgressPanel makeProgressPanel(final String title, final Component window) {
        if (!SwingUtilities.isEventDispatchThread()) {
            ProgressPanel.invokeAndWait(new Runnable(){

                public void run() {
                    _newPanel = ProgressPanel.makeProgressPanel(title, window);
                }
            });
            return _newPanel;
        }
        Frame parent = null;
        JDesktopPane desktop = DialogUtil.getDesktop();
        parent = desktop != null ? SwingUtil.getFrame(desktop) : SwingUtil.getFrame(window);
        ProgressPanelDialog f = new ProgressPanelDialog(title, parent);
        f.show();
        return f.getProgressPanel();
    }

    public static ProgressPanel makeProgressPanel(String title) {
        return ProgressPanel.makeProgressPanel(title, null);
    }

    public static ProgressPanel makeProgressPanel() {
        return ProgressPanel.makeProgressPanel("Downloading data...");
    }

    public void setProgress(final int percent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressPanel.this._statusPanel.getProgressBar().stopAnimation();
                    ProgressPanel.this._statusPanel.setProgress(percent);
                }
            });
            return;
        }
        this._statusPanel.getProgressBar().stopAnimation();
        this._statusPanel.setProgress(percent);
    }

    public ProgressBarFilterInputStream getLoggedInputStream(InputStream in, int size) throws IOException {
        if (this._interrupted) {
            throw new ProgressException("Interrupted");
        }
        this._loggedInputStream = this._statusPanel.getLoggedInputStream(in, size);
        return this._loggedInputStream;
    }

    public ProgressBarFilterInputStream getLoggedInputStream(URL url) throws IOException {
        if (this._interrupted) {
            throw new ProgressException("Interrupted");
        }
        this._loggedInputStream = this._statusPanel.getLoggedInputStream(url);
        return this._loggedInputStream;
    }

    public void stopLoggingInputStream(ProgressBarFilterInputStream in) throws IOException {
        this._loggedInputStream = null;
        this._statusPanel.stopLoggingInputStream(in);
    }
}

