/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jsky.util.FileUtil;
import jsky.util.SwingWorker;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ProgressBarUtil;
import jsky.util.gui.ProgressException;
import jsky.util.gui.StatusPanel;

public class ProgressBarFilterInputStream
extends FilterInputStream {
    protected ProgressBarUtil progressBar;
    JTextField statusField;
    protected DefaultBoundedRangeModel model;
    protected int nread = 0;
    protected int size = 0;
    protected long updateTime = 0L;
    protected boolean interrupted = false;

    public ProgressBarFilterInputStream(ProgressBarUtil progressBar, JTextField statusField, InputStream in, int size) {
        super(in);
        this.progressBar = progressBar;
        this.statusField = statusField;
        this.setSize(size);
    }

    public ProgressBarFilterInputStream(ProgressBarUtil progressBar, JTextField statusField, URL url) {
        super(FileUtil.makeURLStream(url));
        this.progressBar = progressBar;
        this.statusField = statusField;
        progressBar.startAnimation();
        statusField.setText("Connect: Host " + url.getHost());
        try {
            int size = url.openConnection().getContentLength();
            progressBar.stopAnimation();
            this.setSize(size);
        }
        catch (Exception e) {
            statusField.setText(e.getMessage());
            progressBar.stopAnimation();
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        statusField.setText("Connected to Host " + url.getHost());
    }

    public ProgressBarFilterInputStream(StatusPanel statusPanel, URL url) {
        this(statusPanel.getProgressBar(), statusPanel.getTextField(), url);
    }

    public void interrupt() {
        this.interrupted = true;
        this.progressBar.stopAnimation();
        this.progressBar.setStringPainted(false);
        if (this.model != null) {
            this.model.setValue(0);
        }
        this.statusField.setText("Reading interrupted.");
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void checkForInterrupt() throws IOException {
        if (this.interrupted) {
            throw new ProgressException("Reading interrupted");
        }
    }

    public void setSize(final int size) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressBarFilterInputStream.this.setSize(size);
                }
            });
            return;
        }
        this.size = size;
        if (size <= 0) {
            this.model = null;
            this.progressBar.startAnimation();
            this.progressBar.setStringPainted(false);
        } else {
            this.progressBar.stopAnimation();
            this.model = new DefaultBoundedRangeModel(0, 0, 0, size);
            this.progressBar.setModel(this.model);
            this.progressBar.setStringPainted(true);
        }
    }

    protected void setNumBytesRead(final int n) {
        this.nread = n;
        long t = System.currentTimeMillis();
        if (t - this.updateTime > 200L) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProgressBarFilterInputStream.this.setNumBytesRead(n);
                    }
                });
                return;
            }
            if (this.model != null) {
                this.progressBar.stopAnimation();
                this.model.setValue(this.nread);
            }
            this.statusField.setText("Reading File: " + this.nread + " bytes");
            this.updateTime = t;
        }
    }

    public void clear() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressBarFilterInputStream.this.clear();
                }
            });
            return;
        }
        this.nread = 0;
        this.updateTime = 0L;
        this.progressBar.stopAnimation();
        this.progressBar.setStringPainted(false);
        this.statusField.setText("Document Done");
        if (this.model != null) {
            this.model.setValue(0);
        }
    }

    public int getSize() {
        return this.size;
    }

    public int read() throws IOException {
        this.checkForInterrupt();
        int c = this.in.read();
        if (c >= 0) {
            this.setNumBytesRead(this.nread + 1);
        } else {
            this.clear();
        }
        return c;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkForInterrupt();
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this.setNumBytesRead(this.nread + nr);
        } else if (nr == -1) {
            this.clear();
        }
        return nr;
    }

    public long skip(long n) throws IOException {
        this.checkForInterrupt();
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.setNumBytesRead(this.nread + (int)nr);
        }
        return nr;
    }

    public void close() throws IOException {
        this.in.close();
        this.clear();
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.clear();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        JPanel top = new JPanel();
        StatusPanel statusPanel = new StatusPanel();
        ProgressBarUtil progressBarUtil = statusPanel.getProgressBar();
        top.setLayout(new BorderLayout());
        top.add((Component)statusPanel, "North");
        frame.getContentPane().add((Component)top, "North");
        JPanel bot = new JPanel();
        JButton busyButton = new JButton("Look Busy");
        JButton startButton = new JButton("Start Reading");
        JButton stopButton = new JButton("Stop");
        bot.add(busyButton);
        bot.add(startButton);
        bot.add(stopButton);
        frame.getContentPane().add((Component)bot, "South");
        class TestListener
        implements ActionListener {
            ProgressBarFilterInputStream stream;
            URL url;
            private final /* synthetic */ JButton val$busyButton;
            private final /* synthetic */ ProgressBarUtil val$progressBarUtil;
            private final /* synthetic */ JButton val$startButton;
            private final /* synthetic */ StatusPanel val$statusPanel;
            private final /* synthetic */ JButton val$stopButton;

            public TestListener(JButton val$busyButton, ProgressBarUtil val$progressBarUtil, JButton val$startButton, StatusPanel val$statusPanel, JButton val$stopButton) {
                this.val$busyButton = val$busyButton;
                this.val$progressBarUtil = val$progressBarUtil;
                this.val$startButton = val$startButton;
                this.val$statusPanel = val$statusPanel;
                this.val$stopButton = val$stopButton;
                try {
                    this.url = new URL("file:/etc/hosts");
                }
                catch (Exception e) {
                    DialogUtil.error(e);
                    System.exit(1);
                }
            }

            public void actionPerformed(ActionEvent e) {
                Object w = e.getSource();
                if (w == this.val$busyButton) {
                    if (this.stream != null) {
                        this.stream.interrupt();
                        this.stream = null;
                    }
                    this.val$progressBarUtil.startAnimation();
                } else if (w == this.val$startButton) {
                    if (this.stream != null) {
                        this.stream.interrupt();
                        this.stream = null;
                    }
                    this.stream = new ProgressBarFilterInputStream(this.val$statusPanel, this.url);
                    SwingWorker worker = new SwingWorker(this){
                        private final /* synthetic */ TestListener this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public Object construct() {
                            try {
                                while (this.this$0.stream.read() != -1) {
                                }
                                return null;
                            }
                            catch (Exception ex) {
                                return null;
                            }
                        }
                    };
                    worker.start();
                } else if (w == this.val$stopButton) {
                    if (this.stream != null) {
                        this.stream.interrupt();
                        this.stream = null;
                    } else {
                        this.val$progressBarUtil.stopAnimation();
                    }
                }
            }
        }
        TestListener tl = new TestListener(busyButton, progressBarUtil, startButton, statusPanel, stopButton);
        busyButton.addActionListener(tl);
        startButton.addActionListener(tl);
        stopButton.addActionListener(tl);
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }
}

