/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicArrowButton;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.GridBagUtil;

public class MultiSelectComboBox
extends JComponent {
    private JButton _button;
    private BasicArrowButton _arrowButton;
    private JPopupMenu _popupMenu;
    private JCheckBoxMenuItem[] _menuItems;
    private ListModel _model;
    private DefaultListSelectionModel _selectionModel;
    private ItemListener _itemListener;
    private ListDataListener _listDataListener;
    private boolean _ignoreSelection = false;
    private static final String _ANY = "<Any>";
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public MultiSelectComboBox() {
        GridBagUtil layout = new GridBagUtil(this);
        MouseAdapter l = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                MultiSelectComboBox.this._popupMenu.show(MultiSelectComboBox.this, 0, MultiSelectComboBox.this.getHeight());
            }
        };
        this._button = new JButton(_ANY);
        this._button.setRequestFocusEnabled(false);
        this._button.setBorder(null);
        this._button.setHorizontalAlignment(2);
        this._button.addMouseListener(l);
        this._arrowButton = new BasicArrowButton(5);
        this._arrowButton.setRequestFocusEnabled(false);
        this._arrowButton.setBorder(null);
        this._arrowButton.addMouseListener(l);
        this._popupMenu = new JPopupMenu();
        this.setRequestFocusEnabled(true);
        this.setBorder(BorderFactory.createEtchedBorder());
        layout.add(this._button, 0, 0, 1, 1, 1.0, 1.0, 1, 10, new Insets(2, 2, 2, 0), 0, 0);
        layout.add(this._arrowButton, 1, 0, 1, 1, 0.0, 0.0, 1, 13, new Insets(2, 0, 2, 2), 0, 0);
        this._selectionModel = new DefaultListSelectionModel();
        this._selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                MultiSelectComboBox.this._updateSelection();
            }
        });
        this._itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MultiSelectComboBox.this._updateSelectionModel();
                MultiSelectComboBox.this._fireActionEvent();
            }
        };
        this._listDataListener = new ListDataListener(){

            public void intervalAdded(ListDataEvent e) {
                MultiSelectComboBox.this.setModel(MultiSelectComboBox.this._model);
            }

            public void intervalRemoved(ListDataEvent e) {
                MultiSelectComboBox.this.setModel(MultiSelectComboBox.this._model);
            }

            public void contentsChanged(ListDataEvent e) {
                MultiSelectComboBox.this.setModel(MultiSelectComboBox.this._model);
            }
        };
    }

    public MultiSelectComboBox(ListModel model) {
        this();
        this.setModel(model);
    }

    public MultiSelectComboBox(Object[] ar) {
        this();
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        for (int i = 0; i < ar.length; ++i) {
            model.addElement(ar[i]);
        }
        this.setModel(model);
    }

    public void setToolTipText(String s) {
        this._button.setToolTipText(s);
        this._arrowButton.setToolTipText(s);
    }

    public void setEnabled(boolean b) {
        this._button.setEnabled(b);
        this._arrowButton.setEnabled(b);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = MultiSelectComboBox.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = MultiSelectComboBox.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    private void _fireActionEvent() {
        ActionEvent e = new ActionEvent(this, 0, "");
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$ActionListener == null ? MultiSelectComboBox.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public void setModel(ListModel model) {
        this.clearSelection();
        this._popupMenu = new JPopupMenu();
        this._model = model;
        int n = model.getSize();
        this._menuItems = new JCheckBoxMenuItem[n];
        for (int i = 0; i < n; ++i) {
            this._menuItems[i] = new JCheckBoxMenuItem(model.getElementAt(i).toString());
            this._menuItems[i].removeItemListener(this._itemListener);
            this._menuItems[i].addItemListener(this._itemListener);
            this._popupMenu.add(this._menuItems[i]);
        }
        model.addListDataListener(this._listDataListener);
    }

    public ListModel getModel() {
        return this._model;
    }

    public ListSelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    public int getSelectionCount() {
        int result = 0;
        if (this._menuItems != null && this._menuItems.length != 0) {
            for (int i = 0; i < this._menuItems.length; ++i) {
                if (!this._menuItems[i].isSelected()) continue;
                ++result;
            }
        }
        return result;
    }

    public int[] getSelectedIndexes() {
        int[] result = new int[this.getSelectionCount()];
        int index = 0;
        if (this._menuItems != null && this._menuItems.length != 0 && result.length != 0) {
            for (int i = 0; i < this._menuItems.length; ++i) {
                if (!this._menuItems[i].isSelected()) continue;
                result[index++] = i;
            }
        }
        return result;
    }

    public void setSelectedIndexes(int[] ar) {
        this.clearSelection();
        if (this._menuItems != null && this._menuItems.length != 0 && ar.length != 0) {
            block0: for (int i = 0; i < this._menuItems.length; ++i) {
                Object item = this._model.getElementAt(i);
                for (int j = 0; j < ar.length; ++j) {
                    if (!this._model.getElementAt(ar[j]).equals(item)) continue;
                    this._menuItems[i].setSelected(true);
                    continue block0;
                }
            }
        }
    }

    public Object[] getSelectedObjects() {
        Object[] result = new Object[this.getSelectionCount()];
        int index = 0;
        if (this._menuItems != null && this._menuItems.length != 0 && result.length != 0) {
            for (int i = 0; i < this._menuItems.length; ++i) {
                if (!this._menuItems[i].isSelected()) continue;
                result[index++] = this._model.getElementAt(i);
            }
        }
        return result;
    }

    public String[] getSelected() {
        Object[] ar = this.getSelectedObjects();
        String[] result = new String[ar.length];
        for (int i = 0; i < ar.length; ++i) {
            result[i] = ar[i].toString();
        }
        return result;
    }

    public void clearSelection() {
        if (this._menuItems != null && this._menuItems.length != 0) {
            for (int i = 0; i < this._menuItems.length; ++i) {
                if (!this._menuItems[i].isSelected()) continue;
                this._menuItems[i].setSelected(false);
            }
        }
    }

    public void setSelectedObjects(Object[] ar) {
        this.clearSelection();
        if (this._menuItems != null && this._menuItems.length != 0 && ar.length != 0) {
            block0: for (int i = 0; i < this._menuItems.length; ++i) {
                Object item = this._model.getElementAt(i);
                for (int j = 0; j < ar.length; ++j) {
                    if (!ar[j].equals(item)) continue;
                    this._menuItems[i].setSelected(true);
                    continue block0;
                }
            }
        }
    }

    private void _updateButton() {
        if (this._menuItems != null && this._menuItems.length != 0) {
            StringBuffer sb = new StringBuffer();
            String sep = "";
            int count = 0;
            for (int i = 0; i < this._menuItems.length; ++i) {
                if (!this._menuItems[i].isSelected()) continue;
                sb.append(sep);
                sep = ", ";
                sb.append(this._menuItems[i].getText());
                ++count;
            }
            if (count == 0) {
                this._button.setText(_ANY);
            } else {
                this._button.setText(sb.toString());
            }
            Dimension d = new Dimension();
            this._button.setPreferredSize(d);
            this._button.setMinimumSize(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateSelection() {
        if (!this._ignoreSelection) {
            this._ignoreSelection = true;
            try {
                for (int i = 0; i < this._menuItems.length; ++i) {
                    boolean selected = this._selectionModel.isSelectedIndex(i);
                    if (selected == this._menuItems[i].isSelected()) continue;
                    this._menuItems[i].setSelected(selected);
                }
                this._updateButton();
            }
            finally {
                this._ignoreSelection = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateSelectionModel() {
        if (!this._ignoreSelection) {
            this._ignoreSelection = true;
            try {
                for (int i = 0; i < this._menuItems.length; ++i) {
                    boolean selected = this._menuItems[i].isSelected();
                    if (selected == this._selectionModel.isSelectedIndex(i)) continue;
                    if (selected) {
                        this._selectionModel.setSelectionInterval(i, i);
                        continue;
                    }
                    this._selectionModel.removeSelectionInterval(i, i);
                }
                this._updateButton();
            }
            finally {
                this._ignoreSelection = false;
            }
        }
    }

    public static void main(String[] args) {
        Object[] ar = new String[]{"Test", "First Item", "Second Item", "Third Item", "Fourth Item", "Fifth Item"};
        JComboBox<String> cb = new JComboBox<String>(ar);
        MultiSelectComboBox mscb = new MultiSelectComboBox(ar);
        mscb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("XXX MultiSelectComboBox.actionPerformed");
            }
        });
        JFrame f = new JFrame("Test MultiSelectComboBox");
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        f.getContentPane().add(p);
        p.add(cb, "North");
        p.add((Component)mscb, "South");
        f.pack();
        f.setVisible(true);
        f.addWindowListener(new BasicWindowMonitor());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

