/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import jsky.util.I18N;
import jsky.util.Resources;
import jsky.util.gui.GenericToolBarTarget;

public class GenericToolBar
extends JToolBar {
    private static final I18N _I18N = I18N.getInstance(class$jsky$util$gui$GenericToolBar == null ? (class$jsky$util$gui$GenericToolBar = GenericToolBar.class$("jsky.util.gui.GenericToolBar")) : class$jsky$util$gui$GenericToolBar);
    protected GenericToolBarTarget target;
    protected JButton openButton;
    protected JButton backButton;
    protected JButton forwardButton;
    protected boolean showPictures = true;
    protected boolean showText = true;
    static /* synthetic */ Class class$jsky$util$gui$GenericToolBar;

    public GenericToolBar(GenericToolBarTarget target, boolean addItems, int orientation) {
        super(orientation);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.setFloatable(false);
        if (target != null) {
            target.getBackAction().setEnabled(false);
            target.getForwAction().setEnabled(false);
            this.target = target;
        }
        if (addItems) {
            this.addToolBarItems();
        }
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), this.getBorder()));
    }

    public GenericToolBar(GenericToolBarTarget target, boolean addItems) {
        this(target, addItems, 0);
    }

    public GenericToolBar(GenericToolBarTarget target) {
        this(target, true);
    }

    public GenericToolBar() {
        this(null, true);
    }

    protected void addToolBarItems() {
        this.add(this.makeOpenButton());
        this.addSeparator();
        this.add(this.makeBackButton());
        this.add(this.makeForwardButton());
    }

    protected AbstractButton setupButton(AbstractButton button) {
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        return button;
    }

    protected JButton makeOpenButton() {
        if (this.openButton == null) {
            this.openButton = this.makeButton(_I18N.getString("fileOpenTip"), this.target.getOpenAction(), false);
        }
        this.updateButton(this.openButton, _I18N.getString("open"), Resources.getIcon("Open24.gif"));
        this.target.getOpenAction().setEnabled(true);
        return this.openButton;
    }

    protected JButton makeBackButton() {
        if (this.backButton == null) {
            this.backButton = this.makeButton(_I18N.getString("fileBackTip"), this.target.getBackAction(), false);
        }
        this.updateButton(this.backButton, _I18N.getString("back"), Resources.getIcon("Back24.gif"));
        return this.backButton;
    }

    protected JButton makeForwardButton() {
        if (this.forwardButton == null) {
            this.forwardButton = this.makeButton(_I18N.getString("fileForwardTip"), this.target.getForwAction(), false);
        }
        this.updateButton(this.forwardButton, _I18N.getString("forward"), Resources.getIcon("Forward24.gif"));
        return this.forwardButton;
    }

    protected JButton makeButton(String toolTip, Action action, boolean isMenuButton) {
        JButton button = new JButton();
        button.setToolTipText(toolTip);
        if (action != null) {
            action.addPropertyChangeListener(new ButtonPropertyChangeListener(button));
            button.setEnabled(action.isEnabled());
            button.addActionListener(action);
        }
        this.setupButton(button);
        return button;
    }

    protected JToggleButton makeToggleButton(String toolTip, Action action) {
        JToggleButton button = new JToggleButton();
        button.setToolTipText(toolTip);
        if (action != null) {
            action.addPropertyChangeListener(new ButtonPropertyChangeListener(button));
            button.setEnabled(action.isEnabled());
            button.addActionListener(action);
        }
        this.setupButton(button);
        return button;
    }

    protected JButton makeMenuButton(String toolTip, final JPopupMenu menu) {
        JButton button = this.makeButton(toolTip, null, true);
        button.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Component c = e.getComponent();
                menu.show(c, 0, c.getHeight());
            }
        });
        return button;
    }

    protected void updateButton(AbstractButton button, String text, Icon icon) {
        if (this.showText) {
            button.setText(text);
        } else {
            button.setText(null);
        }
        button.setAlignmentX(0.5f);
        if (this.showPictures) {
            button.setIcon(icon);
        } else {
            button.setIcon(null);
        }
    }

    public void setShowPictures(boolean b) {
        this.showPictures = b;
        this.update();
    }

    public void setShowText(boolean b) {
        this.showText = b;
        this.update();
    }

    public void update() {
        this.makeOpenButton();
        this.makeBackButton();
        this.makeForwardButton();
    }

    public JButton getOpenButton() {
        return this.openButton;
    }

    public JButton getBackButton() {
        return this.backButton;
    }

    public JButton getForwardButton() {
        return this.forwardButton;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ButtonPropertyChangeListener
    implements PropertyChangeListener {
        AbstractButton button;

        public ButtonPropertyChangeListener(AbstractButton button) {
            this.button = button;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("enabled")) {
                this.button.setEnabled((Boolean)e.getNewValue());
            }
        }
    }
}

