/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import jsky.util.ExceptionHandler;
import jsky.util.gui.BusyWin;

public class DialogUtil {
    private static JDesktopPane _desktop;
    private static List _exceptionHandlerList;

    public static void setDesktop(JDesktopPane d) {
        _desktop = d;
    }

    public static JDesktopPane getDesktop() {
        return _desktop;
    }

    public static void addExceptionHandler(ExceptionHandler handler) {
        if (_exceptionHandlerList == null) {
            _exceptionHandlerList = new LinkedList();
        }
        _exceptionHandlerList.add(handler);
    }

    public static void removeExceptionHandler(ExceptionHandler handler) {
        if (_exceptionHandlerList != null) {
            _exceptionHandlerList.remove(handler);
        }
    }

    public static void error(Component parentComponent, String msg) {
        if (_desktop != null) {
            BusyWin.setBusy(false);
            JOptionPane.showInternalMessageDialog(_desktop, msg, "Error", 0);
        } else {
            JOptionPane.showMessageDialog(parentComponent, msg, "Error", 0);
        }
    }

    public static void error(String msg) {
        DialogUtil.error(null, msg);
    }

    public static void error(Component parentComponent, Exception e) {
        if (_exceptionHandlerList != null && _exceptionHandlerList.size() != 0) {
            ListIterator it = _exceptionHandlerList.listIterator();
            while (it.hasNext()) {
                ExceptionHandler handler = (ExceptionHandler)it.next();
                if (!handler.handleException(e)) continue;
                return;
            }
        }
        e.printStackTrace();
        String s = e.getMessage();
        if (e instanceof UnknownHostException) {
            s = "Unknown host: " + s;
        } else if (s == null || s.trim().length() == 0) {
            s = e.toString();
        }
        if (_desktop != null) {
            BusyWin.setBusy(false);
            JOptionPane.showInternalMessageDialog(_desktop, s, "Error", 0);
        } else {
            JOptionPane.showMessageDialog(parentComponent, s, "Error", 0);
        }
    }

    public static void error(Exception e) {
        DialogUtil.error(null, e);
    }

    public static void message(Component parentComponent, String msg) {
        if (_desktop != null) {
            BusyWin.setBusy(false);
            JOptionPane.showInternalMessageDialog(_desktop, msg, "Message", 1);
        } else {
            JOptionPane.showMessageDialog(parentComponent, msg, "Message", 1);
        }
    }

    public static void message(String msg) {
        DialogUtil.message(null, msg);
    }

    public static String input(Component parentComponent, String msg, String initialValue) {
        if (_desktop != null) {
            BusyWin.setBusy(false);
            return (String)JOptionPane.showInternalInputDialog(_desktop, msg, "Input", 3, null, null, initialValue);
        }
        return JOptionPane.showInputDialog(parentComponent, msg, initialValue);
    }

    public static String input(Component parentComponent, String msg) {
        if (_desktop != null) {
            BusyWin.setBusy(false);
            return JOptionPane.showInternalInputDialog(_desktop, msg, "Input", 3);
        }
        return JOptionPane.showInputDialog(parentComponent, msg, "Input", 3);
    }

    public static String input(String msg) {
        return DialogUtil.input(null, msg);
    }

    public static Object input(Component parentComponent, String msg, Object[] choices, Object initialValue) {
        if (_desktop != null) {
            BusyWin.setBusy(false);
            return JOptionPane.showInternalInputDialog(_desktop, msg, "Input", 3, null, choices, initialValue);
        }
        return JOptionPane.showInputDialog(parentComponent, msg, "Input", 3, null, choices, initialValue);
    }

    public static int confirm(Component parentComponent, String msg) {
        if (_desktop != null) {
            BusyWin.setBusy(false);
            return JOptionPane.showInternalConfirmDialog(_desktop, msg);
        }
        return JOptionPane.showConfirmDialog(parentComponent, msg);
    }

    public static int confirm(String msg) {
        return DialogUtil.confirm(null, msg);
    }
}

