/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

public class StringUtil {
    public static String replace(String source, String target, String replacement) {
        StringBuffer sbuf = new StringBuffer(source);
        int n = source.length();
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            if (!source.startsWith(target, i)) continue;
            int tl = target.length();
            int rl = replacement.length();
            sbuf.replace(i + offset, i + offset + tl, replacement);
            offset += rl - tl;
            i += tl - 1;
        }
        return sbuf.toString();
    }

    public static String[] split(String s, int sep) {
        int i = s.indexOf(sep);
        if (i > 0) {
            String[] ar = new String[]{s.substring(0, i), s.substring(i + 1)};
            return ar;
        }
        return null;
    }

    public static String combine(String[] ar, String sep) {
        if (ar == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ar.length; ++i) {
            sb.append(ar[i]);
            if (i + 1 >= ar.length) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean match(String pattern, String string) {
        int sLen = string.length();
        int pLen = pattern.length();
        int p = 0;
        while (true) {
            int s = 0;
            while (true) {
                boolean pEnd;
                boolean sEnd = s >= sLen;
                boolean bl = pEnd = p >= pLen || pattern.charAt(p) == '|';
                if (sEnd && !pEnd && pattern.charAt(p) == '*' && (p == pLen - 1 || p < pLen - 1 && pattern.charAt(p + 1) == '|')) {
                    return true;
                }
                if (sEnd && pEnd) {
                    return true;
                }
                if (sEnd || pEnd) break;
                if (pattern.charAt(p) != '?') {
                    if (pattern.charAt(p) == '*' || pattern.charAt(p) == '%') {
                        ++p;
                        for (int i = sLen; i >= s; --i) {
                            if (!StringUtil.match(pattern.substring(p), string.substring(i))) continue;
                            return true;
                        }
                        break;
                    }
                    if (Character.toUpperCase(pattern.charAt(p)) != Character.toUpperCase(string.charAt(s))) break;
                }
                ++p;
                ++s;
            }
            if ((p = pattern.indexOf(124, p)) == -1) {
                return false;
            }
            ++p;
        }
    }

    public static String pad(String s, int length, boolean leftJustify) {
        StringBuffer sb = new StringBuffer(length);
        if (leftJustify) {
            sb.append(s);
            int n = s.length();
            while (n++ < length) {
                sb.append(' ');
            }
        } else {
            int n = s.length();
            while (n++ < length) {
                sb.append(' ');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static boolean arrayContains(String[] ar, String s) {
        for (int j = 0; j < ar.length; ++j) {
            if (!s.equals(ar[j])) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println("");
        System.out.println("test StringUtil.replace");
        String source = "replace $this with $that and $this with $that";
        String s = StringUtil.replace(source, "$this", "X");
        System.out.println("s (1) = " + s);
        s = StringUtil.replace(s, "$that", "Y");
        System.out.println("s (2) = " + s);
        System.out.println("");
        System.out.println("test StringUtil.split");
        String[] ar = StringUtil.split("test|passed", 124);
        if (ar == null) {
            System.out.println("test failed");
        } else {
            System.out.println(ar[0] + " " + ar[1]);
        }
        s = StringUtil.combine(ar, ",");
        if (!s.equals("test,passed")) {
            System.out.println("test failed");
        }
        System.out.println("");
        System.out.println("test StringUtil.match");
        System.out.println("match s* str = " + StringUtil.match("s*", "str"));
        System.out.println("! match *s str = " + !StringUtil.match("*s", "str"));
        System.out.println("match *s xxs = " + StringUtil.match("*s", "xxs"));
        System.out.println("match *s* xxsxx = " + StringUtil.match("*s*", "xxsxx"));
        System.out.println("! match *s* xxpxx = " + !StringUtil.match("*s*", "xxpxx"));
        System.out.println("match *s* s = " + StringUtil.match("*s*", "s"));
        System.out.println("match s* s = " + StringUtil.match("s*", "s"));
        System.out.println("match *s s = " + StringUtil.match("*s", "s"));
        System.out.println("match *s S = " + StringUtil.match("*s", "s"));
        System.out.println("match s*|p* s = " + StringUtil.match("s*|p*", "s"));
        System.out.println("match s*|p* p = " + StringUtil.match("s*|p*", "p"));
        System.out.println("! match s*|p* x = " + !StringUtil.match("s*|p*", "x"));
        System.out.println("match *s|*p s = " + StringUtil.match("*s|*p", "s"));
        System.out.println("match *s|*p p = " + StringUtil.match("*s|*p", "p"));
        System.out.println("! match *s|*p x = " + !StringUtil.match("*s|*p", "x"));
        System.out.println("match *s*|*p* s = " + StringUtil.match("*s*|*p*", "s"));
        System.out.println("match *s*|*p* p = " + StringUtil.match("*s*|*p*", "p"));
        System.out.println("! match *s*|*p* x = " + !StringUtil.match("*s*|*p*", "x"));
        System.out.println("match x*| xyz = " + StringUtil.match("x*|", "xyz"));
        System.out.println("match x*| XYZ = " + StringUtil.match("x*|", "xyz"));
        System.out.println("! match | xyz = " + !StringUtil.match("|", "xyz"));
        System.out.println("match * ppp = " + StringUtil.match("*", "ppp"));
        System.out.println("match ab? abc = " + StringUtil.match("ab?", "abc"));
        System.out.println("match ?b? abc = " + StringUtil.match("?b?", "abc"));
        System.out.println("match ?b? ABC = " + StringUtil.match("?b?", "abc"));
    }
}

