/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.util.Properties;
import jsky.util.Preferences;

public class ProxyServerUtil {
    private static final String PROXY_HOST = "http.proxyHost";
    private static final String PROXY_PORT = "http.proxyPort";
    private static final String NON_PROXY_HOSTS = "http.nonProxyHosts";

    public static void init() {
        String nonProxyHosts;
        String port;
        String savedHost = Preferences.get(PROXY_HOST);
        String savedPort = Preferences.get(PROXY_PORT);
        String savedNonProxyHosts = Preferences.get(NON_PROXY_HOSTS);
        String hostOption = System.getProperty(PROXY_HOST);
        String portOption = System.getProperty(PROXY_PORT);
        String nonProxyHostsOption = System.getProperty(NON_PROXY_HOSTS);
        String host = hostOption;
        if (host == null) {
            host = savedHost;
        }
        if (host != null && host != hostOption && host.length() != 0) {
            System.setProperty(PROXY_HOST, host);
        }
        if ((port = portOption) == null) {
            port = savedPort;
        }
        if (port != null && port != portOption) {
            System.setProperty(PROXY_PORT, port);
        }
        if ((nonProxyHosts = nonProxyHostsOption) == null) {
            nonProxyHosts = savedNonProxyHosts;
        }
        if (nonProxyHosts != null && nonProxyHosts != nonProxyHostsOption && nonProxyHosts.length() != 0) {
            System.setProperty(NON_PROXY_HOSTS, nonProxyHosts);
        }
    }

    public static void setProxy(String host, int port, String nonProxyHosts) {
        String portStr = String.valueOf(port);
        Preferences.set(PROXY_HOST, host);
        Preferences.set(PROXY_PORT, portStr);
        Preferences.set(NON_PROXY_HOSTS, nonProxyHosts);
        System.setProperty(PROXY_HOST, host);
        System.setProperty(PROXY_PORT, portStr);
        System.setProperty(NON_PROXY_HOSTS, nonProxyHosts);
    }

    public static void clearProxySettings() {
        Preferences.unset(PROXY_HOST);
        Preferences.unset(PROXY_PORT);
        Preferences.unset(NON_PROXY_HOSTS);
        Properties props = System.getProperties();
        props.remove(PROXY_HOST);
        props.remove(PROXY_PORT);
        props.remove(NON_PROXY_HOSTS);
    }

    public static String getHost() {
        return System.getProperty(PROXY_HOST);
    }

    public static int getPort() {
        String s = System.getProperty(PROXY_PORT);
        if (s == null) {
            return 80;
        }
        return Integer.parseInt(s);
    }

    public static String getNonProxyHosts() {
        return System.getProperty(NON_PROXY_HOSTS);
    }
}

