/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.util.Arrays;
import java.util.Iterator;

public abstract class ListenerHandler {
    Object[] fListeners = null;

    public abstract void fireEvent(String var1, Object var2, Object var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Object listener) {
        ListenerHandler listenerHandler = this;
        synchronized (listenerHandler) {
            Object[] els = null;
            if (this.fListeners != null) {
                for (int i = 0; i < this.fListeners.length; ++i) {
                    if (this.fListeners[i] != listener) continue;
                    return;
                }
                int length = this.fListeners.length;
                els = new Object[length + 1];
                System.arraycopy(this.fListeners, 0, els, 0, length);
            } else {
                els = new Object[1];
            }
            els[els.length - 1] = listener;
            this.fListeners = els;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Object listener) {
        if (this.fListeners == null) {
            return;
        }
        ListenerHandler listenerHandler = this;
        synchronized (listenerHandler) {
            int length = this.fListeners.length;
            for (int i = 0; i < this.fListeners.length; ++i) {
                if (this.fListeners[i] != listener) continue;
                --length;
            }
            if (length == 0) {
                this.fListeners = null;
                return;
            }
            Object[] els = new Object[length];
            int nexti = 0;
            for (int i = 0; i < this.fListeners.length; ++i) {
                if (this.fListeners[i] == listener) continue;
                els[nexti++] = this.fListeners[i];
            }
            this.fListeners = els;
        }
    }

    public void sendEvent(Object evt) {
        this.sendEvent(null, evt);
    }

    public void sendEvent(String eventKey, Object evt) {
        Object[] localListeners = this.fListeners;
        if (localListeners == null) {
            return;
        }
        for (int i = 0; i < localListeners.length; ++i) {
            Object target = localListeners[i];
            this.fireEvent(eventKey, target, evt);
        }
    }

    public Iterator listeners() {
        return Arrays.asList(this.fListeners).iterator();
    }

    public boolean contains(Object o) {
        if (this.fListeners == null || this.fListeners.length == 0) {
            return false;
        }
        Object[] localListeners = this.fListeners;
        for (int i = 0; i < localListeners.length; ++i) {
            if (!localListeners[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        if (this.fListeners == null) {
            return 0;
        }
        return this.fListeners.length;
    }
}

