/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.awt.Component;
import javax.swing.JOptionPane;
import jsky.science.Passband;
import jsky.science.Quantity;
import jsky.science.Wavelength;
import jsky.util.FormatUtilities;

public class WavelengthNotInPassbandException
extends Exception {
    Passband pBand;
    Wavelength pWL;
    private static String TITLE = "Wavelength Not In Passband Range";
    private static JOptionPane optionPane = null;

    public WavelengthNotInPassbandException(Passband passband, Wavelength wavelength) {
        super("WavelengthNotInPassbandException");
        this.pBand = passband;
        this.pWL = wavelength;
    }

    @Override
    public String getMessage() {
        return "Target wavelength (" + this.pWL.toString() + ") is not in the\ngrating's band pass (" + this.pBand.toString() + "). \n\nPlease enter a new wavelength";
    }

    public void showErrorMessageDialog(Component component) {
        if (optionPane == null) {
            optionPane = new JOptionPane(this.getMessage(), 0, 2);
            optionPane.setWantsInput(true);
        }
        boolean bl = true;
        Object object = FormatUtilities.formatDouble(this.pWL.getValue(), 2);
        double d = this.pBand.getLowWavelength().getValue();
        double d2 = this.pBand.getHighWavelength().getValue();
        while (bl) {
            optionPane.setMessage(this.getMessage());
            optionPane.setInputValue(null);
            optionPane.setInitialSelectionValue(null);
            optionPane.createDialog(component, TITLE);
            object = optionPane.getInputValue();
            if (object == null) {
                if (0 != JOptionPane.showConfirmDialog(component, "This will leave the wavelength at " + FormatUtilities.formatDouble(this.pWL.getValue(), 2) + " " + Quantity.getDefaultUnitsAbbrev(Wavelength.class) + "\nIs this what you want?")) continue;
                return;
            }
            try {
                double d3 = Double.NaN;
                if (object instanceof String) {
                    d3 = new Double((String)object);
                } else if (object instanceof Number) {
                    d3 = ((Number)object).doubleValue();
                }
                if (!(d <= d3) || !(d3 <= d2)) continue;
                this.pWL = new Wavelength(d3, this.pWL.getDefaultUnits());
                bl = false;
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public Wavelength getWavelength() {
        return this.pWL;
    }
}

