/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.io.InputStream;
import jsky.science.Flux;
import jsky.science.Quantity;
import jsky.science.Wavelength;
import jsky.science.Wavelength1DArray;
import jsky.science.Wavelength1DArrayParser;
import jsky.science.WavelengthArrayParseException;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Fits;

public class WavelengthArrayParserFitsHst
implements Wavelength1DArrayParser {
    String fWlColName;
    String fWlUnits;
    String fFluxColName;
    String fFluxUnits;
    Wavelength1DArray fArray;
    InputStream fStream;
    static /* synthetic */ Class class$jsky$science$Wavelength;

    public WavelengthArrayParserFitsHst(Wavelength1DArray array, InputStream istream) throws WavelengthArrayParseException {
        this(array, istream, null);
    }

    public WavelengthArrayParserFitsHst(Wavelength1DArray array, InputStream istream, String[] optionalArgs) throws WavelengthArrayParseException {
        this.fArray = array;
        this.fStream = istream;
        this.fWlColName = "WAVELENGTH";
        this.fWlUnits = Wavelength.ANGSTROM;
        this.fFluxColName = "FLUX";
        this.fFluxUnits = Flux.FLAM;
        if (optionalArgs != null) {
            if (optionalArgs.length > 0 && optionalArgs[0] != null) {
                this.fWlColName = optionalArgs[0];
            }
            if (optionalArgs.length > 1 && optionalArgs[1] != null) {
                this.fFluxColName = optionalArgs[1];
            }
            if (optionalArgs.length > 2 && optionalArgs[2] != null) {
                this.fWlUnits = optionalArgs[2];
            }
            if (optionalArgs.length > 3 && optionalArgs[3] != null) {
                this.fFluxUnits = optionalArgs[3];
            }
        }
    }

    private boolean matchesPluralOrNot(String want, String have) {
        if (want.equalsIgnoreCase(have)) {
            return true;
        }
        if (want.endsWith("s")) {
            want = want.substring(0, want.length() - 1);
        }
        if (have.endsWith("s")) {
            have = have.substring(0, have.length() - 1);
        }
        return want.equalsIgnoreCase(have);
    }

    public void parse() throws WavelengthArrayParseException {
        try {
            Fits f = new Fits(this.fStream);
            BasicHDU hdu = f.readHDU();
            while (hdu != null) {
                if (hdu instanceof BinaryTableHDU) {
                    BinaryTableHDU bdu = (BinaryTableHDU)hdu;
                    BinaryTable data = (BinaryTable)bdu.getData();
                    int wlCol = bdu.findColumn(this.fWlColName);
                    if (wlCol < 0) {
                        for (int i = 0; i < bdu.getNCols(); ++i) {
                            if (!this.matchesPluralOrNot(bdu.getColumnName(i), this.fWlColName)) continue;
                            wlCol = i;
                        }
                    }
                    if (wlCol >= 0) {
                        this.fWlUnits = bdu.getHeader().getStringValue("TUNIT" + (wlCol + 1));
                        this.fWlUnits = Quantity.getUnitsIgnoreCase(class$jsky$science$Wavelength == null ? WavelengthArrayParserFitsHst.class$("jsky.science.Wavelength") : class$jsky$science$Wavelength, this.fWlUnits);
                        int flCol = bdu.findColumn(this.fFluxColName);
                        if (flCol < 0) {
                            for (int i = 0; i < bdu.getNCols(); ++i) {
                                if (!this.matchesPluralOrNot(bdu.getColumnName(i), this.fFluxColName)) continue;
                                flCol = i;
                            }
                        }
                        if (flCol >= 0) {
                            String localFluxUnits = bdu.getHeader().getStringValue("TUNIT" + (flCol + 1));
                            this.fArray.setNumPoints(data.getNRows());
                            for (int i = 0; i < this.fArray.getNumPoints(); ++i) {
                                Object rawWl = data.getElement(i, wlCol);
                                float foo = ((float[])rawWl)[0];
                                this.fArray.setWavelengthAtIndex(i, new Wavelength((double)((float[])rawWl)[0], this.fWlUnits));
                                Object rawData = data.getElement(i, flCol);
                                float foo2 = ((float[])rawData)[0];
                                this.fArray.setValueAtIndex(i, ((float[])rawData)[0]);
                            }
                            return;
                        }
                    }
                }
                hdu = f.readHDU();
            }
            throw new WavelengthArrayParseException("No binary table found with requested columns and units");
        }
        catch (Exception e) {
            if (e instanceof WavelengthArrayParseException) {
                throw (WavelengthArrayParseException)e;
            }
            throw new WavelengthArrayParseException("Embedded parse exception: " + e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

