/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import jsky.science.AbstractWavelength1D;
import jsky.science.Wavelength;

public abstract class Wavelength1DFormula
extends AbstractWavelength1D {
    public static final String NUMPOINTS_PROPERTY = "NumPoints";
    public static final String MINWAVELENGTH_PROPERTY = "MinWavelength";
    public static final String MAXWAVELENGTH_PROPERTY = "MaxWavelength";
    protected Wavelength fMinWavelength;
    protected Wavelength fMaxWavelength;
    protected int fNumPoints;
    private static final long serialVersionUID = 1L;

    public Wavelength1DFormula() {
        this(null, new Wavelength(100.0, Wavelength.NANOMETER), new Wavelength(1100.0, Wavelength.NANOMETER), 100);
    }

    public Wavelength1DFormula(int n) {
        this(null, new Wavelength(100.0, Wavelength.NANOMETER), new Wavelength(1100.0, Wavelength.NANOMETER), n);
    }

    public Wavelength1DFormula(String string) {
        this(string, new Wavelength(100.0, Wavelength.NANOMETER), new Wavelength(1100.0, Wavelength.NANOMETER), 100);
    }

    public Wavelength1DFormula(Wavelength wavelength, Wavelength wavelength2, int n) {
        this(null, wavelength, wavelength2, n);
    }

    public Wavelength1DFormula(String string, Wavelength wavelength, Wavelength wavelength2, int n) {
        super(string);
        this.fMinWavelength = wavelength;
        this.fMaxWavelength = wavelength2;
        this.fNumPoints = n;
    }

    @Override
    public Object clone() {
        Wavelength1DFormula wavelength1DFormula = (Wavelength1DFormula)super.clone();
        wavelength1DFormula.setMinWavelength((Wavelength)this.getMinWavelength().clone());
        wavelength1DFormula.setMaxWavelength((Wavelength)this.getMaxWavelength().clone());
        return wavelength1DFormula;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        try {
            Wavelength1DFormula wavelength1DFormula = (Wavelength1DFormula)object;
            if (!this.getClass().equals(wavelength1DFormula.getClass())) {
                return false;
            }
            if (this.fNumPoints != wavelength1DFormula.fNumPoints) {
                return false;
            }
            if (this.fMinWavelength == null ? wavelength1DFormula.fMinWavelength != null : !this.fMinWavelength.equals(wavelength1DFormula.fMinWavelength)) {
                return false;
            }
            return !(this.fMaxWavelength == null ? wavelength1DFormula.fMaxWavelength != null : !this.fMaxWavelength.equals(wavelength1DFormula.fMaxWavelength));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Wavelength getMinWavelength() {
        return this.fMinWavelength;
    }

    public Wavelength getMaxWavelength() {
        return this.fMaxWavelength;
    }

    public void setMinWavelength(Wavelength wavelength) {
        if (this.fMinWavelength != null) {
            this.fMinWavelength.removePropertyChangeListener(this);
        }
        Wavelength wavelength2 = this.fMinWavelength;
        this.fMinWavelength = wavelength;
        if (this.fMinWavelength != null) {
            this.fMinWavelength.addPropertyChangeListener(this);
        }
        this.firePropertyChange(MINWAVELENGTH_PROPERTY, wavelength2, wavelength);
    }

    public void setMaxWavelength(Wavelength wavelength) {
        if (this.fMaxWavelength != null) {
            this.fMaxWavelength.removePropertyChangeListener(this);
        }
        Wavelength wavelength2 = this.fMaxWavelength;
        this.fMaxWavelength = wavelength;
        if (this.fMaxWavelength != null) {
            this.fMaxWavelength.addPropertyChangeListener(this);
        }
        this.firePropertyChange(MAXWAVELENGTH_PROPERTY, wavelength2, wavelength);
    }

    @Override
    public void setPending(boolean bl) {
        super.setPending(bl);
    }

    @Override
    public double[] toArrayData() {
        double[] dArray = new double[this.fNumPoints];
        double d = this.fMinWavelength.getValue();
        double d2 = (this.fMaxWavelength.getValue() - d) / (double)this.fNumPoints;
        for (int i = 0; i < this.fNumPoints; ++i) {
            dArray[i] = this.getValue(new Wavelength(d));
            d += d2;
        }
        return dArray;
    }

    @Override
    public double[] toArrayWavelengths() {
        double[] dArray = new double[this.fNumPoints];
        double d = this.fMinWavelength.getValue();
        double d2 = (this.fMaxWavelength.getValue() - d) / (double)this.fNumPoints;
        for (int i = 0; i < this.fNumPoints; ++i) {
            dArray[i] = d;
            d += d2;
        }
        return dArray;
    }

    public Wavelength getWavelengthAtIndex(int n) {
        return new Wavelength(this.getWavelengthAtIndexAsDouble(n));
    }

    public double getWavelengthAtIndexAsDouble(int n) {
        double d = (this.fMaxWavelength.getValue() - this.fMinWavelength.getValue()) / (double)this.fNumPoints;
        return this.fMinWavelength.getValue() + (double)n * d;
    }

    public void setNumPoints(int n) {
        int n2 = this.fNumPoints;
        this.fNumPoints = n;
        this.firePropertyChange(NUMPOINTS_PROPERTY, new Integer(n2), new Integer(n));
    }

    @Override
    public int getNumPoints() {
        return this.fNumPoints;
    }
}

