/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import jsky.science.AbstractWavelength1D;
import jsky.science.Passband;
import jsky.science.Quantity;
import jsky.science.Wavelength;
import jsky.science.Wavelength1DModel;
import jsky.science.WavelengthArrayParseException;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Fits;

public class Wavelength1DArray
extends AbstractWavelength1D {
    private double[] fWavelengths;
    private double[] fData;
    private int fNumPoints;
    private static String fWavelengthUnits;
    public static final String NUMPOINTS_PROPERTY = "NumPoints";
    public static final String DATA_PROPERTY = "Data";
    private static final long serialVersionUID = 1L;
    private static double[] NaN;
    private static int NaNSize;

    public Wavelength1DArray() {
        this(null, new Wavelength(100.0, Wavelength.NANOMETER), new Wavelength(1100.0, Wavelength.NANOMETER), 100);
    }

    public Wavelength1DArray(int n) {
        this(null, new Wavelength(100.0, Wavelength.NANOMETER), new Wavelength(1100.0, Wavelength.NANOMETER), n);
    }

    public Wavelength1DArray(String string) {
        this(string, new Wavelength(100.0, Wavelength.NANOMETER), new Wavelength(1100.0, Wavelength.NANOMETER), 100);
    }

    public Wavelength1DArray(Wavelength wavelength, Wavelength wavelength2, int n) {
        this(null, wavelength, wavelength2, n);
    }

    public Wavelength1DArray(double[] dArray, double[] dArray2) {
        this.fWavelengths = dArray;
        this.fData = dArray2;
        this.fNumPoints = dArray.length;
        fWavelengthUnits = Wavelength.NANOMETER;
    }

    public Wavelength1DArray(Wavelength1DModel wavelength1DModel) {
        super(wavelength1DModel.getName());
        fWavelengthUnits = Quantity.getDefaultUnits(Wavelength.class);
        double[] dArray = wavelength1DModel.toArrayData(null, null, 0);
        double[] dArray2 = wavelength1DModel.toArrayWavelengths(null, null, 0);
        this.fNumPoints = dArray2.length;
        this.fData = new double[this.fNumPoints];
        System.arraycopy(dArray, 0, this.fData, 0, this.fNumPoints);
        this.fWavelengths = new double[this.fNumPoints];
        System.arraycopy(dArray2, 0, this.fWavelengths, 0, this.fNumPoints);
    }

    public Wavelength1DArray(String string, Wavelength wavelength, Wavelength wavelength2, int n) {
        this(string, wavelength == null ? Double.NaN : wavelength.getValue(), wavelength2 == null ? Double.NaN : wavelength2.getValue(), n);
    }

    protected Wavelength1DArray(String string, double d, double d2, int n) {
        super(string);
        fWavelengthUnits = Quantity.getDefaultUnits(Wavelength.class);
        this.fNumPoints = Math.max(1, n);
        this.fWavelengths = new double[this.fNumPoints];
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            double d3 = (d2 - d) / (double)this.fNumPoints;
            this.fWavelengths[0] = d;
            if (this.fNumPoints > 1) {
                this.fWavelengths[this.fNumPoints - 1] = d2;
            }
            for (int i = 1; i < this.fNumPoints - 1; ++i) {
                this.fWavelengths[i] = this.fWavelengths[i - 1] + d3;
            }
        }
        this.fData = new double[this.fNumPoints];
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Wavelength1DArray wavelength1DArray = (Wavelength1DArray)object;
        if (this.fNumPoints != wavelength1DArray.fNumPoints) {
            return false;
        }
        if (this.fData == null && wavelength1DArray.fData == null && this.fWavelengths == null && wavelength1DArray.fWavelengths == null) {
            return true;
        }
        if (this.fWavelengths == null && wavelength1DArray.fWavelengths != null) {
            return false;
        }
        if (this.fWavelengths != null && wavelength1DArray.fWavelengths == null) {
            return false;
        }
        if (this.fData == null && wavelength1DArray.fData != null) {
            return false;
        }
        if (this.fData != null && wavelength1DArray.fData == null) {
            return false;
        }
        for (int i = 0; i < this.fNumPoints; ++i) {
            if (this.fWavelengths[i] != wavelength1DArray.fWavelengths[i]) {
                return false;
            }
            if (this.fData[i] == wavelength1DArray.fData[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Wavelength getMin() {
        return new Wavelength(this.fWavelengths[0]);
    }

    @Override
    public Wavelength getMax() {
        return new Wavelength(this.fWavelengths[this.fWavelengths.length - 1]);
    }

    @Override
    public void setPending(boolean bl) {
        super.setPending(bl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(Wavelength.DEFAULTUNITS_PROPERTY)) {
            for (int i = 0; i < this.fNumPoints; ++i) {
                this.setWavelengthAtIndex(i, this.getWavelengthAtIndex(i));
            }
            fWavelengthUnits = (String)propertyChangeEvent.getNewValue();
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    public void setWavelengthAtIndex(int n, Wavelength wavelength) {
        this.setWavelengthAtIndex(n, wavelength.getValue());
    }

    public void setWavelengthAtIndex(int n, double d) {
        this.fWavelengths[n] = d;
        this.firePropertyChange(DATA_PROPERTY, null, null);
    }

    public void setWavelengthArray(double[] dArray) {
        this.fNumPoints = dArray.length;
        this.fWavelengths = new double[this.fNumPoints];
        System.arraycopy(dArray, 0, this.fWavelengths, 0, this.fNumPoints);
        this.fData = new double[this.fNumPoints];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyData(Wavelength1DArray wavelength1DArray) {
        Wavelength1DArray wavelength1DArray2 = this;
        synchronized (wavelength1DArray2) {
            this.fNumPoints = wavelength1DArray.fWavelengths.length;
            this.fWavelengths = new double[this.fNumPoints];
            System.arraycopy(wavelength1DArray.fWavelengths, 0, this.fWavelengths, 0, this.fNumPoints);
            this.fData = new double[this.fNumPoints];
            System.arraycopy(wavelength1DArray.fData, 0, this.fData, 0, this.fNumPoints);
        }
    }

    @Override
    public double[] toArrayWavelengths() {
        return this.fWavelengths;
    }

    @Override
    public double[] toArrayWavelengths(Wavelength wavelength, Wavelength wavelength2, int n) {
        return this.toArrayWavelengths(wavelength == null ? Double.NaN : wavelength.getValue(), wavelength2 == null ? Double.NaN : wavelength2.getValue(), n);
    }

    protected double[] toArrayWavelengths(double d, double d2, int n) {
        double[] dArray;
        int n2;
        if (d == this.fWavelengths[0] && d2 == this.fWavelengths[this.fNumPoints - 1] && n == this.fNumPoints) {
            return this.fWavelengths;
        }
        int n3 = Double.isNaN(d) ? 0 : this.getIndexOf(d);
        int n4 = n2 = Double.isNaN(d2) ? this.fNumPoints - 1 : this.getIndexOf(d2);
        if (!(n != n2 - n3 + 1 && n != 0 || n2 < 0 || n3 < 0 || this.fWavelengths[n2] != d2 && !Double.isNaN(d2) || this.fWavelengths[n3] != d && !Double.isNaN(d))) {
            n = n2 - n3 + 1;
            dArray = new double[n];
            System.arraycopy(this.fWavelengths, n3, dArray, 0, n);
        } else {
            if (n == 0) {
                n = this.fNumPoints;
            }
            dArray = new double[n];
            double d3 = (d2 - d) / (double)(n - 1);
            for (int i = 0; i < n; ++i) {
                dArray[i] = d;
                d += d3;
            }
        }
        return dArray;
    }

    @Override
    public double[] toArrayData(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = this.getValue(dArray[i]);
        }
        return dArray2;
    }

    @Override
    public double[] toArrayData() {
        return this.fData;
    }

    @Override
    public double[] toArrayData(Wavelength wavelength, Wavelength wavelength2, int n) {
        this.dumpData();
        return this.toArrayData(wavelength == null ? Double.NaN : wavelength.getValue(), wavelength2 == null ? Double.NaN : wavelength2.getValue(), n);
    }

    protected double[] toArrayData(double d, double d2, int n) {
        if (d == this.fWavelengths[0] && d2 == this.fWavelengths[this.fNumPoints - 1] && n == this.fNumPoints) {
            return this.fData;
        }
        return this.toArrayData(this.toArrayWavelengths(d, d2, n));
    }

    public void replaceDataSet(Wavelength1DArray wavelength1DArray) {
        double[] dArray = this.fData;
        if (wavelength1DArray != null) {
            this.fNumPoints = wavelength1DArray.getNumPoints();
            this.fWavelengths = wavelength1DArray.fWavelengths;
            this.fData = wavelength1DArray.fData;
        } else {
            this.fNumPoints = 0;
            this.fWavelengths = null;
            this.fData = null;
        }
        this.setException(null);
        this.firePropertyChange(DATA_PROPERTY, dArray, this.fData);
    }

    public Wavelength getWavelengthAtIndex(int n) {
        return this.fWavelengths == null || n >= this.fNumPoints || n < 0 ? null : new Wavelength(this.fWavelengths[n], fWavelengthUnits);
    }

    public double getWavelengthAtIndexAsDouble(int n) {
        return this.fWavelengths == null || n >= this.fNumPoints || n < 0 ? Double.NaN : this.fWavelengths[n];
    }

    public int getIndexOf(double d) {
        return this.getIndexOf(d, this.fWavelengths);
    }

    public int getIndexOf(Wavelength wavelength) {
        return this.getIndexOf(wavelength, this.fWavelengths);
    }

    @Override
    public void setValue(Wavelength wavelength, double d) {
        int n = this.getIndexOf(wavelength, this.fWavelengths, true);
        if (n < 0) {
            this.insert(this.getIndexOf(wavelength, this.fWavelengths, false), wavelength, d);
        } else {
            this.setValueAtIndex(n, d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(int n, Wavelength wavelength, double d) {
        if (n == -1) {
            // empty if block
        }
        double[] dArray = new double[this.fData.length + 1];
        double[] dArray2 = new double[this.fWavelengths.length + 1];
        Wavelength1DArray wavelength1DArray = this;
        synchronized (wavelength1DArray) {
            if (n > 0 && n < this.fData.length) {
                System.arraycopy(this.fData, 0, dArray, 0, n);
                System.arraycopy(this.fData, n, dArray, n + 1, this.fData.length - n);
                System.arraycopy(this.fWavelengths, 0, dArray2, 0, n);
                System.arraycopy(this.fWavelengths, n, dArray2, n + 1, this.fData.length - n);
            } else {
                System.arraycopy(this.fData, 0, dArray, 0, this.fData.length);
                System.arraycopy(this.fWavelengths, 0, dArray2, 0, this.fData.length);
            }
            this.fData = dArray;
            this.fWavelengths = dArray2;
            this.fNumPoints = this.fData.length;
            this.fData[n] = d;
            this.fWavelengths[n] = wavelength.getValue();
        }
        this.firePropertyChange(DATA_PROPERTY, null, null);
    }

    public void simpleSetValue(int n, double d) {
        this.fData[n] = d;
    }

    public void setValueAtIndex(int n, double d) {
        this.fData[n] = d;
        this.firePropertyChange(DATA_PROPERTY, null, null);
    }

    public double getValueAtIndex(int n) {
        return this.fData == null || n >= this.fNumPoints || n < 0 ? 0.0 : this.fData[n];
    }

    @Override
    public Object clone() {
        Wavelength1DArray wavelength1DArray = (Wavelength1DArray)super.clone();
        if (wavelength1DArray.fWavelengths != null) {
            wavelength1DArray.fWavelengths = new double[this.fNumPoints];
            System.arraycopy(this.fWavelengths, 0, wavelength1DArray.fWavelengths, 0, this.fNumPoints);
        }
        if (wavelength1DArray.fData != null) {
            wavelength1DArray.fData = new double[this.fNumPoints];
            System.arraycopy(this.fData, 0, wavelength1DArray.fData, 0, this.fNumPoints);
        }
        return wavelength1DArray;
    }

    @Override
    public double getValue(Wavelength wavelength) {
        if (wavelength == null) {
            return Double.NaN;
        }
        return this.getValue(wavelength.getValue(fWavelengthUnits));
    }

    protected synchronized double getValue(double d) {
        if (this.fWavelengths.length != this.fData.length) {
            System.out.println("[Wavelength1DArray.getValue] WARNING: unequal lengths: " + this.fWavelengths.length + "/" + this.fData.length);
        }
        if (this.fWavelengths.length == 0 || Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d < this.fWavelengths[0] || this.fWavelengths[this.fWavelengths.length - 1] < d) {
            return 0.0;
        }
        int n = 0;
        int n2 = this.fWavelengths.length - 1;
        double d2 = this.fWavelengths[n];
        double d3 = this.fWavelengths[n2];
        while (n2 - n >= 1) {
            if (d == d2) {
                return this.fData[n];
            }
            if (d == d3) {
                return this.fData[n2];
            }
            if (n2 - n == 1) {
                return this.fData[n] + (this.fData[n2] - this.fData[n]) * (d - d2) / (d3 - d2);
            }
            int n3 = n + (n2 - n) / 2;
            double d4 = this.fWavelengths[n3];
            if (d >= d4) {
                n = n3;
                d2 = d4;
                continue;
            }
            n2 = n3;
            d3 = d4;
        }
        return this.fData[n];
    }

    public void setAllNaN(boolean bl) {
        int n;
        if (NaN == null) {
            NaN = new double[NaNSize];
            for (n = 0; n < NaNSize; ++n) {
                Wavelength1DArray.NaN[n] = Double.NaN;
            }
        }
        for (n = 0; n < this.fNumPoints; n += NaNSize) {
            int n2 = Math.min(NaNSize, this.fNumPoints - n);
            if (!bl && this.fWavelengths != null) {
                System.arraycopy(NaN, 0, this.fWavelengths, n, n2);
            }
            if (this.fData == null) continue;
            System.arraycopy(NaN, 0, this.fData, n, n2);
        }
        this.firePropertyChange(DATA_PROPERTY, null, null);
    }

    public void setAllNaN() {
        this.setAllNaN(false);
    }

    public void add(Wavelength1DModel wavelength1DModel) {
        double[] dArray = wavelength1DModel.toArrayData(this.fWavelengths);
        for (int i = 0; i < this.fNumPoints; ++i) {
            this.setValueAtIndex(i, this.fData[i] + dArray[i]);
        }
    }

    public void combineData(Wavelength1DModel wavelength1DModel, int n) {
        double[] dArray = wavelength1DModel.toArrayWavelengths(null, null, 0);
        double[] dArray2 = wavelength1DModel.toArrayData(null, null, 0);
        int n2 = dArray.length;
        if (n <= 1) {
            this.fData = new double[n2];
            this.fWavelengths = new double[n2];
            this.setNumPoints(dArray.length, 0, false);
            System.arraycopy(dArray2, 0, this.fData, 0, n2);
            System.arraycopy(dArray, 0, this.fWavelengths, 0, n2);
        } else {
            int n3 = n2 / n;
            this.fWavelengths = new double[n3];
            this.fData = new double[n3];
            for (int i = 0; i < n3; ++i) {
                this.fWavelengths[i] = dArray[i * n];
                double d = 0.0;
                for (int j = 0; j < n; ++j) {
                    if (i * n + j >= n2) continue;
                    d += dArray2[i * n + j];
                }
                this.fData[i] = d;
            }
            this.fNumPoints = n3;
        }
    }

    public void alignData(Wavelength1DModel wavelength1DModel) {
        double[] dArray = wavelength1DModel.toArrayWavelengths(null, null, 0);
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.getValue(new Wavelength(dArray[i]));
        }
        this.fData = dArray2;
        this.fWavelengths = dArray;
        this.fNumPoints = n;
    }

    public void trim() {
        int n;
        if (this.fNumPoints == 0) {
            return;
        }
        int n2 = this.fNumPoints - 1;
        if (this.fData[n] == 0.0) {
            for (n = 0; n < this.fNumPoints && this.fData[n] == 0.0; ++n) {
            }
            --n;
        }
        if (this.fData[n2] == 0.0) {
            while (n2 > 0 && this.fData[n2] == 0.0) {
                --n2;
            }
            ++n2;
        }
        if (n == 0 && n2 == this.fNumPoints) {
            return;
        }
        int n3 = n2 - n + 1;
        if (n3 < 0) {
            if (this.fNumPoints >= 2) {
                this.fWavelengths[1] = this.fWavelengths[this.fNumPoints - 1];
                this.setNumPoints(2, 0, true);
            }
        } else {
            this.setNumPoints(n3, n, true);
        }
    }

    private void setNumPoints(int n, int n2, boolean bl) {
        if (n != this.fNumPoints) {
            int n3 = this.fNumPoints;
            double[] dArray = this.fWavelengths;
            double[] dArray2 = this.fData;
            this.fNumPoints = n;
            this.fWavelengths = new double[n];
            this.fData = new double[n];
            if (bl) {
                int n4 = Math.min(n3 - n2, n);
                System.arraycopy(dArray, n2, this.fWavelengths, 0, n4);
                System.arraycopy(dArray2, n2, this.fData, 0, n4);
            }
        }
    }

    public void setNumPoints(int n) {
        int n2 = this.fNumPoints;
        this.setNumPoints(n, 0, true);
        this.firePropertyChange(NUMPOINTS_PROPERTY, new Integer(n2), new Integer(n));
    }

    @Override
    public int getNumPoints() {
        return this.fNumPoints;
    }

    public void multiply(double d) {
        int n = 0;
        while (n < this.fNumPoints) {
            int n2 = n++;
            this.fData[n2] = this.fData[n2] * d;
        }
    }

    public void parse(InputStream inputStream) throws WavelengthArrayParseException {
        this.parse(inputStream, null);
    }

    public void parse(Reader reader) throws WavelengthArrayParseException {
        this.parseAscii(reader, null);
    }

    public void parse(InputStream inputStream, String string) throws WavelengthArrayParseException {
        try {
            Fits fits = new Fits(inputStream);
            BasicHDU basicHDU = fits.readHDU();
            try {
                while (basicHDU != null) {
                    basicHDU = fits.readHDU();
                    if (!(basicHDU instanceof BinaryTableHDU)) continue;
                    BinaryTableHDU binaryTableHDU = (BinaryTableHDU)basicHDU;
                    BinaryTable binaryTable = (BinaryTable)binaryTableHDU.getData();
                    int n = binaryTableHDU.findColumn("WAVELENGTH");
                    string = binaryTableHDU.getHeader().getStringValue("TUNIT" + (n + 1));
                    string = Quantity.getUnitsIgnoreCase(Wavelength.class, string);
                    int n2 = binaryTableHDU.findColumn("FLUX");
                    String string2 = binaryTableHDU.getHeader().getStringValue("TUNIT" + (n2 + 1));
                    if (!string2.equalsIgnoreCase("FLAM")) {
                        throw new WavelengthArrayParseException("Flux units must be in FLAM");
                    }
                    this.setNumPoints(binaryTable.getNRows(), 0, false);
                    for (int i = 0; i < this.fNumPoints; ++i) {
                        Object object = binaryTable.getElement(i, n);
                        this.setWavelengthAtIndex(i, new Wavelength((double)((float[])object)[0], string));
                        Object object2 = binaryTable.getElement(i, n2);
                        this.setValueAtIndex(i, ((float[])object2)[0]);
                    }
                }
            }
            catch (Exception exception) {
                throw new WavelengthArrayParseException("Exception encounter parsing FITS file, " + exception.toString());
            }
        }
        catch (Exception exception) {
            this.parseAscii(new InputStreamReader(inputStream), string);
        }
    }

    private void parseAscii(Reader reader, String string) throws WavelengthArrayParseException {
        if (string == null) {
            string = Wavelength.ANGSTROM;
        }
        int n = 500;
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        streamTokenizer.commentChar(35);
        int n2 = 0;
        boolean bl = false;
        try {
            int n3 = streamTokenizer.nextToken();
            while (n3 != -1) {
                if (streamTokenizer.ttype == -3) {
                    if (!streamTokenizer.sval.startsWith("E") && !streamTokenizer.sval.startsWith("e")) {
                        throw new WavelengthArrayParseException(streamTokenizer.sval + ", encountered after " + n2 + " valid pairs.");
                    }
                    try {
                        int n4 = new Integer(streamTokenizer.sval.substring(1));
                        if (bl) {
                            this.setWavelengthAtIndex(n2, this.getWavelengthAtIndexAsDouble(n2) * Math.pow(10.0, n4));
                        }
                        this.setValueAtIndex(n2 - 1, this.getValueAtIndex(n2 - 1) * Math.pow(10.0, n4));
                    }
                    catch (Exception exception) {
                        throw new WavelengthArrayParseException(streamTokenizer.sval + ", encountered after " + n2 + " valid pairs.");
                    }
                } else {
                    if (streamTokenizer.ttype != -2) {
                        throw new WavelengthArrayParseException(streamTokenizer.ttype + ", encountered after " + n2 + " valid pairs.");
                    }
                    if (n2 >= this.getNumPoints()) {
                        this.setNumPoints(this.getNumPoints() + n);
                    }
                    if (bl) {
                        this.setValueAtIndex(n2++, streamTokenizer.nval);
                    } else {
                        this.setWavelengthAtIndex(n2, new Wavelength(streamTokenizer.nval, string));
                    }
                    bl = !bl;
                }
                n3 = streamTokenizer.nextToken();
            }
        }
        catch (IOException iOException) {
            throw new WavelengthArrayParseException(iOException.toString());
        }
        if (n2 < this.getNumPoints()) {
            this.setNumPoints(n2);
        }
    }

    @Override
    public Passband getPassband() {
        Passband passband = new Passband();
        if (this.fNumPoints == 0) {
            return passband;
        }
        int n = 0;
        while (this.fData[n] == 0.0) {
            if (++n < this.fData.length) continue;
            return passband;
        }
        double d = this.fWavelengths[n];
        double d2 = this.fWavelengths[n];
        while (this.fData[n] != 0.0) {
            d2 = this.fWavelengths[n];
            if (++n < this.fData.length) continue;
        }
        passband.setLowWavelength(new Wavelength(d, fWavelengthUnits));
        passband.setHighWavelength(new Wavelength(d2, fWavelengthUnits));
        return passband;
    }

    public Wavelength getWavelengthAtMaxValue() {
        int n = -1;
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.fData.length; ++i) {
            if (!(this.fData[i] > d)) continue;
            d = this.fData[i];
            n = i;
        }
        if (n > -1) {
            return new Wavelength(this.fWavelengths[n]);
        }
        return null;
    }

    public void dumpData() {
        for (int i = 0; i < this.fWavelengths.length; ++i) {
            System.out.println("[" + i + "] " + this.fWavelengths[i] + ": " + this.fData[i]);
        }
    }

    static {
        NaN = null;
        NaNSize = 1000;
    }
}

