/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import jsky.science.Quantity;
import jsky.science.Unit;
import jsky.science.UnitsNotSupportedException;

public class Wavelength
extends Quantity {
    public static final String DEFAULTUNITS_PROPERTY = "defaultWavelengthUnit".intern();
    static final double E_ANGSTROM = Math.pow(10.0, -10.0);
    static final double E_NANOMETER = Math.pow(10.0, -9.0);
    static final double E_MICRON = Math.pow(10.0, -6.0);
    static final double E_MILLIMETER = Math.pow(10.0, -3.0);
    static final double E_CENTIMETER = Math.pow(10.0, -2.0);
    static final double E_METER = 1.0;
    static final double E_KILOMETER = Math.pow(10.0, 3.0);
    static final double E_HERTZ = Math.pow(10.0, 0.0) / 2.99792458E8;
    static final double E_KILOHERTZ = Math.pow(10.0, 3.0) / 2.99792458E8;
    static final double E_MEGAHERTZ = Math.pow(10.0, 6.0) / 2.99792458E8;
    static final double E_GIGAHERTZ = Math.pow(10.0, 9.0) / 2.99792458E8;
    static final double E_EV = 1.23984282E-6;
    static final double E_KILOEV = Math.pow(10.0, 3.0) * 1.23984282E-6;
    static final double E_MEGAEV = Math.pow(10.0, 6.0) * 1.23984282E-6;
    public static final String ANGSTROM = "angstroms".intern();
    public static final String NANOMETER = "nanometers".intern();
    public static final String MICRON = "microns".intern();
    public static final String MILLIMETER = "millimeters".intern();
    public static final String CENTIMETER = "centimeters".intern();
    public static final String METER = "meters".intern();
    public static final String KILOMETER = "kilometers".intern();
    public static final String HERTZ = "hertz".intern();
    public static final String KILOHERTZ = "kilohertz".intern();
    public static final String MEGAHERTZ = "megahertz".intern();
    public static final String GIGAHERTZ = "gigahertz".intern();
    public static final String EV = "electron-volts".intern();
    public static final String KILOEV = "kiloelectron-volts".intern();
    public static final String MEGAEV = "megaelectron-volts".intern();
    public static final String ANGSTROMABBREV = "\u00c5".intern();
    public static final String NANOMETERABBREV = "nm".intern();
    public static final String MICRONABBREV = "\u00b5m".intern();
    public static final String MILLIMETERABBREV = "mm".intern();
    public static final String CENTIMETERABBREV = "cm".intern();
    public static final String METERABBREV = "m".intern();
    public static final String KILOMETERABBREV = "km".intern();
    public static final String HERTZABBREV = "Hz".intern();
    public static final String KILOHERTZABBREV = "KHz".intern();
    public static final String MEGAHERTZABBREV = "MHz".intern();
    public static final String GIGAHERTZABBREV = "GHz".intern();
    public static final String EVABBREV = "eV".intern();
    public static final String KILOEVABBREV = "KeV".intern();
    public static final String MEGAEVABBREV = "MeV".intern();
    public static final Unit UNIT_ANGSTROM = new Unit(E_ANGSTROM, ANGSTROM, ANGSTROMABBREV, "&Aring;");
    private static final Unit UNIT_NANOMETER = new Unit(E_NANOMETER, NANOMETER, NANOMETERABBREV);
    private static final Unit UNIT_MICRON = new Unit(E_MICRON, MICRON, MICRONABBREV, "&mu;m", 5);
    private static final Unit UNIT_MILLLIMETER = new Unit(E_MILLIMETER, MILLIMETER, MILLIMETERABBREV);
    private static final Unit UNIT_CENTIMETER = new Unit(E_CENTIMETER, CENTIMETER, CENTIMETERABBREV);
    private static final Unit UNIT_METER = new Unit(1.0, METER, METERABBREV);
    private static final Unit UNIT_KILOMETER = new Unit(E_KILOMETER, KILOMETER, KILOMETERABBREV);
    private static final Unit UNIT_HERTZ = new Unit(E_HERTZ, HERTZ, HERTZABBREV);
    private static final Unit UNIT_KILOHERTZ = new Unit(E_KILOHERTZ, KILOHERTZ, KILOHERTZABBREV);
    private static final Unit UNIT_MEGAHERTZ = new Unit(E_MEGAHERTZ, MEGAHERTZ, MEGAHERTZABBREV);
    private static final Unit UNIT_GIGAHERTZ = new Unit(E_GIGAHERTZ, GIGAHERTZ, GIGAHERTZABBREV);
    private static final Unit UNIT_EV = new Unit(1.23984282E-6, EV, EVABBREV);
    private static final Unit UNIT_KILOEV = new Unit(E_KILOEV, KILOEV, KILOEVABBREV);
    private static final Unit UNIT_MEGAEV = new Unit(E_MEGAEV, MEGAEV, MEGAEVABBREV);
    public static final Wavelength MAX_VALUE;
    public static final Wavelength MIN_VALUE;
    private static final long serialVersionUID = 1L;

    public Wavelength() {
        this(0.0);
    }

    public Wavelength(double d) {
        this(d, (Unit)null);
    }

    public Wavelength(double d, String string) {
        if (string == null) {
            string = this.getDefaultUnits();
        }
        this.setValue(d, string);
    }

    public Wavelength(double d, Unit unit) {
        if (unit == null) {
            unit = this.getDefaultUnitObject();
        }
        this.setValue(d, unit);
    }

    @Override
    public Quantity newInstance(double d) {
        return new Wavelength(d);
    }

    @Override
    public double getValue(String string) {
        try {
            return Wavelength.convert(Wavelength.class, this.fValue, METER, string);
        }
        catch (UnitsNotSupportedException unitsNotSupportedException) {
            this.writeError(this, unitsNotSupportedException.toString());
            return Double.NaN;
        }
    }

    @Override
    public double getValue(Unit unit) {
        return Wavelength.convert(this.fValue, UNIT_METER, unit);
    }

    @Override
    protected void setValue(double d, String string) {
        try {
            this.fValue = Wavelength.convert(Wavelength.class, d, string, METER);
        }
        catch (UnitsNotSupportedException unitsNotSupportedException) {
            this.writeError(this, unitsNotSupportedException.toString());
            this.fValue = Double.NaN;
        }
    }

    protected void setValue(double d, Unit unit) {
        this.fValue = Wavelength.convert(d, unit, UNIT_METER);
    }

    public static void addDefaultUnitsChangeListener(PropertyChangeListener propertyChangeListener) {
        Quantity.addDefaultUnitsChangeListener(Wavelength.class, propertyChangeListener);
    }

    public static void removeDefaultUnitsChangeListener(PropertyChangeListener propertyChangeListener) {
        Quantity.removeDefaultUnitsChangeListener(Wavelength.class, propertyChangeListener);
    }

    static {
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        arrayList.add(UNIT_ANGSTROM);
        arrayList.add(UNIT_NANOMETER);
        arrayList.add(UNIT_MICRON);
        arrayList.add(UNIT_MILLLIMETER);
        arrayList.add(UNIT_CENTIMETER);
        arrayList.add(UNIT_METER);
        arrayList.add(UNIT_KILOMETER);
        arrayList.add(UNIT_HERTZ);
        arrayList.add(UNIT_KILOHERTZ);
        arrayList.add(UNIT_MEGAHERTZ);
        arrayList.add(UNIT_GIGAHERTZ);
        arrayList.add(UNIT_EV);
        arrayList.add(UNIT_KILOEV);
        arrayList.add(UNIT_MEGAEV);
        Quantity.initializeSubClass(Wavelength.class, arrayList, ANGSTROM, DEFAULTUNITS_PROPERTY);
        MAX_VALUE = new Wavelength(Double.MAX_VALUE, ANGSTROM);
        MIN_VALUE = new Wavelength(0.0, ANGSTROM);
    }
}

