/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import jsky.science.Quantity;
import jsky.science.Unit;
import jsky.science.UnitsNotSupportedException;

public class Time
extends Quantity {
    private static final long serialVersionUID = 3592097662233611662L;
    public static final String DEFAULTUNITS_PROPERTY = "defaultTimeUnit".intern();
    public static final String SECOND = "seconds".intern();
    public static final String MINUTE = "minutes".intern();
    public static final String HOUR = "hours".intern();
    public static final String DAY = "days".intern();
    public static final String SECONDABBREV = "sec".intern();
    public static final String MINUTEABBREV = "min".intern();
    public static final String HOURABBREV = "hr".intern();
    public static final String DAYABBREV = "day".intern();
    public static final Unit UNIT_SECOND = new Unit(1.0, SECOND, SECONDABBREV);
    public static final Unit UNIT_MINUTE = new Unit(60.0, MINUTE, MINUTEABBREV);
    public static final Unit UNIT_HOUR = new Unit(3600.0, HOUR, HOURABBREV);
    public static final Unit UNIT_DAY = new Unit(86400.0, DAY, DAYABBREV);

    public Time() {
        this(0.0);
    }

    public Time(double d) {
        this(d, Quantity.getDefaultUnits(Time.class));
    }

    public Time(double d, String string) {
        this.setValue(d, string);
    }

    @Override
    public Quantity newInstance(double d) {
        return new Time(d);
    }

    @Override
    public double getValue(String string) {
        try {
            return Time.convert(Time.class, this.fValue, SECOND, string);
        }
        catch (UnitsNotSupportedException unitsNotSupportedException) {
            this.writeError(this, unitsNotSupportedException.toString());
            return Double.NaN;
        }
    }

    @Override
    public double getValue(Unit unit) {
        return Time.convert(this.fValue, UNIT_SECOND, unit);
    }

    @Override
    protected void setValue(double d, String string) {
        try {
            this.fValue = Time.convert(Time.class, d, string, SECOND);
        }
        catch (UnitsNotSupportedException unitsNotSupportedException) {
            this.writeError(this, unitsNotSupportedException.toString());
            this.fValue = Double.NaN;
        }
    }

    public static void addDefaultUnitsChangeListener(PropertyChangeListener propertyChangeListener) {
        Quantity.addDefaultUnitsChangeListener(Time.class, propertyChangeListener);
    }

    public static void removeDefaultUnitsChangeListener(PropertyChangeListener propertyChangeListener) {
        Quantity.removeDefaultUnitsChangeListener(Time.class, propertyChangeListener);
    }

    public static String getDefaultUnitsAbbrev() {
        return Quantity.getDefaultUnitsAbbrev(Time.class);
    }

    public static String getUnitsAbbrev(String string) {
        return Quantity.getUnitsAbbrev(Time.class, string);
    }

    static {
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        arrayList.add(UNIT_SECOND);
        arrayList.add(UNIT_MINUTE);
        arrayList.add(UNIT_HOUR);
        arrayList.add(UNIT_DAY);
        Quantity.initializeSubClass(Time.class, arrayList, SECOND, DEFAULTUNITS_PROPERTY);
    }
}

