/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import jsky.science.Quantity;
import jsky.science.Unit;
import jsky.science.UnitsNotSupportedException;
import jsky.util.FormatUtilities;

public class Redshift
extends Quantity {
    private static final long serialVersionUID = 662600968082910788L;
    public static final String DEFAULTUNITS_PROPERTY = "defaultRedshiftUnit".intern();
    public static final String Z = "Z".intern();
    public static final String RADIALVELOCITY = "RadialVelocity".intern();
    public static final String ZABBREV = "z".intern();
    public static final String RADIALVELOCITYABBREV = "km/s".intern();
    public static final Unit UNIT_Z = new Unit(0.0, Z, ZABBREV);
    public static final Unit UNIT_RADIAL_VELOCITY = new Unit(0.0, RADIALVELOCITY, RADIALVELOCITYABBREV);

    public Redshift() {
        this(0.0);
    }

    public Redshift(double d) {
        this(d, Quantity.getDefaultUnits(Redshift.class));
    }

    @Override
    public Quantity newInstance(double d) {
        return new Redshift(d);
    }

    public Redshift(double d, String string) {
        this.setValue(d, string);
    }

    @Override
    public double getValue(String string) {
        try {
            return Redshift.convert(this.fValue, Z, string);
        }
        catch (UnitsNotSupportedException unitsNotSupportedException) {
            this.writeError(this, unitsNotSupportedException.toString());
            return Double.NaN;
        }
    }

    @Override
    public double getValue(Unit unit) {
        try {
            return Redshift.convert(this.fValue, Z, unit.getLongName());
        }
        catch (UnitsNotSupportedException unitsNotSupportedException) {
            this.writeError(this, unitsNotSupportedException.toString());
            return Double.NaN;
        }
    }

    @Override
    protected void setValue(double d, String string) {
        try {
            this.fValue = Redshift.convert(d, string, Z);
        }
        catch (UnitsNotSupportedException unitsNotSupportedException) {
            this.writeError(this, unitsNotSupportedException.toString());
            this.fValue = Double.NaN;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double convert(double d, String string, String string2) throws UnitsNotSupportedException {
        double d2 = Double.NaN;
        if (string.equalsIgnoreCase(Z)) {
            if (string2.equalsIgnoreCase(Z)) {
                return d;
            }
            if (!string2.equalsIgnoreCase(RADIALVELOCITY)) throw new UnitsNotSupportedException(string2);
            double d3 = Math.pow(d + 1.0, 2.0);
            double d4 = 2.99792458E8 * (d3 - 1.0) / (d3 + 1.0);
            return d4 / 1000.0;
        }
        if (string2.equalsIgnoreCase(Z)) {
            if (string.equalsIgnoreCase(Z)) {
                return d;
            }
            if (!string.equalsIgnoreCase(RADIALVELOCITY)) throw new UnitsNotSupportedException(string);
            double d5 = d * 1000.0 / 2.99792458E8;
            return Math.pow((1.0 + d5) / (1.0 - d5), 0.5) - 1.0;
        }
        double d6 = Redshift.convert(d, string, Z);
        return Redshift.convert(d6, Z, string2);
    }

    public static void addDefaultUnitsChangeListener(PropertyChangeListener propertyChangeListener) {
        Quantity.addDefaultUnitsChangeListener(Redshift.class, propertyChangeListener);
    }

    public static void removeDefaultUnitsChangeListener(PropertyChangeListener propertyChangeListener) {
        Quantity.removeDefaultUnitsChangeListener(Redshift.class, propertyChangeListener);
    }

    public static String getDefaultUnitsAbbrev() {
        return Quantity.getDefaultUnitsAbbrev(Redshift.class);
    }

    @Override
    public String toString(int n) {
        return FormatUtilities.formatDouble(this.getValue(), n);
    }

    @Override
    public String toString() {
        return this.toString(2);
    }

    static {
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        arrayList.add(UNIT_Z);
        arrayList.add(UNIT_RADIAL_VELOCITY);
        Quantity.initializeSubClass(Redshift.class, arrayList, Z, DEFAULTUNITS_PROPERTY);
    }
}

