/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jsky.science.AbstractScienceObjectNode;
import jsky.science.Unit;
import jsky.science.UnitsNotSupportedException;
import jsky.util.FormatUtilities;

public abstract class Quantity
extends AbstractScienceObjectNode {
    protected double fValue;
    private static Map sListeners = new HashMap();
    private static Map sUnits = new HashMap();
    private static Map sDefaults = new HashMap();
    private static Map sUnitsProperties = new HashMap();
    private static final long serialVersionUID = 1L;

    public abstract double getValue(String var1);

    public abstract double getValue(Unit var1);

    public abstract Quantity newInstance(double var1);

    protected abstract void setValue(double var1, String var3);

    public static void initializeSubClass(Class clazz, List list, String string, String string2) {
        if (sUnits.get(clazz) != null) {
            sUnits.remove(clazz);
            sDefaults.remove(clazz);
            sListeners.remove(clazz);
            sUnitsProperties.remove(clazz);
        }
        sUnits.put(clazz, list);
        sDefaults.put(clazz, string);
        sListeners.put(clazz, new HashSet(10));
        sUnitsProperties.put(clazz, string2);
    }

    public static boolean isInitialized(Class clazz) {
        return sUnits.get(clazz) != null;
    }

    public static String getDefaultUnitsAbbrev(Class clazz) {
        String string = Quantity.getDefaultUnits(clazz);
        return Quantity.getUnitsAbbrev(clazz, string);
    }

    public static String getUnitsAbbrev(Class clazz, String string) {
        if (string == null) {
            return null;
        }
        List list = (List)sUnits.get(clazz);
        for (int i = 0; i < list.size(); ++i) {
            Unit unit = (Unit)list.get(i);
            if (!string.equals(unit.getLongName())) continue;
            return unit.getAbbreviation();
        }
        return null;
    }

    public static String getDefaultUnits(Class clazz) {
        return (String)sDefaults.get(clazz);
    }

    public static String getDefaultUnitsProperty(Class clazz) {
        return (String)sUnitsProperties.get(clazz);
    }

    public static void setDefaultUnits(Class clazz, String string) {
        String string2 = (String)sDefaults.get(clazz);
        if (string2 == null || !string2.equals(string)) {
            sDefaults.remove(clazz);
            sDefaults.put(clazz, string);
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(clazz.toString(), (String)sUnitsProperties.get(clazz), string2, string);
            Quantity.fireDefaultUnitsChange(clazz, propertyChangeEvent);
        }
    }

    public double getValue() {
        return this.getValue(this.getDefaultUnits());
    }

    public String getDefaultUnits() {
        return (String)sDefaults.get(this.getClass());
    }

    public Unit getDefaultUnitObject() {
        String string = (String)sDefaults.get(this.getClass());
        return Quantity.getUnit(this.getClass(), string);
    }

    @Override
    public String toString() {
        return this.toString(this.getDefaultUnitObject(), 2, false);
    }

    public String toString(Unit unit) {
        return this.toString(unit, 2, false);
    }

    public String toString(int n) {
        return this.toString(this.getDefaultUnitObject(), n, false);
    }

    public String toString(Unit unit, int n) {
        return this.toString(unit, n, false);
    }

    public String toString(Unit unit, int n, boolean bl) {
        String string = unit.getAbbreviation();
        if (bl) {
            string = unit.getHtmlRepresentation();
        }
        return FormatUtilities.formatDouble(this.getValue(unit), n) + " " + string;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Quantity)) {
            return false;
        }
        return this.fValue == ((Quantity)object).fValue;
    }

    public int hashCode() {
        return (int)this.fValue;
    }

    public static List getAllUnits(Class clazz) {
        return (List)sUnits.get(clazz);
    }

    public List getAllUnits() {
        return (List)sUnits.get(this.getClass());
    }

    public static List getAllUnitsAbbrev(Class clazz) {
        List list = (List)sUnits.get(clazz);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Unit unit = (Unit)list.get(i);
            arrayList.add(unit.getAbbreviation());
        }
        return arrayList;
    }

    public List getAllUnitsAbbrev() {
        return Quantity.getAllUnitsAbbrev(this.getClass());
    }

    public static String getUnitsIgnoreCase(Class clazz, String string) {
        List list = (List)sUnits.get(clazz);
        for (Unit unit : list) {
            String string2 = unit.getLongName();
            if (!string.equalsIgnoreCase(string2)) continue;
            return string2;
        }
        return null;
    }

    public static void addDefaultUnitsChangeListener(Class clazz, PropertyChangeListener propertyChangeListener) {
        Collection collection = (Collection)sListeners.get(clazz);
        if (!collection.contains(propertyChangeListener)) {
            collection.add(propertyChangeListener);
        }
    }

    public static void removeDefaultUnitsChangeListener(Class clazz, PropertyChangeListener propertyChangeListener) {
        Collection collection = (Collection)sListeners.get(clazz);
        if (collection.contains(propertyChangeListener)) {
            collection.remove(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireDefaultUnitsChange(Class clazz, PropertyChangeEvent propertyChangeEvent) {
        Collection collection;
        Map map = sListeners;
        synchronized (map) {
            collection = (Collection)sListeners.get(clazz);
        }
        for (PropertyChangeListener propertyChangeListener : collection) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    protected void fireDefaultUnitsChange(PropertyChangeEvent propertyChangeEvent) {
        Quantity.fireDefaultUnitsChange(this.getClass(), propertyChangeEvent);
    }

    public static Unit getUnit(Class clazz, String string) {
        List list = (List)sUnits.get(clazz);
        for (Unit unit : list) {
            String string2 = unit.getLongName();
            if (!string.equalsIgnoreCase(string2)) continue;
            return unit;
        }
        return null;
    }

    public static double convert(double d, Unit unit, Unit unit2) {
        double d2 = Double.NaN;
        if (unit2 == null || unit == null) {
            System.out.println("[Quantity.convert] invalid call to convert with null units.");
        }
        d2 = d / unit2.getScaleFactor() * unit.getScaleFactor();
        return d2;
    }

    public static double convert(Class clazz, double d, String string, String string2) throws UnitsNotSupportedException {
        Unit unit = Quantity.getUnit(clazz, string2);
        if (unit == null) {
            throw new UnitsNotSupportedException(string2);
        }
        Unit unit2 = Quantity.getUnit(clazz, string);
        if (unit2 == null) {
            throw new UnitsNotSupportedException(string);
        }
        return Quantity.convert(d, unit2, unit);
    }
}

