/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jsky.science.AbstractScienceObject;
import jsky.science.Wavelength;
import jsky.util.FormatUtilities;

public class Passband
extends AbstractScienceObject {
    private static final long serialVersionUID = 7848426480608091945L;
    private Wavelength pLow;
    private Wavelength pHigh;
    private Wavelength pMiddle;
    public static final String LOW_PROPERTY = "Low";
    public static final String MIDDLE_PROPERTY = "Middle";
    public static final String HIGH_PROPERTY = "High";
    private static Map sStandardPassbands = new HashMap();

    public Passband() {
        this("H-Alpha");
    }

    public Passband(Wavelength wavelength, Wavelength wavelength2) {
        this(FormatUtilities.formatDouble(wavelength.getValue(), 0) + "-" + FormatUtilities.formatDouble(wavelength2.getValue(), 0), wavelength, wavelength2, new Wavelength(wavelength.getValue() + (wavelength2.getValue() - wavelength.getValue()) / 2.0));
    }

    public Passband(Wavelength wavelength, Wavelength wavelength2, Wavelength wavelength3) {
        this(FormatUtilities.formatDouble(wavelength.getValue(Wavelength.NANOMETER), 0) + "-" + FormatUtilities.formatDouble(wavelength2.getValue(Wavelength.NANOMETER), 0) + " (" + FormatUtilities.formatDouble(wavelength3.getValue(Wavelength.NANOMETER), 0) + ")", wavelength, wavelength2, wavelength3);
    }

    public Passband(String string, Wavelength wavelength, Wavelength wavelength2, Wavelength wavelength3) {
        super(string);
        this.pLow = wavelength;
        this.pHigh = wavelength2;
        this.pMiddle = wavelength3;
    }

    public Passband(String string) throws NumberFormatException {
        super(string);
        Passband passband = (Passband)sStandardPassbands.get(string);
        if (passband != null) {
            this.pLow = passband.getLowWavelength();
            this.pMiddle = passband.getMiddleWavelength();
            this.pHigh = passband.getHighWavelength();
        } else {
            double d;
            double d2;
            double d3;
            String string2;
            String string3;
            String string4 = string;
            int n = string4.indexOf(45);
            if (n >= 0 && n > 0) {
                string3 = string4.substring(0, n).trim();
                string2 = string4.substring(n + 1).trim();
                if (string3.endsWith("e") || string3.endsWith("E")) {
                    int n2 = string2.indexOf(45);
                    int n3 = n = n2 >= 0 ? n + n2 + 1 : -1;
                }
            }
            if (n >= 0) {
                string3 = string4.substring(0, n).trim();
                string2 = string4.substring(n + 1).trim();
                if (string3.length() == 0) {
                    string3 = "0";
                }
                if (string2.length() == 0) {
                    string2 = "10000";
                }
                d3 = new Double(string3);
                d2 = new Double(string2);
                d = (d2 - d3) / 2.0;
            } else {
                d = d3 = new Double(string4).doubleValue();
                d2 = d3;
            }
            this.pLow = new Wavelength(d3);
            this.pMiddle = new Wavelength(d);
            this.pHigh = new Wavelength(d2);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        Passband passband = (Passband)object;
        if (this.pLow == null ? passband.pLow != null : !this.pLow.equals(passband.pLow)) {
            return false;
        }
        if (this.pHigh == null ? passband.pHigh != null : !this.pHigh.equals(passband.pHigh)) {
            return false;
        }
        return !(this.pMiddle == null ? passband.pMiddle != null : !this.pMiddle.equals(passband.pMiddle));
    }

    public static String[] getStdBands() {
        Iterator iterator = sStandardPassbands.keySet().iterator();
        String[] stringArray = new String[sStandardPassbands.size()];
        for (int i = 0; i < sStandardPassbands.size(); ++i) {
            stringArray[i] = (String)iterator.next();
        }
        return stringArray;
    }

    public static String[] getStandardBroadBands() {
        Object object;
        Iterator iterator = sStandardPassbands.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (((String)object).length() != 1) continue;
            ++n;
        }
        object = new String[n];
        iterator = sStandardPassbands.keySet().iterator();
        n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.length() != 1) continue;
            object[n++] = string;
        }
        return object;
    }

    public static void setStdBands(String[] stringArray) {
        sStandardPassbands.clear();
        for (int i = 0; i < stringArray.length; i += 2) {
            Passband passband = new Passband(stringArray[i + 1]);
            passband.setName(stringArray[i]);
            sStandardPassbands.put(stringArray[i], passband);
        }
    }

    public static Passband getStandardPassband(String string) {
        return (Passband)sStandardPassbands.get(string);
    }

    public static Passband findStandardContaining(Wavelength wavelength) {
        for (Passband passband : sStandardPassbands.values()) {
            if (!passband.contains(wavelength)) continue;
            return passband;
        }
        return null;
    }

    public boolean contains(Wavelength wavelength) {
        double d = wavelength.getValue(Wavelength.NANOMETER);
        return this.pLow.getValue(Wavelength.NANOMETER) <= d && this.pHigh.getValue(Wavelength.NANOMETER) >= d;
    }

    public Wavelength getHighWavelength() {
        return this.pHigh;
    }

    public void setHighWavelength(Wavelength wavelength) {
        Wavelength wavelength2 = this.pHigh;
        this.pHigh = wavelength;
        this.firePropertyChange(HIGH_PROPERTY, wavelength2, this.pHigh);
    }

    public Wavelength getLowWavelength() {
        return this.pLow;
    }

    public void setLowWavelength(Wavelength wavelength) {
        Wavelength wavelength2 = this.pLow;
        this.pLow = wavelength;
        this.firePropertyChange(LOW_PROPERTY, wavelength2, this.pLow);
    }

    public Wavelength getMiddleWavelength() {
        return this.pMiddle;
    }

    public void setMiddleWavelength(Wavelength wavelength) {
        Wavelength wavelength2 = this.pMiddle;
        this.pMiddle = wavelength;
        this.firePropertyChange(MIDDLE_PROPERTY, wavelength2, this.pMiddle);
    }

    public String toString() {
        return this.pLow.toString() + " to " + this.pHigh.toString();
    }

    static {
        sStandardPassbands.put("H-Alpha", new Passband("H-Alpha", new Wavelength(645.0, Wavelength.NANOMETER), new Wavelength(670.0, Wavelength.NANOMETER), new Wavelength(658.1, Wavelength.NANOMETER)));
        sStandardPassbands.put("O III", new Passband("O III", new Wavelength(495.0, Wavelength.NANOMETER), new Wavelength(510.0, Wavelength.NANOMETER), new Wavelength(502.5, Wavelength.NANOMETER)));
        sStandardPassbands.put("Ne V", new Passband("Ne V", new Wavelength(338.0, Wavelength.NANOMETER), new Wavelength(350.0, Wavelength.NANOMETER), new Wavelength(343.4, Wavelength.NANOMETER)));
        sStandardPassbands.put("U", new Passband("U", new Wavelength(180.0, Wavelength.NANOMETER), new Wavelength(350.0, Wavelength.NANOMETER), new Wavelength(265.0, Wavelength.NANOMETER)));
        sStandardPassbands.put("B", new Passband("B", new Wavelength(391.0, Wavelength.NANOMETER), new Wavelength(489.0, Wavelength.NANOMETER), new Wavelength(440.0, Wavelength.NANOMETER)));
        sStandardPassbands.put("V", new Passband("V", new Wavelength(450.0, Wavelength.NANOMETER), new Wavelength(750.0, Wavelength.NANOMETER), new Wavelength(600.0, Wavelength.NANOMETER)));
        sStandardPassbands.put("R", new Passband("R", new Wavelength(530.0, Wavelength.NANOMETER), new Wavelength(720.0, Wavelength.NANOMETER), new Wavelength(632.0, Wavelength.NANOMETER)));
        sStandardPassbands.put("I", new Passband("I", new Wavelength(680.0, Wavelength.NANOMETER), new Wavelength(980.0, Wavelength.NANOMETER), new Wavelength(833.0, Wavelength.NANOMETER)));
    }
}

