/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import jsky.science.AbstractScienceObjectNode;
import jsky.science.Wavelength;
import jsky.science.Wavelength1DModel;

public abstract class AbstractWavelength1D
extends AbstractScienceObjectNode
implements Wavelength1DModel {
    public AbstractWavelength1D() {
    }

    public AbstractWavelength1D(String string) {
        super(string);
    }

    @Override
    public double getArea() {
        return this.getArea(this.getMin(), this.getMax());
    }

    @Override
    public double getArea(Wavelength wavelength, Wavelength wavelength2) {
        double[] dArray = this.toArrayWavelengths(wavelength, wavelength2, 0);
        double[] dArray2 = this.toArrayData(wavelength, wavelength2, 0);
        double d = 0.0;
        double d2 = wavelength.getValue();
        double d3 = wavelength2.getValue();
        int n = this.getIndexOf(wavelength, dArray);
        if (n >= 0) {
            d += this.calcArea(d2, dArray[n], this.getValue(wavelength), dArray2[n]);
        } else {
            n = 0;
        }
        int n2 = this.getIndexOf(wavelength2, dArray) - 1;
        if (n2 < 0) {
            n2 = dArray.length - 1;
        } else {
            d += this.calcArea(dArray[n2], d3, dArray2[n2], this.getValue(wavelength2));
        }
        for (int i = n; i < n2; ++i) {
            d += this.calcArea(dArray[i], dArray[i + 1], dArray2[i], dArray2[i + 1]);
        }
        return d;
    }

    protected double calcArea(double d, double d2, double d3, double d4) {
        double d5 = (d2 - d) * (d3 + (d4 - d3) / 2.0);
        return d5;
    }

    public abstract Wavelength getMin();

    public abstract Wavelength getMax();

    protected int getIndexOf(Wavelength wavelength, double[] dArray) {
        return this.getIndexOf(wavelength.getValue(), dArray, false);
    }

    protected int getIndexOf(double d, double[] dArray) {
        return this.getIndexOf(d, dArray, false);
    }

    protected int getIndexOf(Wavelength wavelength, double[] dArray, boolean bl) {
        return this.getIndexOf(wavelength.getValue(), dArray, bl);
    }

    protected int getIndexOf(double d, double[] dArray, boolean bl) {
        if (Double.isNaN(d)) {
            return -1;
        }
        if (dArray.length == 0) {
            return -1;
        }
        if (dArray[dArray.length - 1] < d) {
            if (bl) {
                return -1;
            }
            return dArray.length;
        }
        if (d < dArray[0]) {
            if (bl) {
                return -1;
            }
            return 0;
        }
        int n = 0;
        double d2 = dArray[n];
        if (d == d2) {
            return n;
        }
        int n2 = dArray.length - 1;
        double d3 = dArray[n2];
        if (d == d3) {
            return n2;
        }
        while (n2 - n > 1) {
            if (d == d2) {
                return n;
            }
            if (d == d3) {
                return n2;
            }
            int n3 = n + (n2 - n) / 2;
            double d4 = dArray[n3];
            if (d >= d4) {
                n = n3;
                d2 = d4;
                continue;
            }
            n2 = n3;
            d3 = d4;
        }
        if (d == d2) {
            return n;
        }
        return bl ? -1 : n2;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void setValue(Wavelength wavelength, double d) {
    }

    @Override
    public double[] toArrayData(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = this.getValue(new Wavelength(dArray[i]));
        }
        return dArray2;
    }

    @Override
    public double[] toArrayData() {
        return new double[0];
    }

    @Override
    public double[] toArrayWavelengths() {
        return this.toArrayWavelengths(null, null, this.getNumPoints());
    }
}

