/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jsky.science.AbstractScienceObject;
import jsky.science.ScienceObjectModel;
import jsky.science.ScienceObjectNodeModel;
import jsky.util.ReplacementEvent;
import jsky.util.ReplacementVetoException;

public abstract class AbstractScienceObjectNode
extends AbstractScienceObject
implements ScienceObjectNodeModel {
    private boolean fMoreDataAvailable;
    private ScienceObjectNodeModel fDataSource;
    private List<ScienceObjectModel> fChildren;
    private static final long serialVersionUID = 1L;
    private boolean fHolding = false;
    private boolean fUpdateNeeded = false;
    private boolean fPending = false;
    protected static String cloneIndent = "";

    public AbstractScienceObjectNode() {
        this(null, false);
    }

    public AbstractScienceObjectNode(String string, boolean bl) {
        super(string);
        this.fHolding = bl;
        this.fUpdateNeeded = bl;
        this.fChildren = new ArrayList<ScienceObjectModel>(5);
        this.fMoreDataAvailable = false;
        this.fDataSource = null;
        this.initializeTransients();
    }

    public AbstractScienceObjectNode(boolean bl) {
        this(null, bl);
    }

    public AbstractScienceObjectNode(String string) {
        this(string, false);
    }

    @Override
    public Object clone() {
        AbstractScienceObjectNode abstractScienceObjectNode = (AbstractScienceObjectNode)super.clone();
        abstractScienceObjectNode.clearAllListeners();
        if (this.isTracing()) {
            this.writeDebug(cloneIndent + AbstractScienceObjectNode.getObjectIdString(this) + ".clone", " to " + AbstractScienceObjectNode.getObjectIdString(abstractScienceObjectNode));
            cloneIndent = cloneIndent + "  ";
        }
        abstractScienceObjectNode.fChildren = new ArrayList<ScienceObjectModel>(5);
        for (ScienceObjectModel scienceObjectModel : this.fChildren) {
            ScienceObjectModel scienceObjectModel2 = (ScienceObjectModel)scienceObjectModel.clone();
            abstractScienceObjectNode.addChild(scienceObjectModel2);
        }
        if (this.isTracing()) {
            cloneIndent = cloneIndent.substring(2);
        }
        return abstractScienceObjectNode;
    }

    public int indexOfChild(Object object) {
        for (int i = 0; i < this.fChildren.size(); ++i) {
            ScienceObjectModel scienceObjectModel = this.fChildren.get(i);
            if (scienceObjectModel != object) continue;
            return i;
        }
        return -1;
    }

    public ScienceObjectModel namedClone() {
        AbstractScienceObjectNode abstractScienceObjectNode = (AbstractScienceObjectNode)this.clone();
        abstractScienceObjectNode.setName(this.createDefaultName());
        return abstractScienceObjectNode;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof AbstractScienceObjectNode)) {
            return false;
        }
        AbstractScienceObjectNode abstractScienceObjectNode = (AbstractScienceObjectNode)object;
        if (this.fDataSource == null ? abstractScienceObjectNode.fDataSource != null : !this.fDataSource.equals(abstractScienceObjectNode.fDataSource)) {
            return false;
        }
        return !(this.fChildren == null ? abstractScienceObjectNode.fChildren != null : !this.fChildren.equals(abstractScienceObjectNode.fChildren));
    }

    @Override
    public void replaceObject(ReplacementEvent replacementEvent) throws ReplacementVetoException {
        ScienceObjectNodeModel scienceObjectNodeModel;
        ScienceObjectNodeModel scienceObjectNodeModel2 = (ScienceObjectNodeModel)replacementEvent.getOldValue();
        if (scienceObjectNodeModel2 == (scienceObjectNodeModel = (ScienceObjectNodeModel)replacementEvent.getNewValue())) {
            return;
        }
        if (scienceObjectNodeModel2 == this) {
            this.setHolding(true);
            Iterator<ScienceObjectModel> iterator = this.getChildren().iterator();
            Iterator iterator2 = scienceObjectNodeModel.getChildren().iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                ScienceObjectModel scienceObjectModel = iterator.next();
                scienceObjectModel.removePropertyChangeListener(this);
                scienceObjectModel.replaceObject(new ReplacementEvent(scienceObjectModel, iterator2.next()));
            }
            try {
                this.fireReplaceObject(this, scienceObjectNodeModel);
            }
            catch (ReplacementVetoException replacementVetoException) {
                this.writeError(this, "Unexpected exception: " + replacementVetoException.toString());
            }
        } else {
            for (int i = 0; i < this.fChildren.size(); ++i) {
                if (this.fChildren.get(i) != scienceObjectNodeModel2 || scienceObjectNodeModel == scienceObjectNodeModel2) continue;
                this.fChildren.set(i, scienceObjectNodeModel);
                scienceObjectNodeModel2.removePropertyChangeListener(this);
                scienceObjectNodeModel.addPropertyChangeListener(this);
                scienceObjectNodeModel.setParent(this);
            }
        }
    }

    public void saveAsText(PrintWriter printWriter, int n) {
        String string = AbstractScienceObjectNode.repeat(" ", n);
        printWriter.println(string + this.toString());
    }

    public static String repeat(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void saveAsText(PrintWriter printWriter) {
        this.saveAsText(printWriter, 0);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isMoreDataAvailable() {
        return this.fMoreDataAvailable;
    }

    @Override
    public void setMoreDataAvailable(boolean bl) {
        this.fMoreDataAvailable = bl;
        this.firePropertyChange(MORE_DATA_PROPERTY, new Boolean(true), new Boolean(false));
    }

    @Override
    public void retrieveMoreData(ScienceObjectNodeModel scienceObjectNodeModel) {
        scienceObjectNodeModel.setMoreDataAvailable(false);
    }

    @Override
    public void requestMoreData() {
        if (!this.fMoreDataAvailable) {
            return;
        }
        if (this.fDataSource != null) {
            this.fDataSource.retrieveMoreData(this);
        }
    }

    @Override
    public ScienceObjectNodeModel getDataSource() {
        return this.fDataSource;
    }

    @Override
    public void setDataSource(ScienceObjectNodeModel scienceObjectNodeModel) {
        ScienceObjectNodeModel scienceObjectNodeModel2 = this.fDataSource;
        this.fDataSource = scienceObjectNodeModel;
        this.firePropertyChange(DATA_SOURCE_PROPERTY, scienceObjectNodeModel2, this.fDataSource);
    }

    @Override
    public boolean isHolding() {
        return this.fHolding;
    }

    @Override
    public void setHolding(boolean bl) {
        this.fHolding = bl;
        if (!bl && this.fUpdateNeeded) {
            this.update();
        }
    }

    public void setUpdatesPending(boolean bl) {
        this.fUpdateNeeded = bl;
    }

    protected synchronized void update() {
        if (this.fHolding) {
            this.fUpdateNeeded = true;
        } else {
            this.setPending(true);
            this.processUpdates();
            this.fUpdateNeeded = false;
        }
    }

    protected void processUpdates() {
        this.setPending(false);
    }

    public boolean isUpToDate() {
        if (!this.isHolding()) {
            return true;
        }
        return this.fUpdateNeeded;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isPending() {
        return this.fPending;
    }

    protected void setPending(boolean bl) {
        if (this.fPending == bl) {
            return;
        }
        Boolean bl2 = new Boolean(this.fPending);
        this.fPending = bl;
        this.firePropertyChange(ScienceObjectModel.PENDING_PROPERTY, bl2, new Boolean(this.fPending));
    }

    @Override
    public void setTracing(boolean bl) {
        super.setTracing(bl);
        this.writeDebug(AbstractScienceObjectNode.getObjectIdString(this), "tracing has been turned " + (bl ? "ON" : "OFF"));
    }

    protected void initializeTransients() {
        this.setParent(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransients();
        for (ScienceObjectModel scienceObjectModel : this.fChildren) {
            scienceObjectModel.addPropertyChangeListener(this);
            scienceObjectModel.setParent(this);
        }
    }

    @Override
    public void addChild(ScienceObjectModel scienceObjectModel) {
        scienceObjectModel.addPropertyChangeListener(this);
        scienceObjectModel.setParent(this);
        for (int i = 0; i < this.fChildren.size(); ++i) {
            if (this.fChildren.get(i) != scienceObjectModel) continue;
            return;
        }
        this.fChildren.add(scienceObjectModel);
    }

    @Override
    public ScienceObjectModel removeChild(ScienceObjectModel scienceObjectModel) {
        if (scienceObjectModel != null) {
            for (int i = 0; i < this.fChildren.size(); ++i) {
                if (this.fChildren.get(i) != scienceObjectModel) continue;
                this.fChildren.remove(i++);
                scienceObjectModel.removePropertyChangeListener(this);
                scienceObjectModel.setParent(null);
                return scienceObjectModel;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllChildren() {
        List<ScienceObjectModel> list = this.fChildren;
        synchronized (list) {
            Object[] objectArray = this.fChildren.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                this.removeChild((ScienceObjectModel)objectArray[i]);
            }
        }
    }

    @Override
    public ScienceObjectModel replaceChild(ScienceObjectModel scienceObjectModel, ScienceObjectModel scienceObjectModel2) {
        if (scienceObjectModel2 == null) {
            this.removeChild(scienceObjectModel);
            return scienceObjectModel;
        }
        if (scienceObjectModel != null) {
            for (int i = 0; i < this.fChildren.size(); ++i) {
                if (this.fChildren.get(i) != scienceObjectModel) continue;
                this.fChildren.set(i, scienceObjectModel2);
                scienceObjectModel.removePropertyChangeListener(this);
                scienceObjectModel.setParent(null);
                if (scienceObjectModel2 != null) {
                    scienceObjectModel2.addPropertyChangeListener(this);
                    scienceObjectModel2.setParent(this);
                }
                return scienceObjectModel;
            }
        }
        if (scienceObjectModel2 != null) {
            this.addChild(scienceObjectModel2);
        }
        return null;
    }

    @Override
    public List<ScienceObjectModel> getChildren() {
        return this.fChildren;
    }
}

