/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.HashMap;
import jsky.science.ScienceObjectModel;
import jsky.science.ScienceObjectNodeModel;
import jsky.util.ReplaceablePropertyChangeListener;
import jsky.util.ReplaceablePropertyVetoException;
import jsky.util.ReplacementEvent;
import jsky.util.ReplacementVetoException;

public abstract class AbstractScienceObject
implements ScienceObjectModel,
Cloneable,
Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private String fName;
    private boolean fTracing = false;
    public static final String PARENT_PROPERTY = "Parent";
    private transient ScienceObjectNodeModel fParent;
    private transient ReplaceablePropertyChangeListener[] fListeners;
    private static transient Object[] sTracers = null;
    private static transient HashMap sClassIndices = null;
    private Exception fException;
    private static String debugIndent = "";
    private static boolean showDebug = false;

    public AbstractScienceObject() {
        this(null);
    }

    public AbstractScienceObject(String string) {
        this.setParent(null);
        this.fName = string;
    }

    @Override
    public ScienceObjectNodeModel getParent() {
        return this.fParent;
    }

    @Override
    public void setParent(ScienceObjectNodeModel scienceObjectNodeModel) {
        if (scienceObjectNodeModel != this.fParent) {
            ScienceObjectNodeModel scienceObjectNodeModel2 = this.fParent;
            this.fParent = scienceObjectNodeModel;
            this.firePropertyChange(PARENT_PROPERTY, scienceObjectNodeModel2, this.fParent);
        }
    }

    public boolean isPending() {
        return false;
    }

    @Override
    public Exception getException() {
        return this.fException;
    }

    @Override
    public void setException(Exception exception) {
        this.fException = exception;
    }

    @Override
    public boolean isValid() {
        return this.fException == null;
    }

    @Override
    public boolean isHolding() {
        return false;
    }

    @Override
    public void setHolding(boolean bl) {
    }

    @Override
    public Object clone() {
        AbstractScienceObject abstractScienceObject = null;
        try {
            abstractScienceObject = (AbstractScienceObject)super.clone();
            abstractScienceObject.setName(this.getName());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return abstractScienceObject;
    }

    public int compareTo(Object object) {
        return this.getName().compareTo(((AbstractScienceObject)object).getName());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractScienceObject)) {
            return false;
        }
        AbstractScienceObject abstractScienceObject = (AbstractScienceObject)object;
        return this.areNamesEqual(abstractScienceObject);
    }

    @Override
    public String getName() {
        if (this.fName == null) {
            this.fName = this.createDefaultName();
        }
        return this.fName == null ? "" : this.fName;
    }

    protected boolean areNamesEqual(ScienceObjectModel scienceObjectModel) {
        String string = scienceObjectModel.getName();
        if (this.fName == null && string != null) {
            return false;
        }
        if (this.fName != null && string == null) {
            return false;
        }
        return this.fName == null || string == null || this.fName.equals(string);
    }

    protected String createDefaultName() {
        if (sClassIndices == null) {
            sClassIndices = new HashMap();
        }
        String string = this.getClass().toString();
        Integer n = (Integer)sClassIndices.get(string = string.substring(string.lastIndexOf(".") + 1));
        n = n == null ? new Integer(1) : new Integer(n + 1);
        sClassIndices.put(string, n);
        return string + n;
    }

    @Override
    public void setName(String string) {
        String string2 = this.fName;
        this.fName = string == null ? null : string.intern();
        this.firePropertyChange(NAME_PROPERTY, string2, string);
    }

    @Override
    public String getLabel() {
        return this.toString();
    }

    @Override
    public boolean isTracing() {
        return this.fTracing;
    }

    @Override
    public void setTracing(boolean bl) {
        this.writeDebug(this.getObjectIdString(), "tracing has been turned " + (bl ? "ON" : "OFF"));
        this.fTracing = bl;
    }

    @Override
    public void clearAllListeners() {
        this.fListeners = null;
        sTracers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPropertyChangeListener(ReplaceablePropertyChangeListener replaceablePropertyChangeListener) {
        AbstractScienceObject abstractScienceObject = this;
        synchronized (abstractScienceObject) {
            ReplaceablePropertyChangeListener[] replaceablePropertyChangeListenerArray = null;
            if (this.fListeners != null) {
                int n;
                for (n = 0; n < this.fListeners.length; ++n) {
                    if (this.fListeners[n] != replaceablePropertyChangeListener) continue;
                    return;
                }
                n = this.fListeners.length;
                replaceablePropertyChangeListenerArray = new ReplaceablePropertyChangeListener[n + 1];
                System.arraycopy(this.fListeners, 0, replaceablePropertyChangeListenerArray, 0, n);
            } else {
                replaceablePropertyChangeListenerArray = new ReplaceablePropertyChangeListener[1];
            }
            replaceablePropertyChangeListenerArray[replaceablePropertyChangeListenerArray.length - 1] = replaceablePropertyChangeListener;
            this.fListeners = replaceablePropertyChangeListenerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePropertyChangeListener(ReplaceablePropertyChangeListener replaceablePropertyChangeListener) {
        if (this.fListeners == null) {
            return;
        }
        AbstractScienceObject abstractScienceObject = this;
        synchronized (abstractScienceObject) {
            int n = this.fListeners.length;
            for (int i = 0; i < this.fListeners.length; ++i) {
                if (this.fListeners[i] != replaceablePropertyChangeListener) continue;
                --n;
            }
            if (n == 0) {
                this.fListeners = null;
                return;
            }
            ReplaceablePropertyChangeListener[] replaceablePropertyChangeListenerArray = new ReplaceablePropertyChangeListener[n];
            int n2 = 0;
            for (int i = 0; i < this.fListeners.length; ++i) {
                if (this.fListeners[i] == replaceablePropertyChangeListener) continue;
                replaceablePropertyChangeListenerArray[n2++] = this.fListeners[i];
            }
            this.fListeners = replaceablePropertyChangeListenerArray;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals(NAME_PROPERTY)) {
            this.firePropertyChange(this.getName() + "." + propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    public static void replaceObjectNYI(Object object, ReplacementEvent replacementEvent) {
        System.err.println("[ERROR] " + object + ": Unimplemented replaceObject call, oldv=" + AbstractScienceObject.getObjectIdString(replacementEvent.getOldValue()) + " newv=" + AbstractScienceObject.getObjectIdString(replacementEvent.getNewValue()));
    }

    @Override
    public void replaceObject(ReplacementEvent replacementEvent) throws ReplacementVetoException {
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        this.firePropertyChange(string, object, object2, this.isTracing());
    }

    public void firePropertyChange(String string, Object object, Object object2, boolean bl) {
        if (object != null && object.equals(object2)) {
            return;
        }
        if (object == null && object2 == null) {
            return;
        }
        ReplaceablePropertyChangeListener[] replaceablePropertyChangeListenerArray = this.fListeners;
        if (replaceablePropertyChangeListenerArray == null) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        if (bl) {
            this.writeDebug(debugIndent + AbstractScienceObject.getObjectIdString(this) + ".firepropertyChange", "");
            debugIndent = debugIndent + "  ";
        }
        for (int i = 0; i < replaceablePropertyChangeListenerArray.length; ++i) {
            ReplaceablePropertyChangeListener replaceablePropertyChangeListener = replaceablePropertyChangeListenerArray[i];
            if (bl) {
                this.writeDebug(debugIndent, AbstractScienceObject.getObjectIdString(replaceablePropertyChangeListener));
            }
            try {
                replaceablePropertyChangeListener.propertyChange(propertyChangeEvent);
                continue;
            }
            catch (ReplaceablePropertyVetoException replaceablePropertyVetoException) {
                this.writeError(this, "Unexpected ReplaceablePropertyVetoException returned and ignored, " + replaceablePropertyVetoException.toString());
            }
        }
        if (bl) {
            debugIndent = debugIndent.substring(2);
        }
    }

    public void fireVetoableChange(String string, Object object, Object object2) throws ReplaceablePropertyVetoException {
        this.fireVetoableChange(string, object, object2, this.isTracing());
    }

    public void fireVetoableChange(String string, Object object, Object object2, boolean bl) throws ReplaceablePropertyVetoException {
        AbstractScienceObject abstractScienceObject = this;
        if (object != null && object.equals(object2)) {
            return;
        }
        if (object == null && object2 == null) {
            return;
        }
        ReplaceablePropertyChangeListener[] replaceablePropertyChangeListenerArray = this.fListeners;
        if (replaceablePropertyChangeListenerArray == null) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(abstractScienceObject, string, object, object2);
        for (int i = 0; i < replaceablePropertyChangeListenerArray.length; ++i) {
            ReplaceablePropertyChangeListener replaceablePropertyChangeListener = replaceablePropertyChangeListenerArray[i];
            if (bl) {
                this.writeDebug("    calling", AbstractScienceObject.getObjectIdString(replaceablePropertyChangeListener) + ".propertyChange");
            }
            try {
                replaceablePropertyChangeListener.propertyChange(propertyChangeEvent);
                continue;
            }
            catch (ReplaceablePropertyVetoException replaceablePropertyVetoException) {
                PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(abstractScienceObject, string, object2, object);
                for (int j = i - 1; j >= 0; --j) {
                    ReplaceablePropertyChangeListener replaceablePropertyChangeListener2 = replaceablePropertyChangeListenerArray[j];
                    if (bl) {
                        this.writeDebug("    reversing", AbstractScienceObject.getObjectIdString(replaceablePropertyChangeListener2) + ".propertyChange");
                    }
                    try {
                        replaceablePropertyChangeListener2.propertyChange(propertyChangeEvent2);
                        continue;
                    }
                    catch (ReplaceablePropertyVetoException replaceablePropertyVetoException2) {
                        this.writeError(this, "Unexpected ReplaceablePropertyVetoException returned and ignored, " + replaceablePropertyVetoException2.toString());
                    }
                }
                throw replaceablePropertyVetoException;
            }
        }
    }

    public void fireReplaceObject(Object object, Object object2) throws ReplacementVetoException {
        this.fireReplaceObject(object, object2, this.isTracing());
    }

    public void fireReplaceObject(ReplaceablePropertyChangeListener replaceablePropertyChangeListener) throws ReplacementVetoException {
        this.fireReplaceObject(this, replaceablePropertyChangeListener, this.isTracing());
    }

    public void fireReplaceObject(Object object, Object object2, boolean bl) throws ReplacementVetoException {
        if (object == object2) {
            return;
        }
        if (object == null && object2 == null) {
            return;
        }
        ReplaceablePropertyChangeListener[] replaceablePropertyChangeListenerArray = this.fListeners;
        if (replaceablePropertyChangeListenerArray == null) {
            return;
        }
        Object object3 = null;
        int n = 0;
        try {
            ReplacementEvent replacementEvent = new ReplacementEvent(object, object2);
            for (n = 0; n < replaceablePropertyChangeListenerArray.length; ++n) {
                object3 = replaceablePropertyChangeListenerArray[n];
                if (bl) {
                    this.writeDebug("    calling", AbstractScienceObject.getObjectIdString(object3) + ".replaceObject");
                }
                object3.replaceObject(replacementEvent);
            }
        }
        catch (ReplacementVetoException replacementVetoException) {
            if (object3 != null) {
                this.writeDebug(this, "ReplacementVetoException trapped in replaceObject, from " + object3.toString());
            }
            try {
                ReplacementEvent replacementEvent = new ReplacementEvent(object2, object);
                for (int i = n - 1; i >= 0; --i) {
                    object3 = replaceablePropertyChangeListenerArray[i];
                    object3.replaceObject(replacementEvent);
                }
            }
            catch (ReplacementVetoException replacementVetoException2) {
                // empty catch block
            }
            throw replacementVetoException;
        }
    }

    protected void writeDebug(Object object, Object object2) {
        if (showDebug) {
            System.err.println("[DEBUG] " + object + ": " + object2);
        }
    }

    protected void writeError(Object object, Object object2) {
        System.err.println("[ERROR] " + object + ": " + object2);
    }

    public String getObjectIdString() {
        return AbstractScienceObject.getObjectIdString(this);
    }

    public static String getObjectIdString(Object object) {
        Object object2;
        if (object == null) {
            object2 = "<null>";
        } else {
            object2 = object.getClass().toString() + "/" + object.hashCode();
            String string = "class ";
            int n = string.length();
            if (((String)object2).indexOf(string) >= 0) {
                object2 = ((String)object2).substring(n, ((String)object2).length());
            }
        }
        return object2;
    }
}

