/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.operator;

import java.awt.geom.Rectangle2D;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.ROI;
import javax.media.jai.StatisticsOpImage;

class CutLevelOpImage
extends StatisticsOpImage {
    private double ignore;
    private double median;
    private static final String[] opNames = new String[]{"cutlevel"};

    public CutLevelOpImage(RenderedImage source, ImageLayout layout, ROI roi, Double ignore, Double median) {
        super(source, roi, 0, 0, 1, 1);
        this.ignore = ignore;
        this.median = median;
    }

    protected void accumulateStatistics(String name, Raster source, Object ar) {
        double[] stats = (double[])ar;
        DataBuffer dbuf = source.getDataBuffer();
        Rectangle2D rect = this.roi.getBounds().createIntersection(source.getBounds());
        int x0 = Math.max((int)rect.getX() - source.getMinX(), 0);
        int y0 = Math.max((int)rect.getY() - source.getMinY(), 0);
        int x1 = x0 + (int)rect.getWidth() - 1;
        int y1 = y0 + (int)rect.getHeight() - 1;
        int w = source.getWidth();
        int h = source.getHeight();
        if (this.xPeriod < this.width / 2 && this.yPeriod < this.height / 2) {
            x0 += this.xPeriod;
            y0 += this.yPeriod;
            x1 -= this.xPeriod;
            y1 -= this.yPeriod;
        }
        switch (dbuf.getDataType()) {
            case 0: {
                DataBufferByte dataBuffer = (DataBufferByte)source.getDataBuffer();
                byte[] data = dataBuffer.getData();
                short ignore = (short)this.ignore;
                short median = (short)this.median;
                this.getCutLevelsByte(data, ignore, median, x0, y0, x1, y1, w, stats);
                break;
            }
            case 2: {
                DataBufferShort dataBuffer = (DataBufferShort)source.getDataBuffer();
                short[] data = dataBuffer.getData();
                short ignore = (short)this.ignore;
                short median = (short)this.median;
                this.getCutLevelsShort(data, ignore, median, x0, y0, x1, y1, w, stats);
                break;
            }
            case 1: {
                DataBufferUShort dataBuffer = (DataBufferUShort)source.getDataBuffer();
                short[] data = dataBuffer.getData();
                int ignore = (int)this.ignore;
                int median = (int)this.median;
                this.getCutLevelsUShort(data, ignore, median, x0, y0, x1, y1, w, stats);
                break;
            }
            case 3: {
                DataBufferInt dataBuffer = (DataBufferInt)source.getDataBuffer();
                int[] data = dataBuffer.getData();
                int ignore = (int)this.ignore;
                int median = (int)this.median;
                this.getCutLevelsInt(data, ignore, median, x0, y0, x1, y1, w, stats);
                break;
            }
            case 4: {
                DataBufferFloat dataBuffer = (DataBufferFloat)source.getDataBuffer();
                float[] data = dataBuffer.getData();
                float ignore = (float)this.ignore;
                float median = (float)this.median;
                this.getCutLevelsFloat(data, ignore, median, x0, y0, x1, y1, w, stats);
                break;
            }
            default: {
                throw new IllegalArgumentException("CutLevel not implemented for this data type");
            }
        }
    }

    void getCutLevelsByte(byte[] data, short ignore, short median, int x0, int y0, int x1, int y1, int w, double[] stats) {
        int nmed = 7;
        int xskip = nmed * 3;
        int yskip = 3;
        int p = 0;
        short lcut = 0;
        short hcut = 0;
        short[] medary = new short[nmed];
        if (!Double.isNaN(stats[0])) {
            lcut = (short)stats[0];
            hcut = (short)stats[1];
        } else {
            lcut = median;
            hcut = median;
        }
        if (x1 - x0 <= nmed || y1 - y0 <= nmed) {
            return;
        }
        for (int i = y0; i <= y1; i += yskip) {
            for (int j = x0; j <= x1; j += xskip) {
                int k;
                p = i * w + j;
                for (k = 0; k < nmed; ++k) {
                    medary[k] = (short)(data[p++] & 0xFF);
                    if (medary[k] != ignore) continue;
                    medary[k] = median;
                }
                for (k = 0; k < nmed; ++k) {
                    for (int l = k; l < nmed; ++l) {
                        if (medary[k] >= medary[l]) continue;
                        short tmp = medary[l];
                        medary[l] = medary[k];
                        medary[k] = tmp;
                    }
                }
                short val = medary[nmed / 2];
                if (val < lcut) {
                    lcut = val;
                }
                if (val <= hcut) continue;
                hcut = val;
            }
        }
        stats[0] = lcut;
        stats[1] = hcut;
    }

    void getCutLevelsShort(short[] data, short ignore, short median, int x0, int y0, int x1, int y1, int w, double[] stats) {
        int nmed = 7;
        int xskip = nmed * 3;
        int yskip = 3;
        int p = 0;
        short lcut = 0;
        short hcut = 0;
        short[] medary = new short[nmed];
        if (!Double.isNaN(stats[0])) {
            lcut = (short)stats[0];
            hcut = (short)stats[1];
        } else {
            lcut = median;
            hcut = median;
        }
        if ((x1 -= nmed) - x0 <= nmed || y1 - y0 <= nmed) {
            return;
        }
        for (int i = y0; i <= y1; i += yskip) {
            for (int j = x0; j <= x1; j += xskip) {
                int k;
                p = i * w + j;
                for (k = 0; k < nmed; ++k) {
                    medary[k] = data[p++];
                    if (medary[k] != ignore) continue;
                    medary[k] = median;
                }
                for (k = 0; k < nmed; ++k) {
                    for (int l = k; l < nmed; ++l) {
                        if (medary[k] >= medary[l]) continue;
                        short tmp = medary[l];
                        medary[l] = medary[k];
                        medary[k] = tmp;
                    }
                }
                short val = medary[nmed / 2];
                if (val < lcut) {
                    lcut = val;
                }
                if (val <= hcut) continue;
                hcut = val;
            }
        }
        stats[0] = lcut;
        stats[1] = hcut;
    }

    void getCutLevelsUShort(short[] data, int ignore, int median, int x0, int y0, int x1, int y1, int w, double[] stats) {
        int nmed = 7;
        int xskip = nmed * 3;
        int yskip = 3;
        int p = 0;
        int lcut = 0;
        int hcut = 0;
        int[] medary = new int[nmed];
        if (!Double.isNaN(stats[0])) {
            lcut = (int)stats[0];
            hcut = (int)stats[1];
        } else {
            lcut = median;
            hcut = median;
        }
        if (x1 - x0 <= nmed || y1 - y0 <= nmed) {
            return;
        }
        for (int i = y0; i <= y1; i += yskip) {
            for (int j = x0; j <= x1; j += xskip) {
                int k;
                p = i * w + j;
                for (k = 0; k < nmed; ++k) {
                    medary[k] = data[p++] & 0xFFFF;
                    if (medary[k] != ignore) continue;
                    medary[k] = median;
                }
                for (k = 0; k < nmed; ++k) {
                    for (int l = k; l < nmed; ++l) {
                        if (medary[k] >= medary[l]) continue;
                        int tmp = medary[l];
                        medary[l] = medary[k];
                        medary[k] = tmp;
                    }
                }
                int val = medary[nmed / 2];
                if (val < lcut) {
                    lcut = val;
                }
                if (val <= hcut) continue;
                hcut = val;
            }
        }
        stats[0] = lcut;
        stats[1] = hcut;
    }

    void getCutLevelsInt(int[] data, int ignore, int median, int x0, int y0, int x1, int y1, int w, double[] stats) {
        int nmed = 7;
        int xskip = nmed * 3;
        int yskip = 3;
        int p = 0;
        int lcut = 0;
        int hcut = 0;
        int[] medary = new int[nmed];
        if (!Double.isNaN(stats[0])) {
            lcut = (int)stats[0];
            hcut = (int)stats[1];
        } else {
            lcut = median;
            hcut = median;
        }
        if (x1 - x0 <= nmed || y1 - y0 <= nmed) {
            return;
        }
        for (int i = y0; i <= y1; i += yskip) {
            for (int j = x0; j <= x1; j += xskip) {
                int k;
                p = i * w + j;
                for (k = 0; k < nmed; ++k) {
                    medary[k] = data[p++];
                    if (medary[k] != ignore) continue;
                    medary[k] = median;
                }
                for (k = 0; k < nmed; ++k) {
                    for (int l = k; l < nmed; ++l) {
                        if (medary[k] >= medary[l]) continue;
                        int tmp = medary[l];
                        medary[l] = medary[k];
                        medary[k] = tmp;
                    }
                }
                int val = medary[nmed / 2];
                if (val < lcut) {
                    lcut = val;
                }
                if (val <= hcut) continue;
                hcut = val;
            }
        }
        stats[0] = lcut;
        stats[1] = hcut;
    }

    void getCutLevelsFloat(float[] data, float ignore, float median, int x0, int y0, int x1, int y1, int w, double[] stats) {
        int nmed = 7;
        int xskip = nmed * 3;
        int yskip = 3;
        int p = 0;
        float lcut = 0.0f;
        float hcut = 0.0f;
        float[] medary = new float[nmed];
        if (!Double.isNaN(stats[0])) {
            lcut = (float)stats[0];
            hcut = (float)stats[1];
        } else {
            lcut = median;
            hcut = median;
        }
        if (x1 - x0 <= nmed || y1 - y0 <= nmed) {
            return;
        }
        for (int i = y0; i <= y1; i += yskip) {
            for (int j = x0; j <= x1; j += xskip) {
                int k;
                p = i * w + j;
                for (k = 0; k < nmed; ++k) {
                    medary[k] = data[p++];
                    if (!Float.isNaN(medary[k]) && medary[k] != ignore) continue;
                    medary[k] = median;
                }
                for (k = 0; k < nmed; ++k) {
                    for (int l = k; l < nmed; ++l) {
                        if (!(medary[k] < medary[l])) continue;
                        float tmp = medary[l];
                        medary[l] = medary[k];
                        medary[k] = tmp;
                    }
                }
                float val = medary[nmed / 2];
                if (val < lcut) {
                    lcut = val;
                }
                if (!(val > hcut)) continue;
                hcut = val;
            }
        }
        stats[0] = lcut;
        stats[1] = hcut;
    }

    protected Object createStatistics(String name) {
        double[] ar = new double[2];
        ar[1] = Double.NaN;
        ar[0] = Double.NaN;
        return ar;
    }

    protected String[] getStatisticsNames() {
        return opNames;
    }
}

