/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.media.jai.PlanarImage;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import jsky.image.ImageChangeEvent;
import jsky.image.gui.MainImageDisplay;
import jsky.util.gui.SortedJTable;

public class ImageProperties
extends JPanel {
    protected Component parent;
    protected MainImageDisplay imageDisplay;
    protected SortedJTable table;

    public ImageProperties(Component parent, MainImageDisplay imageDisplay) {
        this.parent = parent;
        this.imageDisplay = imageDisplay;
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeTable(), "Center");
        this.add((Component)this.makeButtonPanel(), "South");
        imageDisplay.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                ImageChangeEvent e = (ImageChangeEvent)ce;
                if (e.isNewImage() && !e.isBefore()) {
                    ImageProperties.this.updateDisplay();
                }
            }
        });
        this.updateDisplay();
    }

    JScrollPane makeTable() {
        this.table = new SortedJTable();
        this.table.setAutoResizeMode(4);
        JScrollPane propertyScrollPane = new JScrollPane(this.table);
        return propertyScrollPane;
    }

    JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        JButton closeButton = new JButton("Close");
        panel.add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ImageProperties.this.close();
            }
        });
        return panel;
    }

    public void updateDisplay() {
        PlanarImage image = this.imageDisplay.getImageProcessor().getSourceImage();
        if (image == null) {
            return;
        }
        Object[] columnNames = new String[]{"Property Name", "Value"};
        String[] propertyNames = image.getPropertyNames();
        if (propertyNames == null) {
            return;
        }
        int numProperties = propertyNames.length;
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        for (int i = 0; i < numProperties; ++i) {
            String name = propertyNames[i];
            if (name == null || name.length() == 0 || name.startsWith("#")) continue;
            treeSet.add(name.toUpperCase());
            ++n;
        }
        Object[] keys = treeSet.toArray();
        numProperties = keys.length;
        Object[][] values = new String[numProperties][2];
        for (int i = 0; i < numProperties; ++i) {
            String name = (String)keys[i];
            values[i][0] = name;
            Object property = image.getProperty(name);
            if (property == null) continue;
            values[i][1] = property.toString();
        }
        this.table.setModel(new DefaultTableModel(values, columnNames));
        this.table.sizeColumnsToFit(-1);
    }

    void close() {
        if (this.parent != null) {
            this.parent.setVisible(false);
        }
    }
}

