/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JComponent;
import jsky.coords.WorldCoordinateConverter;
import jsky.coords.WorldCoords;
import jsky.image.gui.MainImageDisplay;
import jsky.util.I18N;
import jsky.util.Preferences;
import jsky.util.SwingWorker;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.PrintPreview;
import jsky.util.gui.ProgressPanel;

public class ImagePrintDialog
implements Printable,
ActionListener {
    private static final I18N _I18N = I18N.getInstance(class$jsky$image$gui$ImagePrintDialog == null ? (class$jsky$image$gui$ImagePrintDialog = ImagePrintDialog.class$("jsky.image.gui.ImagePrintDialog")) : class$jsky$image$gui$ImagePrintDialog);
    private static final String _ATTR_FILE = "ImagePrintDialog.printerAttr";
    private MainImageDisplay _imageDisplay;
    private PrinterJob _printerJob;
    private HashPrintRequestAttributeSet _printerAttr;
    private ProgressPanel _progressPanel;
    private static final Font PRINTING_FONT = Font.decode("SansSerif-8");
    private boolean _newPrint;
    private double _printOffsetX;
    private double _printOffsetY;
    private final SimpleDateFormat _dateFormatter = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
    static /* synthetic */ Class class$jsky$image$gui$ImagePrintDialog;

    public ImagePrintDialog(MainImageDisplay imageDisplay) {
        this._imageDisplay = imageDisplay;
    }

    public void preview() {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                try {
                    String title = ImagePrintDialog.this._imageDisplay.getObjectName();
                    if (title == null) {
                        title = ImagePrintDialog.this._imageDisplay.getFilename();
                    }
                    if (title == null) {
                        title = _I18N.getString("printPreview");
                    }
                    ImagePrintDialog.this.startPrint(_I18N.getString("preparingImage"));
                    return new PrintPreview(ImagePrintDialog.this, ImagePrintDialog.this, title);
                }
                catch (Exception e) {
                    return e;
                }
            }

            public void finished() {
                ImagePrintDialog.this._progressPanel.stop();
                ImagePrintDialog.this._progressPanel.setTitle(_I18N.getString("printingImage"));
                Object o = this.getValue();
                if (o instanceof Exception) {
                    DialogUtil.error((Exception)o);
                } else if (o instanceof PrintPreview) {
                    PrintPreview pp = (PrintPreview)o;
                    pp.setVisible(true);
                }
            }
        };
        worker.start();
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            this.print();
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
    }

    public void print() throws PrinterException {
        if (this._printerJob == null) {
            this._printerJob = PrinterJob.getPrinterJob();
        }
        this._printerJob.setJobName(_I18N.getString("imageDisplay"));
        this._printerJob.setPrintable(this);
        String prefKey = this.getClass().getName() + ".printer";
        String printer = Preferences.get(prefKey);
        if (printer != null) {
            PrintService[] ar = PrintServiceLookup.lookupPrintServices(null, null);
            for (int i = 0; i < ar.length; ++i) {
                if (!printer.equals(ar[i].getName())) continue;
                this._printerJob.setPrintService(ar[i]);
                break;
            }
        }
        try {
            this._restorePrinterAttr();
            if (this._printerJob.printDialog(this._printerAttr)) {
                PrintService ps = this._printerJob.getPrintService();
                if (ps == null) {
                    return;
                }
                Preferences.set(prefKey, ps.getName());
                this._savePrinterAttr();
                new PrintWorker().start();
            }
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
    }

    private void _savePrinterAttr() {
        if (this._printerAttr != null) {
            try {
                Preferences.getPreferences().serialize(_ATTR_FILE, this._printerAttr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void _restorePrinterAttr() {
        if (this._printerAttr == null) {
            try {
                this._printerAttr = (HashPrintRequestAttributeSet)Preferences.getPreferences().deserialize(_ATTR_FILE);
            }
            catch (Exception e) {
                this._printerAttr = new HashPrintRequestAttributeSet();
            }
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        Graphics2D g2d = (Graphics2D)g;
        JComponent canvas = this._imageDisplay.getCanvas();
        int canvasWidth = canvas.getWidth();
        int canvasHeight = canvas.getHeight();
        if (pageIndex > 0) {
            return 1;
        }
        boolean progress = true;
        if (this._newPrint) {
            this._newPrint = false;
            progress = false;
            Rectangle r = g2d.getClipBounds();
            if (r != null) {
                this._printOffsetX = r.x;
                this._printOffsetY = r.y;
            }
        }
        double scale = Math.min((pf.getImageableWidth() - 20.0) / (double)canvasWidth, (pf.getImageableHeight() - 20.0) / (double)canvasHeight);
        String footer = this._imageDisplay.getObjectName();
        if (footer == null) {
            footer = this._imageDisplay.getFilename();
        }
        if (footer == null) {
            if (this._imageDisplay.isWCS()) {
                WorldCoordinateConverter wcc = this._imageDisplay.getWCS();
                WorldCoords center = new WorldCoords(wcc.getWCSCenter(), wcc.getEquinox());
                footer = center.toString();
            } else {
                footer = _I18N.getString("blankImage");
            }
        }
        FontMetrics metrics = canvas.getFontMetrics(PRINTING_FONT);
        int width = metrics.stringWidth(footer) + 6;
        int height = metrics.getHeight() + 4;
        g2d.setColor(Color.black);
        g2d.setFont(PRINTING_FONT);
        g2d.drawString(footer, (float)this._printOffsetX, (float)((double)(canvasHeight + height) * scale + pf.getImageableY()));
        footer = this._dateFormatter.format(new Date());
        width = metrics.stringWidth(footer) + 6;
        g2d.drawString(footer, (float)(this._printOffsetX + (double)(canvasWidth - width) * scale - 15.0), (float)((double)(canvasHeight + height) * scale + pf.getImageableY()));
        g2d.translate(this._printOffsetX, this._printOffsetY);
        g2d.scale(scale, scale);
        int y = 0;
        int x = 0;
        int h = canvasHeight;
        int w = canvasWidth;
        if (g2d.getClipBounds() != null) {
            x = g2d.getClipBounds().x;
            y = g2d.getClipBounds().y;
            w = g2d.getClipBounds().width;
            h = g2d.getClipBounds().height;
            if (x + w > canvasWidth) {
                w = canvasWidth;
            }
            if (y + h > canvasHeight) {
                h = Math.max(0, canvasHeight - y);
            }
        }
        g2d.setClip(x, y, w, h);
        this._imageDisplay.paintImageAndGraphics(g2d);
        if (progress) {
            int percent = (int)Math.min(100.0, Math.floor((double)(y + h) / (double)canvasHeight * 100.0));
            this._progressPanel.setProgress(percent);
        }
        return 0;
    }

    public void startPrint(String msg) {
        this._newPrint = true;
        this._printOffsetX = 0.0;
        this._printOffsetY = 0.0;
        if (this._progressPanel == null) {
            this._progressPanel = ProgressPanel.makeProgressPanel(msg);
        } else {
            this._progressPanel.setTitle(msg);
        }
        this._progressPanel.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class PrintWorker
    extends SwingWorker {
        public PrintWorker() {
            ImagePrintDialog.this.startPrint(_I18N.getString("printing"));
        }

        public Object construct() {
            try {
                ImagePrintDialog.this._progressPanel.setProgress(5);
                ImagePrintDialog.this._printerJob.print(ImagePrintDialog.this._printerAttr);
            }
            catch (Exception ex) {
                return ex;
            }
            return null;
        }

        public void finished() {
            ImagePrintDialog.this._progressPanel.stop();
            Object o = this.getValue();
            if (o instanceof Exception) {
                DialogUtil.error((Exception)o);
            }
        }
    }
}

