/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.media.jai.PlanarImage;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import jsky.coords.CoordinateConverter;
import jsky.coords.WorldCoordinateConverter;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageProcessor;
import jsky.image.fits.codec.FITSImage;
import jsky.image.graphics.ShapeUtil;
import jsky.image.gui.BasicImageDisplay;
import jsky.image.gui.ImageDisplay;
import jsky.image.gui.ImageGraphicsHandler;
import jsky.image.gui.MainImageDisplay;
import jsky.image.operator.ImageOps;

public class ImagePanner
extends JComponent
implements MouseInputListener,
ChangeListener,
ImageGraphicsHandler {
    public static final int DEFAULT_SIZE = 152;
    private MainImageDisplay _mainImageDisplay;
    private BasicImageDisplay _imageDisplay = new ImageDisplay("pan window");
    private PlanarImage _pannerImage;
    private int _panWidth;
    private int _panHeight;
    private Point2D.Double _mark;
    private Point2D.Double _offset;
    private Rectangle2D.Double _rect;
    private Shape _compass;
    private Point2D.Double _north;
    private Point2D.Double _east;
    private Font _compassFont;
    private boolean _ignoreStateChanges = false;

    public ImagePanner(MainImageDisplay mainImageDisplay, int width, int height) {
        this._imageDisplay.setPrescaled(true);
        this._imageDisplay.addImageGraphicsHandler(this);
        ImageProcessor ip = this._imageDisplay.getImageProcessor();
        ip.removeChangeListener((ChangeListener)((Object)this._imageDisplay));
        ip.setName("Panner ip");
        JComponent c = (JComponent)((Object)this._imageDisplay);
        this._panWidth = width;
        this._panHeight = height;
        c.setPreferredSize(new Dimension(this._panWidth, this._panHeight));
        c.addMouseListener(this);
        c.addMouseMotionListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)c, "Center");
        this.setMainImageDisplay(mainImageDisplay);
    }

    public ImagePanner(MainImageDisplay mainImageDisplay) {
        this(mainImageDisplay, 152, 152);
    }

    public ImagePanner() {
        this(null);
    }

    public void setMainImageDisplay(MainImageDisplay mainImageDisplay) {
        this._mainImageDisplay = mainImageDisplay;
        ((Component)((Object)this._mainImageDisplay)).addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ImagePanner.this._updateRect();
            }
        });
        this._mainImageDisplay.addChangeListener(this);
        this._mainImageDisplay.getImageProcessor().addChangeListener(this);
    }

    public void stateChanged(ChangeEvent ce) {
        if (this._ignoreStateChanges) {
            return;
        }
        ImageChangeEvent e = (ImageChangeEvent)ce;
        if (e.getSource() == this._mainImageDisplay) {
            if (e.isNewImage()) {
                if (e.isBefore()) {
                    this._pannerImage = null;
                } else {
                    this._updateImage();
                    this._updateRect();
                    this._updateCompass();
                }
            } else {
                this._updateRect();
                this._updateCompass();
            }
        } else {
            if (e.isImageDataChanged()) {
                this._pannerImage = null;
            }
            this._updateImage();
            if (e.isNewAngle()) {
                this._updateCompass();
            }
        }
    }

    private PlanarImage _getPannerImage() {
        PlanarImage im = this._mainImageDisplay.getImageProcessor().getSourceImage();
        if (im == null) {
            return null;
        }
        FITSImage.setPreviewSize(this._panWidth);
        float scale = 1.0f;
        float w = im.getWidth();
        float h = im.getHeight();
        Object o = im.getProperty("#preview_image");
        if (o != null && o instanceof PlanarImage) {
            PlanarImage preview = (PlanarImage)o;
            FITSImage fitsImage = (FITSImage)im.getProperty("#fits_image");
            if (fitsImage != null) {
                w = fitsImage.getRealWidth();
                h = fitsImage.getRealHeight();
            }
            scale = Math.min((float)preview.getWidth() / w, (float)preview.getHeight() / h);
            this._imageDisplay.setScale(scale);
            return preview;
        }
        scale = Math.min((float)this._panWidth / w, (float)this._panHeight / h);
        if (scale >= 1.0f) {
            scale = 1.0f;
        }
        this._imageDisplay.setScale(scale);
        return ImageOps.scale(im, scale, scale, 0.0f, 0.0f, this._imageDisplay.getInterpolation(), null);
    }

    private void _updateImage() {
        if (this._mainImageDisplay == null) {
            return;
        }
        if (this._pannerImage == null) {
            this._pannerImage = this._getPannerImage();
        }
        ImageProcessor ip = this._imageDisplay.getImageProcessor();
        ip.setSourceImage(this._pannerImage, this._mainImageDisplay.getImageProcessor());
        ip.update();
        this._imageDisplay.updateImage();
    }

    private void _updateRect() {
        if (!this._imageDisplay.isInitialized() || !this._mainImageDisplay.isInitialized()) {
            return;
        }
        this._rect = this._mainImageDisplay.getVisibleArea();
        Point2D.Double p = new Point2D.Double(this._rect.getX(), this._rect.getY());
        Point2D.Double d = new Point2D.Double(this._rect.getWidth(), this._rect.getHeight());
        CoordinateConverter cc = this._imageDisplay.getCoordinateConverter();
        cc.userToScreenCoords(p, false);
        cc.userToScreenCoords(d, true);
        this._rect.setRect(p.getX(), p.getY(), d.getX(), d.getY());
    }

    private void _updateCompass() {
        WorldCoordinateConverter wcs = this._mainImageDisplay.getWCS();
        if (wcs == null) {
            this._compass = null;
            return;
        }
        this._imageDisplay.setWCS(wcs);
        double wcsw = wcs.getWidthInDeg();
        double wcsh = wcs.getHeightInDeg();
        double sizeInDeg = Math.min(wcsw, wcsh) / 4.0;
        double equinox = wcs.getEquinox();
        Point2D.Double center = wcs.getWCSCenter();
        this._north = new Point2D.Double(center.x, center.y);
        this._east = new Point2D.Double(center.x, center.y);
        if (90.0 - Math.abs(center.y) < wcsh) {
            return;
        }
        this._east.x = center.x + sizeInDeg / Math.cos(center.y / 180.0 * Math.PI);
        if (this._east.x < 0.0) {
            this._east.x = 360.0 + this._east.x;
        }
        this._north.y = center.y + sizeInDeg;
        if (this._north.y >= 90.0) {
            this._north.y = 180.0 - this._north.y;
        }
        CoordinateConverter cc = this._imageDisplay.getCoordinateConverter();
        cc.worldToScreenCoords(center, false);
        cc.worldToScreenCoords(this._north, false);
        cc.worldToScreenCoords(this._east, false);
        GeneralPath path = new GeneralPath();
        ShapeUtil.addArrowLine(path, center, this._north);
        ShapeUtil.addArrowLine(path, center, this._east);
        this._compass = path;
        double f = 0.25;
        this._east.x += (this._east.x - center.x) * f;
        this._east.y += (this._east.y - center.y) * f + 5.0;
        this._north.x += (this._north.x - center.x) * f - 3.0;
        this._north.y += (this._north.y - center.y) * f;
    }

    public void drawImageGraphics(BasicImageDisplay imageDisplay, Graphics2D g) {
        if (this._compass != null) {
            g.setColor(Color.white);
            g.draw(this._compass);
            if (this._compassFont == null) {
                this._compassFont = g.getFont().deriveFont(1);
            }
            g.setFont(this._compassFont);
            g.drawString("N", (float)this._north.x, (float)this._north.y);
            g.drawString("E", (float)this._east.x, (float)this._east.y);
        }
        if (this._rect != null) {
            g.setColor(Color.yellow);
            g.draw(this._rect);
        }
    }

    private void pan() {
        Point2D.Double origin = new Point2D.Double(this._rect.getX(), this._rect.getY());
        this._imageDisplay.getCoordinateConverter().screenToUserCoords(origin, false);
        this._mainImageDisplay.getCoordinateConverter().userToCanvasCoords(origin, false);
        this._mainImageDisplay.setOrigin(origin);
        this._mainImageDisplay.updateImage();
    }

    public void mousePressed(MouseEvent e) {
        this._ignoreStateChanges = true;
        this._mark = new Point2D.Double(e.getX(), e.getY());
        this._offset = new Point2D.Double(0.0, 0.0);
    }

    public void mouseDragged(MouseEvent e) {
        Point2D.Double d = new Point2D.Double((double)e.getX() - (this._mark.getX() + this._offset.getX()), (double)e.getY() - (this._mark.getY() + this._offset.getY()));
        this._offset.setLocation((double)e.getX() - this._mark.getX(), (double)e.getY() - this._mark.getY());
        if (d.getX() != 0.0 || d.getY() != 0.0) {
            this._rect.setRect(this._rect.getX() + d.getX(), this._rect.getY() + d.getY(), this._rect.getWidth(), this._rect.getHeight());
            if (this._mainImageDisplay.isImmediateMode()) {
                this.pan();
            } else {
                ((JComponent)((Object)this._imageDisplay)).repaint();
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        this._ignoreStateChanges = false;
        if (!this._mainImageDisplay.isImmediateMode()) {
            this.pan();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

